/**
 * Copyright (C) 2019  The Software Heritage developers
 * See the AUTHORS file at the top-level directory of this distribution
 * License: GNU Affero General Public License version 3, or any later version
 * See top-level LICENSE file for more information
 */

import {staticAsset} from 'utils/functions';

// Constants defining Bootstrap Breakpoints
export const BREAKPOINT_SM = 768;
export const BREAKPOINT_MD = 992;
export const BREAKPOINT_LG = 1200;

export const swhSpinnerSrc = staticAsset('img/swh-spinner.gif');

export const dataTableCommonConfig = {
  serverSide: true,
  processing: true,
  language: {
    processing: `<img src="${swhSpinnerSrc}"></img>`
  },
  fixedHeader: true,
  lengthMenu: [10, 25, 50, 100, 1000],
  scrollCollapse: true,
  searchDelay: 1000
};
