# Generated by Django 2.2.24 on 2022-03-08 10:25

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Request",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.TextField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("WAITING_FOR_FEEDBACK", "Waiting for feedback"),
                            ("FEEDBACK_TO_HANDLE", "Feedback to handle"),
                            ("ACCEPTED", "Accepted"),
                            ("SCHEDULED", "Scheduled"),
                            ("FIRST_LISTING_DONE", "First listing done"),
                            ("FIRST_ORIGIN_LOADED", "First origin loaded"),
                            ("REJECTED", "Rejected"),
                            ("SUSPENDED", "Suspended"),
                            ("DENIED", "Denied"),
                        ],
                        default="PENDING",
                    ),
                ),
                ("submission_date", models.DateTimeField(auto_now_add=True)),
                ("submitter_name", models.TextField()),
                ("submitter_email", models.TextField()),
                ("forge_type", models.TextField()),
                ("forge_url", models.TextField()),
                ("forge_contact_email", models.EmailField(max_length=254)),
                ("forge_contact_name", models.TextField()),
                (
                    "forge_contact_comment",
                    models.TextField(
                        help_text=(
                            "Where did you find this contact information (url, ...)"
                        )
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="RequestHistory",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("text", models.TextField()),
                ("actor", models.TextField()),
                (
                    "actor_role",
                    models.TextField(
                        choices=[("MODERATOR", "moderator"), ("SUBMITTER", "submitter")]
                    ),
                ),
                ("date", models.DateTimeField(auto_now_add=True)),
                (
                    "new_status",
                    models.TextField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("WAITING_FOR_FEEDBACK", "Waiting for feedback"),
                            ("FEEDBACK_TO_HANDLE", "Feedback to handle"),
                            ("ACCEPTED", "Accepted"),
                            ("SCHEDULED", "Scheduled"),
                            ("FIRST_LISTING_DONE", "First listing done"),
                            ("FIRST_ORIGIN_LOADED", "First origin loaded"),
                            ("REJECTED", "Rejected"),
                            ("SUSPENDED", "Suspended"),
                            ("DENIED", "Denied"),
                        ],
                        null=True,
                    ),
                ),
                (
                    "request",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="swh_web_add_forge_now.Request",
                    ),
                ),
            ],
        ),
    ]
