# Generated by Django 2.2.28 on 2022-08-12 15:08

from django.db import migrations, models


def _set_new_fields_value_to_requests(apps, schema_editor):
    AddForgeNowRequest = apps.get_model("swh_web_add_forge_now", "Request")
    AddForgeNowRequestHistory = apps.get_model(
        "swh_web_add_forge_now", "RequestHistory"
    )
    for request in AddForgeNowRequest.objects.all():
        history = AddForgeNowRequestHistory.objects.filter(request=request)
        history = history.order_by("id")
        if history:
            request.last_modified_date = history.last().date
            last_history_with_moderator = history.filter(actor_role="MODERATOR").last()
            if last_history_with_moderator:
                request.last_moderator = last_history_with_moderator.actor
            request.save()


class Migration(migrations.Migration):
    dependencies = [
        ("swh_web_add_forge_now", "0005_prepare_inbound_email"),
    ]

    operations = [
        migrations.AddField(
            model_name="request",
            name="last_moderator",
            field=models.TextField(default="None"),
        ),
        migrations.AddField(
            model_name="request",
            name="last_modified_date",
            field=models.DateTimeField(null=True),
        ),
        migrations.RunPython(
            _set_new_fields_value_to_requests, migrations.RunPython.noop
        ),
    ]
