/*! For license information please see guided_tour.d4d80c72d889d1f87995.js.LICENSE.txt */
!function(t,e){"object"==typeof exports&&"object"==typeof module?module.exports=e():"function"==typeof define&&define.amd?define([],e):"object"==typeof exports?exports.swh=e():(t.swh=t.swh||{},t.swh.guided_tour=e())}(self,function(){return function(){"use strict";var t={8725:function(t){t.exports=JSON.parse('{"TB":[{"title":"Welcome to the guided tour !","intro":"This guided tour will showcase Software Heritage web application\\nfeatures to help you navigate into the archive.<br/>\\nLet\'s see what we can do from the homepage first.\\n"},{"element":".swh-search-box","title":"Search archived software origins","intro":"An origin corresponds to a location from which a coherent set of\\nsource codes has been obtained, like a git repository, a directory\\ncontaining tarballs, etc.<br/><br/>\\nSoftware origins are identified by URLs (git clone URLs for instance).<br/><br/>\\nYou can search for terms in the full set of archived software\\norigin URLs. You will be redirected to a dedicated interface displaying search\\nresults. Clicking on an origin URL will then take you to the source code browsing\\ninterface. If you enter a complete archived origin URL, you will be immediately\\nredirected to its source code browsing interface.\\n"},{"element":".swh-origin-save-link","title":"Save code now","intro":"If you haven\'t found the software origin you were looking for, you can use the\\nSave Code Now interface to submit a save request that will be immediately processed.\\n"},{"element":".swh-vault-link","title":"Downloads from the vault","intro":"Show the list of downloads you requested from the Software Heritage Vault\\nwhile browsing the archive. <br/>\\nThose downloads correspond to tarballs containing source directories\\narchived by Software Heritage. <br/>\\nThe list of downloads is stored in your browser local storage so it\\nwill be persistent across your visits.\\n"},{"element":".swh-help-link","title":"Launch guided tour","intro":"Replay the guided tour."},{"element":"#swh-login","title":"Login or register","intro":"Come and join our users community with a Software Heritage account.\\nClick here and register in less than 30 seconds.\\nWhen authenticated, you can benefit from extended features like a higher\\nrate-limit quota for the Web API.<br/><br/>\\nIf you are already logged in, that link will take you to your user\\nprofile interface where you can generate bearer token for Web API\\nauthentication.\\n"},{"element":"#swh-web-api-link","title":"Software Heritage Web API","intro":"In the Software Heritage Web API documentation you will find the complete list\\nof endpoints and how to use each one with a detailed example.<br/>\\nPlease note that the Web API can also be queried from your web browser\\nthrough a dedicated HTML interface displaying query results.\\n"},{"title":"Browsing source code of an archived software origin","intro":"Come on in, let\'s introduce the Web UI to browse the content of an\\narchived software origin.\\n"}],"JS":[{"title":"Browse source code of an archived software origin","intro":"You just arrived into the first view of the archived source code of an origin.\\nThe displayed source code files are taken from the most recent snapshot taken by\\nSoftware Heritage. By default, the content of the main branch (aka HEAD, master, ...)\\nis displayed.\\nContinue your journey and dive deeper into the code and its development history.\\n"},{"element":"#swh-origin-url","title":"Software origin URL","intro":"You can find the URL of the archived software origin.<br/>\\nFollowing that link will always bring you back to the code in the HEAD branch\\nas captured by the latest Software Heritage visit.\\n","position":"bottom"},{"element":"#swh-go-to-origin","title":"Visit software origin","intro":"You can go directly to the place where source code was captured.\\n","position":"bottom"},{"element":"#swh-origin-visit","title":"Software Heritage origin visit date","intro":"You can find the date when Software Heritage captured the source code of\\nthat origin.\\n","position":"bottom"},{"element":"#swh-browse-code-nav-link","title":"Browse source code","intro":"You can browse the source code of a software origin. <br/>\\nClicking on the Code tab will always bring you back to the code in the HEAD branch\\nfor the currently selected Software Heritage visit.\\n","position":"bottom"},{"element":"#swh-browse-snapshot-branches-nav-link","title":"Browse branches","intro":"You can browse the list of branches for a software origin. <br/>\\nLinks are offered to browse the source code contained in each branch.\\n","position":"bottom"},{"element":"#swh-browse-snapshot-releases-nav-link","title":"Browse releases","intro":"You can browse the list of releases for a software origin. <br/>\\nLinks are offered to browse the source code contained in each release. <br/>\\nPlease note that for git origins, only annotated tags are considered as releases.\\nFor non annotated git tags, you can browse them in the Branches tab.\\n","position":"bottom"},{"element":"#swh-browse-origin-visits-nav-link","title":"Browse origin visits","intro":"You can find when Software Heritage captured the source code.\\nThese visits are called snapshots and visualized in various ways: timeline,\\ncalendar and simple list.\\nLike with a way-back machine, you can travel in time and see the code as it was\\nwhen crawled by Software Heritage.\\n","position":"bottom"},{"element":"#swh-branches-releases-dd","title":"Switch between branches and releases","intro":"You can easily switch between different branches and releases using this dropdown.\\n","position":"bottom"},{"element":"#swh-breadcrumbs-container","title":"Current navigation path","intro":"You can see here the current path you are taking in the code, which will make it\\neasier to navigate back.\\n","position":"bottom"},{"element":".swh-tr-link","title":"Browse revisions history","intro":"Display the list of revisions (aka commits) for the current branch in various\\norderings. Links are offered to browse source code as it was in each revision.\\nThe list of files changes introduced in each revision can also be computed and\\nthe associated diffs displayed.\\n","position":"bottom"},{"element":".swh-vault-download","title":"Download source code in an archive","intro":"You can request the creation of an archive in .tar.gz format that will contain\\nthe currently browsed directory.\\nYou can follow the archive creation progress and download it once done by\\nvisiting the Downloads page (link can be found in the left sidebar).\\n","position":"bottom"},{"element":"#swh-take-new-snashot","title":"Request to save origin again","intro":"If the archived software origin currently browsed is not synchronized with its\\nupstream version (for instance when new commits have been issued), you can\\nexplicitly request Software Heritage to take a new snapshot of it.\\n","position":"bottom"},{"element":"#swh-tip-revision","title":"Branch tip revision","intro":"You can see the latest revision (commit) archived by Software Heritage\\nfor the current branch.\\n","position":"bottom"},{"element":"#swhids-handle","title":"Display SWHIDs of browsed objects","intro":"When clicking on this handle, a tab will be displayed containing Software Heritage\\nIDentifiers of currently browsed objects.\\n","position":"left"},{"element":"#swh-identifiers","title":"Get SWHIDs of browsed objects","intro":"The <b>SWHID</b> (Software Heritage Identifier), is an intrinsic identifier that is\\ncomputed uniquely from the software artifact itself.<br/>\\nAll details about the syntax, semantics, interoperability and implementation can be\\nfound in\\n<a href=\\"https://docs.softwareheritage.org/devel/swh-model/persistent-identifiers.html\\"\\ntarget=\\"_blank\\" rel=\\"noopener noreferrer\\">the formal specification</a>.\\n","position":"left"},{"element":"#swhid-object-types","title":"Select archived object type","intro":"Software Heritage computes identifiers for all archived objects whose type can be:\\n<ul>\\n  <li>\\n    <b>content:</b> a (specific version of a) file stored in the archive.\\n  </li>\\n  <li>\\n    <b>directory:</b> a set of named pointers to contents (file entries), directories\\n    (directory entries) and revisions (revision entries).\\n  </li>\\n  <li>\\n    <b>release:</b> a revision that has been marked as noteworthy with a specific name\\n    (e.g., a version number).\\n  </li>\\n  <li>\\n    <b>revision:</b> a point in time snapshot of the content of a directory, together\\n    with associated development metadata (e.g., author, timestamp, log message, etc).\\n  </li>\\n  <li>\\n    <b>snapshot:</b> the state of all visible branches during a specific visit of a\\n    software origin\\n  </li>\\n</ul>\\nBased on the current context, you can get the SWHID of each browsed object in a\\ndedicated tab.\\n","position":"left"},{"element":".swh-badges","title":"Software Heritage badges","intro":"You can include Software Heritage badges in the README file of you code repository\\nto indicate its archival by Software Heritage.<br/>\\nClicking on a badge will show you how to do so depending on your README format.\\n"},{"element":".swhid","title":"Software Heritage IDentifier (SWHID)","intro":"You can find the SWHID of the selected object.\\n","position":"left"},{"element":"#swhid-options-directory","title":"Add / remove qualifiers to SWHID","intro":"Toggle the adding of qualifiers to the SWHID which adds extra information regarding\\nthe context the object has been found.\\n","position":"bottom"},{"element":"#swhid-copy-buttons","title":"Copy SWHID for a given browsed object","intro":"You can easily copy to clipboard a SWHID or its permalink using these dedicated\\nbuttons.\\n","position":"bottom"},{"element":"#citations-handle","title":"Generate software citations for browsed objects","intro":"When clicking on this handle, a tab will be displayed containing an interface to\\ngenerate software citations for browsed objects in multiple formats.\\n","position":"left"},{"title":"Browsing a source code file","intro":"Special features are also offered when browsing a source code file.<br/>\\nThis is what we will see in the next part of that tour.\\n"}],"ym":[{"title":"Browsing a source code file","intro":"You just arrived in the source code file view. Let\'s check a few extra features.\\n"},{"element":".swh-tr-link","title":"Download source code file","intro":"You can download the raw bytes of the source code file and save it locally\\nby using the \\"Save Page\\" feature of your browser.\\n","position":"bottom"},{"element":".chosen-container","title":"Select programming language","intro":"If Software Heritage did not manage to automatically find a programming language\\nfor the browsed source code file or did not find the right one, you can explicitly\\nset the language to highlight using this dropdown.\\n","position":"bottom"},{"element":".hljs-ln-numbers[data-line-number=\\"11\\"]","title":"Highlight a source code line","intro":"<b>Click on the line number to highlight the corresponding line of code.</b><br/>\\nWhen a line gets selected, it is automatically added in the SWHID qualifiers\\nfor the associated content object. It enables to easily browse back that\\nspecific line of code.\\n","position":"bottom"},{"element":".hljs-ln-numbers[data-line-number=\\"17\\"]","title":"Highlight a range of source code lines,","intro":"<b>Hold Shift key and click on the line number to highlight a range of source\\ncode lines.</b><br/>\\nWhen a range of lines get selected, it is automatically added in the SWHID qualifiers\\nfor the associated content object. It enables to easily browse back that specific\\ncode snippet.\\n","position":"bottom"},{"element":".swhid","title":"SWHID with lines qualifier","intro":"As you can see, selecting lines of code updates the source file SWHID with\\nlines qualifier.<br>\\nBrowsing such qualified SWHID will immediately take you to the selected\\ncode snippet.\\n","position":"left"},{"title":"Guided tour completed","intro":"Thank your for following our guided tour ! <br/>\\nYou will now be redirected to the page you were browsing prior to launching it.\\n"}]}')},25187:function(t,e,n){n.d(e,{M:function(){return c},v:function(){return u}});var r={38:1,40:1,32:1,33:1,34:1,35:1,36:1};function o(t){t.preventDefault()}function i(t){if(r[t.keyCode])return o(t),!1}var a=!1;try{window.addEventListener("test",null,Object.defineProperty({},"passive",{get:function(){a=!0}}))}catch(t){}var s=!!a&&{passive:!1},l="onwheel"in document.createElement("div")?"wheel":"mousewheel";function c(){window.addEventListener("DOMMouseScroll",o,!1),window.addEventListener(l,o,s),window.addEventListener("touchmove",o,s),window.addEventListener("keydown",i,!1)}function u(){window.removeEventListener("DOMMouseScroll",o,!1),window.removeEventListener(l,o,s),window.removeEventListener("touchmove",o,s),window.removeEventListener("keydown",i,!1)}},43104:function(t,e,n){function r(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,r=Array(e);n<e;n++)r[n]=t[n];return r}function o(t){if(Array.isArray(t))return t}function i(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}function a(t,e){for(var n=0;n<e.length;n++){var r=e[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(t,y(r.key),r)}}function s(t,e,n){return e&&a(t.prototype,e),n&&a(t,n),Object.defineProperty(t,"prototype",{writable:!1}),t}function l(t,e){var n="undefined"!=typeof Symbol&&t[Symbol.iterator]||t["@@iterator"];if(!n){if(Array.isArray(t)||(n=x(t))||e&&t&&"number"==typeof t.length){n&&(t=n);var r=0,o=function(){};return{s:o,n:function(){return r>=t.length?{done:!0}:{done:!1,value:t[r++]}},e:function(t){throw t},f:o}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var i,a=!0,s=!1;return{s:function(){n=n.call(t)},n:function(){var t=n.next();return a=t.done,t},e:function(t){s=!0,i=t},f:function(){try{a||null==n.return||n.return()}finally{if(s)throw i}}}}function c(t){var e=d();return function(){var n,r=h(t);if(e){var o=h(this).constructor;n=Reflect.construct(r,arguments,o)}else n=r.apply(this,arguments);return function(t,e){if(e&&("object"==typeof e||"function"==typeof e))return e;if(void 0!==e)throw new TypeError("Derived constructors may only return object or undefined");return function(t){if(void 0===t)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return t}(t)}(this,n)}}function u(t,e,n){return(e=y(e))in t?Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}):t[e]=n,t}function h(t){return h=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(t){return t.__proto__||Object.getPrototypeOf(t)},h(t)}function d(){try{var t=!Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}))}catch(t){}return(d=function(){return!!t})()}function f(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)}function p(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function v(){v=function(){return e};var t,e={},n=Object.prototype,r=n.hasOwnProperty,o=Object.defineProperty||function(t,e,n){t[e]=n.value},i="function"==typeof Symbol?Symbol:{},a=i.iterator||"@@iterator",s=i.asyncIterator||"@@asyncIterator",l=i.toStringTag||"@@toStringTag";function c(t,e,n){return Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{c({},"")}catch(t){c=function(t,e,n){return t[e]=n}}function u(t,e,n,r){var i=e&&e.prototype instanceof b?e:b,a=Object.create(i.prototype),s=new L(r||[]);return o(a,"_invoke",{value:O(t,n,s)}),a}function h(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}e.wrap=u;var d="suspendedStart",f="executing",p="completed",g={};function b(){}function m(){}function w(){}var y={};c(y,a,function(){return this});var k=Object.getPrototypeOf,x=k&&k(k(H([])));x&&x!==n&&r.call(x,a)&&(y=x);var S=w.prototype=b.prototype=Object.create(y);function C(t){["next","throw","return"].forEach(function(e){c(t,e,function(t){return this._invoke(e,t)})})}function _(t,e){function n(o,i,a,s){var l=h(t[o],t,i);if("throw"!==l.type){var c=l.arg,u=c.value;return u&&"object"==typeof u&&r.call(u,"__await")?e.resolve(u.__await).then(function(t){n("next",t,a,s)},function(t){n("throw",t,a,s)}):e.resolve(u).then(function(t){c.value=t,a(c)},function(t){return n("throw",t,a,s)})}s(l.arg)}var i;o(this,"_invoke",{value:function(t,r){function o(){return new e(function(e,o){n(t,r,e,o)})}return i=i?i.then(o,o):o()}})}function O(e,n,r){var o=d;return function(i,a){if(o===f)throw Error("Generator is already running");if(o===p){if("throw"===i)throw a;return{value:t,done:!0}}for(r.method=i,r.arg=a;;){var s=r.delegate;if(s){var l=E(s,r);if(l){if(l===g)continue;return l}}if("next"===r.method)r.sent=r._sent=r.arg;else if("throw"===r.method){if(o===d)throw o=p,r.arg;r.dispatchException(r.arg)}else"return"===r.method&&r.abrupt("return",r.arg);o=f;var c=h(e,n,r);if("normal"===c.type){if(o=r.done?p:"suspendedYield",c.arg===g)continue;return{value:c.arg,done:r.done}}"throw"===c.type&&(o=p,r.method="throw",r.arg=c.arg)}}}function E(e,n){var r=n.method,o=e.iterator[r];if(o===t)return n.delegate=null,"throw"===r&&e.iterator.return&&(n.method="return",n.arg=t,E(e,n),"throw"===n.method)||"return"!==r&&(n.method="throw",n.arg=new TypeError("The iterator does not provide a '"+r+"' method")),g;var i=h(o,e.iterator,n.arg);if("throw"===i.type)return n.method="throw",n.arg=i.arg,n.delegate=null,g;var a=i.arg;return a?a.done?(n[e.resultName]=a.value,n.next=e.nextLoc,"return"!==n.method&&(n.method="next",n.arg=t),n.delegate=null,g):a:(n.method="throw",n.arg=new TypeError("iterator result is not an object"),n.delegate=null,g)}function A(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function j(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function L(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(A,this),this.reset(!0)}function H(e){if(e||""===e){var n=e[a];if(n)return n.call(e);if("function"==typeof e.next)return e;if(!isNaN(e.length)){var o=-1,i=function n(){for(;++o<e.length;)if(r.call(e,o))return n.value=e[o],n.done=!1,n;return n.value=t,n.done=!0,n};return i.next=i}}throw new TypeError(typeof e+" is not iterable")}return m.prototype=w,o(S,"constructor",{value:w,configurable:!0}),o(w,"constructor",{value:m,configurable:!0}),m.displayName=c(w,l,"GeneratorFunction"),e.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===m||"GeneratorFunction"===(e.displayName||e.name))},e.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,w):(t.__proto__=w,c(t,l,"GeneratorFunction")),t.prototype=Object.create(S),t},e.awrap=function(t){return{__await:t}},C(_.prototype),c(_.prototype,s,function(){return this}),e.AsyncIterator=_,e.async=function(t,n,r,o,i){void 0===i&&(i=Promise);var a=new _(u(t,n,r,o),i);return e.isGeneratorFunction(n)?a:a.next().then(function(t){return t.done?t.value:a.next()})},C(S),c(S,l,"Generator"),c(S,a,function(){return this}),c(S,"toString",function(){return"[object Generator]"}),e.keys=function(t){var e=Object(t),n=[];for(var r in e)n.push(r);return n.reverse(),function t(){for(;n.length;){var r=n.pop();if(r in e)return t.value=r,t.done=!1,t}return t.done=!0,t}},e.values=H,L.prototype={constructor:L,reset:function(e){if(this.prev=0,this.next=0,this.sent=this._sent=t,this.done=!1,this.delegate=null,this.method="next",this.arg=t,this.tryEntries.forEach(j),!e)for(var n in this)"t"===n.charAt(0)&&r.call(this,n)&&!isNaN(+n.slice(1))&&(this[n]=t)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(e){if(this.done)throw e;var n=this;function o(r,o){return s.type="throw",s.arg=e,n.next=r,o&&(n.method="next",n.arg=t),!!o}for(var i=this.tryEntries.length-1;i>=0;--i){var a=this.tryEntries[i],s=a.completion;if("root"===a.tryLoc)return o("end");if(a.tryLoc<=this.prev){var l=r.call(a,"catchLoc"),c=r.call(a,"finallyLoc");if(l&&c){if(this.prev<a.catchLoc)return o(a.catchLoc,!0);if(this.prev<a.finallyLoc)return o(a.finallyLoc)}else if(l){if(this.prev<a.catchLoc)return o(a.catchLoc,!0)}else{if(!c)throw Error("try statement without catch or finally");if(this.prev<a.finallyLoc)return o(a.finallyLoc)}}}},abrupt:function(t,e){for(var n=this.tryEntries.length-1;n>=0;--n){var o=this.tryEntries[n];if(o.tryLoc<=this.prev&&r.call(o,"finallyLoc")&&this.prev<o.finallyLoc){var i=o;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var a=i?i.completion:{};return a.type=t,a.arg=e,i?(this.method="next",this.next=i.finallyLoc,g):this.complete(a)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),g},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),j(n),g}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var r=n.completion;if("throw"===r.type){var o=r.arg;j(n)}return o}}throw Error("illegal catch attempt")},delegateYield:function(e,n,r){return this.delegate={iterator:H(e),resultName:n,nextLoc:r},"next"===this.method&&(this.arg=t),g}},e}function g(t,e){return g=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(t,e){return t.__proto__=e,t},g(t,e)}function b(t,e){return o(t)||function(t,e){var n=null==t?null:"undefined"!=typeof Symbol&&t[Symbol.iterator]||t["@@iterator"];if(null!=n){var r,o,i,a,s=[],l=!0,c=!1;try{if(i=(n=n.call(t)).next,0===e){if(Object(n)!==n)return;l=!1}else for(;!(l=(r=i.call(n)).done)&&(s.push(r.value),s.length!==e);l=!0);}catch(t){c=!0,o=t}finally{try{if(!l&&null!=n.return&&(a=n.return(),Object(a)!==a))return}finally{if(c)throw o}}return s}}(t,e)||x(t,e)||p()}function m(t){return o(t)||f(t)||x(t)||p()}function w(t){return function(t){if(Array.isArray(t))return r(t)}(t)||f(t)||x(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function y(t){var e=function(t){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var n=e.call(t,"string");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return String(t)}(t);return"symbol"==typeof e?e:e+""}function k(t){return k="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},k(t)}function x(t,e){if(t){if("string"==typeof t)return r(t,e);var n={}.toString.call(t).slice(8,-1);return"Object"===n&&t.constructor&&(n=t.constructor.name),"Map"===n||"Set"===n?Array.from(t):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?r(t,e):void 0}}function S(t,e){var n={};for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&e.indexOf(r)<0&&(n[r]=t[r]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var o=0;for(r=Object.getOwnPropertySymbols(t);o<r.length;o++)e.indexOf(r[o])<0&&Object.prototype.propertyIsEnumerable.call(t,r[o])&&(n[r[o]]=t[r[o]])}return n}function C(t,e,n,r){return new(n||(n=Promise))(function(o,i){function a(t){try{l(r.next(t))}catch(t){i(t)}}function s(t){try{l(r.throw(t))}catch(t){i(t)}}function l(t){var e;t.done?o(t.value):(e=t.value,e instanceof n?e:new n(function(t){t(e)})).then(a,s)}l((r=r.apply(t,e||[])).next())})}function _(t){if(null===t||"object"!==k(t)||"nodeType"in t)return t;var e={};for(var n in t)"jQuery"in window&&window.jQuery&&t[n]instanceof window.jQuery?e[n]=t[n]:e[n]=_(t[n]);return e}n.d(e,{A:function(){return ve}}),"function"==typeof SuppressedError&&SuppressedError;var O=function(t,e){return(null!=e?e:document).querySelector(t)},E=function(t,e){return(null!=e?e:document).querySelectorAll(t)},A=function(t){t.setHints([]);var e=t.getTargetElement(),n=t.getOption("hints");if(n&&n.length>0){var r,o=l(n);try{for(o.s();!(r=o.n()).done;){var i=_(r.value);"string"==typeof i.element&&(i.element=O(i.element)),i.hintPosition=i.hintPosition||t.getOption("hintPosition"),i.hintAnimation=i.hintAnimation||t.getOption("hintAnimation"),null!==i.element&&t.addHint(i)}}catch(t){o.e(t)}finally{o.f()}}else{var a=Array.from(E("*[".concat("data-hint","]"),e));if(!a||!a.length)return!1;for(var s=0,c=a;s<c.length;s++){var u=c[s],h=u.getAttribute("data-hint-position"),d=t.getOption("hintAnimation");h&&(d="true"===h),t.addHint({element:u,hint:u.getAttribute("data-hint")||"",hintPosition:u.getAttribute("data-hint-position")||t.getOption("hintPosition"),hintAnimation:d,tooltipClass:u.getAttribute("data-tooltip-class")||void 0,position:u.getAttribute("data-position")||t.getOption("tooltipPosition")})}}return!0};function j(t,e,n){return t[e]=n,t}function L(t,e){for(var n=0,r=Object.entries(e);n<r.length;n++){var o=b(r[n],2);t=j(t,o[0],o[1])}return t}var H,P,T,N,R,B=function(t){return"function"==typeof t},D=new(function(){function t(){i(this,t)}return s(t,[{key:"on",value:function(t,e,n,r){"addEventListener"in t?t.addEventListener(e,n,r):"attachEvent"in t&&t.attachEvent("on".concat(e),n)}},{key:"off",value:function(t,e,n,r){"removeEventListener"in t?t.removeEventListener(e,n,r):"detachEvent"in t&&t.detachEvent("on".concat(e),n)}}]),t}()),I=function(t){return t?"string"==typeof t?function(t){var e=O(t,void 0);if(!e)throw new Error("Element with selector ".concat(t," not found"));return e}(t):t:document.body};function W(t,e){var n;return C(this,void 0,void 0,v().mark(function r(){var o;return v().wrap(function(r){for(;;)switch(r.prev=r.next){case 0:(o=e.isActive)&&(o.val=!1),t.hideHintDialog(),null===(n=t.callback("hintClose"))||void 0===n||n.call(t,e);case 4:case"end":return r.stop()}},r)}))}function Y(t){return C(this,void 0,void 0,v().mark(function e(){var n,r,o;return v().wrap(function(e){for(;;)switch(e.prev=e.next){case 0:n=l(t.getHints()),e.prev=1,n.s();case 3:if((r=n.n()).done){e.next=9;break}return o=r.value,e.next=7,W(t,o);case 7:e.next=3;break;case 9:e.next=14;break;case 11:e.prev=11,e.t0=e.catch(1),n.e(e.t0);case 14:return e.prev=14,n.f(),e.finish(14);case 17:case"end":return e.stop()}},e,null,[[1,11,14,17]])}))}function V(t){return C(this,void 0,void 0,v().mark(function e(){var n,r;return v().wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if(!t.isRendered()){e.next=5;break}n=l(t.getHints());try{for(n.s();!(r=n.n()).done;)F(r.value)}catch(t){n.e(t)}finally{n.f()}e.next=7;break;case 5:return e.next=7,t.render();case 7:case"end":return e.stop()}},e)}))}function F(t){var e=t.isActive;e&&(e.val=!0)}var M=Object,U=document,q=M.getPrototypeOf,z={isConnected:1},G={},J=q(z),$=Function.prototype,K=function(t,e,n,r){return void 0===t&&(setTimeout(n,r),t=new Set),t.add(e),t},Q=function(t,e,n){var r=T;T=e;try{return t(n)}catch(t){return console.error(t),n}finally{T=r}},X=function(t){return t.filter(function(t){var e;return null===(e=t._dom)||void 0===e?void 0:e.isConnected})},Z=function(t){R=K(R,t,function(){if(R){var t,e=l(R);try{for(e.s();!(t=e.n()).done;){var n=t.value;n._bindings=X(n._bindings),n._listeners=X(n._listeners)}}catch(t){e.e(t)}finally{e.f()}R=void 0}},1e3)},tt={get val(){var t;return null===(t=null==T?void 0:T._getters)||void 0===t||t.add(this),this.rawVal},get oldVal(){var t;return null===(t=null==T?void 0:T._getters)||void 0===t||t.add(this),this._oldVal},set val(t){var e,n=this;null===(e=null==T?void 0:T._setters)||void 0===e||e.add(n),t!==n.rawVal&&(n.rawVal=t,n._bindings.length+n._listeners.length?(null==P||P.add(n),H=K(H,n,ut)):n._oldVal=t)}},et=function(t){return{writable:!0,configurable:!0,enumerable:!0,value:t}},nt=function(t){return M.create(tt,{rawVal:et(t),_oldVal:et(t),_bindings:et([]),_listeners:et([])})},rt=function(t,e){var n={_getters:new Set,_setters:new Set},r={f:t},o=N;N=[];var i=Q(t,n,e);i=(null!=i?i:U).nodeType?i:new Text(i);var a,s=l(n._getters);try{for(s.s();!(a=s.n()).done;){var c=a.value;n._setters.has(c)||(Z(c),c._bindings.push(r))}}catch(t){s.e(t)}finally{s.f()}var u,h=l(N);try{for(h.s();!(u=h.n()).done;)u.value._dom=i}catch(t){h.e(t)}finally{h.f()}return N=o,r._dom=i},ot=function(t,e,n){var r;e=null!=e?e:nt();var o={_getters:new Set,_setters:new Set},i={f:t,s:e};i._dom=null!==(r=null!=n?n:null==N?void 0:N.push(i))&&void 0!==r?r:z,e.val=Q(t,o,e.rawVal);var a,s=l(o._getters);try{for(s.s();!(a=s.n()).done;){var c=a.value;o._setters.has(c)||(Z(c),c._listeners.push(i))}}catch(t){s.e(t)}finally{s.f()}return e},it=function(t){for(var e=arguments.length,n=new Array(e>1?e-1:0),r=1;r<e;r++)n[r-1]=arguments[r];var o,i=l(n.flat(1/0));try{var a=function(){var e=o.value,n=q(null!=e?e:0),r=n===tt?rt(function(){return e.val}):n===$?rt(e):e;null!=r&&t.append(r)};for(i.s();!(o=i.n()).done;)a()}catch(t){i.e(t)}finally{i.f()}return t},at=function(t,e){for(var n,r,o,i,a=arguments.length,s=new Array(a>2?a-2:0),c=2;c<a;c++)s[c-2]=arguments[c];var u,h=m(q(null!==(n=s[0])&&void 0!==n?n:0)===J?s:[{}].concat(s)),d=h[0],f=h.slice(1),p=t?U.createElementNS(t,e):U.createElement(e),v=l(M.entries(d));try{var g=function(){var t=b(u.value,2),n=t[0],a=t[1],s="".concat(e,",").concat(n),l=null!==(r=G[s])&&void 0!==r?r:G[s]=null!==(i=null===(o=function t(e){var r;return e?null!==(r=M.getOwnPropertyDescriptor(e,n))&&void 0!==r?r:t(q(e)):void 0}(q(p)))||void 0===o?void 0:o.set)&&void 0!==i?i:0,c=n.startsWith("on")?function(t,e){var r=n.slice(2);e&&p.removeEventListener(r,e),p.addEventListener(r,t)}:l?l.bind(p):p.setAttribute.bind(p,n),h=q(null!=a?a:0);n.startsWith("on")||h===$&&(a=ot(a),h=tt),h===tt?rt(function(){return c(a.val,a._oldVal),p}):c(a)};for(v.s();!(u=v.n()).done;)g()}catch(t){v.e(t)}finally{v.f()}return it.apply(void 0,[p].concat(w(f)))},st=function(t){return{get:function(e,n){return at.bind(void 0,null!=t?t:null,n)}}},lt=new Proxy(function(t){return new Proxy(at,st(t))},st()),ct=function(t,e){e?e!==t&&t.replaceWith(e):t.remove()},ut=function(){var t=0,e=H?w(H).filter(function(t){return t.rawVal!==t._oldVal}):[];do{P=new Set;var n,r=l(new Set(e.flatMap(function(t){return t._listeners=X(t._listeners)})));try{for(r.s();!(n=r.n()).done;){var o=n.value;ot(o.f,o.s,o._dom),o._dom=void 0}}catch(t){r.e(t)}finally{r.f()}}while(++t<100&&(e=w(P)).length);var i=H?w(H).filter(function(t){return t.rawVal!==t._oldVal}):[];H=void 0;var a,s=l(new Set(i.flatMap(function(t){return t._bindings=X(t._bindings)})));try{for(s.s();!(a=s.n()).done;){var c=a.value;c._dom&&ct(c._dom,rt(c.f,c._dom)),c._dom=void 0}}catch(t){s.e(t)}finally{s.f()}var u,h=l(i);try{for(h.s();!(u=h.n()).done;){var d=u.value;d._oldVal=d.rawVal}}catch(t){h.e(t)}finally{h.f()}},ht={add:it,tags:lt,state:nt,derive:ot,hydrate:function(t,e){return ct(t,rt(e,t))}},dt="introjs-hints";function ft(t,e){var n="";return"currentStyle"in t?n=t.currentStyle[e]:document.defaultView&&document.defaultView.getComputedStyle&&(n=document.defaultView.getComputedStyle(t,null).getPropertyValue(e)),n&&n.toLowerCase?n.toLowerCase():n}function pt(t){var e=t.parentElement;return!(!e||"HTML"===e.nodeName)&&("fixed"===ft(t,"position")||pt(e))}function vt(t,e){var n=document.body,r=document.documentElement,o=window.pageYOffset||r.scrollTop||n.scrollTop,i=window.pageXOffset||r.scrollLeft||n.scrollLeft;e=e||n;var a=t.getBoundingClientRect(),s=e.getBoundingClientRect(),l=ft(e,"position"),c={top:0,left:0};return c="body"!==e.tagName.toLowerCase()&&"relative"===l||"sticky"===l?Object.assign(c,{top:a.top-s.top,left:a.left-s.left}):pt(t)?Object.assign(c,{top:a.top,left:a.left}):Object.assign(c,{top:a.top+o,left:a.left+i}),Object.assign(Object.assign({},c),{width:a.width,height:a.height,bottom:c.top+a.height,right:c.left+a.width,absoluteTop:a.top,absoluteLeft:a.left,absoluteBottom:a.bottom,absoluteRight:a.right})}var gt=ht.tags,bt=gt.a,mt=gt.div,wt=function(t){var e,n=t.index,r=t.hintItem,o=t.onClick,i=t.refreshesSignal,a=bt((u(e={},"data-step",n.toString()),u(e,"className",function(){return function(t){var e,n=["introjs-hint"];return t.hintAnimation||n.push("introjs-hint-no-anim"),pt(t.element)&&n.push("introjs-fixedhint"),(null===(e=t.isActive)||void 0===e?void 0:e.val)||n.push("introjs-hidehint"),n.join(" ")}(r)}),u(e,"role","button"),u(e,"tabindex",0),u(e,"onclick",o),e),mt({className:"introjs-hint-dot"}),mt({className:"introjs-hint-pulse"}));return ht.derive(function(){void 0!==i.val&&function(t,e,n){if(void 0!==n){var r=vt(n),o=20,i=20;switch(t){default:case"top-left":e.style.left="".concat(r.left,"px"),e.style.top="".concat(r.top,"px");break;case"top-right":e.style.left="".concat(r.left+r.width-o,"px"),e.style.top="".concat(r.top,"px");break;case"bottom-left":e.style.left="".concat(r.left,"px"),e.style.top="".concat(r.top+r.height-i,"px");break;case"bottom-right":e.style.left="".concat(r.left+r.width-o,"px"),e.style.top="".concat(r.top+r.height-i,"px");break;case"middle-left":e.style.left="".concat(r.left,"px"),e.style.top="".concat(r.top+(r.height-i)/2,"px");break;case"middle-right":e.style.left="".concat(r.left+r.width-o,"px"),e.style.top="".concat(r.top+(r.height-i)/2,"px");break;case"middle-middle":e.style.left="".concat(r.left+(r.width-o)/2,"px"),e.style.top="".concat(r.top+(r.height-i)/2,"px");break;case"bottom-middle":e.style.left="".concat(r.left+(r.width-o)/2,"px"),e.style.top="".concat(r.top+r.height-i,"px");break;case"top-middle":e.style.left="".concat(r.left+(r.width-o)/2,"px"),e.style.top="".concat(r.top,"px")}}}(r.hintPosition,a,r.element)}),a},yt=function(t){for(var e=arguments.length,n=new Array(e>1?e-1:0),r=1;r<e;r++)n[r-1]=arguments[r];for(var o=0,i=n;o<i.length;o++){var a=i[o];if(t instanceof SVGElement){var s=t.getAttribute("class")||"";s.match(a)||kt(t,s,a)}else void 0!==t.classList?t.classList.add(a):t.className.match(a)||kt(t,t.className,a)}},kt=function(t){for(var e=arguments.length,n=new Array(e>1?e-1:0),r=1;r<e;r++)n[r-1]=arguments[r];var o=n.filter(Boolean).join(" ");t instanceof SVGElement?t.setAttribute("class",o):void 0!==t.classList?t.classList.value=o:t.className=o},xt=function(t,e){if(t instanceof SVGElement){var n=t.getAttribute("class")||"";t.setAttribute("class",n.replace(e,"").replace(/\s\s+/g," ").trim())}else t.className=t.className.replace(e,"").replace(/\s\s+/g," ").trim()},St=function(t){var e="";for(var n in t)e+="".concat(n,":").concat(t[n],";");return e},Ct=function(t,e,n,r){var o=function(t,e,n,r){if(e&&t&&n){n instanceof Element&&pt(n)?yt(e,"introjs-fixedTooltip"):xt(e,"introjs-fixedTooltip");var o=vt(n,t);return{width:"".concat(o.width+r,"px"),height:"".concat(o.height+r,"px"),top:"".concat(o.top-r/2,"px"),left:"".concat(o.left-r/2,"px")}}}(t,e,n,r);o&&function(t,e){var n="";t.style.cssText&&(n+=t.style.cssText),n+="string"==typeof e?e:St(e),t.style.cssText=n}(e,o)};function _t(){if(void 0!==window.innerWidth)return{width:window.innerWidth,height:window.innerHeight};var t=document.documentElement;return{width:t.clientWidth,height:t.clientHeight}}function Ot(t,e){t.includes(e)&&t.splice(t.indexOf(e),1)}var Et=ht.tags.div;function At(t,e,n,r,o){return t.left+t.width-e-n<0?(r.val="-".concat(t.left,"px"),!1):(o.val="".concat(e,"px"),!0)}function jt(t,e,n,r,o){return t.left+n+r>e.width?(o.val="".concat(e.width-r-t.left,"px"),!1):(o.val="".concat(n,"px"),!0)}var Lt=function(t,e){var n=t.position,r=t.element,o=t.refreshes,i=t.hintMode,a=void 0!==i&&i,s=t.showStepNumbers,l=void 0!==s&&s,c=t.transitionDuration,u=void 0===c?0:c,h=t.positionPrecedence,d=void 0===h?[]:h,f=t.className,p=t.autoPosition,v=void 0===p||p,g=t.onClick,b=ht.state("auto"),m=ht.state("auto"),w=ht.state("auto"),y=ht.state("auto"),k=ht.state("0"),x=ht.state("0"),S=ht.state(0),C=ht.state(250),_=ht.state(300),O=ht.state(n),E=ht.state(_t()),A=ht.state(vt(r)),j=ht.derive(function(){return A.val.top+C.val>E.val.height});ht.derive(function(){void 0!==o.val&&(E.val=_t(),A.val=vt(r))}),ht.derive(function(){void 0!==O.val&&"floating"!==n&&v&&_.val&&C.val&&A.val&&E.val&&(O.val=function(t,e,n,r,o,i){var a=t.slice();r+=10,n+=20;var s="floating";if(e.absoluteBottom+r>i.height&&Ot(a,"bottom"),e.absoluteTop-r<0&&Ot(a,"top"),e.absoluteRight+n>i.width&&Ot(a,"right"),e.absoluteLeft-n<0&&Ot(a,"left"),o&&(o=o.split("-")[0]),a.length&&(s=a[0],a.includes(o)&&(s=o)),"top"===s||"bottom"===s){var l,c=[];"top"===s?(l="top-middle-aligned",c=["top-left-aligned","top-middle-aligned","top-right-aligned"]):(l="bottom-middle-aligned",c=["bottom-left-aligned","bottom-middle-aligned","bottom-right-aligned"]),s=function(t,e,n,r){var o=e/2,i=Math.min(n,window.screen.width);return i-t<e&&(Ot(r,"top-left-aligned"),Ot(r,"bottom-left-aligned")),(t<o||i-t<o)&&(Ot(r,"top-middle-aligned"),Ot(r,"bottom-middle-aligned")),t<e&&(Ot(r,"top-right-aligned"),Ot(r,"bottom-right-aligned")),r.length?r[0]:null}(e.absoluteLeft,n,i.width,c)||l}return s}(d,A.val,_.val,C.val,n,E.val))}),ht.derive(function(){void 0!==_.val&&void 0!==C.val&&void 0!==j.val&&void 0!==O.val&&void 0!==A.val&&void 0!==E.val&&function(t,e,n,r,o,i,a,s,l,c,u,h,d,f){i.val="auto",a.val="auto",s.val="auto",l.val="auto",c.val="0",u.val="0";var p=e.width/2-r/2;switch(t){case"top-right-aligned":var v=0;At(e,v,r,s,l),a.val="".concat(e.height+20,"px");break;case"top-middle-aligned":f&&(p+=5),At(e,p,r,s,l)&&(l.val=void 0,jt(e,n,p,r,s)),a.val="".concat(e.height+20,"px");break;case"top-left-aligned":case"top":jt(e,n,f?0:15,r,s),a.val="".concat(e.height+20,"px");break;case"right":s.val="".concat(e.width+20,"px"),h.val&&(i.val="-".concat(o-e.height-20,"px"));break;case"left":f||!0!==d||(i.val="15px"),h.val&&(i.val="-".concat(o-e.height-20,"px")),l.val="".concat(e.width+20,"px");break;case"floating":s.val="50%",i.val="50%",c.val="-".concat(r/2,"px"),u.val="-".concat(o/2,"px");break;case"bottom-right-aligned":At(e,v=0,r,s,l),i.val="".concat(e.height+20,"px");break;case"bottom-middle-aligned":f&&(p+=5),At(e,p,r,s,l)&&(l.val="",jt(e,n,p,r,s)),i.val="".concat(e.height+20,"px");break;default:jt(e,n,0,r,s),i.val="".concat(e.height+20,"px")}}(O.val,A.val,E.val,_.val,C.val,b,w,y,m,k,x,j,l,a)});var L,H,P=Et({style:function(){return"top: ".concat(b.val,"; right: ").concat(m.val,"; bottom: ").concat(w.val,"; left: ").concat(y.val,"; margin-left: ").concat(k.val,"; margin-top: ").concat(x.val,";opacity: ").concat(S.val)},className:function(){return"".concat("introjs-tooltip"," introjs-").concat(O.val," ").concat(f||"")},role:"dialog",onclick:null!=g?g:null},[(L={tooltipPosition:O,tooltipBottomOverflow:j},H=ht.derive(function(){var t=["introjs-arrow"];switch(L.tooltipPosition.val){case"top-right-aligned":t.push("bottom-right");break;case"top-middle-aligned":t.push("bottom-middle");break;case"top-left-aligned":case"top":t.push("bottom");break;case"right":L.tooltipBottomOverflow.val?t.push("left-bottom"):t.push("left");break;case"left":L.tooltipBottomOverflow.val?t.push("right-bottom"):t.push("right");break;case"floating":break;case"bottom-right-aligned":t.push("top-right");break;case"bottom-middle-aligned":t.push("top-middle");break;default:t.push("top")}return t}),Et({className:function(){var t;return null===(t=H.val)||void 0===t?void 0:t.filter(Boolean).join(" ")},style:function(){return"display: ".concat("floating"===L.tooltipPosition.val?"none":"block",";")}})),[e]]);return setTimeout(function(){S.val=1},u),setTimeout(function(){C.val=P.offsetHeight,_.val=P.offsetWidth},1),P},Ht=function(t){var e=t.text,n=t.container,r=t.tooltipRenderAsHtml;return ht.derive(function(){var t=n;if(t)if(t.innerHTML="",r&&e){var o=document.createRange().createContextualFragment(e);t.appendChild(o)}else t.textContent=e}),n},Pt=ht.tags,Tt=Pt.a,Nt=Pt.div,Rt=ht.tags.div,Bt=function(t){var e=t.activeHintSignal,n=t.targetElement,r=t.helperElementPadding,o=S(t,["activeHintSignal","targetElement","helperElementPadding"]),i=e.val;return function(){var t;if(null==e.val)return null;if(i!==e.val)return null;var a=Rt((u(t={},"data-step",e.val),u(t,"className","".concat("introjs-tooltipReferenceLayer"," ").concat("introjs-hintReference")),t),function(t){var e=t.hintItem,n=t.closeButtonEnabled,r=t.closeButtonOnClick,o=t.closeButtonLabel,i=t.closeButtonClassName,a=t.className,s=t.renderAsHtml,l=S(t,["hintItem","closeButtonEnabled","closeButtonOnClick","closeButtonLabel","closeButtonClassName","className","renderAsHtml"]),c=e.hint;return Lt(Object.assign(Object.assign({},l),{element:e.hintTooltipElement,position:e.position,hintMode:!0,onClick:function(t){t.stopPropagation?t.stopPropagation():t.cancelBubble=!0}}),[Nt({className:"".concat("introjs-tooltiptext"," ").concat(a||"")},Ht({text:c||"",tooltipRenderAsHtml:s,container:Nt({className:"introjs-tooltiptext"})}),n?Tt({className:i,role:"button",onclick:function(){return r(e)}},o):null)])}(o));return setTimeout(function(){Ct(n,a,o.hintItem.hintTooltipElement,r)},1),a}},Dt=ht.tags.div,It=function(t,e){return function(n){var r=n||window.event;r&&r.stopPropagation&&r.stopPropagation(),r&&null!==r.cancelBubble&&(r.cancelBubble=!0),t.showHintDialog(e)}},Wt=function(){function t(e,n){i(this,t),this._hints=[],this._activeHintSignal=ht.state(void 0),this._refreshesSignal=ht.state(0),this.callbacks={},this._targetElement=I(e),this._options=n?L(this._options,n):{hints:[],isActive:!0,tooltipPosition:"bottom",tooltipClass:"",hintPosition:"top-middle",hintButtonLabel:"Got it",hintShowButton:!0,hintAutoRefreshInterval:10,hintAnimation:!0,buttonClass:"introjs-button",helperElementPadding:10,autoPosition:!0,positionPrecedence:["bottom","top","right","left"],tooltipRenderAsHtml:!0}}return s(t,[{key:"callback",value:function(t){var e=this.callbacks[t];if(B(e))return e}},{key:"getTargetElement",value:function(){return this._targetElement}},{key:"getHints",value:function(){return this._hints}},{key:"getHint",value:function(t){return this._hints[t]}},{key:"setHints",value:function(t){return this._hints=t,this}},{key:"addHint",value:function(t){return t.isActive=ht.state(!0),this._hints.push(t),this}},{key:"getActiveHintSignal",value:function(){return this._activeHintSignal}},{key:"getRefreshesSignal",value:function(){return this._refreshesSignal}},{key:"isRendered",value:function(){return void 0!==this._root}},{key:"createRoot",value:function(){this._root=function(t){var e,n=t.hint,r=[],o=l(n.getHints().entries());try{for(o.s();!(e=o.n()).done;){var i=b(e.value,2),a=i[0],s=i[1],c=wt({index:a,hintItem:s,onClick:It(n,a),refreshesSignal:n.getRefreshesSignal()});s.hintTooltipElement=c,r.push(c)}}catch(t){o.e(t)}finally{o.f()}var u=Dt.apply(void 0,[{className:dt}].concat(r));return ht.derive(function(){var t=n.getActiveHintSignal();if(void 0!==t.val){var e=t.val,r=n.getHints()[e];if(r){var o=Bt({activeHintSignal:t,hintItem:r,helperElementPadding:n.getOption("helperElementPadding"),targetElement:n.getTargetElement(),refreshes:n.getRefreshesSignal(),showStepNumbers:!1,renderAsHtml:n.getOption("tooltipRenderAsHtml"),autoPosition:n.getOption("autoPosition"),positionPrecedence:n.getOption("positionPrecedence"),closeButtonEnabled:n.getOption("hintShowButton"),closeButtonLabel:n.getOption("hintButtonLabel"),closeButtonClassName:n.getOption("buttonClass"),closeButtonOnClick:function(t){return W(n,t)},className:n.getOption("tooltipClass")});ht.add(u,o)}}}),u}({hint:this}),ht.add(this._targetElement,this._root)}},{key:"recreateRoot",value:function(){this._root&&(this._root.remove(),this.createRoot())}},{key:"render",value:function(){var t;return C(this,void 0,void 0,v().mark(function e(){return v().wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if(this.isActive()){e.next=2;break}return e.abrupt("return",this);case 2:if(!this.isRendered()){e.next=4;break}return e.abrupt("return",this);case 4:return A(this),this.createRoot(),null===(t=this.callback("hintsAdded"))||void 0===t||t.call(this),this.enableHintAutoRefresh(),this.enableCloseDialogOnWindowClick(),e.abrupt("return",this);case 10:case"end":return e.stop()}},e,this)}))}},{key:"enableCloseDialogOnWindowClick",value:function(){var t=this;this._windowClickFunction=function(){t._activeHintSignal.val=void 0},D.on(document,"click",this._windowClickFunction,!1)}},{key:"disableCloseDialogOnWindowClick",value:function(){this._windowClickFunction&&D.off(document,"click",this._windowClickFunction,!1)}},{key:"addHints",value:function(){return C(this,void 0,void 0,v().mark(function t(){return v().wrap(function(t){for(;;)switch(t.prev=t.next){case 0:return t.abrupt("return",this.render());case 1:case"end":return t.stop()}},t,this)}))}},{key:"hideHint",value:function(t){return C(this,void 0,void 0,v().mark(function e(){var n;return v().wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if(!(n=this.getHint(t))){e.next=4;break}return e.next=4,W(this,n);case 4:return e.abrupt("return",this);case 5:case"end":return e.stop()}},e,this)}))}},{key:"hideHints",value:function(){return C(this,void 0,void 0,v().mark(function t(){return v().wrap(function(t){for(;;)switch(t.prev=t.next){case 0:return t.next=2,Y(this);case 2:return t.abrupt("return",this);case 3:case"end":return t.stop()}},t,this)}))}},{key:"showHint",value:function(t){var e=this.getHint(t);return e&&F(e),this}},{key:"showHints",value:function(){return C(this,void 0,void 0,v().mark(function t(){return v().wrap(function(t){for(;;)switch(t.prev=t.next){case 0:return t.next=2,V(this);case 2:return t.abrupt("return",this);case 3:case"end":return t.stop()}},t,this)}))}},{key:"destroy",value:function(){return this._root&&(this._root.remove(),this._root=void 0),this.disableHintAutoRefresh(),this.disableCloseDialogOnWindowClick(),this}},{key:"removeHints",value:function(){return this.destroy(),this}},{key:"removeHint",value:function(t){return this._hints=this._hints.filter(function(e,n){return n!==t}),this.recreateRoot(),this}},{key:"showHintDialog",value:function(t){var e;return C(this,void 0,void 0,v().mark(function n(){var r;return v().wrap(function(n){for(;;)switch(n.prev=n.next){case 0:if(r=this.getHint(t)){n.next=3;break}return n.abrupt("return");case 3:if(this._activeHintSignal.val===t){n.next=9;break}return this._activeHintSignal.val=t,n.next=7,null===(e=this.callback("hintClick"))||void 0===e?void 0:e.call(this,r);case 7:n.next=10;break;case 9:this._activeHintSignal.val=void 0;case 10:return n.abrupt("return",this);case 11:case"end":return n.stop()}},n,this)}))}},{key:"hideHintDialog",value:function(){return this._activeHintSignal.val=void 0,this}},{key:"refresh",value:function(){return this.isRendered()?(void 0!==this._refreshesSignal.val&&(this._refreshesSignal.val+=1),this):this}},{key:"enableHintAutoRefresh",value:function(){var t,e,n,r=this,o=this.getOption("hintAutoRefreshInterval");return o>=0&&(this._hintsAutoRefreshFunction=(t=function(){return r.refresh()},e=o,function(){for(var r=arguments.length,o=new Array(r),i=0;i<r;i++)o[i]=arguments[i];window.clearTimeout(n),n=window.setTimeout(function(){t()},e)}),D.on(window,"scroll",this._hintsAutoRefreshFunction,!0),D.on(window,"resize",this._hintsAutoRefreshFunction,!0)),this}},{key:"disableHintAutoRefresh",value:function(){return this._hintsAutoRefreshFunction&&(D.off(window,"scroll",this._hintsAutoRefreshFunction,!0),D.on(window,"resize",this._hintsAutoRefreshFunction,!0),this._hintsAutoRefreshFunction=void 0),this}},{key:"getOption",value:function(t){return this._options[t]}},{key:"setOptions",value:function(t){return this._options=L(this._options,t),this}},{key:"setOption",value:function(t,e){return this._options=j(this._options,t,e),this}},{key:"clone",value:function(){return new t(this._targetElement,this._options)}},{key:"isActive",value:function(){return this.getOption("isActive")}},{key:"onHintsAdded",value:function(t){if(!B(t))throw new Error("Provided callback for onhintsadded was not a function.");return this.callbacks.hintsAdded=t,this}},{key:"onhintsadded",value:function(t){this.onHintsAdded(t)}},{key:"onHintClick",value:function(t){if(!B(t))throw new Error("Provided callback for onhintclick was not a function.");return this.callbacks.hintClick=t,this}},{key:"onhintclick",value:function(t){this.onHintClick(t)}},{key:"onHintClose",value:function(t){if(!B(t))throw new Error("Provided callback for onhintclose was not a function.");return this.callbacks.hintClose=t,this}},{key:"onhintclose",value:function(t){this.onHintClose(t)}}]),t}();function Yt(t){yt(t,"introjs-showElement");var e=ft(t,"position");"absolute"!==e&&"relative"!==e&&"sticky"!==e&&"fixed"!==e&&yt(t,"introjs-relativePosition")}function Vt(t,e){var n,r;return C(this,void 0,void 0,v().mark(function o(){return v().wrap(function(o){for(;;)switch(o.prev=o.next){case 0:return null===(n=t.callback("change"))||void 0===n||n.call(t,e.element),Ft(),Yt(e.element),o.next=5,null===(r=t.callback("afterChange"))||void 0===r?void 0:r.call(t,e.element);case 5:case"end":return o.stop()}},o)}))}function Ft(){for(var t=0,e=Array.from(E(".".concat("introjs-showElement"),undefined));t<e.length;t++){var n=e[t];xt(n,/introjs-[a-zA-Z]+/g)}}function Mt(t){var e,n;return C(this,void 0,void 0,v().mark(function r(){var o,i;return v().wrap(function(r){for(;;)switch(r.prev=r.next){case 0:if(t.incrementCurrentStep(),void 0!==(o=t.getCurrentStep())){r.next=4;break}return r.abrupt("return",!1);case 4:return i=t.getStep(o),r.next=8,null===(e=t.callback("beforeChange"))||void 0===e?void 0:e.call(t,i&&i.element,t.getCurrentStep(),t.getDirection());case 8:if(!1!==r.sent){r.next=12;break}return t.decrementCurrentStep(),r.abrupt("return",!1);case 12:if(!t.isEnd()){r.next=18;break}return r.next=15,null===(n=t.callback("complete"))||void 0===n?void 0:n.call(t,t.getCurrentStep(),"end");case 15:return r.next=17,t.exit();case 17:return r.abrupt("return",!1);case 18:return r.next=20,Vt(t,i);case 20:return r.abrupt("return",!0);case 21:case"end":return r.stop()}},r)}))}function Ut(t){var e;return C(this,void 0,void 0,v().mark(function n(){var r,o;return v().wrap(function(n){for(;;)switch(n.prev=n.next){case 0:if(!(void 0===(r=t.getCurrentStep())||r<=0)){n.next=3;break}return n.abrupt("return",!1);case 3:if(t.decrementCurrentStep(),void 0!==(r=t.getCurrentStep())){n.next=7;break}return n.abrupt("return",!1);case 7:return o=t.getStep(r),n.next=11,null===(e=t.callback("beforeChange"))||void 0===e?void 0:e.call(t,o&&o.element,t.getCurrentStep(),t.getDirection());case 11:if(!1!==n.sent){n.next=15;break}return t.incrementCurrentStep(),n.abrupt("return",!1);case 15:return n.next=17,Vt(t,o);case 17:return n.abrupt("return",!0);case 18:case"end":return n.stop()}},n)}))}var qt=function(t){var e,n=[];if(null===(e=t.getOption("steps"))||void 0===e?void 0:e.length){var r,o=l(t.getOption("steps"));try{for(o.s();!(r=o.n()).done;){var i=_(r.value);i.step=n.length+1,i.title=i.title||"","string"==typeof i.element&&(i.element=O(i.element)||void 0),i.element||(i.element=t.appendFloatingElement(),i.position="floating"),i.position=i.position||t.getOption("tooltipPosition"),i.scrollTo=i.scrollTo||t.getOption("scrollTo"),void 0===i.disableInteraction&&(i.disableInteraction=t.getOption("disableInteraction")),null!==i.element&&n.push(i)}}catch(t){o.e(t)}finally{o.f()}}else{var a=Array.from(E("*[".concat("data-intro","]"),t.getTargetElement()));if(a.length<1)return[];for(var s=[],c=0,u=a;c<u.length;c++){var h=u[c];if((!t.getOption("group")||h.getAttribute("data-intro-group")===t.getOption("group"))&&"none"!==h.style.display){var d=parseInt(h.getAttribute("data-step")||"0",10),f=t.getOption("disableInteraction");h.hasAttribute("data-disable-interaction")&&(f=!!h.getAttribute("data-disable-interaction"));var p={step:d,element:h,title:h.getAttribute("data-title")||"",intro:h.getAttribute("data-intro")||"",tooltipClass:h.getAttribute("data-tooltip-class")||void 0,highlightClass:h.getAttribute("data-highlight-class")||void 0,position:h.getAttribute("data-position")||t.getOption("tooltipPosition"),scrollTo:h.getAttribute("data-scroll-to")||t.getOption("scrollTo"),disableInteraction:f};d>0?n[d-1]=p:s.push(p)}}for(var v=0;s.length>0;v++)if(void 0===n[v]){var g=s.shift();if(!g)break;g.step=v+1,n[v]=g}}return(n=n.filter(function(t){return t})).sort(function(t,e){return t.step-e.step}),n},zt=function(t){return C(void 0,void 0,void 0,v().mark(function e(){var n,r;return v().wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if(t.isActive()){e.next=2;break}return e.abrupt("return",!1);case 2:if(!t.hasStarted()){e.next=4;break}return e.abrupt("return",!1);case 4:return e.next=6,null===(n=t.callback("start"))||void 0===n?void 0:n.call(t,t.getTargetElement());case 6:if(0!==(r=qt(t)).length){e.next=9;break}return e.abrupt("return",!1);case 9:return t.setSteps(r),e.next=12,Mt(t);case 12:return e.abrupt("return",!0);case 13:case"end":return e.stop()}},e)}))};function Gt(t){var e,n,r=arguments.length>1&&void 0!==arguments[1]&&arguments[1];return C(this,void 0,void 0,v().mark(function o(){var i,a;return v().wrap(function(o){for(;;)switch(o.prev=o.next){case 0:return i=t.getTargetElement(),a=!0,o.next=4,null===(e=t.callback("beforeExit"))||void 0===e?void 0:e.call(t,i);case 4:if(a=o.sent,r||!1!==a){o.next=7;break}return o.abrupt("return",!1);case 7:return Ft(),o.next=10,null===(n=t.callback("exit"))||void 0===n?void 0:n.call(t);case 10:return t.resetCurrentStep(),o.abrupt("return",!0);case 12:case"end":return o.stop()}},o)}))}function Jt(t,e,n){var r,o=(u(r={},t,e),u(r,"path","/"),u(r,"expires",void 0),r);if(n){var i=new Date;i.setTime(i.getTime()+24*n*60*60*1e3),o.expires=i.toUTCString()}var a=[];for(var s in o)a.push("".concat(s,"=").concat(o[s]));return document.cookie=a.join("; "),$t(t)}function $t(t){return(e={},document.cookie.split(";").forEach(function(t){var n=b(t.split("="),2),r=n[0],o=n[1];e[r.trim()]=o}),e)[t];var e}var Kt=function(t,e,n,r){Ct(t,e,n.element,"floating"===n.position?0:r)};var Qt=ht.tags,Xt=Qt.h1,Zt=Qt.div,te=Qt.input,ee=Qt.label,ne=Qt.ul,re=Qt.li,oe=Qt.a,ie=function(t){var e=t.label,n=t.onClick,r=t.disabled,o=t.className;return oe({role:"button",tabIndex:0,ariaDisabled:null!=r&&r,onclick:n,className:null!=o?o:""},[e])},ae=function(t){var e=t.step,n=t.currentStep,r=t.steps,o=t.onBulletClick,i=t.bullets,a=t.buttons,s=t.nextLabel,l=t.onNextClick,c=t.prevLabel,h=t.onPrevClick,d=t.skipLabel,f=t.onSkipClick,p=t.buttonClass,v=t.nextToDone,g=t.doneLabel,b=t.hideNext,m=t.hidePrev,y=t.progress,k=t.progressBarAdditionalClass,x=t.stepNumbers,C=t.stepNumbersOfLabel,_=t.scrollToElement,O=t.scrollPadding,E=t.dontShowAgain,A=t.onDontShowAgainChange,j=t.dontShowAgainLabel,L=t.renderAsHtml,H=S(t,["step","currentStep","steps","onBulletClick","bullets","buttons","nextLabel","onNextClick","prevLabel","onPrevClick","skipLabel","onSkipClick","buttonClass","nextToDone","doneLabel","hideNext","hidePrev","progress","progressBarAdditionalClass","stepNumbers","stepNumbersOfLabel","scrollToElement","scrollPadding","dontShowAgain","onDontShowAgainChange","dontShowAgainLabel","renderAsHtml"]),P=[],T=e.title,N=e.intro,R=e.position;P.push(function(t){var e=t.skipLabel,n=t.onSkipClick,r=Ht({text:t.title,tooltipRenderAsHtml:t.renderAsHtml,container:Xt({className:"introjs-tooltip-title"})});return Zt({className:"introjs-tooltip-header"},[r,ie({className:"introjs-skipbutton",label:e,onClick:n})])}({title:T,skipLabel:d,renderAsHtml:L,onSkipClick:f})),P.push(Ht({text:N,tooltipRenderAsHtml:L,container:Zt({className:"introjs-tooltiptext"})})),E&&P.push(function(t){var e=t.dontShowAgainLabel,n=t.onDontShowAgainChange;return Zt({className:"introjs-dontShowAgain"},[te({type:"checkbox",id:"introjs-dontShowAgain",name:"introjs-dontShowAgain",onchange:function(t){n(t.target.checked)}}),ee({for:"introjs-dontShowAgain"},e)])}({dontShowAgainLabel:j,onDontShowAgainChange:A})),i&&P.push(function(t){var e=t.step,n=t.onBulletClick;return Zt({className:"introjs-bullets"},[ne({role:"tablist"},w(t.steps.map(function(t){var r=t.step;return re({role:"presentation"},[oe(u({role:"tab",className:function(){return"".concat(e.step===r?"active":"")},onclick:function(t){var e=t.target.getAttribute("data-step-number");e&&n(parseInt(e,10))},innerHTML:"&nbsp;"},"data-step-number",r))])})))])}({step:e,steps:r,onBulletClick:o})),y&&P.push(function(t){var e=t.progressBarAdditionalClass,n=(t.currentStep+1)/t.steps.length*100;return Zt({className:"introjs-progress"},[Zt({className:"".concat("introjs-progressbar"," ").concat(e||""),role:"progress","aria-valuemin":"0","aria-valuemax":"100","aria-valuenow":function(){return n.toString()},style:"width:".concat(n,"%;")})])}({steps:r,currentStep:n,progressBarAdditionalClass:k})),x&&P.push(function(t){var e=t.steps,n=t.stepNumbersOfLabel;return Zt({className:"introjs-helperNumberLayer"},["".concat(t.step.step," ").concat(n," ").concat(e.length)])}({step:e,steps:r,stepNumbersOfLabel:C})),a&&P.push(function(t){var e=t.steps,n=t.currentStep,r=t.buttonClass,o=t.nextToDone,i=t.doneLabel,a=t.hideNext,s=t.nextLabel,l=t.onNextClick,c=t.hidePrev,u=t.prevLabel,h=t.onPrevClick;return Zt({className:"introjs-tooltipbuttons"},e.length>1?function(t){var e=t.label,n=t.steps,r=t.currentStep,o=t.hidePrev,i=t.hideNext,a=t.onClick,s=t.buttonClass,l=0===r&&n.length>1,c=l&&!o,u=l&&o,h=(r===n.length-1||1===n.length)&&i;return ie({label:e,onClick:a,disabled:c,className:function(){var t=[s,"introjs-prevbutton"];return h&&t.push("introjs-fullbutton"),c&&t.push("introjs-disabled"),u&&t.push("introjs-hidden"),t.filter(Boolean).join(" ")}})}({label:u,steps:e,currentStep:n,hidePrev:c,hideNext:a,onClick:h,buttonClass:r}):null,function(t){var e=t.steps,n=t.currentStep,r=t.nextLabel,o=t.doneLabel,i=t.hideNext,a=t.hidePrev,s=t.nextToDone,l=t.onClick,c=t.buttonClass,u=0===n&&e.length>1&&a,h=n===e.length-1||1===e.length,d=ht.derive(function(){return h&&!i&&!s}),f=ht.derive(function(){return h&&!i&&s}),p=ie({label:f.val?o:r,onClick:l,className:function(){var t=[c,"introjs-nextbutton"];return f.val&&t.push("introjs-donebutton"),d.val&&t.push("introjs-disabled"),u&&t.push("introjs-fullbutton"),t.filter(Boolean).join(" ")}});return setTimeout(function(){p.focus()},1),p}({currentStep:n,steps:e,doneLabel:i,nextLabel:s,onClick:l,hideNext:a,hidePrev:c,nextToDone:o,buttonClass:r}))}({steps:r,currentStep:n,nextLabel:s,onNextClick:l,prevLabel:c,onPrevClick:h,buttonClass:p,nextToDone:v,doneLabel:g,hideNext:b,hidePrev:m}));var B=Lt(Object.assign(Object.assign({},H),{element:e.element,hintMode:!1,position:R}),P);return function(t){var e=t.step,n=t.tooltip,r=t.scrollToElement,o=t.scrollPadding;(function(t,e){if(t){var n=function(t){var e=window.getComputedStyle(t),n="absolute"===e.position,r=/(auto|scroll)/;if("fixed"===e.position)return document.body;for(var o=t;o=o.parentElement;)if(e=window.getComputedStyle(o),(!n||"static"!==e.position)&&r.test(e.overflow+e.overflowY+e.overflowX))return o;return document.body}(e);n!==document.body&&(n.scrollTop=e.offsetTop-n.offsetTop)}})(r,e.element),function(t,e,n,r,o){var i;if("off"!==e&&t&&(i="tooltip"===e?o.getBoundingClientRect():r.getBoundingClientRect(),!function(t){var e=t.getBoundingClientRect();return e.top>=0&&e.left>=0&&e.bottom+80<=window.innerHeight&&e.right<=window.innerWidth}(r))){var a=_t().height;i.bottom-(i.bottom-i.top)<0||r.clientHeight>a?window.scrollBy(0,i.top-(a/2-i.height/2)-n):window.scrollBy(0,i.top-(a/2-i.height/2)+n)}}(r,e.scrollTo,o,e.element,n)}({step:e,tooltip:B,scrollToElement:_,scrollPadding:O}),B},se=ht.tags.div,le=ht.tags.div,ce=ht.tags.div,ue=ht.tags.div,he=ht.tags.div,de=ht.tags.div,fe=function(){function t(e,n){i(this,t),this._steps=[],this._currentStepSignal=ht.state(void 0),this._refreshesSignal=ht.state(0),this.callbacks={},this._targetElement=I(e),this._options=n?L(this._options,n):{steps:[],isActive:!0,nextLabel:"Next",prevLabel:"Back",skipLabel:"×",doneLabel:"Done",hidePrev:!1,hideNext:!1,nextToDone:!0,tooltipPosition:"bottom",tooltipClass:"",group:"",highlightClass:"",exitOnEsc:!0,exitOnOverlayClick:!0,showStepNumbers:!1,stepNumbersOfLabel:"of",keyboardNavigation:!0,showButtons:!0,showBullets:!0,showProgress:!1,scrollToElement:!0,scrollTo:"element",scrollPadding:30,overlayOpacity:.5,autoPosition:!0,positionPrecedence:["bottom","top","right","left"],disableInteraction:!1,dontShowAgain:!1,dontShowAgainLabel:"Don't show this again",dontShowAgainCookie:"introjs-dontShowAgain",dontShowAgainCookieDays:365,helperElementPadding:10,buttonClass:"introjs-button",progressBarAdditionalClass:"",tooltipRenderAsHtml:!0}}return s(t,[{key:"callback",value:function(t){var e=this.callbacks[t];if(B(e))return e}},{key:"goToStep",value:function(t){return C(this,void 0,void 0,v().mark(function e(){return v().wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return this.setCurrentStep(t-2),e.next=3,Mt(this);case 3:return e.abrupt("return",this);case 4:case"end":return e.stop()}},e,this)}))}},{key:"goToStepNumber",value:function(t){return C(this,void 0,void 0,v().mark(function e(){var n;return v().wrap(function(e){for(;;)switch(e.prev=e.next){case 0:n=0;case 1:if(!(n<this._steps.length)){e.next=9;break}if(this._steps[n].step!==t){e.next=6;break}return this.setCurrentStep(n-1),e.abrupt("break",9);case 6:n++,e.next=1;break;case 9:return e.next=11,Mt(this);case 11:return e.abrupt("return",this);case 12:case"end":return e.stop()}},e,this)}))}},{key:"addStep",value:function(t){return this._options.steps||(this._options.steps=[]),this._options.steps.push(t),this}},{key:"addSteps",value:function(t){if(!t.length)return this;var e,n=l(t);try{for(n.s();!(e=n.n()).done;){var r=e.value;this.addStep(r)}}catch(t){n.e(t)}finally{n.f()}return this}},{key:"setSteps",value:function(t){return this._steps=t,this}},{key:"getSteps",value:function(){return this._steps}},{key:"getStep",value:function(t){return this._steps[t]}},{key:"getCurrentStepSignal",value:function(){return this._currentStepSignal}},{key:"getRefreshesSignal",value:function(){return this._refreshesSignal}},{key:"getCurrentStep",value:function(){return this._currentStepSignal.val}},{key:"currentStep",value:function(){return this._currentStepSignal.val}},{key:"resetCurrentStep",value:function(){this._currentStepSignal.val=void 0}},{key:"setCurrentStep",value:function(t){return void 0===this._currentStepSignal.val||t>=this._currentStepSignal.val?this._direction="forward":this._direction="backward",this._currentStepSignal.val=t,this}},{key:"incrementCurrentStep",value:function(){var t=this.getCurrentStep();return void 0===t?this.setCurrentStep(0):this.setCurrentStep(t+1),this}},{key:"decrementCurrentStep",value:function(){var t=this.getCurrentStep();return void 0!==t&&t>0&&this.setCurrentStep(t-1),this}},{key:"getDirection",value:function(){return this._direction}},{key:"nextStep",value:function(){return C(this,void 0,void 0,v().mark(function t(){return v().wrap(function(t){for(;;)switch(t.prev=t.next){case 0:return t.next=2,Mt(this);case 2:return t.abrupt("return",this);case 3:case"end":return t.stop()}},t,this)}))}},{key:"previousStep",value:function(){return C(this,void 0,void 0,v().mark(function t(){return v().wrap(function(t){for(;;)switch(t.prev=t.next){case 0:return t.next=2,Ut(this);case 2:return t.abrupt("return",this);case 3:case"end":return t.stop()}},t,this)}))}},{key:"isEnd",value:function(){var t=this.getCurrentStep();return void 0!==t&&t>=this._steps.length}},{key:"isLastStep",value:function(){return this.getCurrentStep()===this._steps.length-1}},{key:"getTargetElement",value:function(){return this._targetElement}},{key:"setOptions",value:function(t){return this._options=L(this._options,t),this}},{key:"setOption",value:function(t,e){return this._options=j(this._options,t,e),this}},{key:"getOption",value:function(t){return this._options[t]}},{key:"clone",value:function(){return new t(this._targetElement,this._options)}},{key:"isActive",value:function(){return(!this.getOption("dontShowAgain")||(""===(t=$t(this.getOption("dontShowAgainCookie")))||"true"!==t))&&this.getOption("isActive");var t}},{key:"hasStarted",value:function(){return void 0!==this.getCurrentStep()}},{key:"setDontShowAgain",value:function(t){return function(t,e,n){t?Jt(e,"true",n):Jt(e,"",-1)}(t,this.getOption("dontShowAgainCookie"),this.getOption("dontShowAgainCookieDays")),this}},{key:"enableKeyboardNavigation",value:function(){var t=this;return this.getOption("keyboardNavigation")&&(this._keyboardNavigationHandler=function(e){return function(t,e){var n;return C(this,void 0,void 0,v().mark(function r(){var o,i;return v().wrap(function(r){for(;;)switch(r.prev=r.next){case 0:if(null===(o=void 0===e.code?e.which:e.code)&&(o=null===e.charCode?e.keyCode:e.charCode),"Escape"!==o&&27!==o||!0!==t.getOption("exitOnEsc")){r.next=7;break}return r.next=5,t.exit();case 5:r.next=39;break;case 7:if("ArrowLeft"!==o&&37!==o){r.next=12;break}return r.next=10,Ut(t);case 10:r.next=39;break;case 12:if("ArrowRight"!==o&&39!==o){r.next=17;break}return r.next=15,Mt(t);case 15:r.next=39;break;case 17:if("Enter"!==o&&"NumpadEnter"!==o&&13!==o){r.next=39;break}if(!(i=e.target||e.srcElement)||!i.className.match("introjs-prevbutton")){r.next=24;break}return r.next=22,Ut(t);case 22:r.next=38;break;case 24:if(!i||!i.className.match("introjs-skipbutton")){r.next=32;break}if(!t.isEnd()){r.next=28;break}return r.next=28,null===(n=t.callback("complete"))||void 0===n?void 0:n.call(t,t.getCurrentStep(),"skip");case 28:return r.next=30,t.exit();case 30:r.next=38;break;case 32:if(!i||!i.getAttribute("data-step-number")){r.next=36;break}i.click(),r.next=38;break;case 36:return r.next=38,Mt(t);case 38:e.preventDefault?e.preventDefault():e.returnValue=!1;case 39:case"end":return r.stop()}},r)}))}(t,e)},D.on(window,"keydown",this._keyboardNavigationHandler,!0)),this}},{key:"disableKeyboardNavigation",value:function(){return this._keyboardNavigationHandler&&(D.off(window,"keydown",this._keyboardNavigationHandler,!0),this._keyboardNavigationHandler=void 0),this}},{key:"enableRefreshOnResize",value:function(){var t=this;this._refreshOnResizeHandler=function(e){return t.refresh()},D.on(window,"resize",this._refreshOnResizeHandler,!0)}},{key:"disableRefreshOnResize",value:function(){this._refreshOnResizeHandler&&(D.off(window,"resize",this._refreshOnResizeHandler,!0),this._refreshOnResizeHandler=void 0)}},{key:"appendFloatingElement",value:function(){var t,e,n;return this._floatingElement||(this._floatingElement=(t={currentStep:this.getCurrentStepSignal()},e=t.currentStep,n=de({className:"introjsFloatingElement"}),ht.derive(function(){void 0===e.val&&n.remove()}),n),ht.add(this.getTargetElement(),this._floatingElement)),this._floatingElement}},{key:"createRoot",value:function(){this._root||(this._root=function(t){var e=t.tour,n=e.getCurrentStepSignal(),r=e.getRefreshesSignal(),o=e.getSteps(),i=function(t){var e=t.currentStep,n=t.steps,r=t.refreshes,o=t.targetElement,i=t.tourHighlightClass,a=t.overlayOpacity,s=t.helperLayerPadding,l=ht.derive(function(){return void 0!==e.val?n[e.val]:null}),c=le({className:function(){return function(t){var e=t.step,n=t.tourHighlightClass,r="introjs-helperLayer";return e.val&&"string"==typeof e.val.highlightClass&&(r+=" ".concat(e.val.highlightClass)),"string"==typeof n&&(r+=" ".concat(n)),r}({step:l,tourHighlightClass:i})},style:St({"box-shadow":"0 0 1px 2px rgba(33, 33, 33, 0.8), rgba(33, 33, 33, ".concat(a.toString(),") 0 0 0 5000px")})});return ht.derive(function(){l.val&&void 0!==r.val&&Kt(o,c,l.val,s)}),c}({currentStep:n,steps:o,refreshes:r,targetElement:e.getTargetElement(),tourHighlightClass:e.getOption("highlightClass"),overlayOpacity:e.getOption("overlayOpacity"),helperLayerPadding:e.getOption("helperElementPadding")}),a=ht.state(0),s=0,l=he({className:"introjs-tour",style:function(){return St({opacity:"".concat(a.val)})}},i,function(){if(void 0===n.val)return null;var t=ht.derive(function(){return void 0!==n.val?o[n.val]:null});if(!t.val)return null;var i=function(t){var e=t.exitOnOverlayClick,n=t.onExitTour,r=ue({className:"introjs-overlay",style:St({top:0,bottom:0,left:0,right:0,position:"fixed",cursor:e?"pointer":"auto"})});return e&&(r.onclick=function(){return C(void 0,void 0,void 0,v().mark(function t(){return v().wrap(function(t){for(;;)switch(t.prev=t.next){case 0:return t.next=2,n();case 2:case"end":return t.stop()}},t)}))}),r}({exitOnOverlayClick:!0===e.getOption("exitOnOverlayClick"),onExitTour:function(){return C(void 0,void 0,void 0,v().mark(function t(){return v().wrap(function(t){for(;;)switch(t.prev=t.next){case 0:return t.abrupt("return",e.exit());case 1:case"end":return t.stop()}},t)}))}}),a=function(t){var e=t.targetElement,n=t.helperElementPadding,r=S(t,["targetElement","helperElementPadding"]),o=se({className:"introjs-tooltipReferenceLayer"},ae(r));return ht.derive(function(){null!=r.refreshes.val&&Kt(e,o,r.step,n)}),o}({step:t.val,targetElement:e.getTargetElement(),refreshes:r,helperElementPadding:e.getOption("helperElementPadding"),transitionDuration:s,positionPrecedence:e.getOption("positionPrecedence"),autoPosition:e.getOption("autoPosition"),showStepNumbers:e.getOption("showStepNumbers"),steps:e.getSteps(),currentStep:n.val,onBulletClick:function(t){e.goToStep(t)},bullets:e.getOption("showBullets"),buttons:e.getOption("showButtons"),nextLabel:e.getOption("nextLabel"),onNextClick:function(t){return C(void 0,void 0,void 0,v().mark(function n(){var r;return v().wrap(function(n){for(;;)switch(n.prev=n.next){case 0:if(e.isLastStep()){n.next=5;break}return n.next=3,Mt(e);case 3:n.next=10;break;case 5:if(!new RegExp("introjs-donebutton","gi").test(t.target.className)){n.next=10;break}return n.next=8,null===(r=e.callback("complete"))||void 0===r?void 0:r.call(e,e.getCurrentStep(),"done");case 8:return n.next=10,e.exit();case 10:case"end":return n.stop()}},n)}))},prevLabel:e.getOption("prevLabel"),onPrevClick:function(){return C(void 0,void 0,void 0,v().mark(function t(){var n;return v().wrap(function(t){for(;;)switch(t.prev=t.next){case 0:if(!(void 0!==(n=e.getCurrentStep())&&n>0)){t.next=4;break}return t.next=4,Ut(e);case 4:case"end":return t.stop()}},t)}))},skipLabel:e.getOption("skipLabel"),onSkipClick:function(){return C(void 0,void 0,void 0,v().mark(function t(){var n,r;return v().wrap(function(t){for(;;)switch(t.prev=t.next){case 0:if(!e.isLastStep()){t.next=3;break}return t.next=3,null===(n=e.callback("complete"))||void 0===n?void 0:n.call(e,e.getCurrentStep(),"skip");case 3:return t.next=5,null===(r=e.callback("skip"))||void 0===r?void 0:r.call(e,e.getCurrentStep());case 5:return t.next=7,e.exit();case 7:case"end":return t.stop()}},t)}))},buttonClass:e.getOption("buttonClass"),nextToDone:e.getOption("nextToDone"),doneLabel:e.getOption("doneLabel"),hideNext:e.getOption("hideNext"),hidePrev:e.getOption("hidePrev"),className:t.val.tooltipClass||e.getOption("tooltipClass"),progress:e.getOption("showProgress"),progressBarAdditionalClass:e.getOption("progressBarAdditionalClass"),stepNumbers:e.getOption("showStepNumbers"),stepNumbersOfLabel:e.getOption("stepNumbersOfLabel"),scrollToElement:e.getOption("scrollToElement"),scrollPadding:e.getOption("scrollPadding"),dontShowAgain:e.getOption("dontShowAgain"),onDontShowAgainChange:function(t){e.setDontShowAgain(t)},dontShowAgainLabel:e.getOption("dontShowAgainLabel"),renderAsHtml:e.getOption("tooltipRenderAsHtml")}),l=t.val.disableInteraction?function(t){var e=t.currentStep,n=t.steps,r=t.refreshes,o=t.targetElement,i=t.helperElementPadding,a=ht.derive(function(){return void 0!==e.val?n[e.val]:null});return function(){if(!a.val)return null;var t=ce({className:"introjs-disableInteraction"});return ht.derive(function(){a.val&&null!=r.val&&Kt(o,t,a.val,i)}),t}}({currentStep:n,steps:e.getSteps(),refreshes:r,targetElement:e.getTargetElement(),helperElementPadding:e.getOption("helperElementPadding")}):null;return s=300,he(i,a,l)});return ht.derive(function(){void 0===n.val&&(a.val=0,setTimeout(function(){l.remove()},250))}),setTimeout(function(){a.val=1},1),l}({tour:this}),ht.add(this.getTargetElement(),this._root))}},{key:"recreateRoot",value:function(){this._root&&(this._root.remove(),this._root=void 0,this.createRoot())}},{key:"start",value:function(){return C(this,void 0,void 0,v().mark(function t(){return v().wrap(function(t){for(;;)switch(t.prev=t.next){case 0:return t.next=2,zt(this);case 2:if(!t.sent){t.next=6;break}this.createRoot(),this.enableKeyboardNavigation(),this.enableRefreshOnResize();case 6:return t.abrupt("return",this);case 7:case"end":return t.stop()}},t,this)}))}},{key:"exit",value:function(t){return C(this,void 0,void 0,v().mark(function e(){return v().wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,Gt(this,null!=t&&t);case 2:if(!e.sent){e.next=5;break}this.disableKeyboardNavigation(),this.disableRefreshOnResize();case 5:return e.abrupt("return",this);case 6:case"end":return e.stop()}},e,this)}))}},{key:"refresh",value:function(t){return void 0===this.getCurrentStep()||(void 0!==this._refreshesSignal.val&&(this._refreshesSignal.val+=1),t&&(this.setSteps(qt(this)),this.recreateRoot())),this}},{key:"onbeforechange",value:function(t){return this.onBeforeChange(t)}},{key:"onBeforeChange",value:function(t){if(!B(t))throw new Error("Provided callback for onBeforeChange was not a function");return this.callbacks.beforeChange=t,this}},{key:"onchange",value:function(t){this.onChange(t)}},{key:"onChange",value:function(t){if(!B(t))throw new Error("Provided callback for onChange was not a function.");return this.callbacks.change=t,this}},{key:"onafterchange",value:function(t){this.onAfterChange(t)}},{key:"onAfterChange",value:function(t){if(!B(t))throw new Error("Provided callback for onAfterChange was not a function");return this.callbacks.afterChange=t,this}},{key:"oncomplete",value:function(t){return this.onComplete(t)}},{key:"onComplete",value:function(t){if(!B(t))throw new Error("Provided callback for oncomplete was not a function.");return this.callbacks.complete=t,this}},{key:"onstart",value:function(t){return this.onStart(t)}},{key:"onStart",value:function(t){if(!B(t))throw new Error("Provided callback for onstart was not a function.");return this.callbacks.start=t,this}},{key:"onexit",value:function(t){return this.onExit(t)}},{key:"onExit",value:function(t){if(!B(t))throw new Error("Provided callback for onexit was not a function.");return this.callbacks.exit=t,this}},{key:"onskip",value:function(t){return this.onSkip(t)}},{key:"onSkip",value:function(t){if(!B(t))throw new Error("Provided callback for onskip was not a function.");return this.callbacks.skip=t,this}},{key:"onbeforeexit",value:function(t){return this.onBeforeExit(t)}},{key:"onBeforeExit",value:function(t){if(!B(t))throw new Error("Provided callback for onbeforeexit was not a function.");return this.callbacks.beforeExit=t,this}}]),t}(),pe=function(){!function(t,e){if("function"!=typeof e&&null!==e)throw new TypeError("Super expression must either be null or a function");t.prototype=Object.create(e&&e.prototype,{constructor:{value:t,writable:!0,configurable:!0}}),Object.defineProperty(t,"prototype",{writable:!1}),e&&g(t,e)}(e,fe);var t=c(e);function e(){return i(this,e),t.apply(this,arguments)}return s(e,[{key:"addHints",value:function(){console.error("introJs().addHints() is deprecated, please use introJs.hint.addHints() instead.")}},{key:"addHint",value:function(){console.error("introJs().addHint() is deprecated, please use introJs.hint.addHint() instead.")}},{key:"removeHints",value:function(){console.error("introJs().removeHints() is deprecated, please use introJs.hint.removeHints() instead.")}}]),e}(),ve=function(t){return console.warn("introJs() is deprecated. Please use introJs.tour() or introJs.hint() instead."),new pe(t)};ve.tour=function(t){return new fe(t)},ve.hint=function(t){return new Wt(t)},ve.version="8.3.2"}},e={};function n(r){var o=e[r];if(void 0!==o)return o.exports;var i=e[r]={exports:{}};return t[r](i,i.exports,n),i.exports}n.d=function(t,e){for(var r in e)n.o(e,r)&&!n.o(t,r)&&Object.defineProperty(t,r,{enumerable:!0,get:e[r]})},n.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},n.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})};var r={};n.r(r),n.d(r,{getGuidedTour:function(){return d},guidedTourButtonClick:function(){return f},initGuidedTour:function(){return p}});var o=n(43104),i=n(8725),a=n(25187),s=[],l=null,c=null,u="https://github.com/memononen/libtess2";function h(){return window.scrollTo(0,0),!!$("#swh-identifiers").tabSlideOut("isOpen")||($(".introjs-helperLayer, .introjs-tooltipReferenceLayer").hide(),$("#swh-identifiers").tabSlideOut("open"),setTimeout(function(){$(".introjs-helperLayer, .introjs-tooltipReferenceLayer").show(),l.nextStep()},500),!1)}function d(){return s}function f(t){t.preventDefault(),p()}function p(t){if(void 0===t&&(t=0),!(t>=s.length)){var e=new URL(window.location.origin+s[t].url),n=new URL(window.location.href),r=n.searchParams.get("guided_tour_next");n.searchParams.delete("guided_tour"),n.searchParams.delete("guided_tour_next");var i=decodeURIComponent(e.toString()),c=decodeURIComponent(n.toString());c!==i?(e.searchParams.set("guided_tour",t),0===t&&e.searchParams.set("guided_tour_next",c),window.location=decodeURIComponent(e.toString())):((l=(0,o.A)().setOptions(s[t].introJsOptions)).setOptions({exitOnOverlayClick:!1,showBullets:!1}),t<s.length-1?l.setOption("doneLabel","Next page").onexit(function(){(0,a.v)()}).oncomplete(function(){var e=new URL(window.location.origin+s[t+1].url);e.searchParams.set("guided_tour",t+1),r?e.searchParams.set("guided_tour_next",r):0===t&&e.searchParams.set("guided_tour_next",c),window.location.href=decodeURIComponent(e.toString())}):l.oncomplete(function(){(0,a.v)(),r&&(window.location.href=r)}),s[t].hasOwnProperty("onBeforeChange")&&l.onbeforechange(s[t].onBeforeChange),setTimeout(function(){(0,a.M)(),l.start(),window.scrollTo(0,0)},500))}}return $(function(){s=[{url:Urls.swh_web_homepage(),introJsOptions:{disableInteraction:!0,scrollToElement:!1,steps:i.TB}},{url:Urls.browse_origin_directory()+"?origin_url="+u,introJsOptions:{disableInteraction:!0,scrollToElement:!1,steps:i.JS},onBeforeChange:function(t){return t&&"swh-identifiers"===t.id?h():(t&&"citations-handle"===t.id&&$(t).trigger("click"),!0)}},{url:Urls.browse_content("sha1_git:2d4e23bf1d3f64c1e8b94622178e18d89c653de0")+"?origin_url="+u+"&path=Example/example.c",introJsOptions:{steps:i.ym},onBeforeChange:function(t){if(t&&$(t).hasClass("swhid"))return h();if(t&&"17"===t.dataset.lineNumber){var e="rgba(0, 0, 0, 0)"!==$('.hljs-ln-numbers[data-line-number="11"]').css("background-color");return e||0!==$("#swh-next-step-disabled").length||$(".introjs-tooltiptext").append('<p id="swh-next-step-disabled" style="color: red; font-weight: bold">\n                  You need to select the line number before proceeding to<br/>next step.\n               </p>'),c=t,e}if(c&&"17"===c.dataset.lineNumber){for(var n=!0,r=11;r<=17;++r){var o=$('.hljs-ln-numbers[data-line-number="'+r+'"]').css("background-color");if(!(n=n&&"rgba(0, 0, 0, 0)"!==o)){swh.webapp.resetHighlightedLines(),swh.webapp.scrollToLine(swh.webapp.highlightLine(11,!0)),0===$("#swh-next-step-disabled").length&&$(".introjs-tooltiptext").append('<p id="swh-next-step-disabled" style="color: red; font-weight: bold">\n                      You need to select the line numbers range from 11\n                      to 17 before proceeding to next step.\n                  </p>');break}}return n}return c=t,!0}}];var t=new URLSearchParams(window.location.search);t&&t.has("guided_tour")&&p(parseInt(t.get("guided_tour")))}),r}()});
//# sourceMappingURL=guided_tour.d4d80c72d889d1f87995.js.map