
# 🤖 COVAL v2.0 - Intelligent Code Generation, Execution, and Repair System

![COVAL](https://img.shields.io/badge/COVAL-v2.0-blue.svg)
![Python](https://img.shields.io/badge/Python-3.11+-green.svg)
![Docker](https://img.shields.io/badge/Docker-Required-blue.svg)
![Ollama](https://img.shields.io/badge/Ollama-Required-orange.svg)
![Status](https://img.shields.io/badge/Status-Production%20Ready-brightgreen.svg)

**COVAL** is a comprehensive Python package that manages iterative code generation, execution, and repair with multiple LLM models, integrated Docker Compose deployments, transparent volume overlays, legacy cleanup, and adaptive cost optimization to enable efficient and scalable automated code repair workflows.


```
                    START
                      │
                  [TRIAGE]
                      │
              Collect Metrics
                      │
            ┌─────────┴─────────┐
            │  DECISION MODEL   │
            └─────────┬─────────┘
                      │
           C_fix > 1.5 * C_new?
                 ┌────┴────┐
                YES        NO
                 │          │
            [REBUILD]   [REPAIR]
                 │          │
           Recommend      MRE
           Rebuilding   Creation
                 │          │
                END    Fix Generation
                           │
                      Validation
                      ┌────┴────┐
                   PASS        FAIL
                     │          │
                 [SUCCESS]  Retry?
                     │      ┌──┴──┐
                    END    YES   NO
                            │     │
                      Next Iter  END
```

<?xml version="1.0" encoding="UTF-8"?>
<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="1024" height="1024">
<path d="M0 0 C337.92 0 675.84 0 1024 0 C1024 337.92 1024 675.84 1024 1024 C686.08 1024 348.16 1024 0 1024 C0 686.08 0 348.16 0 0 Z " fill="#F9EBD5" transform="translate(0,0)"/>
<path d="M0 0 C12.77889791 11.65197346 12.77889791 11.65197346 16.34765625 18.140625 C16.34765625 18.800625 16.34765625 19.460625 16.34765625 20.140625 C17.09539307 20.12177246 17.84312988 20.10291992 18.61352539 20.08349609 C27.7702733 19.95661919 36.70869415 20.70146305 45.78515625 21.765625 C46.5413324 21.8529892 47.29750854 21.94035339 48.07659912 22.03036499 C114.46878942 29.80202897 114.46878942 29.80202897 131.34765625 43.140625 C132.25390625 45.19140625 132.25390625 45.19140625 132.34765625 47.140625 C129.55800537 49.93027588 127.69411855 49.47892043 123.78515625 49.6328125 C122.42615658 49.69552725 121.06718945 49.75895015 119.70825195 49.82299805 C118.99609528 49.85372406 118.2839386 49.88445007 117.55020142 49.91610718 C104.82800657 50.4909354 92.59203635 51.44629532 80.34765625 55.140625 C79.53361328 55.37910156 78.71957031 55.61757812 77.88085938 55.86328125 C50.77577105 63.93196125 23.46881914 76.27231254 8.84375 101.76171875 C3.1403584 112.95726523 3.75968922 122.97546553 7.2421875 134.73046875 C10.2812817 145.91379631 10.72440519 157.36618557 10.66015625 168.890625 C10.6580011 169.59128082 10.65584595 170.29193665 10.65362549 171.01382446 C10.5997145 181.96850539 10.03155294 192.48461469 7.34765625 203.140625 C7.04964111 204.35371338 7.04964111 204.35371338 6.74560547 205.59130859 C-5.69331881 255.05816176 -34.92174632 293.33557368 -78.515625 319.4765625 C-108.64777736 337.140625 -108.64777736 337.140625 -120.65234375 337.140625 C-110.43508855 351.72403914 -99.38637949 365.55112319 -88.12451172 379.33642578 C-86.82962864 380.92335546 -85.53943897 382.51411237 -84.25 384.10546875 C-74.83823872 395.9638806 -74.83823872 395.9638806 -64.65234375 407.140625 C-62.68319295 407.25069587 -60.7104064 407.29658518 -58.73828125 407.31640625 C-23.01320644 407.92505047 -23.01320644 407.92505047 -12.65234375 417.140625 C-10.14662788 420.14748404 -8.8058518 422.01489929 -8.27734375 425.890625 C-8.65234375 428.140625 -8.65234375 428.140625 -10.65234375 430.140625 C-13.1562048 430.33803714 -15.549543 430.40993975 -18.05456543 430.39459229 C-18.82665454 430.39771227 -19.59874366 430.40083225 -20.39422941 430.40404677 C-22.99531791 430.41205841 -25.59617516 430.40569091 -28.19726562 430.39941406 C-30.05636228 430.40212252 -31.91545786 430.40568263 -33.77455139 430.41003418 C-38.83434984 430.41917771 -43.89406703 430.41560586 -48.95386696 430.40927601 C-54.23938853 430.40422615 -59.52490297 430.40890463 -64.8104248 430.41204834 C-73.68791966 430.41569095 -82.56538128 430.41088115 -91.44287109 430.40136719 C-101.71869365 430.39048208 -111.99443684 430.39400745 -122.27025747 430.40502 C-131.07960488 430.41408447 -139.88892834 430.41538227 -148.6982789 430.41014266 C-153.96552742 430.40701833 -159.2327386 430.40662627 -164.49998474 430.41321564 C-169.45097522 430.41897629 -174.401863 430.41501579 -179.35284233 430.40342712 C-181.17419196 430.40077366 -182.99555018 430.40155726 -184.81689644 430.40595245 C-187.29475658 430.4113824 -189.77228342 430.40460513 -192.25012207 430.39459229 C-192.97832138 430.39905373 -193.70652068 430.40351517 -194.45678663 430.40811181 C-199.42404359 430.36892516 -199.42404359 430.36892516 -201.65234375 428.140625 C-201.56113503 423.39777162 -200.63501979 420.08520955 -197.359375 416.5546875 C-189.72003065 410.22644344 -180.46163088 408.42742448 -170.8671875 407.59375 C-169.3975354 407.46468262 -169.3975354 407.46468262 -167.89819336 407.33300781 C-166.7864978 407.23777832 -166.7864978 407.23777832 -165.65234375 407.140625 C-174.03976713 392.81435834 -182.95700598 378.91735745 -192.21484375 365.140625 C-193.48413182 363.24246017 -194.75301361 361.3440236 -196.02148438 359.4453125 C-197.23270845 357.63517273 -198.44428325 355.82526759 -199.65625 354.015625 C-200.21558731 353.1803125 -200.77492462 352.345 -201.35121155 351.484375 C-201.87283371 350.70835937 -202.39445587 349.93234375 -202.93188477 349.1328125 C-203.38644547 348.45589355 -203.84100616 347.77897461 -204.30934143 347.08154297 C-205.26911223 345.69447434 -206.27996613 344.34220093 -207.32237244 343.01611328 C-208.65234375 341.140625 -208.65234375 341.140625 -208.65234375 339.140625 C-209.78671875 339.099375 -210.92109375 339.058125 -212.08984375 339.015625 C-216.94319675 338.47296663 -221.31945743 337.06342465 -225.90234375 335.453125 C-226.64347412 335.19837402 -227.38460449 334.94362305 -228.14819336 334.68115234 C-232.89320571 332.98062769 -236.84961449 330.79469543 -241.15234375 328.140625 C-244.18538736 326.70332448 -246.26741346 325.77273106 -249.58789062 326.65478516 C-255.10294956 329.02457812 -259.86718828 332.56581367 -264.65234375 336.140625 C-265.37534668 336.66817383 -266.09834961 337.19572266 -266.84326172 337.73925781 C-271.1882458 340.92136262 -275.44153284 344.20536342 -279.65625 347.55761719 C-281.5394748 349.05111396 -283.43593753 350.5251928 -285.33984375 351.9921875 C-291.92305925 357.07963097 -298.31595698 362.34796783 -304.60522461 367.79443359 C-308.15596204 370.86883426 -311.74978697 373.87422887 -315.40234375 376.828125 C-318.91118365 379.67521001 -322.31101012 382.59875052 -325.65234375 385.640625 C-329.95979952 389.55959188 -334.3912007 393.28428862 -338.92578125 396.9375 C-340.7183971 398.3859747 -342.49514618 399.85434958 -344.25390625 401.34375 C-355.97846383 411.14446377 -366.68662553 413.10454292 -381.65234375 412.140625 C-388.69667441 411.09109089 -393.83938573 408.42457586 -398.65234375 403.140625 C-400.11884741 400.20761768 -400.0167467 398.42025156 -399.65234375 395.140625 C-396.76876672 389.2130527 -392.54007537 384.60958137 -387.83984375 380.078125 C-387.21819336 379.46815674 -386.59654297 378.85818848 -385.95605469 378.22973633 C-382.2620278 374.62781899 -378.5096664 371.11574699 -374.57421875 367.77734375 C-372.22503721 365.77671963 -369.94067348 363.71052326 -367.65234375 361.640625 C-364.7155591 358.98948506 -361.76631833 356.35772329 -358.77734375 353.765625 C-354.80981651 350.31210939 -350.94386735 346.7505856 -347.07470703 343.18798828 C-343.68578838 340.07283523 -340.25036371 337.02314434 -336.76953125 334.01171875 C-334.5920378 332.08732879 -332.45931639 330.11828779 -330.32910156 328.1418457 C-324.63899847 322.86623565 -318.79885833 317.88649577 -312.65234375 313.140625 C-313.65652344 313.39457031 -314.66070312 313.64851563 -315.6953125 313.91015625 C-319.29507583 314.81806116 -322.89766454 315.71422233 -326.50146484 316.60595703 C-328.44524503 317.08914416 -330.38682595 317.58115767 -332.328125 318.07421875 C-346.75698108 321.61785085 -346.75698108 321.61785085 -352.71484375 318.578125 C-354.65234375 316.140625 -354.65234375 316.140625 -354.90234375 313.078125 C-352.60735142 303.09065839 -343.76917793 294.06856454 -337.65234375 286.140625 C-336.88809082 285.14434082 -336.88809082 285.14434082 -336.10839844 284.12792969 C-328.00374109 273.56934889 -319.68077164 263.21539532 -311.17431641 252.97851562 C-309.10838994 250.48376194 -307.06823042 247.96837993 -305.02734375 245.453125 C-300.67386004 240.12413845 -296.19279167 234.90937195 -291.703125 229.6953125 C-289.23353594 226.82471931 -286.78759439 223.93520993 -284.35009766 221.03735352 C-279.88701374 215.73183695 -275.34339855 210.51371429 -270.6796875 205.3828125 C-268.91267176 203.42854076 -267.18320846 201.45002763 -265.46484375 199.453125 C-261.39977569 194.78161322 -257.14427986 190.28800815 -252.9074707 185.77294922 C-249.60543546 182.24978577 -246.34800621 178.69867891 -243.15234375 175.078125 C-238.88836109 170.29511823 -234.36467067 165.79284581 -229.78710938 161.31225586 C-226.89268926 158.46135151 -224.12629522 155.56769896 -221.49194336 152.47363281 C-217.47486221 147.86013289 -213.16162809 143.59430611 -208.7890625 139.3203125 C-207.07962426 137.63327226 -205.3706547 135.94575703 -203.66210938 134.2578125 C-201.00769989 131.64031395 -198.35044784 129.02599214 -195.68481445 126.41992188 C-177.44232866 108.59896861 -177.44232866 108.59896861 -164.33984375 86.890625 C-164.01918945 86.1901001 -163.69853516 85.4895752 -163.36816406 84.76782227 C-159.30441829 75.54254642 -156.93716775 65.81258178 -154.70703125 56.01171875 C-149.98349727 35.49822781 -140.56505683 18.07431236 -125.65234375 3.140625 C-124.84925781 2.3259375 -124.04617188 1.51125 -123.21875 0.671875 C-90.42529715 -30.775377 -33.82394261 -28.68541376 0 0 Z " fill="#39230D" transform="translate(632.65234375,196.859375)"/>
<path d="M0 0 C10.70508859 9.21568496 18.46270843 20.19995847 19.609375 34.55859375 C20.20181359 49.73983256 20.20181359 49.73983256 17.265625 55.26171875 C15 57.625 15 57.625 12.515625 59.78125 C2.96543155 68.20440199 -1.65071578 81.89786138 -3.4765625 94.21484375 C-3.96518306 104.61731837 -1.29135669 114.89970528 0.80859375 125.0234375 C8.14415195 160.93553593 -1.52614307 198.95021613 -20.4375 229.8125 C-24.22795316 235.54523955 -28.50540225 240.80784068 -33 246 C-33.85722656 246.99257813 -34.71445312 247.98515625 -35.59765625 249.0078125 C-60.17906327 276.92539521 -98.30241299 296.47651631 -135.53152466 299.18411255 C-140.75552119 299.43231304 -145.97447596 299.47140121 -151.20361328 299.44604492 C-153.86699728 299.4375256 -156.52823113 299.46646482 -159.19140625 299.49804688 C-180.0925807 299.58357647 -203.82617995 295.92904367 -221 283 C-221.33 282.34 -221.66 281.68 -222 281 C-220.80008423 280.63032104 -220.80008423 280.63032104 -219.57592773 280.25317383 C-198.71374975 273.85661295 -198.71374975 273.85661295 -178 267 C-176.28103516 266.42378906 -176.28103516 266.42378906 -174.52734375 265.8359375 C-165.71755496 262.81153603 -157.32689438 259.14883257 -149 255 C-148.05592285 254.52997559 -147.1118457 254.05995117 -146.13916016 253.57568359 C-133.25352073 247.11572067 -120.60830701 240.5870588 -109 232 C-108.40155273 231.55946289 -107.80310547 231.11892578 -107.18652344 230.66503906 C-89.15916577 217.2610565 -69.20922131 198.26233413 -64.5625 175.25 C-62.48064586 157.72967695 -63.93640687 142.07023072 -74 127 C-74.721875 126.27941406 -75.44375 125.55882812 -76.1875 124.81640625 C-78 123 -78 123 -78 121 C-78.58007812 120.731875 -79.16015625 120.46375 -79.7578125 120.1875 C-82.03390719 118.98204219 -83.8699302 117.61049783 -85.875 116 C-90.48699054 112.51330106 -93.85050059 110.89252503 -99.75 111.1875 C-103.27327332 111.68118112 -103.27327332 111.68118112 -105 115 C-104.8766771 121.28297723 -103.31585566 124.74239354 -99.1875 129.5 C-95.38886668 134.14098563 -92.36796327 138.47475237 -90 144 C-89.649375 144.71414063 -89.29875 145.42828125 -88.9375 146.1640625 C-85.37906795 156.92831946 -87.34562695 169.69772773 -92.18359375 179.71484375 C-94.95305543 184.7236981 -98.08341917 188.83782499 -102 193 C-102.67047363 193.73766602 -102.67047363 193.73766602 -103.35449219 194.49023438 C-122.11830518 215.03566194 -147.5531608 228.48038301 -173 239 C-173.81871582 239.3398291 -174.63743164 239.6796582 -175.48095703 240.02978516 C-186.36250388 244.48859654 -197.42628814 248.18123503 -208.6875 251.5625 C-209.87674072 251.92158447 -211.06598145 252.28066895 -212.29125977 252.65063477 C-213.39526123 252.97346436 -214.4992627 253.29629395 -215.63671875 253.62890625 C-216.62373779 253.91838135 -217.61075684 254.20785645 -218.62768555 254.50610352 C-221 255 -221 255 -223 254 C-222.14728516 253.1646875 -222.14728516 253.1646875 -221.27734375 252.3125 C-217.66546342 248.74282862 -214.0937623 245.19112031 -210.8125 241.3125 C-207.40834735 237.33434502 -203.71830473 233.68050624 -200 230 C-190.05826159 220.27036046 -190.05826159 220.27036046 -182 209 C-182 208.01 -182 207.02 -182 206 C-188.46230548 206.26528348 -192.8138337 209.87801213 -197.9375 213.4375 C-198.87335938 214.07421631 -199.80921875 214.71093262 -200.7734375 215.36694336 C-203.52115516 217.23668231 -206.26074523 219.11789529 -209 221 C-233.59974295 237.74268219 -259.15509722 253.11764725 -286 266 C-286 265.34 -286 264.68 -286 264 C-285.34 264 -284.68 264 -284 264 C-283.72470459 263.41081787 -283.44940918 262.82163574 -283.16577148 262.21459961 C-282.05066332 260.09624439 -280.86085207 258.41370814 -279.34765625 256.56640625 C-278.82397461 255.92405029 -278.30029297 255.28169434 -277.76074219 254.61987305 C-277.20032227 253.94093994 -276.63990234 253.26200684 -276.0625 252.5625 C-275.19286621 251.50059448 -275.19286621 251.50059448 -274.30566406 250.41723633 C-270.21291797 245.43332778 -266.0689176 240.49396783 -261.88500977 235.58642578 C-259.03749873 232.24380838 -256.25487931 228.85667645 -253.5 225.4375 C-249.85785106 220.95635604 -246.0238885 216.70922426 -242.09033203 212.48681641 C-239.04465585 209.19808311 -236.1780553 205.81387744 -233.375 202.3125 C-229.86059685 197.94459894 -226.10676473 194.00267861 -222.09765625 190.08984375 C-220.24359625 188.242689 -218.51577378 186.36001831 -216.8125 184.375 C-207.48347715 173.55503743 -197.48612379 163.35670603 -187.30541992 153.34228516 C-183.2009749 149.28618188 -179.29396587 145.13897084 -175.52954102 140.76538086 C-173.65482798 138.60160592 -171.70160643 136.53428785 -169.6875 134.5 C-169.03136719 133.8296875 -168.37523437 133.159375 -167.69921875 132.46875 C-166 131 -166 131 -164 131 C-163.61328125 130.10667969 -163.61328125 130.10667969 -163.21875 129.1953125 C-161.89188606 126.8052563 -160.60890657 125.59496888 -158.5 123.875 C-136.23627414 104.90068949 -121.97862902 81.69283073 -115.15890503 53.32522583 C-112.12660841 40.82911327 -108.98703835 28.93380851 -102 18 C-101.36449219 16.989375 -100.72898437 15.97875 -100.07421875 14.9375 C-90.33737188 0.57613869 -76.00187709 -9.40326282 -59.1328125 -13.3828125 C-38.46552386 -16.96785077 -16.78490796 -12.80036008 0 0 Z " fill="#A87139" transform="translate(615,215)"/>
<path d="M0 0 C13.90795267 10.57460918 24.98279545 26.23252657 28.59765625 43.55078125 C31.07556351 64.79342308 27.38878927 84.0950833 14.125 101.375 C1.29741898 116.35683127 -15.23323643 125.48031163 -34.93603516 127.26611328 C-55.01603389 128.41932389 -75.17137805 125.72866021 -90.88696289 111.98925781 C-93.33896416 109.73299968 -95.67148675 107.38411954 -98 105 C-98.67804688 104.34257813 -99.35609375 103.68515625 -100.0546875 103.0078125 C-112.64342866 89.97147165 -116.62362522 71.8118434 -116.39819336 54.32617188 C-115.835769 35.72785574 -108.16713125 19.2801589 -95.0703125 6.05078125 C-69.88044994 -17.26754534 -28.0525853 -19.09585077 0 0 Z " fill="#39230D" transform="translate(433,698)"/>
<path d="M0 0 C2.11182556 -0.01721465 4.22208543 -0.06110337 6.33349609 -0.10522461 C7.67853668 -0.11535193 9.02359056 -0.12386792 10.36865234 -0.13061523 C11.59181152 -0.14519775 12.8149707 -0.15978027 14.07519531 -0.17480469 C17.93207392 0.39587105 18.94952845 1.19726313 21.25146484 4.29516602 C22.66088867 7.0078125 22.66088867 7.0078125 23.95849609 10.16625977 C24.70256714 11.95773437 24.70256714 11.95773437 25.46166992 13.78540039 C25.99601507 15.10105537 26.53010521 16.41681395 27.06396484 17.73266602 C27.63440325 19.11774871 28.20562949 20.50250717 28.77758789 21.88696289 C30.616984 26.35038664 32.43512501 30.82232122 34.25146484 35.29516602 C34.85553641 36.77974248 35.45970253 38.26428047 36.06396484 39.7487793 C38.52829221 45.80624906 40.98741776 51.86580209 43.43652344 57.92944336 C47.80441014 68.74323228 52.21403607 79.53921702 56.64880371 90.32574463 C57.67586961 92.82579009 58.70088522 95.32666518 59.72509766 97.82788086 C60.37709287 99.41984992 61.02911057 101.01180977 61.68115234 102.60375977 C62.14865906 103.74524475 62.14865906 103.74524475 62.62561035 104.90979004 C64.42095508 109.28772629 66.23743767 113.65603518 68.07177734 118.01782227 C68.8192247 119.81858213 69.56662643 121.61936093 70.31396484 123.42016602 C70.64259521 124.18272705 70.97122559 124.94528809 71.30981445 125.73095703 C72.97158861 129.77322624 73.29760601 132.09351784 72.25146484 136.29516602 C68.1764369 136.36936813 64.10167092 136.42379172 60.02612305 136.45996094 C58.63998565 136.47503999 57.2538959 136.49550652 55.86791992 136.52148438 C53.87488338 136.55790317 51.88149762 136.5732962 49.88818359 136.58813477 C48.08933716 136.61170044 48.08933716 136.61170044 46.25415039 136.63574219 C43.25146484 136.29516602 43.25146484 136.29516602 40.25146484 133.29516602 C37.28146484 126.03516602 34.31146484 118.77516602 31.25146484 111.29516602 C12.77146484 111.29516602 -5.70853516 111.29516602 -24.74853516 111.29516602 C-28.04853516 119.21516602 -31.34853516 127.13516602 -34.74853516 135.29516602 C-36.63172784 137.1783587 -39.86783653 136.42570886 -42.37353516 136.42797852 C-43.03562988 136.42893524 -43.69772461 136.42989197 -44.37988281 136.43087769 C-45.78206477 136.43155928 -47.18424986 136.42970643 -48.58642578 136.42553711 C-50.73949229 136.42018848 -52.89235018 136.42548271 -55.04541016 136.43188477 C-56.40478562 136.43122398 -57.76416095 136.42994281 -59.12353516 136.42797852 C-60.36876953 136.42685059 -61.61400391 136.42572266 -62.89697266 136.42456055 C-65.74853516 136.29516602 -65.74853516 136.29516602 -66.74853516 135.29516602 C-66.35783937 128.745003 -63.92095907 123.10529036 -61.47900391 117.07250977 C-61.04688599 115.98746155 -60.61476807 114.90241333 -60.16955566 113.78448486 C-58.76563396 110.26426445 -57.35094898 106.74848089 -55.93603516 103.23266602 C-54.96309549 100.799104 -53.99084868 98.36526487 -53.01928711 95.93115234 C-50.67335112 90.0581465 -48.31936267 84.18841299 -45.96240234 78.31982422 C-44.38598142 74.39177135 -42.81607763 70.46114361 -41.24853516 66.52954102 C-39.41580445 61.93527073 -37.57879545 57.34276732 -35.73681641 52.75219727 C-33.70189661 47.67944811 -31.67424542 42.6038551 -29.65052795 37.52662659 C-28.17421147 33.82294723 -26.69658055 30.11979283 -25.21890259 26.41665649 C-24.49482098 24.60111662 -23.77132035 22.78534492 -23.0484314 20.96932983 C-22.04119799 18.43928514 -21.03181316 15.91010853 -20.02197266 13.38110352 C-19.72046799 12.62218307 -19.41896332 11.86326263 -19.10832214 11.0813446 C-14.57809691 -0.24547248 -11.74989294 0.06680724 0 0 Z " fill="#39220D" transform="translate(668.74853515625,686.704833984375)"/>
<path d="M0 0 C2.20383585 -0.00969571 4.40673525 -0.04070084 6.61035156 -0.07226562 C8.00878351 -0.07879652 9.40722215 -0.08404665 10.80566406 -0.08789062 C12.08231934 -0.09723633 13.35897461 -0.10658203 14.67431641 -0.11621094 C17.84472656 0.24023438 17.84472656 0.24023438 19.59423828 1.29711914 C21.48634053 4.23722883 22.67616561 7.39901224 23.89160156 10.65820312 C24.17978256 11.41154938 24.46796356 12.16489563 24.76487732 12.94107056 C25.7160057 15.4337189 26.65541048 17.93061335 27.59472656 20.42773438 C28.25596222 22.16780122 28.91783707 23.90762529 29.58032227 25.6472168 C31.68112175 31.17347317 33.76472764 36.70612069 35.84472656 42.24023438 C36.19283386 43.16598267 36.54094116 44.09173096 36.89959717 45.04553223 C39.91450698 53.065315 42.92720834 61.08591752 45.91992188 69.11401367 C48.80875207 76.8585237 51.70535298 84.59260937 54.84472656 92.24023438 C56.95406563 90.1308953 57.44843971 88.97327442 58.41015625 86.20996094 C58.85341751 84.95070801 58.85341751 84.95070801 59.30563354 83.66601562 C59.78131271 82.28736328 59.78131271 82.28736328 60.26660156 80.88085938 C60.77188889 79.43984863 60.77188889 79.43984863 61.28738403 77.96972656 C62.01486768 75.89408681 62.73992208 73.81759441 63.46282959 71.74035645 C65.36546022 66.27715444 67.28954642 60.82151609 69.21191406 55.36523438 C69.59997223 54.26262268 69.9880304 53.16001099 70.3878479 52.02398682 C73.80916077 42.31360472 77.27939107 32.62189572 80.81896973 22.95397949 C81.41686633 21.31861601 82.01218685 19.68230828 82.6048584 18.04504395 C83.42551689 15.77946737 84.25486663 13.5172738 85.08691406 11.25585938 C85.44210617 10.26851807 85.44210617 10.26851807 85.80447388 9.26123047 C88.32265877 2.48887075 88.32265877 2.48887075 90.84472656 0.24023438 C94.10693359 -0.22973633 94.10693359 -0.22973633 98.10253906 -0.18554688 C99.15802444 -0.1806147 99.15802444 -0.1806147 100.23483276 -0.17558289 C101.71931227 -0.16517231 103.20375135 -0.1452393 104.68798828 -0.11645508 C106.96832447 -0.07229278 109.24760904 -0.0550087 111.52832031 -0.04296875 C122.66521416 0.06072197 122.66521416 0.06072197 123.84472656 1.24023438 C124.40050947 6.70657222 122.77282632 10.69718435 120.71582031 15.63085938 C120.37877075 16.46360382 120.04172119 17.29634827 119.69445801 18.15432739 C118.95611026 19.97523684 118.21301502 21.7942267 117.46578979 23.61151123 C115.83926719 27.56762287 114.23559844 31.53288026 112.63002014 35.49752808 C111.76138632 37.64151183 110.8915112 39.78499303 110.02049255 41.92800903 C105.03380096 54.20400141 100.15332776 66.52179686 95.27639771 78.8416748 C93.82032161 82.51979822 92.36182637 86.1969597 90.90307617 89.87402344 C90.44010635 91.04187378 89.97713654 92.20972412 89.50013733 93.41296387 C88.59099028 95.70597985 87.68112421 97.99871089 86.77049255 100.2911377 C84.57037824 105.83939487 82.3953677 111.39543514 80.26708984 116.97167969 C79.85874405 118.03560944 79.45039825 119.09953918 79.02967834 120.19570923 C78.26341869 122.19633388 77.50361153 124.19944641 76.75144958 126.20541382 C76.41170609 127.09040558 76.07196259 127.97539734 75.72192383 128.88720703 C75.43019791 129.65924469 75.13847198 130.43128235 74.83790588 131.22671509 C73.75760905 133.41685182 72.75603078 134.72435776 70.84472656 136.24023438 C67.70605469 136.62841797 67.70605469 136.62841797 63.87597656 136.63867188 C63.19925903 136.64154205 62.5225415 136.64441223 61.82531738 136.64736938 C60.39639447 136.64940835 58.96744354 136.64389006 57.53857422 136.63134766 C55.35222932 136.61528948 53.16773277 136.63119972 50.98144531 136.65039062 C49.59211832 136.64840816 48.20279247 136.64456441 46.81347656 136.63867188 C45.54955078 136.63528809 44.285625 136.6319043 42.98339844 136.62841797 C39.46110662 136.19278916 38.99140269 135.88997666 36.84472656 133.24023438 C35.72393799 131.03894043 35.72393799 131.03894043 34.63867188 128.37890625 C33.99850128 126.8236322 33.99850128 126.8236322 33.34539795 125.23693848 C32.87595764 124.07271362 32.40651733 122.90848877 31.92285156 121.70898438 C31.40664972 120.44329343 30.88996836 119.17779797 30.37286377 117.91247559 C28.8636037 114.21009316 27.36694489 110.50272104 25.87332153 106.79400635 C24.78493945 104.09179631 23.69466104 101.39035596 22.60424805 98.68896484 C17.46754577 85.95596378 12.36425121 73.20980351 7.27685547 60.45703125 C5.47214366 55.93423682 3.66227259 51.41355683 1.84814453 46.89453125 C-0.37131893 41.36578384 -2.58243848 35.83377157 -4.78743744 30.29924011 C-5.62182874 28.20888375 -6.45912406 26.11968406 -7.29941559 24.0316925 C-8.46287906 21.13885127 -9.6155415 18.24193156 -10.765625 15.34375 C-11.11145126 14.49091431 -11.45727753 13.63807861 -11.81358337 12.75939941 C-14.72331669 5.3678047 -14.72331669 5.3678047 -14.15527344 1.24023438 C-11.48928783 -1.42575124 -3.83989599 0.01025339 0 0 Z " fill="#39220D" transform="translate(484.1552734375,686.759765625)"/>
<path d="M0 0 C1.08845215 -0.01417969 2.1769043 -0.02835938 3.29833984 -0.04296875 C13.90561023 0.0210365 23.61676428 2.12868344 33.0625 7 C33.73627686 7.34119873 34.41005371 7.68239746 35.10424805 8.03393555 C41.21287185 11.26550499 46.13358344 15.41454033 50.9375 20.375 C51.51886719 20.95636719 52.10023438 21.53773438 52.69921875 22.13671875 C53.10785156 22.54535156 53.51648438 22.95398438 53.9375 23.375 C51.82555207 28.13419118 48.39430701 31.01455882 44.625 34.5 C43.96048828 35.13292969 43.29597656 35.76585937 42.61132812 36.41796875 C39.25457352 39.54562735 36.45812782 42.0983817 31.9375 43.375 C31.40382813 42.85550781 30.87015625 42.33601562 30.3203125 41.80078125 C20.16917328 32.29945544 11.30238378 29.02006906 -2.4921875 29.1640625 C-13.0940251 29.79042927 -21.54811965 34.40587449 -28.8125 42.0625 C-37.36675061 52.40717516 -38.96357337 64.28081389 -38.2890625 77.25390625 C-37.18793144 87.56277115 -30.59247149 96.61811228 -22.875 103.125 C-13.24030811 110.11895408 -2.72422514 111.92835106 8.9375 110.375 C17.64134867 108.38991171 23.5982394 104.59913728 29.81640625 98.265625 C33.08455385 95.35257999 33.08455385 95.35257999 35.9375 95.375 C38.015625 97 38.015625 97 40.1875 99.375 C43.73827893 103.13706495 47.37763964 106.60566478 51.30859375 109.96484375 C52.56357573 111.05129098 53.76375655 112.20125655 54.9375 113.375 C54.44198248 118.82569267 49.86395666 122.05678279 45.9375 125.375 C27.79501361 138.83315588 6.20115431 141.26956995 -15.828125 138.984375 C-33.31418798 135.55745814 -49.59913972 124.67397184 -59.6484375 110.0703125 C-69.96295413 93.68227339 -74.97380433 74.66933299 -71.03271484 55.43945312 C-67.76012651 41.50631486 -61.42942815 29.31146747 -51.0625 19.375 C-50.39992187 18.68148437 -49.73734375 17.98796875 -49.0546875 17.2734375 C-35.59835602 4.02176505 -18.22960557 0.18468153 0 0 Z " fill="#39220D" transform="translate(244.0625,685.625)"/>
<path d="M0 0 C0.65830811 -0.00191345 1.31661621 -0.0038269 1.99487305 -0.00579834 C3.3868854 -0.0071595 4.77891047 -0.00346783 6.17089844 0.00488281 C8.30432589 0.015584 10.43691131 0.00498594 12.5703125 -0.0078125 C13.92187686 -0.00649089 15.2734407 -0.00392847 16.625 0 C18.47544922 0.00338379 18.47544922 0.00338379 20.36328125 0.00683594 C23.3125 0.265625 23.3125 0.265625 25.3125 2.265625 C25.55859566 4.15154457 25.55859566 4.15154457 25.55300903 6.49234009 C25.55575836 7.37857559 25.55850769 8.2648111 25.56134033 9.17790222 C25.55414978 10.15253922 25.54695923 11.12717621 25.53955078 12.13134766 C25.53984283 13.15576462 25.54013489 14.18018158 25.54043579 15.23564148 C25.53903849 18.63374193 25.52345839 22.03162519 25.5078125 25.4296875 C25.5040838 27.78095378 25.50123615 30.13222161 25.49923706 32.48348999 C25.49158938 38.68135851 25.47193115 44.87913375 25.4498291 51.07696533 C25.42939509 57.39765155 25.42024058 63.71835279 25.41015625 70.0390625 C25.38868633 82.44795772 25.35453673 94.85678361 25.3125 107.265625 C26.00963104 107.26340439 26.70676208 107.26118378 27.42501831 107.25889587 C33.98779238 107.23887702 40.55055796 107.22364271 47.11335564 107.21381283 C50.48753026 107.20858935 53.86167971 107.20150139 57.23583984 107.19018555 C61.11296259 107.17810064 64.9900494 107.17239237 68.8671875 107.16796875 C70.08179657 107.16280746 71.29640564 107.15764618 72.54782104 107.15232849 C74.22933762 107.15221519 74.22933762 107.15221519 75.94482422 107.15209961 C76.93521698 107.149879 77.92560974 107.14765839 78.9460144 107.14537048 C81.3125 107.265625 81.3125 107.265625 83.3125 108.265625 C83.34136338 112.74477828 83.35925187 117.22390791 83.375 121.703125 C83.38337891 122.98251953 83.39175781 124.26191406 83.40039062 125.58007812 C83.40361328 126.79501953 83.40683594 128.00996094 83.41015625 129.26171875 C83.41539307 130.38763428 83.42062988 131.5135498 83.42602539 132.67358398 C83.3125 135.265625 83.3125 135.265625 82.3125 136.265625 C79.553862 136.37145103 76.82012765 136.41240354 74.06079102 136.41088867 C73.19578979 136.41424728 72.33078857 136.4176059 71.4395752 136.42106628 C68.56517115 136.43060613 65.69082516 136.4325209 62.81640625 136.43359375 C60.82722448 136.43680419 58.83804295 136.4401681 56.84886169 136.44367981 C52.67324272 136.44967866 48.49764447 136.45151893 44.32202148 136.45092773 C38.96043567 136.45082606 33.59898214 136.46448015 28.23742771 136.48169994 C24.12745041 136.49279564 20.01750533 136.49484769 15.90751457 136.49431801 C13.9302824 136.49550173 11.9530495 136.4999453 9.97583199 136.50765038 C7.21499379 136.5174015 4.45444596 136.51459166 1.69360352 136.50854492 C0.45842232 136.51697418 0.45842232 136.51697418 -0.80171204 136.52557373 C-6.45918463 136.49394037 -6.45918463 136.49394037 -8.6875 134.265625 C-8.93918228 131.96362305 -8.93918228 131.96362305 -8.94146729 129.02734375 C-8.94710693 127.91681641 -8.95274658 126.80628906 -8.95855713 125.66210938 C-8.95450867 124.43814453 -8.95046021 123.21417969 -8.94628906 121.953125 C-8.9497937 120.66857422 -8.95329834 119.38402344 -8.95690918 118.06054688 C-8.96604611 114.53167976 -8.96248361 111.00292927 -8.95615101 107.47406006 C-8.95109773 103.78608886 -8.95578058 100.09812783 -8.95892334 96.41015625 C-8.96256496 90.21612754 -8.95775879 84.02214648 -8.94824219 77.828125 C-8.93735724 70.66059043 -8.94088268 63.49316963 -8.951895 56.32563782 C-8.96096233 50.17868575 -8.96225588 44.03176799 -8.95701766 37.8848114 C-8.9538949 34.21046076 -8.95349697 30.53616364 -8.96009064 26.86181641 C-8.96692486 22.76718373 -8.95746042 18.6727481 -8.94628906 14.578125 C-8.95236176 12.74217773 -8.95236176 12.74217773 -8.95855713 10.86914062 C-8.95291748 9.75861328 -8.94727783 8.64808594 -8.94146729 7.50390625 C-8.94071323 6.53493408 -8.93995918 5.56596191 -8.93918228 4.56762695 C-8.35320658 -0.79197645 -4.42976097 0.0081004 0 0 Z " fill="#3A230E" transform="translate(772.6875,686.734375)"/>
<path d="M0 0 C10.02650002 7.2374384 17.08659409 16.78492688 19.3125 29.25 C20.37963 42.5018144 17.59911368 53.74257385 9.3125 64.25 C1.90472236 72.22076874 -7.06974857 76.64205369 -17.91796875 77.5078125 C-30.55527247 77.92124665 -41.06272462 74.3189831 -50.40234375 65.66015625 C-58.76851512 56.61276991 -62.11606031 45.56493529 -61.8671875 33.453125 C-61.25890423 22.60981454 -56.8192815 12.85818819 -49.4453125 4.80859375 C-45.89513888 1.66077314 -41.8834247 -0.57628704 -37.6875 -2.75 C-36.74970703 -3.26433594 -36.74970703 -3.26433594 -35.79296875 -3.7890625 C-24.6101661 -9.00283106 -10.10622499 -6.35248428 0 0 Z " fill="#F8EBD5" transform="translate(410.6875,719.75)"/>
<path d="M0 0 C9.56061563 -0.26652181 18.89702521 0.52021894 28.375 1.625 C29.51301056 1.7560463 29.51301056 1.7560463 30.67401123 1.88973999 C97.10054682 9.64513551 97.10054682 9.64513551 114 23 C114.90625 25.05078125 114.90625 25.05078125 115 27 C111.97903075 30.02096925 108.43837517 29.48637303 104.3671875 29.67578125 C102.52926983 29.77938787 100.69138037 29.88349583 98.85351562 29.98803711 C97.87938721 30.0403952 96.90525879 30.0927533 95.90161133 30.146698 C79.36845979 31.05240716 62.92624955 32.34040127 46.5 34.4375 C45.66832306 34.54351532 44.83664612 34.64953064 43.97976685 34.75875854 C33.54129787 36.1083184 23.14813885 37.62966151 12.8671875 39.91967773 C8.94139542 40.77735134 5.86341532 41.29503997 2 40 C-2.32444331 35.99588582 -2.85446359 30.1830461 -3.2265625 24.6015625 C-3.42249828 15.96257577 -2.26964056 8.31064472 0 0 Z " fill="#D54426" transform="translate(650,217)"/>
<path d="M0 0 C9.5231462 -0.7362758 9.5231462 -0.7362758 14.00390625 2.4140625 C16.17936244 4.76908015 18.14277041 7.16853486 20.00683594 9.77636719 C21.23858296 11.48607586 22.52822551 13.13064518 23.84765625 14.7734375 C25.70692765 17.09178003 27.54307644 19.42517181 29.359375 21.77734375 C32.28649569 25.56044235 35.27869333 29.28914215 38.27734375 33.015625 C42.89123381 38.76109794 47.40929578 44.57146018 51.87890625 50.4296875 C54.78437626 54.19027912 57.78544301 57.86742568 60.81640625 61.52734375 C62.21484375 63.453125 62.21484375 63.453125 62.21484375 65.453125 C29.58075802 68.10991898 29.58075802 68.10991898 21.56103516 64.13916016 C17.70379332 60.55412143 16.04216065 55.93700451 14.28369141 51.06689453 C12.3143895 46.2511462 9.27671574 42.07968511 6.40234375 37.765625 C5.22078166 35.91430919 4.0437413 34.06010021 2.87109375 32.203125 C0.3400189 28.21709389 -2.20311604 24.23906728 -4.75390625 20.265625 C-5.71913208 18.75875122 -5.71913208 18.75875122 -6.70385742 17.22143555 C-7.94366085 15.28637043 -9.18591827 13.35287486 -10.4309082 11.42114258 C-11.26561646 10.11632935 -11.26561646 10.11632935 -12.1171875 8.78515625 C-12.85545776 7.63623901 -12.85545776 7.63623901 -13.60864258 6.46411133 C-14.78515625 4.453125 -14.78515625 4.453125 -15.78515625 1.453125 C-12.99592902 1.16225587 -10.21169638 0.9169295 -7.4140625 0.71875 C-4.93774733 0.53749119 -2.4653379 0.29512817 0 0 Z " fill="#F8ECD6" transform="translate(472.78515625,539.546875)"/>
<path d="M0 0 C2.33901094 2.12148418 3.61452737 3.95845306 4.80932617 6.87304688 C5.12943161 7.64394653 5.44953705 8.41484619 5.77934265 9.20910645 C6.11383926 10.03728882 6.44833588 10.86547119 6.79296875 11.71875 C7.14386063 12.57303589 7.4947525 13.42732178 7.85627747 14.30749512 C8.59524778 16.11154869 9.3304887 17.91713376 10.06225586 19.72412109 C11.1847966 22.49333094 12.32094162 25.2566614 13.45898438 28.01953125 C14.17529504 29.77310445 14.89081687 31.52700013 15.60546875 33.28125 C15.94603806 34.10943237 16.28660736 34.93761475 16.63749695 35.79089355 C16.9481459 36.56179321 17.25879486 37.33269287 17.57885742 38.12695312 C17.85404709 38.80407349 18.12923676 39.48119385 18.4127655 40.17883301 C19 42 19 42 19 45 C7.12 45 -4.76 45 -17 45 C-15.07957799 38.5985933 -13.14835392 32.51562651 -10.64453125 26.3671875 C-10.33803146 25.6044754 -10.03153168 24.84176331 -9.71574402 24.05593872 C-8.75209332 21.66061666 -7.78242482 19.26778737 -6.8125 16.875 C-6.1512898 15.23453734 -5.49047918 13.59391356 -4.83007812 11.953125 C-3.22465388 7.96687713 -1.61383429 3.98285006 0 0 Z " fill="#F7ECD8" transform="translate(671,725)"/>
<path d="M0 0 C3.62491138 3.11910979 7.31890993 6.47962201 7.9609375 11.4140625 C8.18974491 17.09904653 7.59532571 21.01036173 4.234375 25.68359375 C0.75384959 29.34869247 -3.42247313 30.43787063 -8.3125 30.75 C-14.00193112 30.50742736 -17.83680085 27.90470171 -21.6875 23.75 C-24.71353973 19.21094041 -25.21259908 14.61879841 -24.3125 9.3125 C-22.17061958 5.0213278 -19.38849936 2.0776551 -15.5 -0.6875 C-9.86735906 -2.45460304 -5.32432854 -2.71239378 0 0 Z " fill="#301C0A" transform="translate(593.3125,223.6875)"/>
<path d="M0 0 C0.83313721 -0.00902344 1.66627441 -0.01804688 2.5246582 -0.02734375 C3.31187256 -0.02347656 4.09908691 -0.01960937 4.91015625 -0.015625 C5.96601929 -0.01224121 5.96601929 -0.01224121 7.04321289 -0.00878906 C8.9375 0.25 8.9375 0.25 11.9375 2.25 C3.6875 2.25 -4.5625 2.25 -13.0625 2.25 C-13.0625 2.91 -13.0625 3.57 -13.0625 4.25 C-16.4375 4.375 -16.4375 4.375 -20.0625 4.25 C-20.7225 3.59 -21.3825 2.93 -22.0625 2.25 C-14.70458677 0.6051172 -7.51567274 0.03427575 0 0 Z " fill="#3E2A1B" transform="translate(571.0625,174.75)"/>
<path d="M0 0 C-4.61800279 2.45846207 -9.49255411 3.74369776 -14.5 5.1875 C-15.92505859 5.61579102 -15.92505859 5.61579102 -17.37890625 6.05273438 C-18.29542969 6.31763672 -19.21195313 6.58253906 -20.15625 6.85546875 C-20.98962891 7.09934326 -21.82300781 7.34321777 -22.68164062 7.59448242 C-25 8 -25 8 -29 7 C-26.03 6.34 -23.06 5.68 -20 5 C-20.33 4.01 -20.66 3.02 -21 2 C-18.81347261 1.66034526 -16.62571975 1.32857523 -14.4375 1 C-13.21933594 0.814375 -12.00117187 0.62875 -10.74609375 0.4375 C-7.12372152 0.01444923 -3.64287954 -0.07501425 0 0 Z " fill="#261509" transform="translate(725,248)"/>
<path d="M0 0 C0.66 1.32 1.32 2.64 2 4 C1.67 4.66 1.34 5.32 1 6 C1.5775 5.649375 2.155 5.29875 2.75 4.9375 C5.39786506 3.83422289 6.33185326 4.19843491 9 5 C6.37764986 5.86316536 3.75266548 6.71580779 1.125 7.5625 C0.37863281 7.80935547 -0.36773437 8.05621094 -1.13671875 8.31054688 C-6.7734375 10.11328125 -6.7734375 10.11328125 -9 9 C-6.03 6.03 -3.06 3.06 0 0 Z " fill="#B4783D" transform="translate(401,460)"/>
<path d="M0 0 C2.39549711 3.70731696 2.29904074 7.35845523 2.25 11.625 C2.25773438 12.305625 2.26546875 12.98625 2.2734375 13.6875 C2.25344122 18.74655878 2.25344122 18.74655878 0 21 C-1.18637743 17.44086771 -1.14615346 14.201855 -1.125 10.5 C-1.12886719 9.82324219 -1.13273438 9.14648438 -1.13671875 8.44921875 C-1.13062416 5.35926233 -0.9844023 2.95320689 0 0 Z " fill="#3E2A19" transform="translate(173,744)"/>
<path d="M0 0 C0 0.33 0 0.66 0 1 C-1.670625 1.4021875 -1.670625 1.4021875 -3.375 1.8125 C-7.21840951 2.65809019 -7.21840951 2.65809019 -9 6 C-9.39013716 7.9896995 -9.73202649 9.99019869 -10 12 C-12.97 11.505 -12.97 11.505 -16 11 C-16 9.35 -16 7.7 -16 6 C-14.576875 5.87625 -14.576875 5.87625 -13.125 5.75 C-9.90165132 5.36247285 -9.90165132 5.36247285 -8.75 3 C-8.5025 2.34 -8.255 1.68 -8 1 C-5.29120665 -0.35439668 -2.99066732 -0.06501451 0 0 Z " fill="#B3783E" transform="translate(519,324)"/>
<path d="M0 0 C0.66 0.33 1.32 0.66 2 1 C1.21625 1.9075 0.4325 2.815 -0.375 3.75 C-3.87330208 7.8744561 -3.87330208 7.8744561 -5 13 C-5.763125 12.938125 -6.52625 12.87625 -7.3125 12.8125 C-10.04525312 12.74101915 -10.04525312 12.74101915 -11.8125 14.5 C-12.204375 14.995 -12.59625 15.49 -13 16 C-13.66 15.67 -14.32 15.34 -15 15 C-10.05 10.05 -5.1 5.1 0 0 Z " fill="#B87B3E" transform="translate(435,361)"/>
<path d="M0 0 C1.98 0.66 3.96 1.32 6 2 C5.125 5.875 5.125 5.875 4 7 C2.29227642 7.08713831 0.58101351 7.10700007 -1.12890625 7.09765625 C-2.68061523 7.09282227 -2.68061523 7.09282227 -4.26367188 7.08789062 C-5.35228516 7.07951172 -6.44089844 7.07113281 -7.5625 7.0625 C-9.2012207 7.05573242 -9.2012207 7.05573242 -10.87304688 7.04882812 C-13.58208495 7.03699826 -16.29101599 7.02051543 -19 7 C-19 6.67 -19 6.34 -19 6 C-12.07 6 -5.14 6 2 6 C1.34 4.02 0.68 2.04 0 0 Z " fill="#D12A13" transform="translate(759,239)"/>
<path d="M0 0 C0.33 0.66 0.66 1.32 1 2 C1.928125 1.773125 2.85625 1.54625 3.8125 1.3125 C7 1 7 1 8.875 2.4375 C9.431875 3.2109375 9.431875 3.2109375 10 4 C8.375 9.75 8.375 9.75 5 12 C5.33 11.236875 5.66 10.47375 6 9.6875 C7.17436686 7.00930865 7.17436686 7.00930865 7 4 C3.26512223 4.4979837 1.18762365 4.87491756 -2 7 C-2.99 6.67 -3.98 6.34 -5 6 C-4.01 5.34 -3.02 4.68 -2 4 C-0.80767387 1.94996045 -0.80767387 1.94996045 0 0 Z " fill="#B3773C" transform="translate(426,417)"/>
<path d="M0 0 C0.33 0 0.66 0 1 0 C1.0544452 2.20805524 1.09299283 4.41650554 1.125 6.625 C1.14820313 7.85476563 1.17140625 9.08453125 1.1953125 10.3515625 C0.87852088 16.26922987 -0.59773374 20.04941772 -4.625 24.375 C-5.25664063 25.06335938 -5.88828125 25.75171875 -6.5390625 26.4609375 C-7.02117188 26.96882813 -7.50328125 27.47671875 -8 28 C-8.66 27.67 -9.32 27.34 -10 27 C-9.44570313 26.55914062 -8.89140625 26.11828125 -8.3203125 25.6640625 C-0.41298071 18.31953012 -0.44013263 10.20007376 0 0 Z " fill="#281808" transform="translate(635,249)"/>
<path d="M0 0 C3.62806974 3.49895693 6.80523484 7.10914328 9.875 11.125 C10.67679688 12.15882813 11.47859375 13.19265625 12.3046875 14.2578125 C12.86414063 15.16273438 13.42359375 16.06765625 14 17 C13.67 17.99 13.34 18.98 13 20 C10.8082282 17.8082282 9.51990614 15.44559004 8.01953125 12.75390625 C6.83033348 10.70812158 5.47741124 8.84676405 4 7 C3.34 7.66 2.68 8.32 2 9 C1.34 6.03 0.68 3.06 0 0 Z " fill="#B3783D" transform="translate(509,337)"/>
<path d="M0 0 C0.33 0 0.66 0 1 0 C1.22716871 3.70742928 1.4283696 7.41583562 1.625 11.125 C1.68945312 12.17171875 1.75390625 13.2184375 1.8203125 14.296875 C2.09114451 19.64580711 2.26521977 24.0026831 0 29 C-0.33 29 -0.66 29 -1 29 C-1.16831537 19.29381339 -0.64217298 9.67846426 0 0 Z " fill="#241506" transform="translate(618,355)"/>
<path d="M0 0 C3.96 0 7.92 0 12 0 C8.09987886 2.92509086 6.61691161 3.47535095 2 4 C2 5.32 2 6.64 2 8 C1.01 8.33 0.02 8.66 -1 9 C-0.67 6.03 -0.34 3.06 0 0 Z " fill="#DE4B2C" transform="translate(650,217)"/>
<path d="M0 0 C0 3.88291746 -1.37860494 5.46752535 -3.5 8.6875 C-4.1496875 9.68136719 -4.799375 10.67523438 -5.46875 11.69921875 C-6.22671875 12.83810547 -6.22671875 12.83810547 -7 14 C-7.33 13.34 -7.66 12.68 -8 12 C-7.484375 10.865625 -6.96875 9.73125 -6.4375 8.5625 C-5.963125 7.386875 -5.48875 6.21125 -5 5 C-5.66 4.01 -6.32 3.02 -7 2 C-6.030625 1.855625 -5.06125 1.71125 -4.0625 1.5625 C-1.13513227 1.32437659 -1.13513227 1.32437659 0 0 Z " fill="#B3773D" transform="translate(625,274)"/>
<path d="M0 0 C0.33 1.32 0.66 2.64 1 4 C0.1646875 4.3403125 0.1646875 4.3403125 -0.6875 4.6875 C-3.22472385 5.99203598 -3.22472385 5.99203598 -5.625 8.625 C-6.40875 9.40875 -7.1925 10.1925 -8 11 C-8.66 11 -9.32 11 -10 11 C-8.55218207 7.55571735 -6.72305391 5.63869038 -3.875 3.25 C-3.15054687 2.63640625 -2.42609375 2.0228125 -1.6796875 1.390625 C-0.84824219 0.70226562 -0.84824219 0.70226562 0 0 Z " fill="#271406" transform="translate(321,509)"/>
<path d="M0 0 C0.33 0.99 0.66 1.98 1 3 C-0.65 4.65 -2.3 6.3 -4 8 C-6 5 -6 5 -5.625 2.8125 C-5.41875 2.214375 -5.2125 1.61625 -5 1 C-3.02 1.495 -3.02 1.495 -1 2 C-0.67 1.34 -0.34 0.68 0 0 Z " fill="#301C0A" transform="translate(614,457)"/>
<path d="M0 0 C0.33 0.66 0.66 1.32 1 2 C1.66 2 2.32 2 3 2 C2.8125 3.875 2.8125 3.875 2 6 C-0.5625 7.25 -0.5625 7.25 -3 8 C-2.45276317 4.62537285 -1.9451 2.91765 0 0 Z " fill="#B0763D" transform="translate(494,290)"/>
<path d="M0 0 C0 3 0 3 -1.125 4.625 C-3.64613093 6.47382935 -5.93350175 6.65927797 -9 7 C-9 6.34 -9 5.68 -9 5 C-6.03 3.35 -3.06 1.7 0 0 Z " fill="#B1763C" transform="translate(496,454)"/>
<path d="M0 0 C1.32 0.66 2.64 1.32 4 2 C-0.455 4.97 -0.455 4.97 -5 8 C-5.66 7.67 -6.32 7.34 -7 7 C-5.6875 5.5 -5.6875 5.5 -4 4 C-3.01 4 -2.02 4 -1 4 C-0.67 2.68 -0.34 1.36 0 0 Z " fill="#B3773C" transform="translate(388,443)"/>
<path d="M0 0 C0.66 1.32 1.32 2.64 2 4 C2.66 4.33 3.32 4.66 4 5 C3.01 8.3 2.02 11.6 1 15 C0.67 15 0.34 15 0 15 C0 10.05 0 5.1 0 0 Z " fill="#C44124" transform="translate(647,230)"/>
<path d="M0 0 C2.22189824 2.22189824 2.92598892 4.08482708 4 7 C4.66 7 5.32 7 6 7 C5.67 9.31 5.34 11.62 5 14 C3.37723842 11.56585763 2.38255208 9.68680554 1.375 7 C0.98441406 5.9790625 0.98441406 5.9790625 0.5859375 4.9375 C0 3 0 3 0 0 Z " fill="#F6F1E7" transform="translate(535,768)"/>
<path d="M0 0 C0.33 0 0.66 0 1 0 C0.67 4.62 0.34 9.24 0 14 C-0.33 14 -0.66 14 -1 14 C-1.22226864 12.23086176 -1.42733873 10.45955629 -1.625 8.6875 C-1.74101562 7.70136719 -1.85703125 6.71523438 -1.9765625 5.69921875 C-2 3 -2 3 0 0 Z " fill="#200F05" transform="translate(204,746)"/>
<path d="M0 0 C-0.33 0.99 -0.66 1.98 -1 3 C-3.64 3 -6.28 3 -9 3 C-9 2.01 -9 1.02 -9 0 C-5.52176885 -1.15941038 -3.54104422 -0.70820884 0 0 Z " fill="#412911" transform="translate(292,514)"/>
<path d="M0 0 C0 0.99 0 1.98 0 3 C-4.95 2.67 -9.9 2.34 -15 2 C-15 1.67 -15 1.34 -15 1 C-10.03926578 -0.32286246 -5.08888488 -0.08893197 0 0 Z " fill="#402912" transform="translate(633,820)"/>
<path d="M0 0 C-1.98 0.66 -3.96 1.32 -6 2 C-5.01 3.485 -5.01 3.485 -4 5 C-8.875 3.25 -8.875 3.25 -10 1 C-3.375 -1.125 -3.375 -1.125 0 0 Z " fill="#BD7F40" transform="translate(403,495)"/>
<path d="M0 0 C0.66 0.33 1.32 0.66 2 1 C0 3 0 3 -2 4 C-1.67 4.66 -1.34 5.32 -1 6 C-2.65 6.66 -4.3 7.32 -6 8 C-4.73058503 4.08597051 -3.48832306 2.20927127 0 0 Z " fill="#1D0F05" transform="translate(577,224)"/>
<path d="M0 0 C2.02350324 3.03525486 2.32124018 4.19426202 2.625 7.6875 C2.69976562 8.49574219 2.77453125 9.30398438 2.8515625 10.13671875 C2.90054688 10.75160156 2.94953125 11.36648438 3 12 C1.09598862 10.09598862 0.06479561 8.66574314 -0.19921875 5.953125 C-0.1886578 3.96766727 -0.09915043 1.9830086 0 0 Z " fill="#F8F4E6" transform="translate(172,766)"/>
<path d="M0 0 C0.33 0 0.66 0 1 0 C1.29296875 6.0546875 1.29296875 6.0546875 1 8 C0.01 8.66 -0.98 9.32 -2 10 C-2.25 3.375 -2.25 3.375 0 0 Z " fill="#442C16" transform="translate(642,374)"/>
<path d="M0 0 C0.99 0.33 1.98 0.66 3 1 C0.59563974 4.60654039 -0.94679607 4.85452932 -5 6 C-3.35 4.02 -1.7 2.04 0 0 Z " fill="#FBF4E5" transform="translate(286,721)"/>
<path d="M0 0 C0.99 1.32 1.98 2.64 3 4 C0.36 4.66 -2.28 5.32 -5 6 C-3.35 4.02 -1.7 2.04 0 0 Z " fill="#C17F42" transform="translate(397,464)"/>
<path d="M0 0 C2.64 0 5.28 0 8 0 C7.67 0.99 7.34 1.98 7 3 C5.02 3 3.04 3 1 3 C0.67 2.01 0.34 1.02 0 0 Z " fill="#412A13" transform="translate(394,822)"/>
<path d="M0 0 C-1.65 1.32 -3.3 2.64 -5 4 C-7 3 -7 3 -8 1 C-3.375 -1.125 -3.375 -1.125 0 0 Z " fill="#F1ECE2" transform="translate(321,510)"/>
<path d="M0 0 C0.33 0.99 0.66 1.98 1 3 C0 5 0 5 -3.0625 6.125 C-4.031875 6.41375 -5.00125 6.7025 -6 7 C-4.02 4.69 -2.04 2.38 0 0 Z " fill="#B87A3E" transform="translate(404,393)"/>
<path d="M0 0 C2.31 0.33 4.62 0.66 7 1 C6.01 2.485 6.01 2.485 5 4 C2.69 3.67 0.38 3.34 -2 3 C-1.34 2.01 -0.68 1.02 0 0 Z " fill="#DA5132" transform="translate(726,244)"/>
<path d="M0 0 C0.66 0.66 1.32 1.32 2 2 C1.625 5.125 1.625 5.125 1 8 C0.01 8 -0.98 8 -2 8 C-1.34 5.36 -0.68 2.72 0 0 Z " fill="#3D2917" transform="translate(482,238)"/>
</svg>


## 🚀 Quick Start

```bash
# Install COVAL
pip install -e .

# Generate new code
coval generate -d "Create a FastAPI app with user authentication" --deploy

# Check status
coval status

# Repair issues
coval repair -e error.log --deploy

# Cleanup old iterations
coval cleanup -c 5
```

## ✨ Key Features

### 🔄 **Iterative Code Management**
- **Intelligent Iteration System**: Each generation/repair creates a new versioned iteration
- **Cost-Based Decisions**: Automatic analysis of whether to modify existing code or generate new
- **Legacy Cleanup**: Automatic removal of old iterations with configurable retention policies
- **History Tracking**: Complete audit trail of all code changes and decisions


```
1. INPUT
   ├── Error File (stacktrace/logs)
   ├── Source Directory
   └── Test File (optional)
          ↓
2. TRIAGE
   ├── Calculate Technical Debt
   ├── Measure Test Coverage
   ├── Assess Available Context
   └── Get Model Capability
          ↓
3. DECISION
   ├── Calculate Repair Cost
   ├── Calculate Rebuild Cost
   └── Make Decision (repair/rebuild)
          ↓
4. MRE CREATION [if repair]
   ├── Copy Relevant Files
   ├── Create Dockerfile
   └── Generate README
          ↓
5. FIX GENERATION
   ├── Prepare Context
   ├── Generate Prompt
   ├── Call LLM
   └── Parse Response
          ↓
6. VALIDATION
   ├── Apply Patch
   ├── Build Container
   ├── Run Tests
   └── Check Results
          ↓
7. INTEGRATION
   ├── Save Final Patch
   ├── Generate Report
   └── Return Result
```

### 🤖 **Multi-LLM Code Generation & Repair** 
- **6 Specialized Models**: Qwen, DeepSeek-R1, CodeLlama 13B, DeepSeek, Granite, Mistral
- **Adaptive Model Selection**: Choose optimal model based on task complexity and context
- **Automatic Model Management**: Download and configure models automatically via Ollama
- **Dynamic Capability Calculation**: Real-time model performance assessment

### 🐳 **Transparent Docker Deployments**
- **Blue-Green Deployments**: Zero-downtime deployments with automatic rollback
- **Volume Overlays**: Expose only latest changes while preserving legacy code
- **Multi-Framework Support**: FastAPI, Flask, Express.js, Next.js templates
- **Health Monitoring**: Automatic health checks and failure detection

### 💡 **Intelligent Cost Analysis**
- **Cost Calculator**: Automatically decides between modifying existing code vs generating new
- **Multi-Factor Analysis**: Considers technical debt, scope, complexity, and historical success
- **Risk Assessment**: Evaluates confidence levels and potential regression risks
- **Optimization Suggestions**: Recommends best approach for each scenario



## 📋 CLI Commands

### `coval generate` - Generate New Code
```bash
# Basic generation
coval generate -d "Create a REST API for user management" --model deepseek-r1

# Specify framework and features
coval generate -d "Build a blog platform" -f fastapi -l python \
  --features "authentication" --features "database" --deploy

# Generate from parent iteration
coval generate -d "Add payment system" --parent iter-001 --model deepseek-r1
```

### `coval run` - Deploy Iterations
```bash
# Deploy latest iteration
coval run

# Deploy specific iteration
coval run -i iter-003 -p 8080

# Use different deployment strategy
coval run -i iter-002 --strategy copy
```

### `coval repair` - Fix Code Issues
```bash
# Basic repair
coval repair -e logs/error.log

# Advanced repair with specific model
coval repair -e error.log -i iter-002 --model codellama13b --deploy

# Analyze only (no repair)
coval repair -e error.log --analyze
```

### `coval status` - Project Overview
```bash
# Show all iterations and deployments
coval status

# Verbose output
coval status -v
```

### `coval cleanup` - Maintenance
```bash
# Keep only 10 most recent iterations
coval cleanup -c 10

# Force cleanup without confirmation
coval cleanup -c 5 --force
```

### `coval stop` - Stop Deployments
```bash
# Stop specific deployment
coval stop -i iter-003

# Stop all deployments
coval stop
```

## 🛠 Installation


## 🧰 Makefile Automation

The repository includes a comprehensive `Makefile` that streamlines the full development and release workflow. Use the commands below to get productive quickly:

### Environment & Dependencies

```bash
make setup          # Create virtualenv and install dev dependencies
make install        # Install runtime dependencies only
make install-docs   # Install documentation toolchain
```

### Code Quality & Testing

- **`make format`** – Format the codebase with Black.
- **`make lint`** – Run Black, Flake8, and MyPy checks.
- **`make test`** – Execute the full pytest suite with coverage.
- **`make quick-test`** – Fast iteration loop (`format` + `test-fast`).
- **`make full-check`** – Complete verification (`format`, `lint`, `test`, `security-check`).

### Build & Deployment

- **`make build`** – Produce source and wheel distributions.
- **`make docker-build`** – Build the Docker image tagged with the current version and `latest`.
- **`make deploy-local`** – Build artifacts and run the Docker container locally.

### Release Automation

- **`make publish`** – Automatically bumps the patch version, builds the project, and uploads it to PyPI.
- **`make publish-test`** – Publish artifacts to TestPyPI.
- **`make publish-docker`** – Push Docker images to the configured registry.
- **`make release-patch`**, **`make release-minor`**, **`make release-major`** – Run quality gates, bump versions, build artifacts, and publish to PyPI & Docker.

> **Note:** The `make publish` target automatically increments the patch version via `make version-patch` before uploading. This prevents accidental attempts to reuse an existing version on PyPI.

### Version Management Workflow

```bash
make version          # Display current version and active git branch
make version-patch    # Bump X.Y.Z → X.Y.(Z+1), commit, and tag
make version-minor    # Bump X.Y.Z → X.(Y+1).0, commit, and tag
make version-major    # Bump X.Y.Z → (X+1).0.0, commit, and tag
```

Each command updates `setup.py` and `coval/__init__.py`, creates a git commit, and produces an annotated tag (e.g., `v2.0.1`).

For full releases:

```bash
make release-patch    # format/lint/test → version-patch → build → publish → docker-push
make release-minor
make release-major
```

If a publication fails after a version bump, you can roll back by deleting the tag and resetting the commit:

```bash
git tag -d v<new_version>
git reset --hard HEAD^   # restore previous commit
```


### Prerequisites
```bash
# System requirements
Python 3.11+
Docker & Docker Compose
Ollama (for LLM models)

# Install Ollama
curl -fsSL https://ollama.com/install.sh | sh
ollama serve
```

### Install COVAL
```bash
# Clone repository
git clone https://github.com/your-org/coval.git
cd coval

# Create virtual environment
python3 -m venv venv
source venv/bin/activate

# Install package
pip install -e .

# Verify installation
coval --help
```

Or use the Makefile helper (recommended):

```bash
make setup            # Creates venv, installs runtime + dev dependencies
source venv/bin/activate
coval --help
```

## ⚙️ Configuration

### Project Configuration (`coval.config.yaml`)
```yaml
# Project settings
project:
  name: "my-coval-project"
  framework: "auto-detect"
  language: "auto-detect" 
  max_iterations: 50

# Docker deployment settings  
docker:
  base_port: 8000
  network_name: "coval-network"
  auto_cleanup: true

# Volume overlay strategy
volumes:
  strategy: "overlay"  # overlay, copy, symlink
  preserve_permissions: true

# Cost calculation settings
cost_calculation:
  modify_base_cost: 10.0
  generate_base_cost: 25.0
  complexity_multiplier: 2.0
```

### LLM Configuration (`llm.config.yaml`)
```yaml
models:
  qwen2.5-coder:
    model_name: "qwen2.5-coder:7b"
    max_tokens: 16384
    temperature: 0.2
    base_capability: 0.85
    context_window: 32768
    
  deepseek-r1:
    model_name: "deepseek-r1:7b" 
    max_tokens: 12288
    temperature: 0.1
    base_capability: 0.80
    context_window: 16384
```

### 🔄 **Automatyczne Pobieranie Modeli**
System automatycznie sprawdza dostępność modelu via `ollama list` i pobiera brakujące:
```bash
🔍 Sprawdzam dostępność modelu: deepseek-r1:7b
📥 Pobieram model: deepseek-r1:7b
✅ Pomyślnie pobrano model: deepseek-r1:7b
```

## Kluczowe funkcjonalności:

### 1. **Model Decyzyjny Repair vs Rebuild**
- Implementuje matematyczny model kosztu naprawy: `C_fix = γD * (1/S) * (1/K) * (1 + λ(1-T))`
- Oblicza prawdopodobieństwo sukcesu używając **funkcji logitowej**
- Automatycznie decyduje czy naprawiać czy przebudować

### 2. **Workflow Naprawy (MRE → Test → Patch → Walidacja)**
- **Triage**: Analiza problemu i zbieranie metryk
- **MRE**: Tworzenie Minimal Reproducible Example
- **Generowanie**: Używa LLM do tworzenia poprawek
- **Walidacja**: Automatyczne testy w Docker
- **Integracja**: Finalizacja i raportowanie

### 3. **Metryki i Analiza**
- Dług techniczny (złożoność, duplikacja, brak dokumentacji)
- Pokrycie testami
- Dostępny kontekst (stacktrace, testy, dokumentacja)
- Zdolności modelu LLM

### 4. **Struktura Folderów**
```
/repairs/
  /repair-{ticket-id}/
    /mre/           # Minimal Reproducible Example
    /proposals/     # Propozycje napraw
    /validation/    # Wyniki walidacji
    decision.md     # Decyzja repair vs rebuild
    repair_report.md # Raport końcowy
```

### 5. **Użycie CLI v2.0**

#### **Dostępne Modele:**
```bash
--model qwen         # qwen2.5-coder:7b (domyślny, 95% zdolności)
--model deepseek     # deepseek-coder:6.7b (80% zdolności)
--model codellama13b # codellama:13b (75% zdolności, duży kontekst)
--model deepseek-r1  # deepseek-r1:7b (88% zdolności, reasoning)
--model granite      # granite-code:8b (70% zdolności, enterprise)
--model mistral      # mistral:7b (60% zdolności, fallback)
```

#### **Przykłady Użycia:**

```bash
# Podstawowa naprawa z najlepszym modelem
python3 repair.py --error error.log --source ./src

# Analiza z pokazaniem dynamicznych zdolności modelu
python3 repair.py --analyze --source ./src --error error.txt --model qwen

# Użyj zaawansowanego modelu z reasoning do złożonych błędów
python3 repair.py --error complex_bug.log --source ./app --model deepseek-r1

# Duży kontekst dla złożonych projektów
python3 repair.py --error error.txt --source ./large_project --model codellama13b

# Z testem i verbose logging
python3 repair.py --error stacktrace.txt --source ./project \
  --test tests/test_bug.py --model qwen --verbose

# Enterprise-grade model dla produkcji
python3 repair.py --error prod_error.log --source ./enterprise_app \
  --model granite --ticket PROD-1234

# Tylko analiza z porównaniem modeli
python3 repair.py --analyze --source ./src --error bug.txt --model deepseek-r1
python3 repair.py --analyze --source ./src --error bug.txt --model codellama13b
```

#### **Przykład Wyjścia z v2.0:**
```bash
$ python3 repair.py --analyze --source ./app --error error.log --model qwen

🔍 Sprawdzam dostępność modelu: qwen2.5-coder:7b
✅ Model qwen2.5-coder:7b jest dostępny
🤖 Użyto modelu: qwen2.5-coder:7b
⚙️  Konfiguracja: 16384 tokenów, temp: 0.2
📊 Tryb analizy (bez naprawy)

============================================================
📊 ANALIZA DECYZYJNA v2.0
============================================================
Rekomendacja: REBUILD
Prawdopodobieństwo sukcesu: 65.63%
Koszt naprawy: 1052.63 ↓ (niższy dzięki lepszej zdolności!)
Koszt przebudowy: 10.18

Metryki:
  - Dług techniczny: 2.00
  - Pokrycie testami: 0.00%
  - Dostępny kontekst: 0.00%
  - Zdolności modelu: 95.00% ↑ (dynamiczne!)
  - Historyczna skuteczność: 0.00% (nowy system)
  - Kategoria problemu: import_error
  - Model użyty: qwen2.5-coder:7b
  - Parametry: 16384 tokenów, temp: 0.2
============================================================
```

### 6. **Inteligentne Funkcje v2.0**

- **Automatyczne pobieranie modeli** - System sprawdza `ollama list` i pobiera brakujące modele
- **Dynamiczne obliczanie zdolności** - Uwzględnia tokeny, temperaturę, kontekst i historię
- **Adaptacyjne uczenie się** - 8 kategorii problemów z historical tracking
- **Automatyczne wykrywanie języka/frameworka** - dostosowuje Dockerfile i proces walidacji
- **Iteracyjne poprawki** - do 5 prób z różnymi podejściami i konfiguracją z YAML
- **Parsowanie błędów** - wyciąga pliki wymienione w stacktrace
- **Generowanie promptów** - różne szablony dla pierwszej i kolejnych prób
- **Walidacja w kontenerach** - izolowane środowisko testowe
- **Konfigurowalne parametry** - Wszystkie ustawienia modeli w `llm.config.yaml`

## 📦 **Instalacja i Wymagania v2.0**

### **Wymagania Systemowe:**
```bash
# Podstawowe wymagania
Python 3.11+
Docker & Docker Compose
Ollama (automatyczne pobieranie modeli)

# Python dependencies
pip install pyyaml requests docker subprocess32
```

### **Instalacja Ollama:**
```bash
# Linux/macOS
curl -fsSL https://ollama.com/install.sh | sh

# Windows
# Pobierz z https://ollama.com/download

# Uruchom ollama
ollama serve
```

### **Konfiguracja COVAL:**
```bash
# Klonuj repozytorium
git clone https://github.com/twój-repo/ymll.git
cd ymll/coval

# System automatycznie pobierze modele przy pierwszym użyciu
python3 repair.py --analyze --source ./test --error ./test.log --model qwen

# Sprawdź dostępne modele
ollama list
```

## 🔧 **Troubleshooting**

### **Problemy z Ollama:**
```bash
# Ollama nie jest zainstalowane
❌ Ollama nie jest zainstalowane lub nie jest w PATH
✅ Rozwiązanie: curl -fsSL https://ollama.com/install.sh | sh

# Model nie może być pobrany
❌ Błąd pobierania modelu: connection refused
✅ Rozwiązanie: Uruchom ollama serve w osobnym terminalu

# Timeout pobierania
⏱️ Timeout przy pobieraniu modelu: deepseek-r1:7b
✅ Rozwiązanie: Zwiększ timeout lub pobierz ręcznie: ollama pull deepseek-r1:7b
```

### **Problemy z Konfiguracją:**
```bash
# Brak llm.config.yaml
❌ Nie można załadować konfiguracji
✅ Rozwiązanie: Skopiuj llm.config.yaml z repozytorium

# Nieprawidłowa konfiguracja YAML
❌ yaml.parser.ParserError
✅ Rozwiązanie: Sprawdź składnię YAML online (yamllint.com)

# Brak uprawnień do zapisu repair_history.json
❌ Permission denied: repairs/repair_history.json
✅ Rozwiązanie: mkdir -p repairs && chmod 755 repairs
```

### **Problemy z Modelami:**
```bash
# Model nie odpowiada
❌ Model timeout po 60s
✅ Rozwiązanie: Użyj mniejszego modelu (--model mistral) lub zwiększ timeout

# Niewystarczająca pamięć
❌ CUDA out of memory
✅ Rozwiązanie: Użyj CPU: CUDA_VISIBLE_DEVICES="" python3 repair.py

# Model daje złe wyniki
❌ Repair failed repeatedly
✅ Rozwiązanie: Spróbuj innego modelu z większymi zdolnościami (--model deepseek-r1)
```

## 📈 **Porównanie Wydajności v1.0 vs v2.0**

### **Analiza tego samego problemu (import_error):**

| Metryka | v1.0 (Static) | v2.0 (Dynamic) | Poprawa |
|---------|---------------|----------------|---------|
| **Zdolność modelu** | 85.00% (static) | 95.00% (dynamic) | **+10%** ↑ |
| **Prawdopodobieństwo sukcesu** | 64.04% | 65.63% | **+1.59%** ↑ |
| **Koszt naprawy** | 1176.47 | 1052.63 | **-123.84** ↓ |
| **Dostępne modele** | 1 (qwen) | 6 modeli | **+500%** ↑ |
| **Konfigurowalność** | Brak | YAML config | **Nowa funkcja** |
| **Uczenie się** | Brak | Historical tracking | **Nowa funkcja** |
| **Auto-pobieranie** | Ręczne | Automatyczne | **Nowa funkcja** |

### **Kluczowe Ulepszenia:**

#### 🎯 **Lepsza Analiza Decyzyjna**
- **Dynamiczne zdolności**: System uwzględnia rzeczywiste parametry modelu
- **Kategoryzacja problemów**: 8 typów błędów vs generyczne podejście  
- **Historyczne uczenie**: System poprawia się z każdą naprawą
- **Niższe koszty**: Lepsze zdolności = mniejszy koszt naprawy

#### 🤖 **Szerszy Wybór Modeli**
```
v1.0: Tylko qwen2.5-coder (85% static capability)
v2.0: 6 modeli z dynamicznymi zdolnościami:
├─ qwen2.5-coder:7b    → 95% (najlepszy do JSON/debugowania)
├─ deepseek-r1:7b      → 88% (reasoning capabilities)  
├─ deepseek-coder:6.7b → 80% (kod specjalizowany)
├─ codellama:13b       → 75% (duży kontekst 32k)
├─ granite-code:8b     → 70% (enterprise grade)
└─ mistral:7b          → 60% (fallback uniwersalny)
```

#### ⚙️ **Łatwiejsza Konfiguracja**
```
v1.0: Twarde kodowanie parametrów w kodzie
v2.0: Centralna konfiguracja YAML:
├─ Optymalne ustawienia per model
├─ Konfigurowalne timeouty  
├─ Adaptacyjne parametry uczenia
└─ Łatwa customizacja bez edycji kodu
```

## ⚙️ **Szczegółowa Konfiguracja `llm.config.yaml`**

### **Pełna Struktura Pliku:**
```yaml
# Globalne ustawienia systemu
global:
  timeout: 60
  max_iterations: 5
  adaptive_evaluation:
    enabled: true
    history_weight: 0.3
    decay_factor: 0.9
    min_samples: 5
  capability_calculation:
    token_bonus_multiplier: 0.0001    # +0.01% za token ponad 8192
    temperature_penalty: 0.2          # -20% * temperatura
    context_bonus_multiplier: 0.0001  # +0.01% za token kontekstu ponad 8192
    max_capability: 0.95              # Maksymalna zdolność (95%)

# Konfiguracje poszczególnych modeli
models:
  # Model domyślny - najlepszy do napraw JSON
  qwen2.5-coder:
    model_name: "qwen2.5-coder:7b"
    max_tokens: 16384           # 2x więcej niż standard
    temperature: 0.2            # Optymalna dla napraw
    retry_attempts: 3
    base_capability: 0.85       # Baza dla dynamicznej kalkulacji
    context_window: 32768       # Duży kontekst
    specialization: ["json", "debugging", "python", "javascript"]
    
  # Nowy model z reasoning - do złożonych problemów
  deepseek-r1:
    model_name: "deepseek-r1:7b"
    max_tokens: 12288
    temperature: 0.1            # Niska dla reasoning
    retry_attempts: 4
    base_capability: 0.80
    context_window: 16384
    specialization: ["reasoning", "complex_logic", "algorithms"]
    
  # Duży model - do większych projektów
  codellama:
    model_name: "codellama:13b"
    max_tokens: 8192
    temperature: 0.3
    retry_attempts: 2
    base_capability: 0.70
    context_window: 32768       # Największy kontekst
    specialization: ["large_codebases", "refactoring", "architecture"]
```

### **Customizacja dla Własnych Potrzeb:**

#### **Zwiększ Zdolności Modelu:**
```yaml
models:
  custom-qwen:
    base_capability: 0.90      # ↑ Wyższa baza
    max_tokens: 32768          # ↑ Więcej tokenów = bonus
    temperature: 0.1           # ↓ Niższa temperatura = mniej penalty
    context_window: 65536      # ↑ Większy kontekst = bonus
```

#### **Dostosuj dla Środowiska Produkcyjnego:**
```yaml
global:
  timeout: 120                 # ↑ Więcej czasu dla złożonych napraw
  max_iterations: 10           # ↑ Więcej prób
  adaptive_evaluation:
    history_weight: 0.5        # ↑ Większa waga dla historii
    min_samples: 10            # ↑ Więcej danych do oceny
```

#### **Optymalizacja dla Szybkości:**
```yaml
models:
  fast-mistral:
    max_tokens: 4096           # ↓ Mniej tokenów = szybciej
    temperature: 0.4           # ↑ Wyższa = mniej precyzyjne ale szybsze
    retry_attempts: 1          # ↓ Mniej prób
```

### 7. **Raporty i Decyzje**

System generuje szczegółowe raporty zawierające:
- Analizę kosztów (repair vs rebuild)
- Prawdopodobieństwo sukcesu
- Zastosowane poprawki
- Ocenę ryzyka regresji
- Rekomendacje dalszych kroków

### 8. **Wsparcie dla wielu języków**

Automatycznie rozpoznaje i obsługuje:
- Python (FastAPI, Django, Flask)
- JavaScript/Node.js (Express, Next.js)
- Go (Gin, Fiber)
- Rust, Java, Ruby, PHP

Skrypt jest w pełni zintegrowany z podejściem YMLL i implementuje wszystkie najlepsze praktyki z REPAIR_GUIDELINES, zapewniając efektywny i powtarzalny proces naprawiania kodu z pomocą LLM.

## Funkcja logitowa

Funkcja **logitowa** to po prostu funkcja matematyczna używana głównie w statystyce i uczeniu maszynowym do przekształcania prawdopodobieństw w tzw. log-odds. Jest odwrotnością funkcji sigmoidalnej (logistycznej).

Dokładniej:

### Definicja

Jeżeli $p$ to prawdopodobieństwo zdarzenia (0 < p < 1), funkcja logitowa jest zdefiniowana jako:

$$
\text{logit}(p) = \ln\left(\frac{p}{1-p}\right)
$$

* $p/(1-p)$ to **odds** (szansa, że zdarzenie nastąpi vs że nie nastąpi)
* $\ln$ to logarytm naturalny

### Przykład

* Jeśli $p = 0.8$ (80% prawdopodobieństwa),

$$
\text{logit}(0.8) = \ln\left(\frac{0.8}{0.2}\right) = \ln(4) \approx 1.386
$$

* Jeśli $p = 0.5$, $\text{logit}(0.5) = \ln(1) = 0$

### Zastosowanie

* W **regresji logistycznej** logit przekształca prawdopodobieństwa w wartość na osi liczbowej od $-\infty$ do $+\infty$, co pozwala modelowi liniowemu prognozować log-odds, a następnie łatwo przekształcać z powrotem w prawdopodobieństwo.
* W twoim kontekście (system naprawy kodu) funkcja logitowa może służyć do obliczenia **prawdopodobieństwa sukcesu naprawy** na podstawie różnych zmiennych (jak złożoność, dostępność testów itd.).

