"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoDiscover = exports.LambdaExtensionAutoDiscover = exports.EdgeLambdaAutoDiscover = exports.LambdaAutoDiscover = exports.IntegrationTestAutoDiscover = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const integration_test_1 = require("./integration-test");
const internal_1 = require("./internal");
const lambda_extension_1 = require("./lambda-extension");
const lambda_function_1 = require("./lambda-function");
const cdk_1 = require("../cdk");
const component_1 = require("../component");
/**
 * Creates integration tests from entry points discovered in the test tree.
 */
class IntegrationTestAutoDiscover extends cdk_1.IntegrationTestAutoDiscoverBase {
    constructor(project, options) {
        super(project, options);
        for (const entrypoint of this.entrypoints) {
            new integration_test_1.IntegrationTest(this.project, {
                entrypoint,
                cdkDeps: options.cdkDeps,
                tsconfigPath: options.tsconfigPath,
                ...options.integrationTestOptions,
            });
        }
    }
}
exports.IntegrationTestAutoDiscover = IntegrationTestAutoDiscover;
_a = JSII_RTTI_SYMBOL_1;
IntegrationTestAutoDiscover[_a] = { fqn: "projen.awscdk.IntegrationTestAutoDiscover", version: "0.79.27" };
/**
 * Creates lambdas from entry points discovered in the project's source tree.
 */
class LambdaAutoDiscover extends cdk_1.AutoDiscoverBase {
    constructor(project, options) {
        super(project, {
            projectdir: options.srcdir,
            extension: internal_1.TYPESCRIPT_LAMBDA_EXT,
        });
        for (const entrypoint of this.entrypoints) {
            new lambda_function_1.LambdaFunction(this.project, {
                entrypoint,
                cdkDeps: options.cdkDeps,
                ...options.lambdaOptions,
            });
        }
    }
}
exports.LambdaAutoDiscover = LambdaAutoDiscover;
_b = JSII_RTTI_SYMBOL_1;
LambdaAutoDiscover[_b] = { fqn: "projen.awscdk.LambdaAutoDiscover", version: "0.79.27" };
/**
 * Creates edge lambdas from entry points discovered in the project's source tree.
 */
class EdgeLambdaAutoDiscover extends cdk_1.AutoDiscoverBase {
    constructor(project, options) {
        super(project, {
            projectdir: options.srcdir,
            extension: internal_1.TYPESCRIPT_EDGE_LAMBDA_EXT,
        });
        for (const entrypoint of this.entrypoints) {
            new lambda_function_1.LambdaFunction(this.project, {
                entrypoint,
                cdkDeps: options.cdkDeps,
                ...options.lambdaOptions,
                edgeLambda: true,
            });
        }
    }
}
exports.EdgeLambdaAutoDiscover = EdgeLambdaAutoDiscover;
_c = JSII_RTTI_SYMBOL_1;
EdgeLambdaAutoDiscover[_c] = { fqn: "projen.awscdk.EdgeLambdaAutoDiscover", version: "0.79.27" };
/**
 * Creates Lambda Extensions from entrypoints discovered in the project's
 * source tree.
 */
class LambdaExtensionAutoDiscover extends cdk_1.AutoDiscoverBase {
    constructor(project, options) {
        super(project, {
            projectdir: options.srcdir,
            extension: internal_1.TYPESCRIPT_LAMBDA_EXTENSION_EXT,
        });
        for (const entrypoint of this.entrypoints) {
            new lambda_extension_1.LambdaExtension(this.project, {
                entrypoint,
                cdkDeps: options.cdkDeps,
                ...options.lambdaExtensionOptions,
            });
        }
    }
}
exports.LambdaExtensionAutoDiscover = LambdaExtensionAutoDiscover;
_d = JSII_RTTI_SYMBOL_1;
LambdaExtensionAutoDiscover[_d] = { fqn: "projen.awscdk.LambdaExtensionAutoDiscover", version: "0.79.27" };
/**
 * Discovers and creates integration tests and lambdas from code in the
 * project's source and test trees.
 */
class AutoDiscover extends component_1.Component {
    constructor(project, options) {
        super(project);
        if (options.lambdaAutoDiscover ?? true) {
            new LambdaAutoDiscover(this.project, {
                cdkDeps: options.cdkDeps,
                tsconfigPath: options.tsconfigPath,
                srcdir: options.srcdir,
                lambdaOptions: options.lambdaOptions,
            });
        }
        if (options.edgeLambdaAutoDiscover ?? true) {
            new EdgeLambdaAutoDiscover(this.project, {
                cdkDeps: options.cdkDeps,
                tsconfigPath: options.tsconfigPath,
                srcdir: options.srcdir,
                lambdaOptions: options.lambdaOptions,
            });
        }
        if (options.lambdaExtensionAutoDiscover ?? true) {
            new LambdaExtensionAutoDiscover(this.project, {
                cdkDeps: options.cdkDeps,
                tsconfigPath: options.tsconfigPath,
                srcdir: options.srcdir,
                lambdaExtensionOptions: options.lambdaExtensionOptions,
            });
        }
        if (options.integrationTestAutoDiscover ?? true) {
            new IntegrationTestAutoDiscover(this.project, {
                cdkDeps: options.cdkDeps,
                testdir: options.testdir,
                tsconfigPath: options.tsconfigPath,
                integrationTestOptions: options.integrationTestOptions,
            });
        }
    }
}
exports.AutoDiscover = AutoDiscover;
_e = JSII_RTTI_SYMBOL_1;
AutoDiscover[_e] = { fqn: "projen.awscdk.AutoDiscover", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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