"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCdkJavaApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const awscdk_deps_java_1 = require("./awscdk-deps-java");
const cdk_config_1 = require("./cdk-config");
const cdk_tasks_1 = require("./cdk-tasks");
const __1 = require("..");
const java_1 = require("../java");
/**
 * AWS CDK app in Java.
 *
 * @pjid awscdk-app-java
 */
class AwsCdkJavaApp extends java_1.JavaProject {
    constructor(options) {
        const mainClassComponents = options.mainClass.split(".");
        const mainPackage = mainClassComponents.slice(0, -1);
        const mainClassName = mainClassComponents[mainClassComponents.length - 1];
        super({
            ...options,
            sample: false,
            sampleJavaPackage: mainPackage.join("."),
        });
        this.mainClass = options.mainClass;
        this.mainPackage = mainPackage.join(".");
        this.mainClassName = mainClassName;
        this.cdkDeps = new awscdk_deps_java_1.AwsCdkDepsJava(this, {
            dependencyType: __1.DependencyType.RUNTIME,
            ...options,
        });
        this.cdkTasks = new cdk_tasks_1.CdkTasks(this);
        this.postCompileTask.spawn(this.cdkTasks.synth);
        this.cdkConfig = new cdk_config_1.CdkConfig(this, {
            app: `mvn exec:java --quiet -Dexec.mainClass=${this.mainClass}`,
            featureFlags: this.cdkDeps.cdkMajorVersion < 2,
            ...options,
        });
        if (options.sample ?? true) {
            this.addSample();
        }
    }
    /**
     * Adds an AWS CDK module dependencies
     *
     * @param modules The list of modules to depend on (e.g. "software.amazon.awscdk/aws-lambda", "software.amazon.awscdk/aws-iam", etc)
     * @deprecated In CDK 2.x all modules are available by default. Alpha modules should be added using the standard 'deps'
     */
    addCdkDependency(...modules) {
        for (const m of modules) {
            this.cdkDeps.addV1Dependencies(m);
        }
    }
    addSample() {
        const pkg = this.mainPackage.split(".");
        const javaFile = `${this.mainClassName}.java`;
        new __1.SampleDir(this, (0, path_1.join)("src", "main", "java", ...pkg), {
            files: {
                [javaFile]: [
                    `package ${pkg.join(".")};`,
                    "",
                    this.cdkDeps.cdkMajorVersion == 1
                        ? "import software.amazon.awscdk.core.App;"
                        : "import software.amazon.awscdk.App;",
                    this.cdkDeps.cdkMajorVersion == 1
                        ? "import software.amazon.awscdk.core.Stack;"
                        : "import software.amazon.awscdk.Stack;",
                    "",
                    `public class ${this.mainClassName} {`,
                    "  public static void main(final String[] args) {",
                    "    App app = new App();",
                    `    new Stack(app, "${this.name}");`,
                    "    app.synth();",
                    "  }",
                    "}",
                ].join("\n"),
            },
        });
    }
}
exports.AwsCdkJavaApp = AwsCdkJavaApp;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkJavaApp[_a] = { fqn: "projen.awscdk.AwsCdkJavaApp", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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