"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCdkPythonApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _1 = require(".");
const awscdk_deps_py_1 = require("./awscdk-deps-py");
const awscdk_pytest_sample_1 = require("./awscdk-pytest-sample");
const __1 = require("..");
const pytest_1 = require("../python/pytest");
const python_project_1 = require("../python/python-project");
/**
 * AWS CDK app in Python
 *
 * @pjid awscdk-app-py
 */
class AwsCdkPythonApp extends python_project_1.PythonProject {
    /**
     * The CDK version this app is using.
     */
    get cdkVersion() {
        return this.cdkDeps.cdkVersion;
    }
    constructor(options) {
        super({ ...options, pytest: false, sample: false });
        this.cdkDeps = new awscdk_deps_py_1.AwsCdkDepsPy(this, {
            dependencyType: __1.DependencyType.RUNTIME,
            ...options,
        });
        this.appEntrypoint = options.appEntrypoint ?? "app.py";
        this.testdir = options.testdir ?? "tests";
        this.cdkTasks = new _1.CdkTasks(this);
        this.postCompileTask.spawn(this.cdkTasks.synthSilent);
        this.cdkConfig = new _1.CdkConfig(this, {
            app: `python ${this.appEntrypoint}`,
            featureFlags: this.cdkDeps.cdkMajorVersion < 2,
            watchIncludes: ["**"],
            watchExcludes: [
                "README.md",
                "cdk*.json",
                "requirements*.txt",
                "source.bat",
                "**/__init__.py",
                "python/__pycache__",
                "tests",
            ],
            ...options,
        });
        if (options.sample ?? true) {
            new AppCode(this, this.appEntrypoint, this.cdkDeps.cdkMajorVersion);
            new MyStackCode(this, this.moduleName, this.cdkDeps.cdkMajorVersion);
        }
        if (options.pytest ?? true) {
            this.pytest = new pytest_1.Pytest(this, options.pytestOptions);
            new awscdk_pytest_sample_1.AwsCdkPytestSample(this, this.pytest.testdir);
        }
    }
}
exports.AwsCdkPythonApp = AwsCdkPythonApp;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkPythonApp[_a] = { fqn: "projen.awscdk.AwsCdkPythonApp", version: "0.79.27" };
class AppCode extends __1.Component {
    constructor(project, fileName, cdkVersion) {
        super(project);
        let versionImport;
        if (cdkVersion < 2) {
            versionImport = "from aws_cdk.core import App, Environment";
        }
        else {
            versionImport = "from aws_cdk import App, Environment";
        }
        new __1.SampleFile(project, fileName, {
            contents: [
                "import os",
                versionImport,
                `from ${project.moduleName}.main import MyStack`,
                "",
                "# for development, use account/region from cdk cli",
                "dev_env = Environment(",
                "  account=os.getenv('CDK_DEFAULT_ACCOUNT'),",
                "  region=os.getenv('CDK_DEFAULT_REGION')",
                ")",
                "",
                "app = App()",
                `MyStack(app, "${this.project.name}-dev", env=dev_env)`,
                `# MyStack(app, "${this.project.name}-prod", env=prod_env)`,
                "",
                "app.synth()",
            ].join("\n"),
        });
    }
}
class MyStackCode extends __1.Component {
    constructor(project, dir, cdkMajorVersion) {
        super(project);
        let appFile = [];
        appFile.push("import os");
        if (cdkMajorVersion < 2) {
            appFile.push("from aws_cdk.core import Construct, Stack");
        }
        else {
            appFile.push("from aws_cdk import Stack");
            appFile.push("from constructs import Construct");
        }
        appFile.push("");
        appFile.push("");
        appFile.push("class MyStack(Stack):");
        appFile.push("  def __init__(self, scope: Construct, construct_id: str, **kwargs) -> None:");
        appFile.push("    super().__init__(scope, construct_id, **kwargs)");
        appFile.push("");
        appFile.push("    # The code that defines your stack goes here");
        appFile.push("");
        new __1.SampleDir(project, dir, {
            files: {
                "__init__.py": "",
                "main.py": appFile.join("\n"),
            },
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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