"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructLibraryAws = exports.AwsCdkConstructLibrary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const semver = require("semver");
const auto_discover_1 = require("./auto-discover");
const awscdk_deps_js_1 = require("./awscdk-deps-js");
const integ_runner_1 = require("./integ-runner");
const cdk_1 = require("../cdk");
const dependencies_1 = require("../dependencies");
/**
 * AWS CDK construct library project
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the AWS CDK with a friendly workflow and automatic publishing to
 * the construct catalog.
 *
 * @pjid awscdk-construct
 */
class AwsCdkConstructLibrary extends cdk_1.ConstructLibrary {
    constructor(options) {
        const cdkMajorVersion = semver.parse(options.cdkVersion)?.major;
        super({
            peerDependencyOptions: cdkMajorVersion === 1
                ? {
                    pinnedDevDependency: false,
                }
                : undefined,
            workflowNodeVersion: options.minNodeVersion ?? "18.x",
            ...options,
        });
        this.cdkDeps = new awscdk_deps_js_1.AwsCdkDepsJs(this, {
            // since this we are a library, dependencies should be added a peers
            dependencyType: dependencies_1.DependencyType.PEER,
            ...options,
        });
        new auto_discover_1.AutoDiscover(this, {
            srcdir: this.srcdir,
            testdir: this.testdir,
            lambdaOptions: options.lambdaOptions,
            tsconfigPath: this.tsconfigDev.fileName,
            cdkDeps: this.cdkDeps,
            lambdaAutoDiscover: options.lambdaAutoDiscover ?? true,
            edgeLambdaAutoDiscover: options.edgeLambdaAutoDiscover ?? true,
            lambdaExtensionAutoDiscover: options.lambdaExtensionAutoDiscover ?? true,
            integrationTestAutoDiscover: options.integrationTestAutoDiscover ?? true,
        });
        if (options.experimentalIntegRunner) {
            new integ_runner_1.IntegRunner(this);
        }
    }
    /**
     * The target CDK version for this library.
     */
    get cdkVersion() {
        return this.cdkDeps.cdkVersion;
    }
    /**
     * @deprecated use `cdkVersion`
     */
    get version() {
        return this.cdkVersion;
    }
    /**
     * Adds dependencies to AWS CDK modules.
     *
     * Since this is a library project, dependencies will be added as peer dependencies.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @deprecated Not supported in v2. For v1, use `project.cdkDeps.addV1Dependencies()`
     */
    addCdkDependencies(...deps) {
        return this.cdkDeps.addV1Dependencies(...deps);
    }
    /**
     * Adds AWS CDK modules as dev dependencies.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @deprecated Not supported in v2. For v1, use `project.cdkDeps.addV1DevDependencies()`
     */
    addCdkTestDependencies(...deps) {
        return this.cdkDeps.addV1DevDependencies(...deps);
    }
}
exports.AwsCdkConstructLibrary = AwsCdkConstructLibrary;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkConstructLibrary[_a] = { fqn: "projen.awscdk.AwsCdkConstructLibrary", version: "0.79.27" };
/** @deprecated use `AwsCdkConstructLibrary` */
class ConstructLibraryAws extends AwsCdkConstructLibrary {
}
exports.ConstructLibraryAws = ConstructLibraryAws;
_b = JSII_RTTI_SYMBOL_1;
ConstructLibraryAws[_b] = { fqn: "projen.awscdk.ConstructLibraryAws", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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