"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalLevel = exports.CdkConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const internal_1 = require("./internal");
const component_1 = require("../component");
const json_1 = require("../json");
/**
 * Represents cdk.json file.
 */
class CdkConfig extends component_1.Component {
    constructor(project, options) {
        super(project);
        this.cdkout = options.cdkout ?? "cdk.out";
        this._include = options.watchIncludes ?? [];
        this._exclude = options.watchExcludes ?? [];
        const context = { ...options.context };
        const fflags = options.featureFlags ?? true;
        if (fflags) {
            for (const flag of internal_1.FEATURE_FLAGS) {
                context[flag] = true;
            }
        }
        this.json = new json_1.JsonFile(project, "cdk.json", {
            omitEmpty: true,
            obj: {
                app: options.app,
                context: context,
                requireApproval: options.requireApproval,
                output: this.cdkout,
                build: options.buildCommand,
                watch: {
                    include: () => this._include,
                    exclude: () => this._exclude,
                },
            },
        });
        project.gitignore.exclude(`/${this.cdkout}/`);
        project.gitignore.exclude(".cdk.staging/");
    }
    /**
     * Add includes to `cdk.json`.
     * @param patterns The includes to add.
     */
    addIncludes(...patterns) {
        this._include.push(...patterns);
    }
    /**
     * Add excludes to `cdk.json`.
     * @param patterns The excludes to add.
     */
    addExcludes(...patterns) {
        this._exclude.push(...patterns);
    }
    /**
     * List of glob patterns to be included by CDK.
     */
    get include() {
        return [...this._include];
    }
    /**
     * List of glob patterns to be excluded by CDK.
     */
    get exclude() {
        return [...this._exclude];
    }
}
exports.CdkConfig = CdkConfig;
_a = JSII_RTTI_SYMBOL_1;
CdkConfig[_a] = { fqn: "projen.awscdk.CdkConfig", version: "0.79.27" };
/**
 * Which approval is required when deploying CDK apps.
 */
var ApprovalLevel;
(function (ApprovalLevel) {
    /**
     * Approval is never required
     */
    ApprovalLevel["NEVER"] = "never";
    /**
     * Requires approval on any IAM or security-group-related change
     */
    ApprovalLevel["ANY_CHANGE"] = "any-change";
    /**
     * Requires approval when IAM statements or traffic rules are added; removals don't require approval
     */
    ApprovalLevel["BROADENING"] = "broadening";
})(ApprovalLevel || (exports.ApprovalLevel = ApprovalLevel = {}));
//# sourceMappingURL=data:application/json;base64,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