"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationTest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const internal_1 = require("./internal");
const cdk_1 = require("../cdk");
const dependencies_1 = require("../dependencies");
/**
 * Cloud integration tests.
 */
class IntegrationTest extends cdk_1.IntegrationTestBase {
    constructor(project, options) {
        super(project, options);
        if (!project.deps.tryGetDependency("aws-cdk")) {
            project.deps.addDependency(`aws-cdk@^${options.cdkDeps.cdkMajorVersion}`, dependencies_1.DependencyType.BUILD);
        }
        if (!project.deps.tryGetDependency("ts-node")) {
            project.deps.addDependency("ts-node", dependencies_1.DependencyType.BUILD);
        }
        const deployDir = (0, path_1.join)(this.tmpDir, "deploy.cdk.out");
        const assertDir = (0, path_1.join)(this.tmpDir, "assert.cdk.out");
        const app = `ts-node -P ${options.tsconfigPath} ${options.entrypoint}`;
        const opts = [
            `--app "${app}"`,
            "--no-notices",
            "--no-version-reporting",
            // don't inject cloudformation metadata into template
            "--no-asset-metadata",
        ];
        const pathMetadata = options.pathMetadata ?? false;
        if (!pathMetadata) {
            opts.push("--no-path-metadata");
        }
        if (options.cdkDeps.cdkMajorVersion === 1) {
            // add all feature flags
            const features = [
                ...internal_1.FEATURE_FLAGS,
                "@aws-cdk/core:newStyleStackSynthesis", // simplifies asset coordinates in synth output
            ];
            for (const feature of features) {
                opts.push(`--context ${feature}=true`);
            }
        }
        const cdkopts = opts.join(" ");
        // Determine which stacks to deploy
        const stacks = options.stacks ?? ["**"];
        const stackOpts = stacks.map((stack) => `'${stack}'`).join(" ");
        this.deployTask.exec(`rm -fr ${deployDir}`);
        this.deployTask.exec(`cdk deploy ${cdkopts} ${stackOpts} --require-approval=never -o ${deployDir}`);
        // if deployment was successful, copy the deploy dir to the expected dir
        this.deployTask.exec(`rm -fr ${this.snapshotDir}`);
        this.deployTask.exec(`mv ${deployDir} ${this.snapshotDir}`);
        this.watchTask = project.addTask(`integ:${this.name}:watch`, {
            description: `watch integration test '${this.name}' (without updating snapshots)`,
            exec: `cdk watch ${cdkopts} ${stackOpts} -o ${deployDir}`,
        });
        this.destroyTask = project.addTask(`integ:${this.name}:destroy`, {
            description: `destroy integration test '${this.name}'`,
            exec: `cdk destroy --app ${this.snapshotDir} ${stackOpts} --no-version-reporting`,
        });
        const destroyAfterDeploy = options.destroyAfterDeploy ?? true;
        if (destroyAfterDeploy) {
            this.deployTask.spawn(this.destroyTask);
        }
        this.snapshotTask.exec(`cdk synth ${cdkopts} -o ${this.snapshotDir} > /dev/null`);
        const exclude = ["asset.*", "cdk.out", "manifest.json", "tree.json"];
        this.assertTask.exec(`cdk synth ${cdkopts} -o ${assertDir} > /dev/null`);
        this.assertTask.exec(`diff -r ${exclude.map((x) => `-x ${x}`).join(" ")} ${this.snapshotDir}/ ${assertDir}/`);
        // do not commit all files we are excluding
        for (const x of exclude) {
            project.addGitIgnore(`${this.snapshotDir}/${x}`);
            project.addGitIgnore(`${this.snapshotDir}/**/${x}`); // nested assemblies
        }
    }
}
exports.IntegrationTest = IntegrationTest;
_a = JSII_RTTI_SYMBOL_1;
IntegrationTest[_a] = { fqn: "projen.awscdk.IntegrationTest", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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