"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationTestBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const internal_1 = require("./internal");
const component_1 = require("../component");
class IntegrationTestBase extends component_1.Component {
    constructor(project, options) {
        super(project);
        const entry = options.entrypoint;
        const name = options.name ?? (0, path_1.basename)(entry, internal_1.TYPESCRIPT_INTEG_EXT);
        this.name = name;
        const dir = (0, path_1.dirname)(entry);
        const tmpRoot = (0, path_1.join)(dir, ".tmp");
        project.addGitIgnore(tmpRoot);
        project.addPackageIgnore(tmpRoot);
        this.tmpDir = (0, path_1.join)(tmpRoot, `${name}.integ`);
        this.snapshotDir = (0, path_1.join)(dir, `${name}.integ.snapshot`);
        project.addPackageIgnore(this.snapshotDir);
        this.deployTask = project.addTask(`integ:${name}:deploy`, {
            description: `deploy integration test '${name}' and capture snapshot`,
        });
        this.snapshotTask = project.addTask(`integ:${name}:snapshot`, {
            description: `update snapshot for integration test "${name}"`,
        });
        this.assertTask = project.addTask(`integ:${name}:assert`, {
            description: `assert the snapshot of integration test '${name}'`,
            exec: `[ -d "${this.snapshotDir}" ] || (echo "No snapshot available for integration test '${name}'. Run 'projen ${this.deployTask.name}' to capture." && exit 1)`,
        });
        // synth as part of our tests, which means that if outdir changes, anti-tamper will fail
        project.testTask.spawn(this.assertTask);
        let snapshotAllTask = project.tasks.tryFind("integ:snapshot-all");
        if (!snapshotAllTask) {
            snapshotAllTask = project.addTask("integ:snapshot-all", {
                description: "update snapshot for all integration tests",
            });
        }
        // integ:snapshot-all should snapshot all integration tests, including
        // this one.
        snapshotAllTask.spawn(this.snapshotTask);
    }
}
exports.IntegrationTestBase = IntegrationTestBase;
_a = JSII_RTTI_SYMBOL_1;
IntegrationTestBase[_a] = { fqn: "projen.cdk.IntegrationTestBase", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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