"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationTest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const cdk_1 = require("../cdk");
const dependencies_1 = require("../dependencies");
/**
 * CDK8S integration test.
 */
class IntegrationTest extends cdk_1.IntegrationTestBase {
    constructor(project, options) {
        super(project, options);
        if (!project.deps.tryGetDependency("cdk8s-cli")) {
            project.deps.addDependency(`cdk8s-cli`, dependencies_1.DependencyType.BUILD);
        }
        if (!project.deps.tryGetDependency("ts-node")) {
            project.deps.addDependency("ts-node", dependencies_1.DependencyType.BUILD);
        }
        const deployDir = (0, path_1.join)(this.tmpDir, "deploy.cdk.out");
        const assertDir = (0, path_1.join)(this.tmpDir, "assert.cdk.out");
        const app = `ts-node -P ${options.tsconfigPath} ${options.entrypoint}`;
        // Synth, deploy, and capture the snapshot
        this.deployTask.exec(`rm -fr ${deployDir}`);
        this.deployTask.exec(`cdk8s synth --app "${app}" -o ${deployDir}`);
        this.deployTask.exec(`kubectl apply -f ${deployDir}`);
        // If deployment was successful, copy the deploy dir to the expected dir
        this.deployTask.exec(`rm -fr ${this.snapshotDir}`);
        this.deployTask.exec(`mv ${deployDir} ${this.snapshotDir}`);
        // Run a snapshot
        this.snapshotTask.exec(`rm -fr ${this.snapshotDir}`);
        this.snapshotTask.exec(`cdk8s synth --app "${app}" -o ${this.snapshotDir}`);
        // Assert that the snapshot has not changed (run during tests)
        this.assertTask.exec(`cdk8s synth --app "${app}" -o ${assertDir} > /dev/null`);
        this.assertTask.exec(`diff ${this.snapshotDir}/ ${assertDir}/`);
    }
}
exports.IntegrationTest = IntegrationTest;
_a = JSII_RTTI_SYMBOL_1;
IntegrationTest[_a] = { fqn: "projen.cdk8s.IntegrationTest", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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