"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructLibraryCdktf = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const semver = require("semver");
const cdk_1 = require("../cdk");
/**
 * CDKTF construct library project
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the CDK for Terraform (CDKTF), with a friendly workflow and
 * automatic publishing to the construct catalog.
 *
 * @pjid cdktf-construct
 */
class ConstructLibraryCdktf extends cdk_1.ConstructLibrary {
    constructor(options) {
        super(options);
        if (!options.cdktfVersion) {
            throw new Error("Required field cdktfVersion is not specified.");
        }
        function getDefaultConstructVersion() {
            const semverCDKTFVersion = semver.coerce(options.cdktfVersion);
            if (semverCDKTFVersion && semver.lte(semverCDKTFVersion, "0.5.0")) {
                return "^3.0.0";
            }
            return "^10.3.0";
        }
        const ver = options.cdktfVersion;
        const constructVersion = options.constructsVersion ?? getDefaultConstructVersion();
        this.addPeerDeps(`constructs@${constructVersion}`, `cdktf@${ver}`);
        this.addKeywords("cdktf");
    }
}
exports.ConstructLibraryCdktf = ConstructLibraryCdktf;
_a = JSII_RTTI_SYMBOL_1;
ConstructLibraryCdktf[_a] = { fqn: "projen.cdktf.ConstructLibraryCdktf", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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