"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerComposeService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const docker_compose_1 = require("./docker-compose");
/**
 * A docker-compose service.
 */
class DockerComposeService {
    constructor(serviceName, serviceDescription) {
        if ((!serviceDescription.imageBuild && !serviceDescription.image) ||
            (serviceDescription.imageBuild && serviceDescription.image)) {
            throw new Error(`A service ${serviceName} requires exactly one of a \`imageBuild\` or \`image\` key`);
        }
        this.serviceName = serviceName;
        this.command = serviceDescription.command;
        this.image = serviceDescription.image;
        this.imageBuild = serviceDescription.imageBuild;
        this.dependsOn = serviceDescription.dependsOn ?? [];
        this.volumes = serviceDescription.volumes ?? [];
        this.networks = serviceDescription.networks ?? [];
        this.ports = serviceDescription.ports ?? [];
        this.environment = serviceDescription.environment ?? {};
        this.labels = serviceDescription.labels ?? {};
        this.entrypoint = serviceDescription.entrypoint;
        this.platform = serviceDescription.platform;
    }
    /**
     * Add a port mapping
     * @param publishedPort Published port number
     * @param targetPort Container's port number
     * @param options Port mapping options
     */
    addPort(publishedPort, targetPort, options) {
        this.ports?.push(docker_compose_1.DockerCompose.portMapping(publishedPort, targetPort, options));
    }
    /**
     * Add an environment variable
     * @param name environment variable name
     * @param value value of the environment variable
     */
    addEnvironment(name, value) {
        this.environment[name] = value;
    }
    /**
     * Make the service depend on another service.
     * @param serviceName
     */
    addDependsOn(serviceName) {
        this.dependsOn.push(serviceName);
    }
    /**
     * Add a volume to the service.
     * @param volume
     */
    addVolume(volume) {
        this.volumes.push(volume);
    }
    /**
     * Add a network to the service.
     * @param network
     */
    addNetwork(network) {
        this.networks.push(network);
    }
    /**
     * Add a label
     * @param name environment variable name
     * @param value value of the environment variable
     */
    addLabel(name, value) {
        this.labels[name] = value;
    }
}
exports.DockerComposeService = DockerComposeService;
_a = JSII_RTTI_SYMBOL_1;
DockerComposeService[_a] = { fqn: "projen.DockerComposeService", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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