"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitAttributesFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("./file");
/**
 * Assign attributes to file names in a git repository.
 *
 * @see https://git-scm.com/docs/gitattributes
 */
class GitAttributesFile extends file_1.FileBase {
    constructor(scope) {
        super(scope, ".gitattributes", {
            editGitignore: false,
        });
        this.attributes = new Map();
    }
    /**
     * Maps a set of attributes to a set of files.
     * @param glob Glob pattern to match files in the repo
     * @param attributes Attributes to assign to these files.
     */
    addAttributes(glob, ...attributes) {
        if (!this.attributes.has(glob)) {
            this.attributes.set(glob, new Set());
        }
        const set = this.attributes.get(glob);
        for (const attribute of attributes) {
            set.add(attribute);
        }
    }
    /**
     * Add attributes necessary to mark these files as stored in LFS
     */
    addLfsPattern(glob) {
        this.addAttributes(glob, "filter=lfs", "diff=lfs", "merge=lfs", "-text");
    }
    /**
     * Whether the current gitattributes file has any LFS patterns
     */
    get hasLfsPatterns() {
        return Array.from(this.attributes.values()).some((attrs) => attrs.has("filter=lfs"));
    }
    preSynthesize() {
        this.project.addPackageIgnore("/.gitattributes");
        super.preSynthesize();
    }
    synthesizeContent(_) {
        // We can assume the file map is never empty.
        const entries = Array.from(this.attributes.entries()).sort(([l], [r]) => l.localeCompare(r));
        if (entries.length === 0) {
            return undefined;
        }
        return [
            ...(this.marker ? [`# ${this.marker}`] : []),
            "",
            ...entries.map(([name, attributes]) => `${name} ${Array.from(attributes).join(" ")}`),
        ].join("\n");
    }
}
exports.GitAttributesFile = GitAttributesFile;
_a = JSII_RTTI_SYMBOL_1;
GitAttributesFile[_a] = { fqn: "projen.GitAttributesFile", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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