"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHubActionsProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Manage the versions used for GitHub Actions used in steps
 */
class GitHubActionsProvider {
    constructor() {
        this.actions = new Map();
    }
    /**
     * Define an override for a given action.
     *
     * Specify the action name without a version to override all usages of the action.
     * You can also override a specific action version, by providing the version string.
     * Specific overrides take precedence over overrides without a version.
     *
     * If an override for the same action name is set multiple times, the last override is used.
     *
     * @example
     * // Force any use of `actions/checkout` to use a pin a specific commit
     * project.github.actions.set("actions/checkout", "actions/checkout@aaaaaa");
     *
     * // But pin usage of `v3` to a different commit
     * project.github.actions.set("actions/checkout@v3", "actions/checkout@ffffff");
     */
    set(action, override) {
        this.actions.set(action, override);
    }
    /**
     * Resolve an action name to the version that should be used,
     * taking into account any overrides.
     */
    get(action) {
        const parts = action.split("@", 1);
        // return this.actions.get(parts?.[0]) ?? this.actions.get(action) ?? action;
        return this.actions.get(action) ?? this.actions.get(parts[0]) ?? action;
    }
}
exports.GitHubActionsProvider = GitHubActionsProvider;
_a = JSII_RTTI_SYMBOL_1;
GitHubActionsProvider[_a] = { fqn: "projen.github.GitHubActionsProvider", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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