"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoApprove = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const workflows_model_1 = require("./workflows-model");
const component_1 = require("../component");
const runner_options_1 = require("../runner-options");
/**
 * Auto approve pull requests that meet a criteria
 */
class AutoApprove extends component_1.Component {
    constructor(github, options = {}) {
        super(github.project);
        this.label = options.label ?? "auto-approve";
        const usernames = options.allowedUsernames ?? ["github-actions[bot]"];
        let condition = `contains(github.event.pull_request.labels.*.name, '${this.label}')`;
        if (usernames.length > 0) {
            condition += " && (";
            condition += usernames
                .map((u) => `github.event.pull_request.user.login == '${u}'`)
                .join(" || ");
            condition += ")";
        }
        const secret = options.secret ?? "GITHUB_TOKEN";
        const approveJob = {
            ...(0, runner_options_1.filteredRunsOnOptions)(options.runsOn, options.runsOnGroup),
            permissions: {
                pullRequests: workflows_model_1.JobPermission.WRITE,
            },
            if: condition,
            steps: [
                {
                    uses: "hmarr/auto-approve-action@v2.2.1",
                    with: {
                        "github-token": `\${{ secrets.${secret} }}`,
                    },
                },
            ],
        };
        const workflow = github.addWorkflow("auto-approve");
        workflow.on({
            // The 'pull request' event gives the workflow 'read-only' permissions on some
            // pull requests (such as the ones from dependabot) when using the `GITHUB_TOKEN`
            // security token. This prevents the workflow from approving these pull requests.
            // Github has placed this guard so as to prevent security attacks by simply opening
            // a pull request and triggering a workflow on a commit that was not vetted to make
            // unintended changes to the repository.
            //
            // Instead use the 'pull request target' event here that gives the Github workflow
            // 'read-write' permissions. This is safe because, this event, unlike the 'pull request'
            // event references the BASE commit of the pull request and not the HEAD commit.
            pullRequestTarget: {
                types: [
                    "labeled",
                    "opened",
                    "synchronize",
                    "reopened",
                    "ready_for_review",
                ],
            },
        });
        workflow.addJobs({ approve: approveJob });
    }
}
exports.AutoApprove = AutoApprove;
_a = JSII_RTTI_SYMBOL_1;
AutoApprove[_a] = { fqn: "projen.github.AutoApprove", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXV0by1hcHByb3ZlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2dpdGh1Yi9hdXRvLWFwcHJvdmUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFDQSx1REFBdUQ7QUFDdkQsNENBQXlDO0FBQ3pDLHNEQUE4RTtBQWtEOUU7O0dBRUc7QUFDSCxNQUFhLFdBQVksU0FBUSxxQkFBUztJQUd4QyxZQUFZLE1BQWMsRUFBRSxVQUE4QixFQUFFO1FBQzFELEtBQUssQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUM7UUFFdEIsSUFBSSxDQUFDLEtBQUssR0FBRyxPQUFPLENBQUMsS0FBSyxJQUFJLGNBQWMsQ0FBQztRQUM3QyxNQUFNLFNBQVMsR0FBRyxPQUFPLENBQUMsZ0JBQWdCLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1FBRXRFLElBQUksU0FBUyxHQUFHLHNEQUFzRCxJQUFJLENBQUMsS0FBSyxJQUFJLENBQUM7UUFDckYsSUFBSSxTQUFTLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtZQUN4QixTQUFTLElBQUksT0FBTyxDQUFDO1lBQ3JCLFNBQVMsSUFBSSxTQUFTO2lCQUNuQixHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLDRDQUE0QyxDQUFDLEdBQUcsQ0FBQztpQkFDNUQsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1lBQ2hCLFNBQVMsSUFBSSxHQUFHLENBQUM7U0FDbEI7UUFFRCxNQUFNLE1BQU0sR0FBRyxPQUFPLENBQUMsTUFBTSxJQUFJLGNBQWMsQ0FBQztRQUVoRCxNQUFNLFVBQVUsR0FBUTtZQUN0QixHQUFHLElBQUEsc0NBQXFCLEVBQUMsT0FBTyxDQUFDLE1BQU0sRUFBRSxPQUFPLENBQUMsV0FBVyxDQUFDO1lBQzdELFdBQVcsRUFBRTtnQkFDWCxZQUFZLEVBQUUsK0JBQWEsQ0FBQyxLQUFLO2FBQ2xDO1lBQ0QsRUFBRSxFQUFFLFNBQVM7WUFDYixLQUFLLEVBQUU7Z0JBQ0w7b0JBQ0UsSUFBSSxFQUFFLGtDQUFrQztvQkFDeEMsSUFBSSxFQUFFO3dCQUNKLGNBQWMsRUFBRSxnQkFBZ0IsTUFBTSxLQUFLO3FCQUM1QztpQkFDRjthQUNGO1NBQ0YsQ0FBQztRQUVGLE1BQU0sUUFBUSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUMsY0FBYyxDQUFDLENBQUM7UUFDcEQsUUFBUSxDQUFDLEVBQUUsQ0FBQztZQUNWLDhFQUE4RTtZQUM5RSxpRkFBaUY7WUFDakYsaUZBQWlGO1lBQ2pGLG1GQUFtRjtZQUNuRixtRkFBbUY7WUFDbkYsd0NBQXdDO1lBQ3hDLEVBQUU7WUFDRixrRkFBa0Y7WUFDbEYsd0ZBQXdGO1lBQ3hGLGdGQUFnRjtZQUNoRixpQkFBaUIsRUFBRTtnQkFDakIsS0FBSyxFQUFFO29CQUNMLFNBQVM7b0JBQ1QsUUFBUTtvQkFDUixhQUFhO29CQUNiLFVBQVU7b0JBQ1Ysa0JBQWtCO2lCQUNuQjthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBQ0gsUUFBUSxDQUFDLE9BQU8sQ0FBQyxFQUFFLE9BQU8sRUFBRSxVQUFVLEVBQUUsQ0FBQyxDQUFDO0lBQzVDLENBQUM7O0FBM0RILGtDQTREQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEdpdEh1YiB9IGZyb20gXCIuL2dpdGh1YlwiO1xuaW1wb3J0IHsgSm9iLCBKb2JQZXJtaXNzaW9uIH0gZnJvbSBcIi4vd29ya2Zsb3dzLW1vZGVsXCI7XG5pbXBvcnQgeyBDb21wb25lbnQgfSBmcm9tIFwiLi4vY29tcG9uZW50XCI7XG5pbXBvcnQgeyBHcm91cFJ1bm5lck9wdGlvbnMsIGZpbHRlcmVkUnVuc09uT3B0aW9ucyB9IGZyb20gXCIuLi9ydW5uZXItb3B0aW9uc1wiO1xuXG4vKipcbiAqIE9wdGlvbnMgZm9yICdBdXRvQXBwcm92ZSdcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBBdXRvQXBwcm92ZU9wdGlvbnMge1xuICAvKipcbiAgICogT25seSBwdWxsIHJlcXVlc3RzIGF1dGhvcmVkIGJ5IHRoZXNlIEdpdGh1YiB1c2VybmFtZXMgd2lsbCBiZSBhdXRvLWFwcHJvdmVkLlxuICAgKiBAZGVmYXVsdCBbJ2dpdGh1Yi1ib3QnXVxuICAgKi9cbiAgcmVhZG9ubHkgYWxsb3dlZFVzZXJuYW1lcz86IHN0cmluZ1tdO1xuXG4gIC8qKlxuICAgKiBPbmx5IHB1bGwgcmVxdWVzdHMgd2l0aCB0aGlzIGxhYmVsIHdpbGwgYmUgYXV0by1hcHByb3ZlZC5cbiAgICogQGRlZmF1bHQgJ2F1dG8tYXBwcm92ZSdcbiAgICovXG4gIHJlYWRvbmx5IGxhYmVsPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBBIEdpdEh1YiBzZWNyZXQgbmFtZSB3aGljaCBjb250YWlucyBhIEdpdEh1YiBBY2Nlc3MgVG9rZW5cbiAgICogd2l0aCB3cml0ZSBwZXJtaXNzaW9ucyBmb3IgdGhlIGBwdWxsX3JlcXVlc3RgIHNjb3BlLlxuICAgKlxuICAgKiBUaGlzIHRva2VuIGlzIHVzZWQgdG8gYXBwcm92ZSBwdWxsIHJlcXVlc3RzLlxuICAgKlxuICAgKiBHaXRodWIgZm9yYmlkcyBhbiBpZGVudGl0eSB0byBhcHByb3ZlIGl0cyBvd24gcHVsbCByZXF1ZXN0LlxuICAgKiBJZiB5b3VyIHByb2plY3QgcHJvZHVjZXMgYXV0b21hdGVkIHB1bGwgcmVxdWVzdHMgdXNpbmcgdGhlIEdpdGh1YiBkZWZhdWx0IHRva2VuIC1cbiAgICoge0BsaW5rIGh0dHBzOi8vZG9jcy5naXRodWIuY29tL2VuL2FjdGlvbnMvcmVmZXJlbmNlL2F1dGhlbnRpY2F0aW9uLWluLWEtd29ya2Zsb3cgYEdJVEhVQl9UT0tFTmAgfVxuICAgKiAtIHRoYXQgeW91IHdvdWxkIGxpa2UgYXV0byBhcHByb3ZlZCwgc3VjaCBhcyB3aGVuIHVzaW5nIHRoZSBgZGVwc1VwZ3JhZGVgIHByb3BlcnR5IGluXG4gICAqIGBOb2RlUHJvamVjdE9wdGlvbnNgLCB0aGVuIHlvdSBtdXN0IHVzZSBhIGRpZmZlcmVudCB0b2tlbiBoZXJlLlxuICAgKlxuICAgKiBAZGVmYXVsdCBcIkdJVEhVQl9UT0tFTlwiXG4gICAqL1xuICByZWFkb25seSBzZWNyZXQ/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEdpdGh1YiBSdW5uZXIgc2VsZWN0aW9uIGxhYmVsc1xuICAgKiBAZGVmYXVsdCBbXCJ1YnVudHUtbGF0ZXN0XCJdXG4gICAqIEBkZXNjcmlwdGlvbiBEZWZpbmVzIGEgdGFyZ2V0IFJ1bm5lciBieSBsYWJlbHNcbiAgICogQHRocm93cyB7RXJyb3J9IGlmIGJvdGggYHJ1bnNPbmAgYW5kIGBydW5zT25Hcm91cGAgYXJlIHNwZWNpZmllZFxuICAgKi9cbiAgcmVhZG9ubHkgcnVuc09uPzogc3RyaW5nW107XG5cbiAgLyoqXG4gICAqIEdpdGh1YiBSdW5uZXIgR3JvdXAgc2VsZWN0aW9uIG9wdGlvbnNcbiAgICogQGRlc2NyaXB0aW9uIERlZmluZXMgYSB0YXJnZXQgUnVubmVyIEdyb3VwIGJ5IG5hbWUgYW5kL29yIGxhYmVsc1xuICAgKiBAdGhyb3dzIHtFcnJvcn0gaWYgYm90aCBgcnVuc09uYCBhbmQgYHJ1bnNPbkdyb3VwYCBhcmUgc3BlY2lmaWVkXG4gICAqL1xuICByZWFkb25seSBydW5zT25Hcm91cD86IEdyb3VwUnVubmVyT3B0aW9ucztcbn1cblxuLyoqXG4gKiBBdXRvIGFwcHJvdmUgcHVsbCByZXF1ZXN0cyB0aGF0IG1lZXQgYSBjcml0ZXJpYVxuICovXG5leHBvcnQgY2xhc3MgQXV0b0FwcHJvdmUgZXh0ZW5kcyBDb21wb25lbnQge1xuICBwdWJsaWMgcmVhZG9ubHkgbGFiZWw6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihnaXRodWI6IEdpdEh1Yiwgb3B0aW9uczogQXV0b0FwcHJvdmVPcHRpb25zID0ge30pIHtcbiAgICBzdXBlcihnaXRodWIucHJvamVjdCk7XG5cbiAgICB0aGlzLmxhYmVsID0gb3B0aW9ucy5sYWJlbCA/PyBcImF1dG8tYXBwcm92ZVwiO1xuICAgIGNvbnN0IHVzZXJuYW1lcyA9IG9wdGlvbnMuYWxsb3dlZFVzZXJuYW1lcyA/PyBbXCJnaXRodWItYWN0aW9uc1tib3RdXCJdO1xuXG4gICAgbGV0IGNvbmRpdGlvbiA9IGBjb250YWlucyhnaXRodWIuZXZlbnQucHVsbF9yZXF1ZXN0LmxhYmVscy4qLm5hbWUsICcke3RoaXMubGFiZWx9JylgO1xuICAgIGlmICh1c2VybmFtZXMubGVuZ3RoID4gMCkge1xuICAgICAgY29uZGl0aW9uICs9IFwiICYmIChcIjtcbiAgICAgIGNvbmRpdGlvbiArPSB1c2VybmFtZXNcbiAgICAgICAgLm1hcCgodSkgPT4gYGdpdGh1Yi5ldmVudC5wdWxsX3JlcXVlc3QudXNlci5sb2dpbiA9PSAnJHt1fSdgKVxuICAgICAgICAuam9pbihcIiB8fCBcIik7XG4gICAgICBjb25kaXRpb24gKz0gXCIpXCI7XG4gICAgfVxuXG4gICAgY29uc3Qgc2VjcmV0ID0gb3B0aW9ucy5zZWNyZXQgPz8gXCJHSVRIVUJfVE9LRU5cIjtcblxuICAgIGNvbnN0IGFwcHJvdmVKb2I6IEpvYiA9IHtcbiAgICAgIC4uLmZpbHRlcmVkUnVuc09uT3B0aW9ucyhvcHRpb25zLnJ1bnNPbiwgb3B0aW9ucy5ydW5zT25Hcm91cCksXG4gICAgICBwZXJtaXNzaW9uczoge1xuICAgICAgICBwdWxsUmVxdWVzdHM6IEpvYlBlcm1pc3Npb24uV1JJVEUsXG4gICAgICB9LFxuICAgICAgaWY6IGNvbmRpdGlvbixcbiAgICAgIHN0ZXBzOiBbXG4gICAgICAgIHtcbiAgICAgICAgICB1c2VzOiBcImhtYXJyL2F1dG8tYXBwcm92ZS1hY3Rpb25AdjIuMi4xXCIsXG4gICAgICAgICAgd2l0aDoge1xuICAgICAgICAgICAgXCJnaXRodWItdG9rZW5cIjogYFxcJHt7IHNlY3JldHMuJHtzZWNyZXR9IH19YCxcbiAgICAgICAgICB9LFxuICAgICAgICB9LFxuICAgICAgXSxcbiAgICB9O1xuXG4gICAgY29uc3Qgd29ya2Zsb3cgPSBnaXRodWIuYWRkV29ya2Zsb3coXCJhdXRvLWFwcHJvdmVcIik7XG4gICAgd29ya2Zsb3cub24oe1xuICAgICAgLy8gVGhlICdwdWxsIHJlcXVlc3QnIGV2ZW50IGdpdmVzIHRoZSB3b3JrZmxvdyAncmVhZC1vbmx5JyBwZXJtaXNzaW9ucyBvbiBzb21lXG4gICAgICAvLyBwdWxsIHJlcXVlc3RzIChzdWNoIGFzIHRoZSBvbmVzIGZyb20gZGVwZW5kYWJvdCkgd2hlbiB1c2luZyB0aGUgYEdJVEhVQl9UT0tFTmBcbiAgICAgIC8vIHNlY3VyaXR5IHRva2VuLiBUaGlzIHByZXZlbnRzIHRoZSB3b3JrZmxvdyBmcm9tIGFwcHJvdmluZyB0aGVzZSBwdWxsIHJlcXVlc3RzLlxuICAgICAgLy8gR2l0aHViIGhhcyBwbGFjZWQgdGhpcyBndWFyZCBzbyBhcyB0byBwcmV2ZW50IHNlY3VyaXR5IGF0dGFja3MgYnkgc2ltcGx5IG9wZW5pbmdcbiAgICAgIC8vIGEgcHVsbCByZXF1ZXN0IGFuZCB0cmlnZ2VyaW5nIGEgd29ya2Zsb3cgb24gYSBjb21taXQgdGhhdCB3YXMgbm90IHZldHRlZCB0byBtYWtlXG4gICAgICAvLyB1bmludGVuZGVkIGNoYW5nZXMgdG8gdGhlIHJlcG9zaXRvcnkuXG4gICAgICAvL1xuICAgICAgLy8gSW5zdGVhZCB1c2UgdGhlICdwdWxsIHJlcXVlc3QgdGFyZ2V0JyBldmVudCBoZXJlIHRoYXQgZ2l2ZXMgdGhlIEdpdGh1YiB3b3JrZmxvd1xuICAgICAgLy8gJ3JlYWQtd3JpdGUnIHBlcm1pc3Npb25zLiBUaGlzIGlzIHNhZmUgYmVjYXVzZSwgdGhpcyBldmVudCwgdW5saWtlIHRoZSAncHVsbCByZXF1ZXN0J1xuICAgICAgLy8gZXZlbnQgcmVmZXJlbmNlcyB0aGUgQkFTRSBjb21taXQgb2YgdGhlIHB1bGwgcmVxdWVzdCBhbmQgbm90IHRoZSBIRUFEIGNvbW1pdC5cbiAgICAgIHB1bGxSZXF1ZXN0VGFyZ2V0OiB7XG4gICAgICAgIHR5cGVzOiBbXG4gICAgICAgICAgXCJsYWJlbGVkXCIsXG4gICAgICAgICAgXCJvcGVuZWRcIixcbiAgICAgICAgICBcInN5bmNocm9uaXplXCIsXG4gICAgICAgICAgXCJyZW9wZW5lZFwiLFxuICAgICAgICAgIFwicmVhZHlfZm9yX3Jldmlld1wiLFxuICAgICAgICBdLFxuICAgICAgfSxcbiAgICB9KTtcbiAgICB3b3JrZmxvdy5hZGRKb2JzKHsgYXBwcm92ZTogYXBwcm92ZUpvYiB9KTtcbiAgfVxufVxuIl19