"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mergify = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const util_1 = require("../util");
const yaml_1 = require("../yaml");
class Mergify extends component_1.Component {
    constructor(github, options = {}) {
        super(github.project);
        this.rules = new Array();
        this.queues = new Array();
        for (const rule of options.rules ?? []) {
            this.addRule(rule);
        }
        for (const queue of options.queues ?? []) {
            this.addQueue(queue);
        }
    }
    createYamlFile() {
        if (this.yamlFile == null) {
            this.yamlFile = new yaml_1.YamlFile(this.project, ".mergify.yml", {
                obj: {
                    queue_rules: () => this.queues.map((q) => (0, util_1.snakeCaseKeys)(q, false)),
                    pull_request_rules: this.rules,
                },
                // Mergify needs to read the file from the repository in order to work.
                committed: true,
            });
        }
    }
    addRule(rule) {
        this.rules.push(rule);
        this.createYamlFile();
    }
    addQueue(queue) {
        this.queues.push(queue);
        this.createYamlFile();
    }
}
exports.Mergify = Mergify;
_a = JSII_RTTI_SYMBOL_1;
Mergify[_a] = { fqn: "projen.github.Mergify", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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