"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stale = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const stale_util_1 = require("./stale-util");
const workflows_model_1 = require("./workflows-model");
const component_1 = require("../component");
const runner_options_1 = require("../runner-options");
/**
 * Warns and then closes issues and PRs that have had no activity for a specified amount of time.
 *
 * The default configuration will:
 *
 *  * Add a "Stale" label to pull requests after 14 days and closed after 2 days
 *  * Add a "Stale" label to issues after 60 days and closed after 7 days
 *  * If a comment is added, the label will be removed and timer is restarted.
 *
 * @see https://github.com/actions/stale
 */
class Stale extends component_1.Component {
    constructor(github, options = {}) {
        super(github.project);
        const stale = github.addWorkflow("stale");
        stale.on({
            schedule: [{ cron: "0 1 * * *" }],
            workflowDispatch: {},
        });
        const pullRequests = (0, stale_util_1.renderBehavior)(options.pullRequest, {
            stale: 14,
            close: 2,
            type: "pull request",
        });
        const issues = (0, stale_util_1.renderBehavior)(options.issues, {
            stale: 60,
            close: 7,
            type: "issue",
        });
        const renderExemptLabels = (exemptLabels) => {
            if (!exemptLabels || exemptLabels.length === 0) {
                return undefined;
            }
            return exemptLabels.join(",");
        };
        stale.addJobs({
            stale: {
                ...(0, runner_options_1.filteredRunsOnOptions)(options.runsOn, options.runsOnGroup),
                permissions: {
                    issues: workflows_model_1.JobPermission.WRITE,
                    pullRequests: workflows_model_1.JobPermission.WRITE,
                },
                steps: [
                    {
                        uses: "actions/stale@v4",
                        with: {
                            // disable global
                            "days-before-stale": -1,
                            "days-before-close": -1,
                            // pull requests
                            "days-before-pr-stale": pullRequests.daysBeforeStale,
                            "days-before-pr-close": pullRequests.daysBeforeClose,
                            "stale-pr-message": pullRequests.staleMessage,
                            "close-pr-message": pullRequests.closeMessage,
                            "stale-pr-label": pullRequests.staleLabel,
                            "exempt-pr-labels": renderExemptLabels(pullRequests.exemptLabels),
                            // issues
                            "days-before-issue-stale": issues.daysBeforeStale,
                            "days-before-issue-close": issues.daysBeforeClose,
                            "stale-issue-message": issues.staleMessage,
                            "close-issue-message": issues.closeMessage,
                            "stale-issue-label": issues.staleLabel,
                            "exempt-issue-labels": renderExemptLabels(issues.exemptLabels),
                        },
                    },
                ],
            },
        });
    }
}
exports.Stale = Stale;
_a = JSII_RTTI_SYMBOL_1;
Stale[_a] = { fqn: "projen.github.Stale", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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