"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskWorkflowJob = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constants_1 = require("./constants");
const workflow_steps_1 = require("./workflow-steps");
const component_1 = require("../component");
const runner_options_1 = require("../runner-options");
/**
 * The primary or initial job of a TaskWorkflow.
 *
 * @implements {Job}
 */
class TaskWorkflowJob extends component_1.Component {
    /**
     * @param scope should be part of the project the Task belongs to.
     * @param task the main task that is run as part of this job.
     * @param options options to configure the TaskWorkflowJob.
     */
    constructor(scope, task, options) {
        super(scope, `${new.target.name}#${task.name}`);
        const preCheckoutSteps = options.preCheckoutSteps ?? [];
        const checkoutWith = {};
        if (options.downloadLfs) {
            checkoutWith.lfs = true;
        }
        // 'checkoutWith' can override 'lfs'
        Object.assign(checkoutWith, options.checkoutWith ?? {});
        const preBuildSteps = options.preBuildSteps ?? [];
        const postBuildSteps = options.postBuildSteps ?? [];
        const gitIdentity = options.gitIdentity ?? constants_1.DEFAULT_GITHUB_ACTIONS_USER;
        if (options.artifactsDirectory) {
            postBuildSteps.push(workflow_steps_1.WorkflowSteps.uploadArtifact({
                // Setting to always will ensure that this step will run even if
                // the previous ones have failed (e.g. coverage report, internal logs, etc)
                if: "always()",
                with: {
                    name: options.artifactsDirectory,
                    path: options.artifactsDirectory,
                },
            }));
        }
        const runsOnInputs = (0, runner_options_1.filteredRunsOnOptions)(options.runsOn, options.runsOnGroup);
        this.runsOn = runsOnInputs?.runsOn;
        this.runsOnGroup = runsOnInputs?.runsOnGroup;
        this.container = options.container;
        this.env = options.env;
        this.permissions = options.permissions;
        this.defaults = options?.jobDefaults;
        this.if = options.condition;
        this.outputs = options.outputs;
        this.steps = [
            ...preCheckoutSteps,
            // check out sources.
            workflow_steps_1.WorkflowSteps.checkout({ with: checkoutWith }),
            // sets git identity so we can push later
            workflow_steps_1.WorkflowSteps.setupGitIdentity({ gitIdentity }),
            ...preBuildSteps,
            // run the main build task
            {
                name: task.name,
                run: this.project.runTaskCommand(task),
            },
            ...postBuildSteps,
        ];
    }
    /**
     * @jsii ignore
     * @internal
     */
    toJSON() {
        return {
            runsOn: this.runsOn,
            runsOnGroup: this.runsOnGroup,
            steps: this.steps,
            environment: this.environment,
            outputs: this.outputs,
            env: this.env,
            defaults: this.defaults,
            timeoutMinutes: this.timeoutMinutes,
            continueOnError: this.continueOnError,
            container: this.container,
            services: this.services,
            tools: this.tools,
            name: this.name,
            needs: this.needs,
            permissions: this.permissions,
            concurrency: this.concurrency,
            if: this.if,
            strategy: this.strategy,
        };
    }
}
exports.TaskWorkflowJob = TaskWorkflowJob;
_a = JSII_RTTI_SYMBOL_1;
TaskWorkflowJob[_a] = { fqn: "projen.github.TaskWorkflowJob", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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