"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskWorkflow = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const task_workflow_job_1 = require("./task-workflow-job");
const workflows_1 = require("./workflows");
const DEFAULT_JOB_ID = "build";
/**
 * A GitHub workflow for common build tasks within a project.
 */
class TaskWorkflow extends workflows_1.GithubWorkflow {
    constructor(github, options) {
        super(github, options.name);
        this.jobId = options.jobId ?? DEFAULT_JOB_ID;
        this.artifactsDirectory = options.artifactsDirectory;
        if (options.triggers) {
            if (options.triggers.issueComment) {
                // https://docs.github.com/en/actions/learn-github-actions/security-hardening-for-github-actions#potential-impact-of-a-compromised-runner
                throw new Error('Trigger "issueComment" should not be used due to a security concern');
            }
            this.on(options.triggers);
        }
        this.on({
            workflowDispatch: {}, // allow manual triggering
        });
        const job = new task_workflow_job_1.TaskWorkflowJob(this, options.task, {
            ...options,
            downloadLfs: options.downloadLfs ?? github.downloadLfs,
        });
        this.addJobs({ [this.jobId]: job });
    }
}
exports.TaskWorkflow = TaskWorkflow;
_a = JSII_RTTI_SYMBOL_1;
TaskWorkflow[_a] = { fqn: "projen.github.TaskWorkflow", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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