"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkflowJobs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _1 = require(".");
const constants_1 = require("./constants");
const runner_options_1 = require("../runner-options");
/**
 * A set of utility functions for creating jobs in GitHub Workflows.
 */
class WorkflowJobs {
    /**
     * Creates a pull request with the changes of a patch file.
     *
     * @returns Job
     */
    static pullRequestFromPatch(options) {
        const jobName = options.jobName ?? "Create Pull Request";
        const gitIdentity = options.gitIdentity ?? constants_1.DEFAULT_GITHUB_ACTIONS_USER;
        const steps = [
            ...(options.credentials?.setupSteps || []),
            ..._1.WorkflowActions.checkoutWithPatch(options.patch),
            _1.WorkflowSteps.setupGitIdentity({ gitIdentity }),
            ..._1.WorkflowActions.createPullRequest({
                ...options,
                gitIdentity,
            }),
        ];
        return {
            name: jobName,
            if: `\${{ needs.${options.patch.jobId}.outputs.${options.patch.outputName} }}`,
            needs: [options.patch.jobId],
            permissions: {
                contents: _1.workflows.JobPermission.READ,
            },
            ...(0, runner_options_1.filteredRunsOnOptions)(options.runsOn, options.runsOnGroup),
            steps,
        };
    }
}
exports.WorkflowJobs = WorkflowJobs;
_a = JSII_RTTI_SYMBOL_1;
WorkflowJobs[_a] = { fqn: "projen.github.WorkflowJobs", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoid29ya2Zsb3ctam9icy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9naXRodWIvd29ya2Zsb3ctam9icy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHdCQU1XO0FBQ1gsMkNBQTBEO0FBRTFELHNEQUE4RTtBQUU5RTs7R0FFRztBQUNILE1BQWEsWUFBWTtJQUN2Qjs7OztPQUlHO0lBQ0ksTUFBTSxDQUFDLG9CQUFvQixDQUNoQyxPQUFvQztRQUVwQyxNQUFNLE9BQU8sR0FBRyxPQUFPLENBQUMsT0FBTyxJQUFJLHFCQUFxQixDQUFDO1FBQ3pELE1BQU0sV0FBVyxHQUFHLE9BQU8sQ0FBQyxXQUFXLElBQUksdUNBQTJCLENBQUM7UUFFdkUsTUFBTSxLQUFLLEdBQWM7WUFDdkIsR0FBRyxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUUsVUFBVSxJQUFJLEVBQUUsQ0FBQztZQUMxQyxHQUFHLGtCQUFlLENBQUMsaUJBQWlCLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQztZQUNuRCxnQkFBYSxDQUFDLGdCQUFnQixDQUFDLEVBQUUsV0FBVyxFQUFFLENBQUM7WUFDL0MsR0FBRyxrQkFBZSxDQUFDLGlCQUFpQixDQUFDO2dCQUNuQyxHQUFHLE9BQU87Z0JBQ1YsV0FBVzthQUNaLENBQUM7U0FDSCxDQUFDO1FBRUYsT0FBTztZQUNMLElBQUksRUFBRSxPQUFPO1lBQ2IsRUFBRSxFQUFFLGNBQWMsT0FBTyxDQUFDLEtBQUssQ0FBQyxLQUFLLFlBQVksT0FBTyxDQUFDLEtBQUssQ0FBQyxVQUFVLEtBQUs7WUFDOUUsS0FBSyxFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUM7WUFDNUIsV0FBVyxFQUFFO2dCQUNYLFFBQVEsRUFBRSxZQUFTLENBQUMsYUFBYSxDQUFDLElBQUk7YUFDdkM7WUFDRCxHQUFHLElBQUEsc0NBQXFCLEVBQUMsT0FBTyxDQUFDLE1BQU0sRUFBRSxPQUFPLENBQUMsV0FBVyxDQUFDO1lBQzdELEtBQUs7U0FDTixDQUFDO0lBQ0osQ0FBQzs7QUFoQ0gsb0NBaUNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcbiAgQ2hlY2tvdXRXaXRoUGF0Y2hPcHRpb25zLFxuICBDcmVhdGVQdWxsUmVxdWVzdE9wdGlvbnMsXG4gIFdvcmtmbG93QWN0aW9ucyxcbiAgV29ya2Zsb3dTdGVwcyxcbiAgd29ya2Zsb3dzLFxufSBmcm9tIFwiLlwiO1xuaW1wb3J0IHsgREVGQVVMVF9HSVRIVUJfQUNUSU9OU19VU0VSIH0gZnJvbSBcIi4vY29uc3RhbnRzXCI7XG5pbXBvcnQgeyBKb2IsIEpvYlN0ZXAgfSBmcm9tIFwiLi93b3JrZmxvd3MtbW9kZWxcIjtcbmltcG9ydCB7IEdyb3VwUnVubmVyT3B0aW9ucywgZmlsdGVyZWRSdW5zT25PcHRpb25zIH0gZnJvbSBcIi4uL3J1bm5lci1vcHRpb25zXCI7XG5cbi8qKlxuICogQSBzZXQgb2YgdXRpbGl0eSBmdW5jdGlvbnMgZm9yIGNyZWF0aW5nIGpvYnMgaW4gR2l0SHViIFdvcmtmbG93cy5cbiAqL1xuZXhwb3J0IGNsYXNzIFdvcmtmbG93Sm9icyB7XG4gIC8qKlxuICAgKiBDcmVhdGVzIGEgcHVsbCByZXF1ZXN0IHdpdGggdGhlIGNoYW5nZXMgb2YgYSBwYXRjaCBmaWxlLlxuICAgKlxuICAgKiBAcmV0dXJucyBKb2JcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcHVsbFJlcXVlc3RGcm9tUGF0Y2goXG4gICAgb3B0aW9uczogUHVsbFJlcXVlc3RGcm9tUGF0Y2hPcHRpb25zXG4gICk6IEpvYiB7XG4gICAgY29uc3Qgam9iTmFtZSA9IG9wdGlvbnMuam9iTmFtZSA/PyBcIkNyZWF0ZSBQdWxsIFJlcXVlc3RcIjtcbiAgICBjb25zdCBnaXRJZGVudGl0eSA9IG9wdGlvbnMuZ2l0SWRlbnRpdHkgPz8gREVGQVVMVF9HSVRIVUJfQUNUSU9OU19VU0VSO1xuXG4gICAgY29uc3Qgc3RlcHM6IEpvYlN0ZXBbXSA9IFtcbiAgICAgIC4uLihvcHRpb25zLmNyZWRlbnRpYWxzPy5zZXR1cFN0ZXBzIHx8IFtdKSxcbiAgICAgIC4uLldvcmtmbG93QWN0aW9ucy5jaGVja291dFdpdGhQYXRjaChvcHRpb25zLnBhdGNoKSxcbiAgICAgIFdvcmtmbG93U3RlcHMuc2V0dXBHaXRJZGVudGl0eSh7IGdpdElkZW50aXR5IH0pLFxuICAgICAgLi4uV29ya2Zsb3dBY3Rpb25zLmNyZWF0ZVB1bGxSZXF1ZXN0KHtcbiAgICAgICAgLi4ub3B0aW9ucyxcbiAgICAgICAgZ2l0SWRlbnRpdHksXG4gICAgICB9KSxcbiAgICBdO1xuXG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWU6IGpvYk5hbWUsXG4gICAgICBpZjogYFxcJHt7IG5lZWRzLiR7b3B0aW9ucy5wYXRjaC5qb2JJZH0ub3V0cHV0cy4ke29wdGlvbnMucGF0Y2gub3V0cHV0TmFtZX0gfX1gLFxuICAgICAgbmVlZHM6IFtvcHRpb25zLnBhdGNoLmpvYklkXSxcbiAgICAgIHBlcm1pc3Npb25zOiB7XG4gICAgICAgIGNvbnRlbnRzOiB3b3JrZmxvd3MuSm9iUGVybWlzc2lvbi5SRUFELFxuICAgICAgfSxcbiAgICAgIC4uLmZpbHRlcmVkUnVuc09uT3B0aW9ucyhvcHRpb25zLnJ1bnNPbiwgb3B0aW9ucy5ydW5zT25Hcm91cCksXG4gICAgICBzdGVwcyxcbiAgICB9O1xuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUHVsbFJlcXVlc3RQYXRjaFNvdXJjZSBleHRlbmRzIENoZWNrb3V0V2l0aFBhdGNoT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgaWQgb2YgdGhlIGpvYiB0aGF0IGNyZWF0ZWQgdGhlIHBhdGNoIGZpbGVcbiAgICovXG4gIHJlYWRvbmx5IGpvYklkOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBvdXRwdXQgdGhhdCBpbmRpY2F0ZXMgaWYgYSBwYXRjaCBoYXMgYmVlbiBjcmVhdGVkXG4gICAqL1xuICByZWFkb25seSBvdXRwdXROYW1lOiBzdHJpbmc7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUHVsbFJlcXVlc3RGcm9tUGF0Y2hPcHRpb25zIGV4dGVuZHMgQ3JlYXRlUHVsbFJlcXVlc3RPcHRpb25zIHtcbiAgLyoqXG4gICAqIEluZm9ybWF0aW9uIGFib3V0IHRoZSBwYXRjaCB0aGF0IGlzIHVzZWQgdG8gY3JlYXRlIHRoZSBwdWxsIHJlcXVlc3QuXG4gICAqL1xuICByZWFkb25seSBwYXRjaDogUHVsbFJlcXVlc3RQYXRjaFNvdXJjZTtcblxuICAvKipcbiAgICogVGhlIG5hbWUgb2YgdGhlIGpvYiBkaXNwbGF5ZWQgb24gR2l0SHViLlxuICAgKiBAZGVmYXVsdCBcIkNyZWF0ZSBQdWxsIFJlcXVlc3RcIlxuICAgKi9cbiAgcmVhZG9ubHkgam9iTmFtZT86IHN0cmluZztcblxuICAvKipcbiAgICogR2l0aHViIFJ1bm5lciBzZWxlY3Rpb24gbGFiZWxzXG4gICAqIEBkZWZhdWx0IFtcInVidW50dS1sYXRlc3RcIl1cbiAgICogQGRlc2NyaXB0aW9uIERlZmluZXMgYSB0YXJnZXQgUnVubmVyIGJ5IGxhYmVsc1xuICAgKiBAdGhyb3dzIHtFcnJvcn0gaWYgYm90aCBgcnVuc09uYCBhbmQgYHJ1bnNPbkdyb3VwYCBhcmUgc3BlY2lmaWVkXG4gICAqL1xuICByZWFkb25seSBydW5zT24/OiBzdHJpbmdbXTtcblxuICAvKipcbiAgICogR2l0aHViIFJ1bm5lciBHcm91cCBzZWxlY3Rpb24gb3B0aW9uc1xuICAgKiBAZGVzY3JpcHRpb24gRGVmaW5lcyBhIHRhcmdldCBSdW5uZXIgR3JvdXAgYnkgbmFtZSBhbmQvb3IgbGFiZWxzXG4gICAqIEB0aHJvd3Mge0Vycm9yfSBpZiBib3RoIGBydW5zT25gIGFuZCBgcnVuc09uR3JvdXBgIGFyZSBzcGVjaWZpZWRcbiAgICovXG4gIHJlYWRvbmx5IHJ1bnNPbkdyb3VwPzogR3JvdXBSdW5uZXJPcHRpb25zO1xufVxuIl19