"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IgnoreFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("./file");
const util_1 = require("./util");
class IgnoreFile extends file_1.FileBase {
    /**
     *
     * @param project The project to tie this file to.
     * @param filePath - the relative path in the project to put the file
     * @param minify - whether comments/blank lines should be filtered
     */
    constructor(project, filePath, options) {
        super(project, filePath, { editGitignore: filePath !== ".gitignore" });
        this.filterCommentLines = options?.filterCommentLines ?? true;
        this.filterEmptyLines = options?.filterEmptyLines ?? true;
        this._patterns = options?.ignorePatterns ?? [];
    }
    /**
     * Add ignore patterns. Files that match this pattern will be ignored. If the
     * pattern starts with a negation mark `!`, files that match will _not_ be
     * ignored.
     *
     * Comment lines (start with `#`) and blank lines ("") are filtered by default
     * but can be included using options specified when instantiating the component.
     *
     * @param patterns Ignore patterns.
     */
    addPatterns(...patterns) {
        for (const pattern of patterns) {
            const isComment = pattern.startsWith("#");
            const isEmptyLine = Boolean(pattern.trim().length === 0);
            if (isComment && this.filterCommentLines) {
                continue;
            }
            if (isEmptyLine && this.filterEmptyLines) {
                continue;
            }
            if (!isComment && !isEmptyLine) {
                this.normalizePatterns(pattern);
            }
            const normalizedPattern = (0, util_1.normalizePersistedPath)(pattern);
            this._patterns.push(normalizedPattern);
        }
    }
    normalizePatterns(pattern) {
        const opposite = pattern.startsWith("!") ? pattern.slice(1) : "!" + pattern;
        remove(this._patterns, pattern); // prevent duplicates
        remove(this._patterns, opposite);
        if (pattern.endsWith("/")) {
            const prefix = opposite;
            for (const p of [...this._patterns]) {
                if (p.startsWith(prefix)) {
                    remove(this._patterns, p);
                }
            }
        }
    }
    /**
     * Removes patterns previously added from the ignore file.
     *
     * If `addPattern()` is called after this, the pattern will be added again.
     *
     * @param patterns patters to remove.
     */
    removePatterns(...patterns) {
        for (const p of patterns) {
            remove(this._patterns, p);
        }
    }
    /**
     * Ignore the files that match these patterns.
     * @param patterns The patterns to match.
     */
    exclude(...patterns) {
        return this.addPatterns(...patterns);
    }
    /**
     * Always include the specified file patterns.
     * @param patterns Patterns to include in git commits.
     */
    include(...patterns) {
        for (let pattern of patterns) {
            if (!pattern.startsWith("!")) {
                pattern = "!" + pattern;
            }
            this.addPatterns(pattern);
        }
    }
    synthesizeContent(resolver) {
        const lines = [
            ...(this.marker ? [`# ${this.marker}`] : []),
            ...this._patterns,
        ];
        return `${resolver.resolve(lines).join("\n")}\n`;
    }
}
exports.IgnoreFile = IgnoreFile;
_a = JSII_RTTI_SYMBOL_1;
IgnoreFile[_a] = { fqn: "projen.IgnoreFile", version: "0.79.27" };
// O(n) hooray!
function remove(arr, value) {
    const idx = arr.indexOf(value);
    if (idx >= 0) {
        arr.splice(idx, 1);
    }
}
//# sourceMappingURL=data:application/json;base64,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