"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Jest = exports.JestReporter = exports.UpdateSnapshot = exports.WatchPlugin = exports.Transform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const semver = require("semver");
const component_1 = require("../component");
const javascript_1 = require("../javascript");
const json_1 = require("../json");
const util_1 = require("../util");
const DEFAULT_TEST_REPORTS_DIR = "test-reports";
class Transform {
    constructor(name, options) {
        this.name = name;
        this.options = options;
    }
    /**
     * @jsii ignore
     * @internal
     */
    toJSON() {
        if (this.options != null) {
            return [this.name, this.options];
        }
        return this.name;
    }
}
exports.Transform = Transform;
_a = JSII_RTTI_SYMBOL_1;
Transform[_a] = { fqn: "projen.javascript.Transform", version: "0.79.27" };
class WatchPlugin {
    constructor(name, options) {
        this.name = name;
        this.options = options;
    }
    /**
     * @jsii ignore
     * @internal
     */
    toJSON() {
        if (this.options != null) {
            return [this.name, this.options];
        }
        return this.name;
    }
}
exports.WatchPlugin = WatchPlugin;
_b = JSII_RTTI_SYMBOL_1;
WatchPlugin[_b] = { fqn: "projen.javascript.WatchPlugin", version: "0.79.27" };
var UpdateSnapshot;
(function (UpdateSnapshot) {
    /**
     * Always update snapshots in "test" task.
     */
    UpdateSnapshot["ALWAYS"] = "always";
    /**
     * Never update snapshots in "test" task and create a separate "test:update" task.
     */
    UpdateSnapshot["NEVER"] = "never";
})(UpdateSnapshot || (exports.UpdateSnapshot = UpdateSnapshot = {}));
class JestReporter {
    constructor(name, options) {
        this.name = name;
        this.options = options;
    }
    /**
     * @jsii ignore
     * @internal
     */
    toJSON() {
        if (this.options == null) {
            return this.name;
        }
        return [this.name, this.options];
    }
}
exports.JestReporter = JestReporter;
_c = JSII_RTTI_SYMBOL_1;
JestReporter[_c] = { fqn: "projen.javascript.JestReporter", version: "0.79.27" };
/**
 * Installs the following npm scripts:
 *
 * - `test`, intended for testing locally and in CI. Will update snapshots unless `updateSnapshot: UpdateSnapshot: NEVER` is set.
 * - `test:watch`, intended for automatically rerunning tests when files change.
 * - `test:update`, intended for testing locally and updating snapshots to match the latest unit under test. Only available when `updateSnapshot: UpdateSnapshot: NEVER`.
 *
 */
class Jest extends component_1.Component {
    /**
     * Returns the singleton Jest component of a project or undefined if there is none.
     */
    static of(project) {
        const isJest = (c) => c instanceof Jest;
        return project.components.find(isJest);
    }
    constructor(project, options = {}) {
        super(project);
        // hard deprecation
        if (options.typescriptConfig) {
            throw new Error('"jestOptions.typescriptConfig" is deprecated. Use "typescriptProject.tsconfigDev" instead');
        }
        // Jest snapshot files are generated files!
        project.root.annotateGenerated("*.snap");
        this.jestVersion = options.jestVersion ? `@${options.jestVersion}` : "";
        project.addDevDeps(`jest${this.jestVersion}`);
        this.jestConfig = {
            ...options.jestConfig,
            additionalOptions: undefined,
            ...options.jestConfig?.additionalOptions,
        };
        this.extraCliOptions = options.extraCliOptions ?? [];
        this.ignorePatterns = this.jestConfig?.testPathIgnorePatterns ??
            options.ignorePatterns ?? ["/node_modules/"];
        this.watchIgnorePatterns = this.jestConfig?.watchPathIgnorePatterns ?? [
            "/node_modules/",
        ];
        this.coverageReporters = this.jestConfig?.coverageReporters ?? [
            "json",
            "lcov",
            "clover",
            "cobertura",
        ];
        this.testMatch = this.jestConfig?.testMatch ?? [
            "**/__tests__/**/*.[jt]s?(x)",
            "**/?(*.)+(spec|test).[tj]s?(x)",
        ];
        const coverageDirectory = this.jestConfig?.coverageDirectory ?? "coverage";
        this.reporters = [];
        if (options.preserveDefaultReporters ?? true) {
            this.reporters.unshift(new JestReporter("default"));
        }
        this.config = {
            ...this.jestConfig,
            clearMocks: this.jestConfig?.clearMocks ?? true,
            collectCoverage: options.coverage ?? this.jestConfig?.collectCoverage ?? true,
            coverageReporters: this.coverageReporters,
            coverageDirectory: coverageDirectory,
            coveragePathIgnorePatterns: this.jestConfig?.coveragePathIgnorePatterns ?? this.ignorePatterns,
            testPathIgnorePatterns: this.ignorePatterns,
            watchPathIgnorePatterns: this.watchIgnorePatterns,
            testMatch: this.testMatch,
            reporters: this.reporters,
            snapshotResolver: (() => this._snapshotResolver),
        };
        if (options.junitReporting ?? true) {
            const reportsDir = DEFAULT_TEST_REPORTS_DIR;
            this.addReporter(new JestReporter("jest-junit", { outputDirectory: reportsDir }));
            project.addDevDeps("jest-junit@^15");
            project.gitignore.exclude("# jest-junit artifacts", `/${reportsDir}/`, "junit.xml");
            project.npmignore?.exclude("# jest-junit artifacts", `/${reportsDir}/`, "junit.xml");
        }
        if (this.jestConfig?.reporters) {
            for (const reporter of this.jestConfig.reporters) {
                this.addReporter(reporter);
            }
        }
        if (this.jestConfig?.coverageThreshold) {
            this.config.coverageThreshold = {
                global: this.jestConfig?.coverageThreshold,
            };
        }
        this.configureTestCommand(options.updateSnapshot ?? UpdateSnapshot.ALWAYS);
        if (options.configFilePath) {
            this.file = new json_1.JsonFile(project, options.configFilePath, {
                obj: this.config,
            });
            project.npmignore?.addPatterns(`/${this.file.path}`);
        }
        else {
            project.addFields({ jest: this.config });
        }
        const coverageDirectoryPath = path.posix.join("/", coverageDirectory, "/");
        project.npmignore?.exclude(coverageDirectoryPath);
        project.gitignore.exclude(coverageDirectoryPath);
        if (options.coverageText ?? true) {
            this.coverageReporters.push("text");
        }
    }
    /**
     * Adds a test match pattern.
     * @param pattern glob pattern to match for tests
     */
    addTestMatch(pattern) {
        this.testMatch.push(pattern);
    }
    /**
     * Adds a watch ignore pattern.
     * @param pattern The pattern (regular expression).
     */
    addWatchIgnorePattern(pattern) {
        this.watchIgnorePatterns.push(pattern);
    }
    addIgnorePattern(pattern) {
        this.ignorePatterns.push(pattern);
    }
    addReporter(reporter) {
        this.reporters.push(reporter);
    }
    /**
     * Adds a a setup file to Jest's setupFiles configuration.
     * @param file File path to setup file
     */
    addSetupFile(file) {
        if (!this.config.setupFiles) {
            this.config.setupFiles = [];
        }
        this.config.setupFiles.push(file);
    }
    /**
     * Adds a a setup file to Jest's setupFilesAfterEnv configuration.
     * @param file File path to setup file
     */
    addSetupFileAfterEnv(file) {
        if (!this.config.setupFilesAfterEnv) {
            this.config.setupFilesAfterEnv = [];
        }
        this.config.setupFilesAfterEnv.push(file);
    }
    addSnapshotResolver(file) {
        const normalized = (0, util_1.normalizePersistedPath)(file);
        this._snapshotResolver = normalized;
    }
    /**
     * Adds one or more moduleNameMapper entries to Jest's configuration.
     * Will overwrite if the same key is used as a pre-existing one.
     *
     * @param moduleNameMapperAdditions - A map from regular expressions to module names or to arrays of module names that allow to stub out resources, like images or styles with a single module.
     */
    addModuleNameMappers(moduleNameMapperAdditions) {
        const existingModuleNameMapper = this.config.moduleNameMapper ?? {};
        this.config.moduleNameMapper = {
            ...existingModuleNameMapper,
            ...moduleNameMapperAdditions,
        };
    }
    /**
     * Adds one or more modulePaths to Jest's configuration.
     *
     * @param modulePaths - An array of absolute paths to additional locations to search when resolving modules   *
     */
    addModulePaths(...modulePaths) {
        const existingModulePaths = this.config.modulePaths ?? [];
        this.config.modulePaths = [
            ...new Set([...existingModulePaths, ...modulePaths]),
        ];
    }
    /**
     * Adds one or more roots to Jest's configuration.
     *
     * @param roots - A list of paths to directories that Jest should use to search for files in.
     */
    addRoots(...roots) {
        const existingRoots = this.config.roots ?? [];
        this.config.roots = [...new Set([...existingRoots, ...roots])];
    }
    configureTestCommand(updateSnapshot) {
        const jestOpts = ["--passWithNoTests", ...this.extraCliOptions];
        const jestConfigOpts = this.file && this.file.path != "jest.config.json"
            ? ` -c ${this.file.path}`
            : "";
        // as recommended in the jest docs, node > 14 may use native v8 coverage collection
        // https://jestjs.io/docs/en/cli#--coverageproviderprovider
        if (this.project instanceof javascript_1.NodeProject &&
            this.project.package.minNodeVersion &&
            semver.gte(this.project.package.minNodeVersion, "14.0.0")) {
            jestOpts.push("--coverageProvider=v8");
        }
        if (updateSnapshot === UpdateSnapshot.ALWAYS) {
            jestOpts.push("--updateSnapshot");
        }
        else {
            jestOpts.push("--ci"); // to prevent accepting new snapshots
            const testUpdate = this.project.tasks.tryFind("test:update");
            if (!testUpdate) {
                this.project.addTask("test:update", {
                    description: "Update jest snapshots",
                    exec: `jest --updateSnapshot ${jestOpts.join(" ")}${jestConfigOpts}`,
                    receiveArgs: true,
                });
            }
        }
        this.project.testTask.exec(`jest ${jestOpts.join(" ")}${jestConfigOpts}`, {
            receiveArgs: true,
        });
        const testWatch = this.project.tasks.tryFind("test:watch");
        if (!testWatch) {
            this.project.addTask("test:watch", {
                description: "Run jest in watch mode",
                exec: `jest --watch${jestConfigOpts}`,
            });
        }
    }
}
exports.Jest = Jest;
_d = JSII_RTTI_SYMBOL_1;
Jest[_d] = { fqn: "projen.javascript.Jest", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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