"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LicenseChecker = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
/**
 * Enforces allowed licenses used by dependencies.
 */
class LicenseChecker extends component_1.Component {
    constructor(scope, options) {
        const taskName = options.taskName ?? "check-licenses";
        super(scope, `LicenseChecker#${taskName}`);
        const { production = true, development = false, allow: allowedLicenses = [], deny: prohibitedLicenses = [], } = options;
        if (!production && !development) {
            throw new Error("LicenseChecker: At least one of `production` or `development` must be enabled.");
        }
        if (!allowedLicenses.length && !prohibitedLicenses.length) {
            throw new Error("LicenseChecker: Neither `allow` nor `deny` found. Exactly one must be provided and not empty.");
        }
        if (allowedLicenses.length && prohibitedLicenses.length) {
            throw new Error("LicenseChecker: `allow` and `deny` can not be used at the same time. Choose one or the other.");
        }
        const cmd = ["license-checker", "--summary"];
        if (production && !development) {
            cmd.push("--production");
        }
        if (development && !production) {
            cmd.push("--development");
        }
        if (allowedLicenses.length) {
            cmd.push("--onlyAllow");
            cmd.push(`"${allowedLicenses.join(";")}"`);
        }
        if (prohibitedLicenses.length) {
            cmd.push("--failOn");
            cmd.push(`"${prohibitedLicenses.join(";")}"`);
        }
        this.project.deps.addDependency("license-checker", dependencies_1.DependencyType.BUILD);
        this.task = this.project.addTask(taskName, {
            exec: cmd.join(" "),
            receiveArgs: true,
        });
        this.project.preCompileTask.spawn(this.task);
    }
}
exports.LicenseChecker = LicenseChecker;
_a = JSII_RTTI_SYMBOL_1;
LicenseChecker[_a] = { fqn: "projen.javascript.LicenseChecker", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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