"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NpmConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const ini_1 = require("../ini");
/**
 * File representing the local NPM config in .npmrc
 */
class NpmConfig extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        /**
         * The config object. This object can be mutated until the project is
         * synthesized.
         */
        this.config = {};
        new ini_1.IniFile(project, ".npmrc", {
            obj: this.config,
            omitEmpty: options.omitEmpty,
        });
        if (options.registry) {
            this.addRegistry(options.registry);
        }
    }
    /**
     * configure a scoped registry
     *
     * @param url the URL of the registry to use
     * @param scope the scope the registry is used for; leave empty for the default registry
     */
    addRegistry(url, scope) {
        this.addConfig(scope ? `${scope}:registry` : "registry", url);
    }
    /**
     * configure a generic property
     *
     * @param name the name of the property
     * @param value the value of the property
     */
    addConfig(name, value) {
        this.config[name] = value;
    }
}
exports.NpmConfig = NpmConfig;
_a = JSII_RTTI_SYMBOL_1;
NpmConfig[_a] = { fqn: "projen.javascript.NpmConfig", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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