"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Yarnrc = exports.YarnWorkerPoolMode = exports.YarnWinLinkType = exports.YarnCacheMigrationMode = exports.YarnProgressBarStyle = exports.YarnPnpMode = exports.YarnPnpFallbackMode = exports.YarnNpmPublishAccess = exports.YarnNodeLinker = exports.YarnNmMode = exports.YarnNmHoistingLimit = exports.YarnLogFilterLevel = exports.YarnDefaultSemverRangePrefix = exports.YarnChecksumBehavior = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const semver = require("semver");
const component_1 = require("../component");
const yaml_1 = require("../yaml");
/** https://yarnpkg.com/configuration/yarnrc#checksumBehavior */
var YarnChecksumBehavior;
(function (YarnChecksumBehavior) {
    YarnChecksumBehavior["THROW"] = "throw";
    YarnChecksumBehavior["UPDATE"] = "update";
    YarnChecksumBehavior["RESET"] = "reset";
    YarnChecksumBehavior["IGNORE"] = "ignore";
})(YarnChecksumBehavior || (exports.YarnChecksumBehavior = YarnChecksumBehavior = {}));
/** https://yarnpkg.com/configuration/yarnrc#defaultSemverRangePrefix */
var YarnDefaultSemverRangePrefix;
(function (YarnDefaultSemverRangePrefix) {
    YarnDefaultSemverRangePrefix["CARET"] = "^";
    YarnDefaultSemverRangePrefix["TILDE"] = "~";
    YarnDefaultSemverRangePrefix["EMPTY_STRING"] = "";
})(YarnDefaultSemverRangePrefix || (exports.YarnDefaultSemverRangePrefix = YarnDefaultSemverRangePrefix = {}));
/** https://v3.yarnpkg.com/configuration/yarnrc#logFilters.0.level */
var YarnLogFilterLevel;
(function (YarnLogFilterLevel) {
    YarnLogFilterLevel["INFO"] = "info";
    YarnLogFilterLevel["WARNING"] = "warning";
    YarnLogFilterLevel["ERROR"] = "error";
    YarnLogFilterLevel["DISCARD"] = "discard";
})(YarnLogFilterLevel || (exports.YarnLogFilterLevel = YarnLogFilterLevel = {}));
/** https://yarnpkg.com/configuration/yarnrc#nmHoistingLimits */
var YarnNmHoistingLimit;
(function (YarnNmHoistingLimit) {
    YarnNmHoistingLimit["DEPENDENCIES"] = "dependencies";
    YarnNmHoistingLimit["NONE"] = "none";
    YarnNmHoistingLimit["WORKSPACES"] = "workspaces";
})(YarnNmHoistingLimit || (exports.YarnNmHoistingLimit = YarnNmHoistingLimit = {}));
/** https://yarnpkg.com/configuration/yarnrc#nmMode */
var YarnNmMode;
(function (YarnNmMode) {
    YarnNmMode["CLASSIC"] = "classic";
    YarnNmMode["HARDLINKS_LOCAL"] = "hardlinks-local";
    YarnNmMode["HARDLINKS_GLOBAL"] = "hardlinks-global";
})(YarnNmMode || (exports.YarnNmMode = YarnNmMode = {}));
/** https://yarnpkg.com/configuration/yarnrc#nodeLinker */
var YarnNodeLinker;
(function (YarnNodeLinker) {
    YarnNodeLinker["PNP"] = "pnp";
    YarnNodeLinker["PNPM"] = "pnpm";
    YarnNodeLinker["NODE_MODULES"] = "node-modules";
})(YarnNodeLinker || (exports.YarnNodeLinker = YarnNodeLinker = {}));
/** https://yarnpkg.com/configuration/yarnrc#npmPublishAccess */
var YarnNpmPublishAccess;
(function (YarnNpmPublishAccess) {
    YarnNpmPublishAccess["PUBLIC"] = "public";
    YarnNpmPublishAccess["RESTRICTED"] = "restricted";
})(YarnNpmPublishAccess || (exports.YarnNpmPublishAccess = YarnNpmPublishAccess = {}));
/** https://yarnpkg.com/configuration/yarnrc#pnpFallbackMode */
var YarnPnpFallbackMode;
(function (YarnPnpFallbackMode) {
    YarnPnpFallbackMode["NONE"] = "none";
    YarnPnpFallbackMode["DEPENDENCIES_ONLY"] = "dependencies-only";
    YarnPnpFallbackMode["ALL"] = "all";
})(YarnPnpFallbackMode || (exports.YarnPnpFallbackMode = YarnPnpFallbackMode = {}));
/** https://yarnpkg.com/configuration/yarnrc#pnpMode */
var YarnPnpMode;
(function (YarnPnpMode) {
    YarnPnpMode["STRICT"] = "strict";
    YarnPnpMode["LOOSE"] = "loose";
})(YarnPnpMode || (exports.YarnPnpMode = YarnPnpMode = {}));
/** https://yarnpkg.com/configuration/yarnrc#progressBarStyle */
var YarnProgressBarStyle;
(function (YarnProgressBarStyle) {
    YarnProgressBarStyle["PATRICK"] = "patrick";
    YarnProgressBarStyle["SIMBA"] = "simba";
    YarnProgressBarStyle["JACK"] = "jack";
    YarnProgressBarStyle["HOGSFATHER"] = "hogsfather";
    YarnProgressBarStyle["DEFAULT"] = "default";
})(YarnProgressBarStyle || (exports.YarnProgressBarStyle = YarnProgressBarStyle = {}));
/** https://yarnpkg.com/configuration/yarnrc#cacheMigrationMode */
var YarnCacheMigrationMode;
(function (YarnCacheMigrationMode) {
    YarnCacheMigrationMode["REQUIRED_ONLY"] = "requied-only";
    YarnCacheMigrationMode["MATCH_SPEC"] = "match-spec";
    YarnCacheMigrationMode["ALWAYS"] = "always";
})(YarnCacheMigrationMode || (exports.YarnCacheMigrationMode = YarnCacheMigrationMode = {}));
/** https://yarnpkg.com/configuration/yarnrc#winLinkType */
var YarnWinLinkType;
(function (YarnWinLinkType) {
    YarnWinLinkType["JUNCTIONS"] = "junctions";
    YarnWinLinkType["SYMLINKS"] = "symlinks";
})(YarnWinLinkType || (exports.YarnWinLinkType = YarnWinLinkType = {}));
var YarnWorkerPoolMode;
(function (YarnWorkerPoolMode) {
    YarnWorkerPoolMode["ASYNC"] = "async";
    YarnWorkerPoolMode["WORKERS"] = "workers";
})(YarnWorkerPoolMode || (exports.YarnWorkerPoolMode = YarnWorkerPoolMode = {}));
class Yarnrc extends component_1.Component {
    constructor(project, version, options = {}) {
        super(project);
        this.validateOptionsForVersion(semver.major(version), options);
        this.updateGitAttributes();
        new yaml_1.YamlFile(project, ".yarnrc.yml", {
            obj: options,
        });
    }
    updateGitAttributes() {
        const { project } = this;
        project.gitattributes.addAttributes("/.yarn/**", "linguist-vendored");
        project.gitattributes.addAttributes("/.yarn/releases/*", "binary");
        project.gitattributes.addAttributes("/.yarn/plugins/**/*", "binary");
        project.gitattributes.addAttributes("/.pnp.*", "binary", "linguist-vendored");
    }
    validateOptionsForVersion(majorVersion, options) {
        const removedInV4 = [
            "ignoreCwd",
            "lockfileFilename",
            "pnpDataPath",
            "preferAggregateCacheInfo",
        ];
        const newInV4 = [
            "cacheMigrationMode",
            "httpsCaFilePath",
            "enableConstraintsCheck",
            "enableHardenedMode",
            "enableInlineHunks",
            "enableOfflineMode",
            "injectEnvironmentFiles",
            "winLinkType",
            "preferReuse",
            "taskPoolConcurrency",
            "workerPoolMode",
            "tsEnableAutoTypes",
        ];
        if (majorVersion >= 4) {
            const invalidOptions = Object.keys(options).filter((option) => removedInV4.includes(option));
            if (invalidOptions.length > 0) {
                throw new Error(`The following options are not available in Yarn >= 4: ${invalidOptions.join(", ")}`);
            }
        }
        else {
            const invalidOptions = Object.keys(options).filter((option) => newInV4.includes(option));
            if (invalidOptions.length > 0) {
                throw new Error(`The following options are only available in Yarn v4 and newer: ${invalidOptions.join(", ")}`);
            }
            if (options.checksumBehavior &&
                options.checksumBehavior === YarnChecksumBehavior.RESET) {
                throw new Error("The YarnChecksumBehavior.RESET is only available in Yarn v4 and newer.");
            }
        }
    }
}
exports.Yarnrc = Yarnrc;
_a = JSII_RTTI_SYMBOL_1;
Yarnrc[_a] = { fqn: "projen.javascript.Yarnrc", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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