"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const object_file_1 = require("./object-file");
/**
 * Represents a JSON file.
 */
class JsonFile extends object_file_1.ObjectFile {
    constructor(scope, filePath, options) {
        super(scope, filePath, options);
        this.newline = options.newline ?? true;
        this.supportsComments =
            options.allowComments ??
                (filePath.toLowerCase().endsWith("json5") ||
                    filePath.toLowerCase().endsWith("jsonc"));
        if (!options.obj) {
            throw new Error('"obj" cannot be undefined');
        }
    }
    synthesizeContent(resolver) {
        const json = super.synthesizeContent(resolver);
        if (!json) {
            return undefined;
        }
        const sanitized = JSON.parse(json);
        if (this.marker && !this.supportsComments) {
            sanitized["//"] = this.marker;
        }
        let content = JSON.stringify(sanitized, undefined, 2);
        if (this.marker && this.supportsComments) {
            content = `// ${this.marker}\n${content}`;
        }
        if (this.newline) {
            content += "\n";
        }
        return content;
    }
}
exports.JsonFile = JsonFile;
_a = JSII_RTTI_SYMBOL_1;
JsonFile[_a] = { fqn: "projen.JsonFile", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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