"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isEnabled = exports.disable = exports.empty = exports.warn = exports.error = exports.info = exports.verbose = exports.debug = exports.ICON = void 0;
const chalk = require("chalk");
const common_1 = require("./common");
exports.ICON = "👾"; //'✨';
// disable logs if running inside a test
let enabled = common_1.IS_TEST_RUN ? false : true;
function log(isError, color, ...text) {
    // errors are always emitted, even if logs are disabled
    if (!enabled && !isError) {
        return;
    }
    console.error(`${exports.ICON} ${color(...text)}`);
}
function debug(...text) {
    if (process.env.DEBUG) {
        log(false, chalk.gray, ...text);
    }
}
exports.debug = debug;
function verbose(...text) {
    log(false, chalk.white, ...text);
}
exports.verbose = verbose;
function info(...text) {
    log(false, chalk.cyan, ...text);
}
exports.info = info;
function error(...text) {
    log(true, chalk.red, ...text);
}
exports.error = error;
function warn(...text) {
    log(false, chalk.yellow, ...text);
}
exports.warn = warn;
function empty(count = 1) {
    console.log("\n".repeat(count - 1));
}
exports.empty = empty;
function disable() {
    enabled = false;
}
exports.disable = disable;
function isEnabled() {
    return enabled;
}
exports.isEnabled = isEnabled;
//# sourceMappingURL=data:application/json;base64,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