"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectTree = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const json_1 = require("./json");
class ProjectTree extends component_1.Component {
    constructor(project) {
        super(project, new.target.name);
        this.file = new json_1.JsonFile(project, ".projen/tree.json", {
            readonly: true,
            marker: false,
            obj: () => ({
                ["//"]: "Experimental. Expect frequent changes to the structure of this file.",
                ...renderConstruct(project),
            }),
        });
    }
}
exports.ProjectTree = ProjectTree;
_a = JSII_RTTI_SYMBOL_1;
ProjectTree[_a] = { fqn: "projen.ProjectTree", version: "0.79.27" };
function renderConstruct(construct) {
    return {
        [construct.node.id]: {
            metadata: Object.fromEntries(construct.node.metadata.map(({ type, data }) => [type, data])),
            nodes: construct.node.children.length
                ? construct.node.children.reduce((nodes, c) => ({
                    ...nodes,
                    ...renderConstruct(c),
                }), {})
                : undefined,
        },
    };
}
//# sourceMappingURL=data:application/json;base64,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