"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = exports.ProjenrcJson = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const projenrc_1 = require("./projenrc");
/**
 * Sets up a project to use JSON for projenrc.
 */
class ProjenrcJson extends projenrc_1.ProjenrcFile {
    constructor(project, options = {}) {
        super(project);
        this.filePath = options.filename ?? ".projenrc.json";
        // this is the task projen executes when running `projen`
        project.defaultTask?.env("FILENAME", this.filePath);
        project.defaultTask?.builtin("run-projenrc-json");
        this.generateProjenrc();
    }
    generateProjenrc() {
        const rcfile = (0, path_1.resolve)(this.project.outdir, this.filePath);
        if ((0, fs_1.existsSync)(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.initProject;
        if (!bootstrap) {
            return;
        }
        const json = {
            type: bootstrap.fqn,
            ...bootstrap.args,
        };
        (0, fs_1.mkdirSync)((0, path_1.dirname)(rcfile), { recursive: true });
        (0, fs_1.writeFileSync)(rcfile, JSON.stringify(json, null, 2));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.ProjenrcJson = ProjenrcJson;
_a = JSII_RTTI_SYMBOL_1;
ProjenrcJson[_a] = { fqn: "projen.ProjenrcJson", version: "0.79.27" };
/**
 * @deprecated use `ProjenrcJson`
 */
class Projenrc extends ProjenrcJson {
}
exports.Projenrc = Projenrc;
_b = JSII_RTTI_SYMBOL_1;
Projenrc[_b] = { fqn: "projen.Projenrc", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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