"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pip = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const requirements_file_1 = require("./requirements-file");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
const task_runtime_1 = require("../task-runtime");
/**
 * Manages dependencies using a requirements.txt file and the pip CLI tool.
 */
class Pip extends component_1.Component {
    constructor(project, _options = {}) {
        super(project);
        new requirements_file_1.RequirementsFile(project, "requirements.txt", {
            packageProvider: new RuntimeDependencyProvider(project),
        });
        new requirements_file_1.RequirementsFile(project, "requirements-dev.txt", {
            packageProvider: new DevDependencyProvider(project),
        });
        this.installCiTask = project.addTask("install", {
            description: "Install and upgrade dependencies",
        });
        this.installCiTask.exec("pip install --upgrade pip");
        this.installCiTask.exec("pip install -r requirements.txt");
        this.installCiTask.exec("pip install -r requirements-dev.txt");
    }
    /**
     * Adds a runtime dependency.
     *
     * @param spec Format `<module>@<semver>`
     */
    addDependency(spec) {
        this.project.deps.addDependency(spec, dependencies_1.DependencyType.RUNTIME);
    }
    /**
     * Adds a dev dependency.
     *
     * @param spec Format `<module>@<semver>`
     */
    addDevDependency(spec) {
        this.project.deps.addDependency(spec, dependencies_1.DependencyType.DEVENV);
    }
    /**
     * Installs dependencies (called during post-synthesis).
     */
    installDependencies() {
        this.project.logger.info("Installing dependencies...");
        const runtime = new task_runtime_1.TaskRuntime(this.project.outdir);
        runtime.runTask(this.installCiTask.name);
    }
}
exports.Pip = Pip;
_a = JSII_RTTI_SYMBOL_1;
Pip[_a] = { fqn: "projen.python.Pip", version: "0.79.27" };
class RuntimeDependencyProvider {
    constructor(project) {
        this.project = project;
    }
    get packages() {
        return this.project.deps.all.filter((dep) => dep.type === dependencies_1.DependencyType.RUNTIME);
    }
}
class DevDependencyProvider {
    constructor(project) {
        this.project = project;
    }
    get packages() {
        return this.project.deps.all.filter((dep) => [dependencies_1.DependencyType.TEST, dependencies_1.DependencyType.DEVENV].includes(dep.type));
    }
}
//# sourceMappingURL=data:application/json;base64,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