import { ProjenrcOptions as ProjenrcPythonOptions } from "./projenrc";
import { Pytest, PytestOptions } from "./pytest";
import { IPythonDeps } from "./python-deps";
import { IPythonEnv } from "./python-env";
import { IPythonPackaging, PythonPackagingOptions } from "./python-packaging";
import { VenvOptions } from "./venv";
import { GitHubProject, GitHubProjectOptions } from "../github";
import { ProjenrcOptions as ProjenrcJsOptions } from "../javascript/projenrc";
import { ProjenrcTsOptions } from "../typescript";
export interface PythonExecutableOptions {
    /**
     * Path to the python executable to use.
     * @default "python"
     */
    readonly pythonExec?: string;
}
/**
 * Options for `PythonProject`.
 */
export interface PythonProjectOptions extends GitHubProjectOptions, PythonPackagingOptions, PythonExecutableOptions {
    /**
     * Name of the python package as used in imports and filenames.
     *
     * Must only consist of alphanumeric characters and underscores.
     *
     * @default $PYTHON_MODULE_NAME
     */
    readonly moduleName: string;
    /**
     * List of runtime dependencies for this project.
     *
     * Dependencies use the format: `<module>@<semver>`
     *
     * Additional dependencies can be added via `project.addDependency()`.
     *
     * @default []
     * @featured
     */
    readonly deps?: string[];
    /**
     * List of dev dependencies for this project.
     *
     * Dependencies use the format: `<module>@<semver>`
     *
     * Additional dependencies can be added via `project.addDevDependency()`.
     *
     * @default []
     * @featured
     */
    readonly devDeps?: string[];
    /**
     * Use pip with a requirements.txt file to track project dependencies.
     *
     * @default - true, unless poetry is true, then false
     * @featured
     */
    readonly pip?: boolean;
    /**
     * Use venv to manage a virtual environment for installing dependencies inside.
     *
     * @default - true, unless poetry is true, then false
     * @featured
     */
    readonly venv?: boolean;
    /**
     * Venv options
     * @default - defaults
     */
    readonly venvOptions?: VenvOptions;
    /**
     * Use setuptools with a setup.py script for packaging and publishing.
     *
     * @default - true, unless poetry is true, then false
     * @featured
     */
    readonly setuptools?: boolean;
    /**
     * Use poetry to manage your project dependencies, virtual environment, and
     * (optional) packaging/publishing.
     *
     * This feature is incompatible with pip, setuptools, or venv.
     * If you set this option to `true`, then pip, setuptools, and venv must be set to `false`.
     *
     * @default false
     * @featured
     */
    readonly poetry?: boolean;
    /**
     * Include pytest tests.
     * @default true
     * @featured
     */
    readonly pytest?: boolean;
    /**
     * pytest options
     * @default - defaults
     */
    readonly pytestOptions?: PytestOptions;
    /**
     * Include sample code and test if the relevant directories don't exist.
     * @default true
     */
    readonly sample?: boolean;
    /**
     * Use projenrc in Python.
     *
     * This will install `projen` as a Python dependency and add a `synth`
     * task which will run `.projenrc.py`.
     *
     * @default true
     */
    readonly projenrcPython?: boolean;
    /**
     * Options related to projenrc in python.
     * @default - default options
     */
    readonly projenrcPythonOptions?: ProjenrcPythonOptions;
    /**
     * Use projenrc in javascript.
     *
     * This will install `projen` as a JavaScript dependency and add a `synth`
     * task which will run `.projenrc.js`.
     *
     * @default false
     */
    readonly projenrcJs?: boolean;
    /**
     * Options related to projenrc in JavaScript.
     * @default - default options
     */
    readonly projenrcJsOptions?: ProjenrcJsOptions;
    /**
     * Use projenrc in TypeScript.
     *
     * This will create a tsconfig file (default: `tsconfig.projen.json`)
     * and use `ts-node` in the default task to parse the project source files.
     *
     * @default false
     */
    readonly projenrcTs?: boolean;
    /**
     * Options related to projenrc in TypeScript.
     * @default - default options
     */
    readonly projenrcTsOptions?: ProjenrcTsOptions;
}
/**
 * Python project.
 *
 * @pjid python
 */
export declare class PythonProject extends GitHubProject {
    /**
     * Python module name (the project name, with any hyphens or periods replaced
     * with underscores).
     */
    readonly moduleName: string;
    /**
     * Version of the package for distribution (should follow semver).
     */
    readonly version: string;
    /**
     * API for managing dependencies.
     */
    readonly depsManager: IPythonDeps;
    /**
     * API for mangaging the Python runtime environment.
     */
    readonly envManager: IPythonEnv;
    /**
     * API for managing packaging the project as a library. Only applies when the `projectType` is LIB.
     */
    readonly packagingManager?: IPythonPackaging;
    /**
     * Pytest component.
     */
    pytest?: Pytest;
    constructor(options: PythonProjectOptions);
    /**
     * Adds default gitignore options for a Python project based on
     * https://github.com/github/gitignore/blob/master/Python.gitignore
     */
    private addDefaultGitIgnore;
    /**
     * Adds a runtime dependency.
     *
     * @param spec Format `<module>@<semver>`
     */
    addDependency(spec: string): void;
    /**
     * Adds a dev dependency.
     *
     * @param spec Format `<module>@<semver>`
     */
    addDevDependency(spec: string): void;
    postSynthesize(): void;
}
