"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonSample = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const sample_file_1 = require("../sample-file");
/**
 * Python code sample.
 */
class PythonSample extends component_1.Component {
    constructor(project, options) {
        super(project);
        new sample_file_1.SampleDir(project, options.dir, {
            files: {
                "__init__.py": '__version__ = "0.1.0"\n',
                "__main__.py": [
                    "from .example import hello",
                    "",
                    'if __name__ == "__main__":',
                    '    name = input("What is your name? ")',
                    "    print(hello(name))",
                    "",
                ].join("\n"),
                "example.py": [
                    "def hello(name: str) -> str:",
                    '    """A simple greeting.',
                    "    Args:",
                    "        name (str): Name to greet.",
                    "    Returns:",
                    "        str: greeting message",
                    '    """',
                    '    return f"Hello {name}!"',
                    "",
                ].join("\n"),
            },
        });
    }
}
exports.PythonSample = PythonSample;
_a = JSII_RTTI_SYMBOL_1;
PythonSample[_a] = { fqn: "projen.python.PythonSample", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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