"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupPy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("../file");
/**
 * Python packaging script where package metadata can be placed.
 */
class SetupPy extends file_1.FileBase {
    constructor(project, options) {
        super(project, "setup.py");
        this.setupConfig = {
            name: project.name,
            packages: options.packages,
            python_requires: ">=3.8",
            classifiers: [
                "Intended Audience :: Developers",
                "Programming Language :: Python :: 3 :: Only",
                "Programming Language :: Python :: 3.8",
                "Programming Language :: Python :: 3.9",
                "Programming Language :: Python :: 3.10",
                "Programming Language :: Python :: 3.11",
                "Programming Language :: Python :: 3.12",
            ],
            ...(options ? this.renameFields(options) : []),
        };
    }
    synthesizeContent(resolver) {
        const lines = [
            ...(this.marker ? [`# ${this.marker}`] : []),
            "",
            "import json",
            "from setuptools import setup",
            "",
            "kwargs = json.loads(",
            '    """',
            JSON.stringify(this.setupConfig, null, 4),
            '"""',
            ")",
            "",
            "setup(**kwargs)",
        ];
        return `${resolver.resolve(lines).join("\n")}\n`;
    }
    // modify some key names since JSII interfaces require fields to be camelCase
    renameFields(options) {
        const obj = {};
        for (const [key, value] of Object.entries(options)) {
            switch (key) {
                case "authorName":
                    obj.author = value;
                    break;
                case "authorEmail":
                    obj.author_email = value;
                    break;
                case "homepage":
                    obj.url = value;
                    break;
                case "additionalOptions":
                    Object.assign(obj, this.renameFields(value));
                    break;
                default:
                    obj[key] = value;
            }
        }
        return obj;
    }
}
exports.SetupPy = SetupPy;
_a = JSII_RTTI_SYMBOL_1;
SetupPy[_a] = { fqn: "projen.python.SetupPy", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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