"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Venv = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const component_1 = require("../component");
const util_1 = require("../util");
/**
 * Manages a virtual environment through the Python venv module.
 */
class Venv extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        this.envdir = options.envdir ?? ".env";
        this.pythonExec = options.pythonExec ?? "python";
        this.project.addGitIgnore(`/${this.envdir}`);
        this.project.tasks.addEnvironment("VIRTUAL_ENV", `$(echo $PWD/${this.envdir})`);
        this.project.tasks.addEnvironment("PATH", `$(echo $PWD/${this.envdir}/bin:$PATH)`);
    }
    /**
     * Initializes the virtual environment if it doesn't exist (called during post-synthesis).
     */
    setupEnvironment() {
        const absoluteEnvdir = path.join(this.project.outdir, this.envdir);
        if (!fs.existsSync(absoluteEnvdir)) {
            this.project.logger.info("Setting up a virtual environment...");
            (0, util_1.exec)(`${this.pythonExec} -m venv ${this.envdir}`, {
                cwd: this.project.outdir,
            });
            this.project.logger.info(`Environment successfully created (located in ./${this.envdir}).`);
        }
    }
}
exports.Venv = Venv;
_a = JSII_RTTI_SYMBOL_1;
Venv[_a] = { fqn: "projen.python.Venv", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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