"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReleaseTrigger = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Used to manage release strategies. This includes release
 * and release artifact automation
 */
class ReleaseTrigger {
    /**
     * Creates a manual release trigger.
     *
     * Use this option if you want totally manual releases.
     *
     * This will give you a release task that, in addition to the normal
     * release activities will trigger a `publish:git` task. This task will
     * handle project-level changelog management, release tagging, and pushing
     * these artifacts to origin.
     *
     * The command used for pushing can be customised by specifying
     * `gitPushCommand`. Set to an empty string to disable pushing entirely.
     *
     * Simply run `yarn release` to trigger a manual release.
     *
     * @param options release options
     */
    static manual(options = {}) {
        let changelogPath;
        if (options.changelog ?? true) {
            changelogPath = options.changelogPath ?? "CHANGELOG.md";
        }
        return new ReleaseTrigger({
            changelogPath: changelogPath,
            gitPushCommand: options.gitPushCommand,
        });
    }
    /**
     * Creates a scheduled release trigger.
     *
     * Automated releases will occur based on the provided cron schedule.
     *
     * @param options release options.
     */
    static scheduled(options) {
        return new ReleaseTrigger({
            schedule: options.schedule,
        });
    }
    /**
     * Creates a continuous release trigger.
     *
     * Automated releases will occur on every commit.
     */
    static continuous() {
        return new ReleaseTrigger({
            continuous: true,
        });
    }
    constructor(options = {}) {
        this.isContinuous = options.continuous ?? false;
        this.schedule = options.schedule;
        this.changelogPath = options.changelogPath;
        this.gitPushCommand = options.gitPushCommand;
    }
    /**
     * Whether or not this is a manual release trigger.
     */
    get isManual() {
        return !(this.isContinuous || this.schedule);
    }
}
exports.ReleaseTrigger = ReleaseTrigger;
_a = JSII_RTTI_SYMBOL_1;
ReleaseTrigger[_a] = { fqn: "projen.release.ReleaseTrigger", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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