"use strict";
// a builtin task that sets the "version" field of the file
// specified in OUTFILE to "0.0.0"
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const outfile = process.env.OUTFILE;
if (!outfile) {
    throw new Error("OUTFILE is required");
}
if (!(0, fs_1.existsSync)(outfile)) {
    process.exit(0); // nothing to do
}
const content = JSON.parse((0, fs_1.readFileSync)(outfile, "utf8"));
content.version = "0.0.0";
(0, fs_1.writeFileSync)(outfile, JSON.stringify(content, undefined, 2) + "\n");
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVzZXQtdmVyc2lvbi50YXNrLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3JlbGVhc2UvcmVzZXQtdmVyc2lvbi50YXNrLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSwyREFBMkQ7QUFDM0Qsa0NBQWtDOztBQUVsQywyQkFBNkQ7QUFFN0QsTUFBTSxPQUFPLEdBQUcsT0FBTyxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUM7QUFDcEMsSUFBSSxDQUFDLE9BQU8sRUFBRTtJQUNaLE1BQU0sSUFBSSxLQUFLLENBQUMscUJBQXFCLENBQUMsQ0FBQztDQUN4QztBQUVELElBQUksQ0FBQyxJQUFBLGVBQVUsRUFBQyxPQUFPLENBQUMsRUFBRTtJQUN4QixPQUFPLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsZ0JBQWdCO0NBQ2xDO0FBRUQsTUFBTSxPQUFPLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFBLGlCQUFZLEVBQUMsT0FBTyxFQUFFLE1BQU0sQ0FBQyxDQUFDLENBQUM7QUFDMUQsT0FBTyxDQUFDLE9BQU8sR0FBRyxPQUFPLENBQUM7QUFDMUIsSUFBQSxrQkFBYSxFQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sRUFBRSxTQUFTLEVBQUUsQ0FBQyxDQUFDLEdBQUcsSUFBSSxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBhIGJ1aWx0aW4gdGFzayB0aGF0IHNldHMgdGhlIFwidmVyc2lvblwiIGZpZWxkIG9mIHRoZSBmaWxlXG4vLyBzcGVjaWZpZWQgaW4gT1VURklMRSB0byBcIjAuMC4wXCJcblxuaW1wb3J0IHsgZXhpc3RzU3luYywgcmVhZEZpbGVTeW5jLCB3cml0ZUZpbGVTeW5jIH0gZnJvbSBcImZzXCI7XG5cbmNvbnN0IG91dGZpbGUgPSBwcm9jZXNzLmVudi5PVVRGSUxFO1xuaWYgKCFvdXRmaWxlKSB7XG4gIHRocm93IG5ldyBFcnJvcihcIk9VVEZJTEUgaXMgcmVxdWlyZWRcIik7XG59XG5cbmlmICghZXhpc3RzU3luYyhvdXRmaWxlKSkge1xuICBwcm9jZXNzLmV4aXQoMCk7IC8vIG5vdGhpbmcgdG8gZG9cbn1cblxuY29uc3QgY29udGVudCA9IEpTT04ucGFyc2UocmVhZEZpbGVTeW5jKG91dGZpbGUsIFwidXRmOFwiKSk7XG5jb250ZW50LnZlcnNpb24gPSBcIjAuMC4wXCI7XG53cml0ZUZpbGVTeW5jKG91dGZpbGUsIEpTT04uc3RyaW5naWZ5KGNvbnRlbnQsIHVuZGVmaW5lZCwgMikgKyBcIlxcblwiKTtcbiJdfQ==