"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Generate an annotated release tag using version and changelog files.
 *
 * The tag from the release tag from the release tag file will be used as is.
 *
 * The tag annotation message will be set to the content of the provided changelog
 * file.
 *
 * Environment variables:
 *
 * - RELEASE_TAG_FILE: Release Tag file containing the bumped release tag
 * - CHANGELOG_FILE: Changelog to be used for tag annotation
 *
 */
const tag_version_1 = require("./tag-version");
const changelog = process.env.CHANGELOG;
const releaseTagFile = process.env.RELEASE_TAG_FILE;
if (!releaseTagFile) {
    throw new Error("RELEASE_TAG_FILE is required");
}
if (!changelog) {
    throw new Error("CHANGELOG is required");
}
const opts = {
    changelog,
    releaseTagFile: releaseTagFile,
};
(0, tag_version_1.tag)(process.cwd(), opts).catch((e) => {
    console.log(e.stack);
    process.exit(1);
});
//# sourceMappingURL=data:application/json;base64,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