"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Renovatebot = exports.RenovatebotScheduleInterval = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const dependencies_1 = require("./dependencies");
const json_1 = require("./json");
/**
 * How often to check for new versions and raise pull requests for version
 * updates.
 *
 * @see https://docs.renovatebot.com/presets-schedule/
 */
var RenovatebotScheduleInterval;
(function (RenovatebotScheduleInterval) {
    /**
     * Run at any time
     */
    RenovatebotScheduleInterval["ANY_TIME"] = "at any time";
    /**
     * Weekly schedule on early monday mornings
     */
    RenovatebotScheduleInterval["EARLY_MONDAYS"] = "before 3am on Monday";
    /**
     * Schedule daily
     */
    RenovatebotScheduleInterval["DAILY"] = "before 2am";
    /**
     * Schedule weekly
     */
    RenovatebotScheduleInterval["WEEKLY"] = "before 3am on Monday";
    /**
     * Schedule monthly
     */
    RenovatebotScheduleInterval["MONTHLY"] = "before 3am on the first day of the month";
    /**
     * Schedule quarterly
     */
    RenovatebotScheduleInterval["QUARTERLY"] = "every 3 months on the first day of the month";
    /**
     * Schedule for weekends
     */
    RenovatebotScheduleInterval["WEEKENDS"] = "every weekend";
    /**
     * Schedule for weekdays
     */
    RenovatebotScheduleInterval["WEEKDAYS"] = "every weekday";
})(RenovatebotScheduleInterval || (exports.RenovatebotScheduleInterval = RenovatebotScheduleInterval = {}));
/**
 * Defines renovatebot configuration for projen project.
 *
 * Ignores the versions controlled by Projen.
 */
class Renovatebot extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        this._project = project;
        this.explicitIgnores = options.ignore ?? [];
        this.labels = options.labels;
        this.scheduleInterval = options.scheduleInterval ?? [
            RenovatebotScheduleInterval.ANY_TIME,
        ];
        (options.ignoreProjen ?? true) && this.explicitIgnores.push("projen");
        this.overrideConfig = options.overrideConfig ?? {};
        this.marker = options.marker ?? true;
        this.file = new json_1.JsonFile(this._project, "renovate.json5", {
            obj: () => this.createRenovateConfiguration(),
            committed: true,
            marker: this.marker,
        });
    }
    createRenovateConfiguration() {
        const renovateIgnore = [
            ...new Set(this._project.deps.all
                .filter((dep) => dep.version || dep.type === dependencies_1.DependencyType.OVERRIDE)
                .map((dep) => dep.name)
                .concat(this.explicitIgnores)),
        ];
        return {
            labels: this.labels,
            schedule: this.scheduleInterval,
            extends: [
                ":preserveSemverRanges",
                "config:recommended",
                "group:allNonMajor",
                "group:recommended",
                "group:monorepos",
            ],
            packageRules: [
                {
                    matchDepTypes: ["devDependencies"],
                    matchUpdateTypes: ["patch", "minor"],
                    groupName: "devDependencies (non-major)",
                },
            ],
            ignoreDeps: renovateIgnore,
            ...this.overrideConfig,
        };
    }
}
exports.Renovatebot = Renovatebot;
_a = JSII_RTTI_SYMBOL_1;
Renovatebot[_a] = { fqn: "projen.Renovatebot", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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