"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.filteredWorkflowRunsOnOptions = exports.filteredRunsOnOptions = void 0;
function filteredRunsOnOptions(runsOn, runsOnGroup) {
    verifyJobConstraints(runsOn, runsOnGroup);
    return runsOnGroup
        ? { runsOnGroup: runsOnGroup }
        : runsOn
            ? { runsOn: runsOn }
            : { runsOn: ["ubuntu-latest"] };
}
exports.filteredRunsOnOptions = filteredRunsOnOptions;
function filteredWorkflowRunsOnOptions(workflowRunsOn, workflowRunsOnGroup) {
    verifyJobConstraints(workflowRunsOn, workflowRunsOnGroup);
    return workflowRunsOnGroup
        ? { workflowRunsOnGroup: workflowRunsOnGroup }
        : workflowRunsOn
            ? { workflowRunsOn: workflowRunsOn }
            : { workflowRunsOn: ["ubuntu-latest"] };
}
exports.filteredWorkflowRunsOnOptions = filteredWorkflowRunsOnOptions;
function verifyJobConstraints(runsOn, runsOnGroup) {
    if (runsOn && runsOnGroup) {
        throw new Error("Cannot specify both `workflowRunsOn` and `runsOn`");
    }
}
//# sourceMappingURL=data:application/json;base64,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