"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjenrcTs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const javascript_1 = require("../javascript");
const render_options_1 = require("../javascript/render-options");
const projenrc_1 = require("../projenrc");
const DEFAULT_FILENAME = ".projenrc.ts";
/**
 * A projenrc file written in TypeScript
 *
 * This component can be instantiated in any type of project
 * and has no expectations around the project's main language.
 *
 * Requires that `npx` is available.
 */
class ProjenrcTs extends projenrc_1.ProjenrcFile {
    constructor(project, options = {}) {
        super(project);
        this.filePath = options.filename ?? DEFAULT_FILENAME;
        this._projenCodeDir = options.projenCodeDir ?? "projenrc";
        project.addPackageIgnore(`/${this.filePath}`);
        // Create a dedicated tsconfig for projen source files
        this.tsconfig = new javascript_1.TypescriptConfig(project, {
            fileName: options.tsconfigFileName ?? "tsconfig.projen.json",
            compilerOptions: {},
        });
        // Use npx since project's deps manager is not guaranteed to be JS-based
        project.defaultTask?.exec(`npx -y ts-node --project ${this.tsconfig.fileName} ${this.filePath}`);
        this.generateProjenrc();
    }
    preSynthesize() {
        super.preSynthesize();
        this.tsconfig.addInclude(this.filePath);
        this.tsconfig.addInclude(`${this._projenCodeDir}/**/*.ts`);
    }
    generateProjenrc() {
        const rcfile = (0, path_1.resolve)(this.project.outdir, this.filePath);
        if ((0, fs_1.existsSync)(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.initProject;
        if (!bootstrap) {
            return;
        }
        const parts = bootstrap.fqn.split(".");
        const moduleName = parts[0];
        const importName = parts[1];
        const className = parts.slice(1).join(".");
        const { renderedOptions, imports } = (0, render_options_1.renderJavaScriptOptions)({
            args: bootstrap.args,
            type: bootstrap.type,
            comments: bootstrap.comments,
        });
        imports.add(moduleName, importName);
        const lines = new Array();
        lines.push(...imports.asEsmImports());
        lines.push();
        lines.push(`const project = new ${className}(${renderedOptions});`);
        lines.push();
        lines.push("project.synth();");
        (0, fs_1.writeFileSync)(rcfile, lines.join("\n"));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.ProjenrcTs = ProjenrcTs;
_a = JSII_RTTI_SYMBOL_1;
ProjenrcTs[_a] = { fqn: "projen.typescript.ProjenrcTs", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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