"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const render_options_1 = require("../javascript/render-options");
const projenrc_1 = require("../projenrc");
const DEFAULT_FILENAME = ".projenrc.ts";
/**
 * Sets up a typescript project to use TypeScript for projenrc.
 */
class Projenrc extends projenrc_1.ProjenrcFile {
    constructor(project, options = {}) {
        super(project);
        this._tsProject = project;
        this.filePath = options.filename ?? DEFAULT_FILENAME;
        this._projenCodeDir = options.projenCodeDir ?? "projenrc";
        this._swc = options.swc ?? false;
        this.addDefaultTask();
        this.generateProjenrc();
    }
    addDefaultTask() {
        const deps = ["ts-node"];
        if (this._swc) {
            deps.push("@swc/core");
        }
        // this is the task projen executes when running `projen` without a
        // specific task (if this task is not defined, projen falls back to
        // running "node .projenrc.js").
        this._tsProject.addDevDeps(...deps);
        const tsNode = this._swc ? "ts-node --swc" : "ts-node";
        // we use "tsconfig.dev.json" here to allow projen source files to reside
        // anywhere in the project tree.
        this._tsProject.defaultTask?.exec(`${tsNode} --project ${this._tsProject.tsconfigDev.fileName} ${this.filePath}`);
    }
    preSynthesize() {
        super.preSynthesize();
        this._tsProject.addPackageIgnore(`/${this.filePath}`);
        this._tsProject.tsconfigDev.addInclude(this.filePath);
        this._tsProject.tsconfigDev.addInclude(`${this._projenCodeDir}/**/*.ts`);
        this._tsProject.eslint?.addLintPattern(this._projenCodeDir);
        this._tsProject.eslint?.addLintPattern(this.filePath);
        this._tsProject.eslint?.allowDevDeps(this.filePath);
        this._tsProject.eslint?.allowDevDeps(`${this._projenCodeDir}/**/*.ts`);
        this._tsProject.eslint?.addIgnorePattern(`!${this.filePath}`);
        this._tsProject.eslint?.addIgnorePattern(`!${this._projenCodeDir}/**/*.ts`);
        this._tsProject.eslint?.addOverride({
            files: [this.filePath],
            rules: {
                "@typescript-eslint/no-require-imports": "off",
                "import/no-extraneous-dependencies": "off",
            },
        });
    }
    generateProjenrc() {
        const rcfile = (0, path_1.resolve)(this.project.outdir, this.filePath);
        if ((0, fs_1.existsSync)(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.initProject;
        if (!bootstrap) {
            return;
        }
        const parts = bootstrap.fqn.split(".");
        const moduleName = parts[0];
        const importName = parts[1];
        const className = parts.slice(1).join(".");
        const { renderedOptions, imports } = (0, render_options_1.renderJavaScriptOptions)({
            args: bootstrap.args,
            type: bootstrap.type,
            comments: bootstrap.comments,
        });
        imports.add(moduleName, importName);
        const lines = new Array();
        lines.push(...imports.asEsmImports());
        lines.push();
        lines.push(`const project = new ${className}(${renderedOptions});`);
        lines.push();
        lines.push("project.synth();");
        (0, fs_1.mkdirSync)((0, path_1.dirname)(rcfile), { recursive: true });
        (0, fs_1.writeFileSync)(rcfile, lines.join("\n"));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.typescript.Projenrc", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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