"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeTsconfigOptions = exports.TypeScriptLibraryProject = exports.TypeScriptAppProject = exports.TypeScriptProject = exports.TsJestTsconfig = exports.TsJestDiagnostics = exports.TsJestBabelConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const semver = require("semver");
const common_1 = require("../common");
const component_1 = require("../component");
const javascript_1 = require("../javascript");
const util_1 = require("../javascript/util");
const sample_file_1 = require("../sample-file");
const textfile_1 = require("../textfile");
const typescript_1 = require("../typescript");
const util_2 = require("../util");
/**
 * @see https://kulshekhar.github.io/ts-jest/docs/getting-started/options/babelConfig/
 */
class TsJestBabelConfig {
    /**
     * Disables the use of Babel
     */
    static disabled() {
        return new TsJestBabelConfig(false);
    }
    /**
     * Enables Babel processing
     *
     * `ts-jest` will try to find an existing Babel configuration and pass it to the `babel-jest` processor.
     */
    static autoDetectConfig() {
        return new TsJestBabelConfig(true);
    }
    /**
     * Path to a babelrc file
     *
     * The path should be relative to the current working directory where you start Jest from. You can also use `<rootDir>` in the path.
     */
    static fromFile(filePath) {
        return new TsJestBabelConfig(filePath);
    }
    /**
     * Inline compiler options
     * @see https://babeljs.io/docs/options
     */
    static custom(config) {
        return new TsJestBabelConfig(config);
    }
    constructor(config) {
        this.config = config;
    }
    /**
     * @jsii ignore
     * @internal
     */
    toJSON() {
        return this.config;
    }
}
exports.TsJestBabelConfig = TsJestBabelConfig;
_a = JSII_RTTI_SYMBOL_1;
TsJestBabelConfig[_a] = { fqn: "projen.typescript.TsJestBabelConfig", version: "0.79.27" };
/**
 * @see https://kulshekhar.github.io/ts-jest/docs/getting-started/options/diagnostics/
 */
class TsJestDiagnostics {
    /**
     * Enable all diagnostics.
     */
    static all() {
        return new TsJestDiagnostics(true);
    }
    /**
     * Disable all diagnostics.
     */
    static none() {
        return new TsJestDiagnostics(false);
    }
    /**
     * Provide a custom diagnostics configuration.
     *
     * @see https://kulshekhar.github.io/ts-jest/docs/getting-started/options/diagnostics/
     */
    static custom(config) {
        return new TsJestDiagnostics(config);
    }
    constructor(config) {
        this.config = config;
    }
    /**
     * @jsii ignore
     * @internal
     */
    toJSON() {
        return this.config;
    }
}
exports.TsJestDiagnostics = TsJestDiagnostics;
_b = JSII_RTTI_SYMBOL_1;
TsJestDiagnostics[_b] = { fqn: "projen.typescript.TsJestDiagnostics", version: "0.79.27" };
/**
 * @see https://kulshekhar.github.io/ts-jest/docs/getting-started/options/tsconfig/
 */
class TsJestTsconfig {
    /**
     * Uses `tsconfig.json` if found, or the built-in default TypeScript compiler options.
     */
    static auto() {
        return new TsJestTsconfig(true);
    }
    /**
     * Force` ts-jest` to use its built-in defaults even if there is a `tsconfig.json` in your project.
     */
    static builtInDefaults() {
        return new TsJestTsconfig(false);
    }
    /**
     * Path to a `tsconfig` file
     *
     * The path should be relative to the current working directory where you start Jest from. You can also use `<rootDir>` in the path to start from the project root dir.
     */
    static fromFile(filePath) {
        return new TsJestTsconfig(filePath);
    }
    /**
     * Inline compiler options
     *
     * @see TypescriptConfigOptions
     */
    static custom(config) {
        return new TsJestTsconfig(config);
    }
    constructor(config) {
        this.config = config;
    }
    /**
     * @jsii ignore
     * @internal
     */
    toJSON() {
        return this.config;
    }
}
exports.TsJestTsconfig = TsJestTsconfig;
_c = JSII_RTTI_SYMBOL_1;
TsJestTsconfig[_c] = { fqn: "projen.typescript.TsJestTsconfig", version: "0.79.27" };
/**
 * TypeScript project
 * @pjid typescript
 */
class TypeScriptProject extends javascript_1.NodeProject {
    constructor(options) {
        super({
            ...options,
            // disable .projenrc.js if typescript is enabled
            projenrcJs: options.projenrcTs ? false : options.projenrcJs,
            jestOptions: {
                ...options.jestOptions,
                jestConfig: {
                    ...options.jestOptions?.jestConfig,
                    testMatch: options.jestOptions?.jestConfig?.testMatch ?? [],
                },
            },
        });
        this.srcdir = options.srcdir ?? "src";
        this.libdir = options.libdir ?? "lib";
        this.docgen = options.docgen;
        this.docsDirectory = options.docsDirectory ?? "docs/";
        const tsconfigFilename = options.tsconfig?.fileName;
        this.compileTask.exec(["tsc", "--build", tsconfigFilename].filter(Boolean).join(" "));
        this.watchTask = this.addTask("watch", {
            description: "Watch & compile in the background",
            exec: ["tsc", "--build", "-w", tsconfigFilename]
                .filter(Boolean)
                .join(" "),
        });
        this.testdir = options.testdir ?? "test";
        this.gitignore.include(`/${this.testdir}/`);
        this.npmignore?.exclude(`/${this.testdir}/`);
        // if the test directory is under `src/`, then we will run our tests against
        // the javascript files and not let jest compile it for us.
        const compiledTests = this.testdir.startsWith(this.srcdir + path.posix.sep);
        if (options.entrypointTypes || this.entrypoint !== "") {
            const entrypointPath = path.join(path.dirname(this.entrypoint), path.basename(this.entrypoint, ".js"));
            const normalizedPath = (0, util_2.normalizePersistedPath)(entrypointPath);
            const entrypointTypes = options.entrypointTypes ?? `${normalizedPath}.d.ts`;
            this.package.addField("types", entrypointTypes);
        }
        const compilerOptionDefaults = {
            alwaysStrict: true,
            declaration: true,
            esModuleInterop: true,
            experimentalDecorators: true,
            inlineSourceMap: true,
            inlineSources: true,
            lib: ["es2019"],
            module: "CommonJS",
            noEmitOnError: false,
            noFallthroughCasesInSwitch: true,
            noImplicitAny: true,
            noImplicitReturns: true,
            noImplicitThis: true,
            noUnusedLocals: true,
            noUnusedParameters: true,
            resolveJsonModule: true,
            strict: true,
            strictNullChecks: true,
            strictPropertyInitialization: true,
            stripInternal: true,
            target: "ES2019",
        };
        if (options.disableTsconfigDev && options.disableTsconfig) {
            throw new Error("Cannot specify both 'disableTsconfigDev' and 'disableTsconfig' fields.");
        }
        if (!options.disableTsconfig) {
            this.tsconfig = new javascript_1.TypescriptConfig(this, mergeTsconfigOptions({
                include: [`${this.srcdir}/**/*.ts`],
                // exclude: ['node_modules'], // TODO: shouldn't we exclude node_modules?
                compilerOptions: {
                    rootDir: this.srcdir,
                    outDir: this.libdir,
                    ...compilerOptionDefaults,
                },
            }, options.tsconfig));
        }
        if (options.disableTsconfigDev) {
            this.tsconfigDev = this.tsconfig;
        }
        else {
            const tsconfigDevFile = options.tsconfigDevFile ?? "tsconfig.dev.json";
            this.tsconfigDev = new javascript_1.TypescriptConfig(this, mergeTsconfigOptions({
                fileName: tsconfigDevFile,
                include: [`${this.srcdir}/**/*.ts`, `${this.testdir}/**/*.ts`],
                exclude: ["node_modules"],
                compilerOptions: compilerOptionDefaults,
            }, options.tsconfig, options.tsconfigDev));
        }
        this.gitignore.include(`/${this.srcdir}/`);
        this.npmignore?.exclude(`/${this.srcdir}/`);
        if (this.srcdir !== this.libdir) {
            // separated, can ignore the entire libdir
            this.gitignore.exclude(`/${this.libdir}`);
        }
        else {
            // collocated, can only ignore the compiled output
            this.gitignore.exclude(`/${this.libdir}/**/*.js`);
            this.gitignore.exclude(`/${this.libdir}/**/*.d.ts`);
            this.gitignore.exclude(`/${this.libdir}/**/*.d.ts.map`);
        }
        this.npmignore?.include(`/${this.libdir}/`);
        this.npmignore?.include(`/${this.libdir}/**/*.js`);
        this.npmignore?.include(`/${this.libdir}/**/*.d.ts`);
        this.gitignore.exclude("/dist/");
        this.npmignore?.exclude("dist"); // jsii-pacmak expects this to be "dist" and not "/dist". otherwise it will tamper with it
        this.npmignore?.exclude("/tsconfig.json");
        this.npmignore?.exclude("/.github/");
        this.npmignore?.exclude("/.vscode/");
        this.npmignore?.exclude("/.idea/");
        this.npmignore?.exclude("/.projenrc.js");
        this.npmignore?.exclude("tsconfig.tsbuildinfo");
        if (this.jest) {
            if (compiledTests) {
                this.addJestCompiled(this.jest);
            }
            else {
                this.addJestNoCompile(this.jest, options?.tsJestOptions);
            }
        }
        if (options.eslint ?? true) {
            this.eslint = new javascript_1.Eslint(this, {
                tsconfigPath: `./${this.tsconfigDev.fileName}`,
                dirs: [this.srcdir],
                devdirs: [this.testdir, "build-tools"],
                fileExtensions: [".ts", ".tsx"],
                lintProjenRc: false,
                ...options.eslintOptions,
            });
            this.tsconfigEslint = this.tsconfigDev;
        }
        // when this is a root project
        if (!this.parent) {
            if (options.projenrcTs) {
                new typescript_1.Projenrc(this, options.projenrcTsOptions);
            }
            else {
                // projenrc.js created in NodeProject needs to be added in tsconfigDev
                const projenrcJs = javascript_1.Projenrc.of(this);
                if (projenrcJs) {
                    this.tsconfigDev.addInclude(projenrcJs.filePath);
                }
            }
        }
        const tsver = options.typescriptVersion
            ? `@${options.typescriptVersion}`
            : "";
        this.addDevDeps(`typescript${tsver}`, 
        // @types/node versions numbers match the node runtime versions' major.minor, however, new
        // releases are only created when API changes are included in a node release... We might for
        // example have dependencies that require `node >= 12.22`, but as 12.21 and 12.22 did not
        // include API changes, `@types/node@12.20.x` is the "correct" version to use. As it is not
        // possible to easily determine the correct version to use, we pick up the latest version.
        //
        // Additionally, we default to tracking the 18.x line, as the current earliest LTS release of
        // node is 18.x, so this is what corresponds to the broadest compatibility with supported node
        // runtimes.
        `@types/node@^${semver.major(this.package.minNodeVersion ?? "18.0.0")}`);
        // generate sample code in `src` and `lib` if these directories are empty or non-existent.
        if (options.sampleCode ?? true) {
            new SampleCode(this);
        }
        if (this.docgen) {
            new typescript_1.TypedocDocgen(this);
        }
    }
    /**
     * Tests are compiled to `lib/TESTDIR`, so we don't need jest to compile them
     * for us. just run them directly from javascript.
     */
    addJestCompiled(jest) {
        this.addDevDeps(`@types/jest${jest.jestVersion}`);
        const testout = path.posix.relative(this.srcdir, this.testdir);
        const libtest = path.posix.join(this.libdir, testout);
        const srctest = this.testdir;
        this.npmignore?.exclude(`/${libtest}/`);
        jest.addTestMatch(`**/${libtest}/**/?(*.)+(spec|test).js?(x)`);
        jest.addWatchIgnorePattern(`/${this.srcdir}/`);
        const resolveSnapshotPath = (test, ext) => {
            const fullpath = test.replace(libtest, srctest);
            return path.join(path.dirname(fullpath), "__snapshots__", path.basename(fullpath, ".js") + ".ts" + ext);
        };
        const resolveTestPath = (snap, ext) => {
            const filename = path.basename(snap, ".ts" + ext) + ".js";
            const dir = path.dirname(path.dirname(snap)).replace(srctest, libtest);
            return path.join(dir, filename);
        };
        const resolver = new textfile_1.TextFile(this, path.posix.join(common_1.PROJEN_DIR, "jest-snapshot-resolver.js"));
        if (!resolver.marker) {
            resolver.addLine(`// ${resolver.marker}`);
        }
        resolver.addLine('const path = require("path");');
        resolver.addLine(`const libtest = "${libtest}";`);
        resolver.addLine(`const srctest= "${srctest}";`);
        resolver.addLine("module.exports = {");
        resolver.addLine(`  resolveSnapshotPath: ${resolveSnapshotPath.toString()},`);
        resolver.addLine(`  resolveTestPath: ${resolveTestPath.toString()},`);
        resolver.addLine("  testPathForConsistencyCheck: path.join('some', '__tests__', 'example.test.js')");
        resolver.addLine("};");
        jest.addSnapshotResolver(`./${resolver.path}`);
    }
    addJestNoCompile(jest, tsJestOptions) {
        this.addDevDeps(`@types/jest${jest.jestVersion}`, `ts-jest${jest.jestVersion}`);
        jest.addTestMatch(`<rootDir>/${this.srcdir}/**/__tests__/**/*.ts?(x)`);
        jest.addTestMatch(`<rootDir>/(${this.testdir}|${this.srcdir})/**/*(*.)@(spec|test).ts?(x)`);
        // Test for the ts-jest version that was requested;
        //
        // - First, check the `jest` version that is requested via projen properties. This
        //   should be the same as the `ts-jest` version anyway.
        // - If none found, fall back to inspecting the actual `ts-jest` version
        //   that happens to be installed.
        let hasTsJest29;
        if (jest.jestVersion) {
            // We could maybe replace this will full "actual version" checking, but
            // the tests depend on this and the reading of 'package.json' is very
            // awkward to test.
            // Note that we use the requested version of `jest` as a proxy for the
            // version of `ts-jest`, which is what we're actually interested in.
            const major = semver.coerce(jest.jestVersion)?.major;
            hasTsJest29 = major ? major >= 29 : undefined;
        }
        if (hasTsJest29 === undefined) {
            hasTsJest29 = (0, util_1.hasDependencyVersion)(this, "ts-jest", ">= 29");
        }
        // add relevant deps (we treat "unknown" as having a modern ts-jest)
        if (hasTsJest29 !== false) {
            return this.addJestNoCompileModern(jest, tsJestOptions);
        }
        this.addJestNoCompileLegacy(jest, tsJestOptions);
    }
    addJestNoCompileModern(jest, tsJestOptions) {
        jest.config.transform = (0, util_2.deepMerge)([
            {
                [tsJestOptions?.transformPattern ??
                    TypeScriptProject.DEFAULT_TS_JEST_TRANFORM_PATTERN]: new javascript_1.Transform("ts-jest", {
                    tsconfig: TsJestTsconfig.fromFile(this.tsconfigDev.fileName),
                    ...(tsJestOptions?.transformOptions ?? {}),
                }),
            },
            jest.config.transform,
        ]);
    }
    addJestNoCompileLegacy(jest, tsJestOptions) {
        if (tsJestOptions) {
            this.logger.warn("You are using a legacy version (<29) of jest and ts-jest that does not support tsJestOptions, they will be ignored.");
        }
        if (!jest.config.preset) {
            jest.config.preset = "ts-jest";
        }
        jest.config.globals = (0, util_2.deepMerge)([
            {
                "ts-jest": {
                    tsconfig: this.tsconfigDev.fileName,
                },
            },
            jest.config.globals,
        ]);
    }
}
exports.TypeScriptProject = TypeScriptProject;
_d = JSII_RTTI_SYMBOL_1;
TypeScriptProject[_d] = { fqn: "projen.typescript.TypeScriptProject", version: "0.79.27" };
TypeScriptProject.DEFAULT_TS_JEST_TRANFORM_PATTERN = "^.+\\.[t]sx?$";
class SampleCode extends component_1.Component {
    constructor(project) {
        super(project);
        const srcCode = [
            "export class Hello {",
            "  public sayHello() {",
            "    return 'hello, world!';",
            "  }",
            "}",
        ].join("\n");
        const testCode = [
            "import { Hello } from '../src';",
            "",
            "test('hello', () => {",
            "  expect(new Hello().sayHello()).toBe('hello, world!');",
            "});",
        ].join("\n");
        new sample_file_1.SampleDir(project, project.srcdir, {
            files: {
                "index.ts": srcCode,
            },
        });
        if (project.jest) {
            new sample_file_1.SampleDir(project, project.testdir, {
                files: {
                    "hello.test.ts": testCode,
                },
            });
        }
    }
}
/**
 * TypeScript app.
 *
 * @pjid typescript-app
 */
class TypeScriptAppProject extends TypeScriptProject {
    constructor(options) {
        super({
            allowLibraryDependencies: false,
            releaseWorkflow: false,
            entrypoint: "",
            package: false,
            ...options,
        });
    }
}
exports.TypeScriptAppProject = TypeScriptAppProject;
_e = JSII_RTTI_SYMBOL_1;
TypeScriptAppProject[_e] = { fqn: "projen.typescript.TypeScriptAppProject", version: "0.79.27" };
/**
 * @deprecated use `TypeScriptProject`
 */
class TypeScriptLibraryProject extends TypeScriptProject {
}
exports.TypeScriptLibraryProject = TypeScriptLibraryProject;
_f = JSII_RTTI_SYMBOL_1;
TypeScriptLibraryProject[_f] = { fqn: "projen.typescript.TypeScriptLibraryProject", version: "0.79.27" };
/**
 * @internal
 */
function mergeTsconfigOptions(...options) {
    const definedOptions = options.filter(Boolean);
    return definedOptions.reduce((previous, current) => ({
        ...previous,
        ...current,
        include: [...(previous.include ?? []), ...(current.include ?? [])],
        exclude: [...(previous.exclude ?? []), ...(current.exclude ?? [])],
        compilerOptions: {
            ...previous.compilerOptions,
            ...current.compilerOptions,
        },
    }), { compilerOptions: {} });
}
exports.mergeTsconfigOptions = mergeTsconfigOptions;
//# sourceMappingURL=data:application/json;base64,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