"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tagAsComponent = exports.tagAsProject = exports.isComponent = exports.isProject = exports.findClosestProject = exports.tryFindClosest = exports.COMPONENT_SYMBOL = exports.PROJECT_SYMBOL = void 0;
exports.PROJECT_SYMBOL = Symbol.for("projen.Project");
exports.COMPONENT_SYMBOL = Symbol.for("projen.Component");
/**
 * Create a function to find the closest construct matching a predicate
 * @param predicate
 * @returns A function to find the closest construct matching the predicate
 */
function tryFindClosest(predicate) {
    return (construct) => construct?.node.scopes.reverse().find(predicate);
}
exports.tryFindClosest = tryFindClosest;
/**
 * Create a function to find the closest construct matching a predicate
 * @param predicate
 * @returns A function to find the closest construct matching the predicate
 */
function findClosestProject(construct) {
    if (isComponent(construct)) {
        return construct.project;
    }
    const project = tryFindClosest(isProject)(construct);
    if (!project) {
        throw new Error(`${new.target.name} at '${construct.node.path}' must be created in the scope of a Project, but no Project was found`);
    }
    return project;
}
exports.findClosestProject = findClosestProject;
function isProject(x) {
    return x !== null && typeof x === "object" && exports.PROJECT_SYMBOL in x;
}
exports.isProject = isProject;
function isComponent(x) {
    return x !== null && typeof x === "object" && exports.COMPONENT_SYMBOL in x;
}
exports.isComponent = isComponent;
function tagAs(scope, tag) {
    Object.defineProperty(scope, tag, { value: true });
}
function tagAsProject(scope) {
    tagAs(scope, exports.PROJECT_SYMBOL);
}
exports.tagAsProject = tagAsProject;
function tagAsComponent(scope) {
    tagAs(scope, exports.COMPONENT_SYMBOL);
}
exports.tagAsComponent = tagAsComponent;
//# sourceMappingURL=data:application/json;base64,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