"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureRelativePathStartsWithDot = void 0;
/**
 * Helper function to format a path as dot notation regardless of how it
 * was handed in.
 *
 * @param path - can be formatted as "path", "./path" (but not "/path", as it is absolute)
 * @returns "./path"
 */
function ensureRelativePathStartsWithDot(path) {
    if (path.startsWith(".")) {
        return path;
    }
    if (path.startsWith("/")) {
        throw new Error(`Path ${path} must be relative`);
    }
    return `./${path}`;
}
exports.ensureRelativePathStartsWithDot = ensureRelativePathStartsWithDot;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGF0aC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlsL3BhdGgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUE7Ozs7OztHQU1HO0FBQ0gsU0FBZ0IsK0JBQStCLENBQUMsSUFBWTtJQUMxRCxJQUFJLElBQUksQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLEVBQUU7UUFDeEIsT0FBTyxJQUFJLENBQUM7S0FDYjtJQUVELElBQUksSUFBSSxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsRUFBRTtRQUN4QixNQUFNLElBQUksS0FBSyxDQUFDLFFBQVEsSUFBSSxtQkFBbUIsQ0FBQyxDQUFDO0tBQ2xEO0lBRUQsT0FBTyxLQUFLLElBQUksRUFBRSxDQUFDO0FBQ3JCLENBQUM7QUFWRCwwRUFVQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogSGVscGVyIGZ1bmN0aW9uIHRvIGZvcm1hdCBhIHBhdGggYXMgZG90IG5vdGF0aW9uIHJlZ2FyZGxlc3Mgb2YgaG93IGl0XG4gKiB3YXMgaGFuZGVkIGluLlxuICpcbiAqIEBwYXJhbSBwYXRoIC0gY2FuIGJlIGZvcm1hdHRlZCBhcyBcInBhdGhcIiwgXCIuL3BhdGhcIiAoYnV0IG5vdCBcIi9wYXRoXCIsIGFzIGl0IGlzIGFic29sdXRlKVxuICogQHJldHVybnMgXCIuL3BhdGhcIlxuICovXG5leHBvcnQgZnVuY3Rpb24gZW5zdXJlUmVsYXRpdmVQYXRoU3RhcnRzV2l0aERvdChwYXRoOiBzdHJpbmcpOiBzdHJpbmcge1xuICBpZiAocGF0aC5zdGFydHNXaXRoKFwiLlwiKSkge1xuICAgIHJldHVybiBwYXRoO1xuICB9XG5cbiAgaWYgKHBhdGguc3RhcnRzV2l0aChcIi9cIikpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoYFBhdGggJHtwYXRofSBtdXN0IGJlIHJlbGF0aXZlYCk7XG4gIH1cblxuICByZXR1cm4gYC4vJHtwYXRofWA7XG59XG4iXX0=