"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeLaunchConfig = exports.InternalConsoleOptions = exports.Console = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const json_1 = require("../json");
/**
 * Controls where to launch the debug target
 * Source: https://code.visualstudio.com/docs/editor/debugging#_launchjson-attributes
 */
var Console;
(function (Console) {
    Console["INTERNAL_CONSOLE"] = "internalConsole";
    Console["INTEGRATED_TERMINAL"] = "integratedTerminal";
    Console["EXTERNAL_TERMINAL"] = "externalTerminal";
})(Console || (exports.Console = Console = {}));
/**
 * Controls the visibility of the VSCode Debug Console panel during a debugging session
 * Source: https://code.visualstudio.com/docs/editor/debugging#_launchjson-attributes
 */
var InternalConsoleOptions;
(function (InternalConsoleOptions) {
    InternalConsoleOptions["NEVER_OPEN"] = "neverOpen";
    InternalConsoleOptions["OPEN_ON_FIRST_SESSION_START"] = "openOnFirstSessionStart";
    InternalConsoleOptions["OPEN_ON_SESSION_START"] = "openOnSessionStart";
})(InternalConsoleOptions || (exports.InternalConsoleOptions = InternalConsoleOptions = {}));
/**
 * VSCode launch configuration file (launch.json), useful for enabling in-editor debugger
 */
class VsCodeLaunchConfig extends component_1.Component {
    static renderLaunchConfig(cfg) {
        if (!cfg.env) {
            return cfg;
        }
        return {
            ...cfg,
            env: Object.fromEntries(Object.entries(cfg.env).map(([key, value]) => [
                key,
                value === false ? null : value,
            ])),
        };
    }
    constructor(vscode) {
        super(vscode.project);
        this.content = {
            version: "0.2.0",
            configurations: [],
        };
        this.file = new json_1.JsonFile(vscode.project, ".vscode/launch.json", {
            obj: () => ({
                ...this.content,
                configurations: this.content.configurations.map(VsCodeLaunchConfig.renderLaunchConfig),
            }),
        });
    }
    /**
     * Adds a VsCodeLaunchConfigurationEntry (e.g. a node.js debugger) to `.vscode/launch.json.
     * Each configuration entry has following mandatory fields: type, request and name.
     * See https://code.visualstudio.com/docs/editor/debugging#_launchjson-attributes for details.
     * @param cfg VsCodeLaunchConfigurationEntry
     */
    addConfiguration(cfg) {
        this.content.configurations.push(cfg);
    }
    /**
     * Adds an input variable with type `promptString` to `.vscode/launch.json`.
     *
     * See https://code.visualstudio.com/docs/editor/variables-reference#_input-variables for details.
     * @param cfg VsCodeLaunchPromptStringInputEntry
     */
    addPromptStringInput(cfg) {
        this.addInput({
            ...cfg,
            type: InputCommandType.PROMPT_STRING,
        });
    }
    /**
     * Adds an input variable with type `pickString` to `.vscode/launch.json`.
     *
     * See https://code.visualstudio.com/docs/editor/variables-reference#_input-variables for details.
     * @param cfg VsCodeLaunchPickStringInputEntry
     */
    addPickStringInput(cfg) {
        this.addInput({
            ...cfg,
            type: InputCommandType.PICK_STRING,
        });
    }
    /**
     * Adds an input variable with type `command` to `.vscode/launch.json`.
     *
     * See https://code.visualstudio.com/docs/editor/variables-reference#_input-variables for details.
     * @param cfg VsCodeLaunchCommandInputEntry
     */
    addCommandInput(cfg) {
        this.addInput({
            ...cfg,
            type: InputCommandType.COMMAND,
        });
    }
    addInput(input) {
        var _b;
        (_b = this.content).inputs ?? (_b.inputs = []);
        this.content.inputs.push(input);
    }
}
exports.VsCodeLaunchConfig = VsCodeLaunchConfig;
_a = JSII_RTTI_SYMBOL_1;
VsCodeLaunchConfig[_a] = { fqn: "projen.vscode.VsCodeLaunchConfig", version: "0.79.27" };
var InputCommandType;
(function (InputCommandType) {
    InputCommandType["PROMPT_STRING"] = "promptString";
    InputCommandType["PICK_STRING"] = "pickString";
    InputCommandType["COMMAND"] = "command";
})(InputCommandType || (InputCommandType = {}));
//# sourceMappingURL=data:application/json;base64,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