"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeSettings = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const json_1 = require("../json");
/**
 * VS Code Workspace settings
 * Source: https://code.visualstudio.com/docs/getstarted/settings#_workspace-settings
 */
class VsCodeSettings extends component_1.Component {
    constructor(vscode) {
        super(vscode.project);
        this.content = {};
        this.file = new json_1.JsonFile(vscode.project, ".vscode/settings.json", {
            omitEmpty: false,
            obj: this.content,
        });
    }
    /**
     * Adds a workspace setting
     *
     * @param setting The setting ID
     * @param value The value of the setting
     * @param language Scope the setting to a specific language
     */
    addSetting(setting, value, language) {
        if (language) {
            this.content[`[${language}]`] = this.content[`[${language}]`] ?? {};
            this.content[`[${language}]`][setting] = value;
        }
        else {
            this.content[setting] = value;
        }
    }
    /**
     * Adds a workspace setting
     *
     * @param settings Array structure: [setting: string, value: any, languages?: string[]]
     */
    addSettings(settings, languages) {
        if (Array.isArray(languages)) {
            languages.forEach((language) => {
                Object.entries(settings).forEach(([setting, value]) => this.addSetting(setting, value, language));
            });
        }
        else {
            Object.entries(settings).forEach(([setting, value]) => this.addSetting(setting, value, languages));
        }
    }
}
exports.VsCodeSettings = VsCodeSettings;
_a = JSII_RTTI_SYMBOL_1;
VsCodeSettings[_a] = { fqn: "projen.vscode.VsCodeSettings", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,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