"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactTypeDef = exports.ReactComponent = exports.ReactTypeScriptProject = exports.ReactProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const component_1 = require("../component");
const file_1 = require("../file");
const javascript_1 = require("../javascript");
const sample_file_1 = require("../sample-file");
const source_code_1 = require("../source-code");
const typescript_1 = require("../typescript");
const util_1 = require("../util");
/**
 * React project using JavaScript.
 *
 * @pjid react
 */
class ReactProject extends javascript_1.NodeProject {
    constructor(options) {
        super({
            jest: false,
            ...options,
        });
        this.srcdir = options.srcdir ?? "src";
        new ReactComponent(this, { typescript: false, rewire: options.rewire });
        // generate sample code in `src` and `public` if these directories are empty or non-existent.
        if (options.sampleCode ?? true) {
            new ReactSampleCode(this, {
                fileExt: "jsx",
                srcdir: this.srcdir,
            });
            new sample_file_1.SampleDir(this, "public", {
                sourceDir: path.join(__dirname, "..", "..", "assets", "web", "react"),
            });
        }
    }
}
exports.ReactProject = ReactProject;
_a = JSII_RTTI_SYMBOL_1;
ReactProject[_a] = { fqn: "projen.web.ReactProject", version: "0.79.27" };
/**
 * React project using TypeScript.
 *
 * @pjid react-ts
 */
class ReactTypeScriptProject extends typescript_1.TypeScriptAppProject {
    constructor(options) {
        const defaultOptions = {
            srcdir: "src",
            eslint: true,
            jest: false,
            tsconfig: {
                include: ["src"],
                compilerOptions: {
                    target: "es5",
                    lib: ["dom", "dom.iterable", "esnext"],
                    allowJs: true,
                    skipLibCheck: true,
                    esModuleInterop: true,
                    allowSyntheticDefaultImports: true,
                    strict: true,
                    forceConsistentCasingInFileNames: true,
                    noFallthroughCasesInSwitch: true,
                    module: "commonjs",
                    moduleResolution: javascript_1.TypeScriptModuleResolution.NODE,
                    resolveJsonModule: true,
                    isolatedModules: true,
                    noEmit: true,
                    jsx: javascript_1.TypeScriptJsxMode.REACT_JSX,
                },
            },
            typescriptVersion: options.typescriptVersion ?? "^4.0.3",
        };
        // never generate default TypeScript sample code, since this class provides its own
        super((0, util_1.deepMerge)([
            defaultOptions,
            options,
            { sampleCode: false },
        ]));
        this.srcdir = options.srcdir ?? "src";
        this.eslint?.addRules({
            "import/no-extraneous-dependencies": [
                "error",
                {
                    devDependencies: ["**/src/**/*.test.tsx", "**/src/setupTests.ts"],
                    optionalDependencies: false,
                    peerDependencies: true,
                },
            ],
        });
        new ReactComponent(this, { typescript: true, rewire: options.rewire });
        // generate sample code in `src` and `public` if these directories are empty or non-existent.
        if (options.sampleCode ?? true) {
            new ReactSampleCode(this, {
                fileExt: "tsx",
                srcdir: this.srcdir,
            });
            new sample_file_1.SampleDir(this, "public", {
                sourceDir: path.join(__dirname, "..", "..", "assets", "web", "react"),
            });
        }
        this.package.addPackageResolutions(
        // https://github.com/DefinitelyTyped/DefinitelyTyped/issues/62300
        "@types/express@4.17.13", "@types/express-serve-static-core@4.17.30");
    }
}
exports.ReactTypeScriptProject = ReactTypeScriptProject;
_b = JSII_RTTI_SYMBOL_1;
ReactTypeScriptProject[_b] = { fqn: "projen.web.ReactTypeScriptProject", version: "0.79.27" };
class ReactComponent extends component_1.Component {
    constructor(project, options) {
        super(project);
        this.typescript = options.typescript ?? false;
        // No compile for react app
        project.compileTask.reset();
        project.addDeps("react", "react-dom", "react-scripts@^5", "web-vitals");
        project.addDevDeps("@testing-library/jest-dom", "@testing-library/react", "@testing-library/user-event");
        if (this.typescript) {
            project.addDevDeps("@types/jest", "@types/react", "@types/react-dom");
        }
        const rewire = options.rewire ?? false;
        if (rewire) {
            const overridesPath = ".projen/react-config-overrides.js";
            project.addDevDeps("react-app-rewired");
            project.addFields({ "config-overrides-path": overridesPath });
            const configOverrides = new source_code_1.SourceCode(this.project, overridesPath);
            if (!configOverrides.marker) {
                configOverrides.line(`// ${configOverrides.marker}`);
            }
            configOverrides.line("/**");
            configOverrides.line(" * Override CRA configuration without needing to eject.");
            configOverrides.line(" *");
            configOverrides.line(" * @see https://www.npmjs.com/package/react-app-rewired");
            configOverrides.line(" */");
            configOverrides.open("module.exports = function override(config, env) {");
            for (const [key, value] of Object.entries(rewire)) {
                configOverrides.line(`config.${key} = ${JSON.stringify(value)};`);
            }
            configOverrides.line("return config;");
            configOverrides.close("};");
        }
        const reactScripts = rewire ? "react-app-rewired" : "react-scripts";
        // Create React App CLI commands, see: https://create-react-app.dev/docs/available-scripts/
        project.addTask("dev", {
            description: "Starts the react application",
            exec: `${reactScripts} start`,
        });
        project.compileTask.exec(`${reactScripts} build`);
        project.testTask.exec(`${reactScripts} test --watchAll=false`);
        const testWatch = project.tasks.tryFind("test:watch");
        testWatch?.reset(`${reactScripts} test`);
        project.npmignore?.exclude("# Build", "/build/");
        project.gitignore.exclude("# Build", "/build/");
        project.package.addField("eslintConfig", {
            extends: ["react-app", "react-app/jest"],
        });
        project.package.addField("browserslist", {
            production: [">0.2%", "not dead", "not op_mini all"],
            development: [
                "last 1 chrome version",
                "last 1 firefox version",
                "last 1 safari version",
            ],
        });
    }
}
exports.ReactComponent = ReactComponent;
_c = JSII_RTTI_SYMBOL_1;
ReactComponent[_c] = { fqn: "projen.web.ReactComponent", version: "0.79.27" };
class ReactSampleCode extends component_1.Component {
    constructor(project, options) {
        super(project);
        this.fileExt = options.fileExt ?? "jsx";
        this.srcdir = options.srcdir;
        const logoSvg = [
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 841.9 595.3">',
            '    <g fill="#61DAFB">',
            '        <path d="M666.3 296.5c0-32.5-40.7-63.3-103.1-82.4 14.4-63.6 8-114.2-20.2-130.4-6.5-3.8-14.1-5.6-22.4-5.6v22.3c4.6 0 8.3.9 11.4 2.6 13.6 7.8 19.5 37.5 14.9 75.7-1.1 9.4-2.9 19.3-5.1 29.4-19.6-4.8-41-8.5-63.5-10.9-13.5-18.5-27.5-35.3-41.6-50 32.6-30.3 63.2-46.9 84-46.9V78c-27.5 0-63.5 19.6-99.9 53.6-36.4-33.8-72.4-53.2-99.9-53.2v22.3c20.7 0 51.4 16.5 84 46.6-14 14.7-28 31.4-41.3 49.9-22.6 2.4-44 6.1-63.6 11-2.3-10-4-19.7-5.2-29-4.7-38.2 1.1-67.9 14.6-75.8 3-1.8 6.9-2.6 11.5-2.6V78.5c-8.4 0-16 1.8-22.6 5.6-28.1 16.2-34.4 66.7-19.9 130.1-62.2 19.2-102.7 49.9-102.7 82.3 0 32.5 40.7 63.3 103.1 82.4-14.4 63.6-8 114.2 20.2 130.4 6.5 3.8 14.1 5.6 22.5 5.6 27.5 0 63.5-19.6 99.9-53.6 36.4 33.8 72.4 53.2 99.9 53.2 8.4 0 16-1.8 22.6-5.6 28.1-16.2 34.4-66.7 19.9-130.1 62-19.1 102.5-49.9 102.5-82.3zm-130.2-66.7c-3.7 12.9-8.3 26.2-13.5 39.5-4.1-8-8.4-16-13.1-24-4.6-8-9.5-15.8-14.4-23.4 14.2 2.1 27.9 4.7 41 7.9zm-45.8 106.5c-7.8 13.5-15.8 26.3-24.1 38.2-14.9 1.3-30 2-45.2 2-15.1 0-30.2-.7-45-1.9-8.3-11.9-16.4-24.6-24.2-38-7.6-13.1-14.5-26.4-20.8-39.8 6.2-13.4 13.2-26.8 20.7-39.9 7.8-13.5 15.8-26.3 24.1-38.2 14.9-1.3 30-2 45.2-2 15.1 0 30.2.7 45 1.9 8.3 11.9 16.4 24.6 24.2 38 7.6 13.1 14.5 26.4 20.8 39.8-6.3 13.4-13.2 26.8-20.7 39.9zm32.3-13c5.4 13.4 10 26.8 13.8 39.8-13.1 3.2-26.9 5.9-41.2 8 4.9-7.7 9.8-15.6 14.4-23.7 4.6-8 8.9-16.1 13-24.1zM421.2 430c-9.3-9.6-18.6-20.3-27.8-32 9 .4 18.2.7 27.5.7 9.4 0 18.7-.2 27.8-.7-9 11.7-18.3 22.4-27.5 32zm-74.4-58.9c-14.2-2.1-27.9-4.7-41-7.9 3.7-12.9 8.3-26.2 13.5-39.5 4.1 8 8.4 16 13.1 24 4.7 8 9.5 15.8 14.4 23.4zM420.7 163c9.3 9.6 18.6 20.3 27.8 32-9-.4-18.2-.7-27.5-.7-9.4 0-18.7.2-27.8.7 9-11.7 18.3-22.4 27.5-32zm-74 58.9c-4.9 7.7-9.8 15.6-14.4 23.7-4.6 8-8.9 16-13 24-5.4-13.4-10-26.8-13.8-39.8 13.1-3.1 26.9-5.8 41.2-7.9zm-90.5 125.2c-35.4-15.1-58.3-34.9-58.3-50.6 0-15.7 22.9-35.6 58.3-50.6 8.6-3.7 18-7 27.7-10.1 5.7 19.6 13.2 40 22.5 60.9-9.2 20.8-16.6 41.1-22.2 60.6-9.9-3.1-19.3-6.5-28-10.2zM310 490c-13.6-7.8-19.5-37.5-14.9-75.7 1.1-9.4 2.9-19.3 5.1-29.4 19.6 4.8 41 8.5 63.5 10.9 13.5 18.5 27.5 35.3 41.6 50-32.6 30.3-63.2 46.9-84 46.9-4.5-.1-8.3-1-11.3-2.7zm237.2-76.2c4.7 38.2-1.1 67.9-14.6 75.8-3 1.8-6.9 2.6-11.5 2.6-20.7 0-51.4-16.5-84-46.6 14-14.7 28-31.4 41.3-49.9 22.6-2.4 44-6.1 63.6-11 2.3 10.1 4.1 19.8 5.2 29.1zm38.5-66.7c-8.6 3.7-18 7-27.7 10.1-5.7-19.6-13.2-40-22.5-60.9 9.2-20.8 16.6-41.1 22.2-60.6 9.9 3.1 19.3 6.5 28.1 10.2 35.4 15.1 58.3 34.9 58.3 50.6-.1 15.7-23 35.6-58.4 50.6zM320.8 78.4z"/>',
            '        <circle cx="420.9" cy="296.5" r="45.7"/>',
            '        <path d="M520.5 78.1z"/>',
            "    </g>",
            "</svg>",
            "",
        ];
        const appJsx = [
            "import logo from './logo.svg';",
            "import './App.css'",
            "",
            "function App() {",
            "  return (",
            '   <div className="App">',
            '      <header className="App-header">',
            '        <img src={logo} className="App-logo" alt="logo" />',
            "        <p>",
            `          Edit <code>src/App.${this.fileExt}</code> and save to reload.`,
            "        </p>",
            '        <a className="App-link"',
            '          href="https://reactjs.org"',
            '          target="_blank"',
            '          rel="noopener noreferrer"',
            "        >",
            "          Learn React",
            "        </a>",
            "      </header>",
            "    </div>",
            "  );",
            "}",
            "",
            "export default App;",
            "",
        ];
        const appCss = [
            ".App {",
            "  text-align: center;",
            "}",
            "",
            ".App-logo {",
            "  height: 40vmin;",
            "  pointer-events: none;",
            "}",
            "",
            "@media (prefers-reduced-motion: no-preference) {",
            "  .App-logo {",
            "    animation: App-logo-spin infinite 20s linear;",
            "  }",
            "}",
            "",
            ".App-header {",
            "  background-color: #282c34;",
            "  min-height: 100vh;",
            "  display: flex;",
            "  flex-direction: column;",
            "  align-items: center;",
            "  justify-content: center;",
            "  font-size: calc(10px + 2vmin);",
            "  color: white;",
            "}",
            "",
            ".App-link {",
            "  color: #61dafb;",
            "}",
            "",
            "@keyframes App-logo-spin {",
            "  from {",
            "    transform: rotate(0deg);",
            "  }",
            "  to {",
            "    transform: rotate(360deg);",
            "  }",
            "}",
            "",
        ];
        const appTestJsx = [
            "import { render, screen } from '@testing-library/react';",
            "import App from './App';",
            "",
            "test('renders learn react link', () => {",
            "  render(<App />);",
            "  const linkElement = screen.getByText(/learn react/i);",
            "  expect(linkElement).toBeInTheDocument();",
            "});",
            "",
        ];
        const indexJsx = [
            "import React from 'react';",
            "import ReactDOM from 'react-dom';",
            "import './index.css';",
            "import App from './App';",
            "import reportWebVitals from './reportWebVitals';",
            "",
            "ReactDOM.render(",
            "  <React.StrictMode>",
            "    <App />",
            "  </React.StrictMode>,",
            "  document.getElementById('root')",
            ");",
            "",
            "// If you want to start measuring performance in your app, pass a function",
            "// to log results (for example: reportWebVitals(console.log))",
            "// or send to an analytics endpoint. Learn more: https://bit.ly/CRA-vitals",
            "reportWebVitals();",
            "",
        ];
        const indexCss = [
            "body {",
            "  margin: 0;",
            "  font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', 'Oxygen',",
            "    'Ubuntu', 'Cantarell', 'Fira Sans', 'Droid Sans', 'Helvetica Neue',",
            "    sans-serif;",
            "  -webkit-font-smoothing: antialiased;",
            "  -moz-osx-font-smoothing: grayscale;",
            "}",
            "",
            "code {",
            "  font-family: source-code-pro, Menlo, Monaco, Consolas, 'Courier New',",
            "    monospace;",
            "}",
            "",
        ];
        const reportWebVitalsJs = [
            "import { ReportHandler } from 'web-vitals';",
            "",
            "const reportWebVitals = (onPerfEntry?: ReportHandler) => {",
            "  if (onPerfEntry && onPerfEntry instanceof Function) {",
            "    import('web-vitals').then(",
            "      ({ getCLS, getFID, getFCP, getLCP, getTTFB }) => {",
            "        getCLS(onPerfEntry);",
            "        getFID(onPerfEntry);",
            "        getFCP(onPerfEntry);",
            "        getLCP(onPerfEntry);",
            "        getTTFB(onPerfEntry);",
            "      },",
            "      () => {}",
            "    );",
            "  }",
            "};",
            "",
            "export default reportWebVitals;",
        ];
        const setupTestsJs = [
            "// jest-dom adds custom jest matchers for asserting on DOM nodes.",
            "// allows you to do things like:",
            "// expect(element).toHaveTextContent(/react/i)",
            "// learn more: https://github.com/testing-library/jest-dom",
            "import '@testing-library/jest-dom';",
            "",
        ];
        const reactTypeDef = ['/// <reference types="react-scripts" />'];
        // js/ts not jsx/tsx
        const fileExtWithoutX = this.fileExt.replace("x", "");
        new sample_file_1.SampleDir(project, this.srcdir, {
            files: {
                "react-app-env.d.ts": reactTypeDef.join("\n"),
                "logo.svg": logoSvg.join("\n"),
                ["App." + this.fileExt]: appJsx.join("\n"),
                ["App.test." + this.fileExt]: appTestJsx.join("\n"),
                "App.css": appCss.join("\n"),
                ["index." + this.fileExt]: indexJsx.join("\n"),
                "index.css": indexCss.join("\n"),
                ["reportWebVitals." + fileExtWithoutX]: reportWebVitalsJs.join("\n"),
                ["setupTests." + fileExtWithoutX]: setupTestsJs.join("\n"),
            },
        });
    }
}
/**
 * @deprecated No longer used.
 */
class ReactTypeDef extends file_1.FileBase {
    constructor(project, filePath, options = {}) {
        super(project, filePath, options);
    }
    synthesizeContent(_) {
        return ['/// <reference types="react-scripts" />'].join("\n");
    }
}
exports.ReactTypeDef = ReactTypeDef;
_d = JSII_RTTI_SYMBOL_1;
ReactTypeDef[_d] = { fqn: "projen.web.ReactTypeDef", version: "0.79.27" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVhY3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvd2ViL3JlYWN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkJBQTZCO0FBQzdCLDRDQUF5QztBQUN6QyxrQ0FBK0Q7QUFDL0QsOENBS3VCO0FBQ3ZCLGdEQUEyQztBQUMzQyxnREFBNEM7QUFDNUMsOENBQStFO0FBQy9FLGtDQUFvQztBQTBEcEM7Ozs7R0FJRztBQUNILE1BQWEsWUFBYSxTQUFRLHdCQUFXO0lBTzNDLFlBQVksT0FBNEI7UUFDdEMsS0FBSyxDQUFDO1lBQ0osSUFBSSxFQUFFLEtBQUs7WUFDWCxHQUFHLE9BQU87U0FDWCxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsTUFBTSxHQUFHLE9BQU8sQ0FBQyxNQUFNLElBQUksS0FBSyxDQUFDO1FBRXRDLElBQUksY0FBYyxDQUFDLElBQUksRUFBRSxFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsTUFBTSxFQUFFLE9BQU8sQ0FBQyxNQUFNLEVBQUUsQ0FBQyxDQUFDO1FBRXhFLDZGQUE2RjtRQUM3RixJQUFJLE9BQU8sQ0FBQyxVQUFVLElBQUksSUFBSSxFQUFFO1lBQzlCLElBQUksZUFBZSxDQUFDLElBQUksRUFBRTtnQkFDeEIsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO2FBQ3BCLENBQUMsQ0FBQztZQUNILElBQUksdUJBQVMsQ0FBQyxJQUFJLEVBQUUsUUFBUSxFQUFFO2dCQUM1QixTQUFTLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsSUFBSSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsS0FBSyxFQUFFLE9BQU8sQ0FBQzthQUN0RSxDQUFDLENBQUM7U0FDSjtJQUNILENBQUM7O0FBM0JILG9DQTRCQzs7O0FBRUQ7Ozs7R0FJRztBQUNILE1BQWEsc0JBQXVCLFNBQVEsaUNBQW9CO0lBTTlELFlBQVksT0FBc0M7UUFDaEQsTUFBTSxjQUFjLEdBQUc7WUFDckIsTUFBTSxFQUFFLEtBQUs7WUFDYixNQUFNLEVBQUUsSUFBSTtZQUNaLElBQUksRUFBRSxLQUFLO1lBQ1gsUUFBUSxFQUFFO2dCQUNSLE9BQU8sRUFBRSxDQUFDLEtBQUssQ0FBQztnQkFDaEIsZUFBZSxFQUFFO29CQUNmLE1BQU0sRUFBRSxLQUFLO29CQUNiLEdBQUcsRUFBRSxDQUFDLEtBQUssRUFBRSxjQUFjLEVBQUUsUUFBUSxDQUFDO29CQUN0QyxPQUFPLEVBQUUsSUFBSTtvQkFDYixZQUFZLEVBQUUsSUFBSTtvQkFDbEIsZUFBZSxFQUFFLElBQUk7b0JBQ3JCLDRCQUE0QixFQUFFLElBQUk7b0JBQ2xDLE1BQU0sRUFBRSxJQUFJO29CQUNaLGdDQUFnQyxFQUFFLElBQUk7b0JBQ3RDLDBCQUEwQixFQUFFLElBQUk7b0JBQ2hDLE1BQU0sRUFBRSxVQUFVO29CQUNsQixnQkFBZ0IsRUFBRSx1Q0FBMEIsQ0FBQyxJQUFJO29CQUNqRCxpQkFBaUIsRUFBRSxJQUFJO29CQUN2QixlQUFlLEVBQUUsSUFBSTtvQkFDckIsTUFBTSxFQUFFLElBQUk7b0JBQ1osR0FBRyxFQUFFLDhCQUFpQixDQUFDLFNBQVM7aUJBQ2pDO2FBQ0Y7WUFDRCxpQkFBaUIsRUFBRSxPQUFPLENBQUMsaUJBQWlCLElBQUksUUFBUTtTQUN6RCxDQUFDO1FBRUYsbUZBQW1GO1FBQ25GLEtBQUssQ0FDSCxJQUFBLGdCQUFTLEVBQUM7WUFDUixjQUFjO1lBQ2QsT0FBTztZQUNQLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRTtTQUN0QixDQUE2QixDQUMvQixDQUFDO1FBRUYsSUFBSSxDQUFDLE1BQU0sR0FBRyxPQUFPLENBQUMsTUFBTSxJQUFJLEtBQUssQ0FBQztRQUV0QyxJQUFJLENBQUMsTUFBTSxFQUFFLFFBQVEsQ0FBQztZQUNwQixtQ0FBbUMsRUFBRTtnQkFDbkMsT0FBTztnQkFDUDtvQkFDRSxlQUFlLEVBQUUsQ0FBQyxzQkFBc0IsRUFBRSxzQkFBc0IsQ0FBQztvQkFDakUsb0JBQW9CLEVBQUUsS0FBSztvQkFDM0IsZ0JBQWdCLEVBQUUsSUFBSTtpQkFDdkI7YUFDRjtTQUNGLENBQUMsQ0FBQztRQUVILElBQUksY0FBYyxDQUFDLElBQUksRUFBRSxFQUFFLFVBQVUsRUFBRSxJQUFJLEVBQUUsTUFBTSxFQUFFLE9BQU8sQ0FBQyxNQUFNLEVBQUUsQ0FBQyxDQUFDO1FBRXZFLDZGQUE2RjtRQUM3RixJQUFJLE9BQU8sQ0FBQyxVQUFVLElBQUksSUFBSSxFQUFFO1lBQzlCLElBQUksZUFBZSxDQUFDLElBQUksRUFBRTtnQkFDeEIsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO2FBQ3BCLENBQUMsQ0FBQztZQUNILElBQUksdUJBQVMsQ0FBQyxJQUFJLEVBQUUsUUFBUSxFQUFFO2dCQUM1QixTQUFTLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsSUFBSSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsS0FBSyxFQUFFLE9BQU8sQ0FBQzthQUN0RSxDQUFDLENBQUM7U0FDSjtRQUVELElBQUksQ0FBQyxPQUFPLENBQUMscUJBQXFCO1FBQ2hDLGtFQUFrRTtRQUNsRSx3QkFBd0IsRUFDeEIsMENBQTBDLENBQzNDLENBQUM7SUFDSixDQUFDOztBQTFFSCx3REEyRUM7OztBQVdELE1BQWEsY0FBZSxTQUFRLHFCQUFTO0lBRzNDLFlBQVksT0FBb0IsRUFBRSxPQUE4QjtRQUM5RCxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7UUFFZixJQUFJLENBQUMsVUFBVSxHQUFHLE9BQU8sQ0FBQyxVQUFVLElBQUksS0FBSyxDQUFDO1FBRTlDLDJCQUEyQjtRQUMzQixPQUFPLENBQUMsV0FBVyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBRTVCLE9BQU8sQ0FBQyxPQUFPLENBQUMsT0FBTyxFQUFFLFdBQVcsRUFBRSxrQkFBa0IsRUFBRSxZQUFZLENBQUMsQ0FBQztRQUN4RSxPQUFPLENBQUMsVUFBVSxDQUNoQiwyQkFBMkIsRUFDM0Isd0JBQXdCLEVBQ3hCLDZCQUE2QixDQUM5QixDQUFDO1FBQ0YsSUFBSSxJQUFJLENBQUMsVUFBVSxFQUFFO1lBQ25CLE9BQU8sQ0FBQyxVQUFVLENBQUMsYUFBYSxFQUFFLGNBQWMsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO1NBQ3ZFO1FBRUQsTUFBTSxNQUFNLEdBQUcsT0FBTyxDQUFDLE1BQU0sSUFBSSxLQUFLLENBQUM7UUFFdkMsSUFBSSxNQUFNLEVBQUU7WUFDVixNQUFNLGFBQWEsR0FBRyxtQ0FBbUMsQ0FBQztZQUMxRCxPQUFPLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUM7WUFDeEMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxFQUFFLHVCQUF1QixFQUFFLGFBQWEsRUFBRSxDQUFDLENBQUM7WUFFOUQsTUFBTSxlQUFlLEdBQUcsSUFBSSx3QkFBVSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsYUFBYSxDQUFDLENBQUM7WUFDcEUsSUFBSSxDQUFDLGVBQWUsQ0FBQyxNQUFNLEVBQUU7Z0JBQzNCLGVBQWUsQ0FBQyxJQUFJLENBQUMsTUFBTSxlQUFlLENBQUMsTUFBTSxFQUFFLENBQUMsQ0FBQzthQUN0RDtZQUNELGVBQWUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDNUIsZUFBZSxDQUFDLElBQUksQ0FDbEIseURBQXlELENBQzFELENBQUM7WUFDRixlQUFlLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO1lBQzNCLGVBQWUsQ0FBQyxJQUFJLENBQ2xCLHlEQUF5RCxDQUMxRCxDQUFDO1lBQ0YsZUFBZSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztZQUM1QixlQUFlLENBQUMsSUFBSSxDQUFDLG1EQUFtRCxDQUFDLENBQUM7WUFDMUUsS0FBSyxNQUFNLENBQUMsR0FBRyxFQUFFLEtBQUssQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLEVBQUU7Z0JBQ2pELGVBQWUsQ0FBQyxJQUFJLENBQUMsVUFBVSxHQUFHLE1BQU0sSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7YUFDbkU7WUFDRCxlQUFlLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLENBQUM7WUFDdkMsZUFBZSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQztTQUM3QjtRQUVELE1BQU0sWUFBWSxHQUFHLE1BQU0sQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLGVBQWUsQ0FBQztRQUVwRSwyRkFBMkY7UUFDM0YsT0FBTyxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUU7WUFDckIsV0FBVyxFQUFFLDhCQUE4QjtZQUMzQyxJQUFJLEVBQUUsR0FBRyxZQUFZLFFBQVE7U0FDOUIsQ0FBQyxDQUFDO1FBRUgsT0FBTyxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsR0FBRyxZQUFZLFFBQVEsQ0FBQyxDQUFDO1FBRWxELE9BQU8sQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEdBQUcsWUFBWSx3QkFBd0IsQ0FBQyxDQUFDO1FBRS9ELE1BQU0sU0FBUyxHQUFHLE9BQU8sQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQyxDQUFDO1FBQ3RELFNBQVMsRUFBRSxLQUFLLENBQUMsR0FBRyxZQUFZLE9BQU8sQ0FBQyxDQUFDO1FBRXpDLE9BQU8sQ0FBQyxTQUFTLEVBQUUsT0FBTyxDQUFDLFNBQVMsRUFBRSxTQUFTLENBQUMsQ0FBQztRQUNqRCxPQUFPLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxTQUFTLEVBQUUsU0FBUyxDQUFDLENBQUM7UUFFaEQsT0FBTyxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsY0FBYyxFQUFFO1lBQ3ZDLE9BQU8sRUFBRSxDQUFDLFdBQVcsRUFBRSxnQkFBZ0IsQ0FBQztTQUN6QyxDQUFDLENBQUM7UUFFSCxPQUFPLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxjQUFjLEVBQUU7WUFDdkMsVUFBVSxFQUFFLENBQUMsT0FBTyxFQUFFLFVBQVUsRUFBRSxpQkFBaUIsQ0FBQztZQUNwRCxXQUFXLEVBQUU7Z0JBQ1gsdUJBQXVCO2dCQUN2Qix3QkFBd0I7Z0JBQ3hCLHVCQUF1QjthQUN4QjtTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBL0VILHdDQWdGQzs7O0FBZ0JELE1BQU0sZUFBZ0IsU0FBUSxxQkFBUztJQUlyQyxZQUFZLE9BQW9CLEVBQUUsT0FBK0I7UUFDL0QsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBRWYsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPLENBQUMsT0FBTyxJQUFJLEtBQUssQ0FBQztRQUN4QyxJQUFJLENBQUMsTUFBTSxHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUM7UUFFN0IsTUFBTSxPQUFPLEdBQUc7WUFDZCxvRUFBb0U7WUFDcEUsd0JBQXdCO1lBQ3hCLG83RUFBbzdFO1lBQ3A3RSxrREFBa0Q7WUFDbEQsa0NBQWtDO1lBQ2xDLFVBQVU7WUFDVixRQUFRO1lBQ1IsRUFBRTtTQUNILENBQUM7UUFFRixNQUFNLE1BQU0sR0FBRztZQUNiLGdDQUFnQztZQUNoQyxvQkFBb0I7WUFDcEIsRUFBRTtZQUNGLGtCQUFrQjtZQUNsQixZQUFZO1lBQ1osMEJBQTBCO1lBQzFCLHVDQUF1QztZQUN2Qyw0REFBNEQ7WUFDNUQsYUFBYTtZQUNiLGdDQUFnQyxJQUFJLENBQUMsT0FBTyw2QkFBNkI7WUFDekUsY0FBYztZQUNkLGlDQUFpQztZQUNqQyxzQ0FBc0M7WUFDdEMsMkJBQTJCO1lBQzNCLHFDQUFxQztZQUNyQyxXQUFXO1lBQ1gsdUJBQXVCO1lBQ3ZCLGNBQWM7WUFDZCxpQkFBaUI7WUFDakIsWUFBWTtZQUNaLE1BQU07WUFDTixHQUFHO1lBQ0gsRUFBRTtZQUNGLHFCQUFxQjtZQUNyQixFQUFFO1NBQ0gsQ0FBQztRQUVGLE1BQU0sTUFBTSxHQUFHO1lBQ2IsUUFBUTtZQUNSLHVCQUF1QjtZQUN2QixHQUFHO1lBQ0gsRUFBRTtZQUNGLGFBQWE7WUFDYixtQkFBbUI7WUFDbkIseUJBQXlCO1lBQ3pCLEdBQUc7WUFDSCxFQUFFO1lBQ0Ysa0RBQWtEO1lBQ2xELGVBQWU7WUFDZixtREFBbUQ7WUFDbkQsS0FBSztZQUNMLEdBQUc7WUFDSCxFQUFFO1lBQ0YsZUFBZTtZQUNmLDhCQUE4QjtZQUM5QixzQkFBc0I7WUFDdEIsa0JBQWtCO1lBQ2xCLDJCQUEyQjtZQUMzQix3QkFBd0I7WUFDeEIsNEJBQTRCO1lBQzVCLGtDQUFrQztZQUNsQyxpQkFBaUI7WUFDakIsR0FBRztZQUNILEVBQUU7WUFDRixhQUFhO1lBQ2IsbUJBQW1CO1lBQ25CLEdBQUc7WUFDSCxFQUFFO1lBQ0YsNEJBQTRCO1lBQzVCLFVBQVU7WUFDViw4QkFBOEI7WUFDOUIsS0FBSztZQUNMLFFBQVE7WUFDUixnQ0FBZ0M7WUFDaEMsS0FBSztZQUNMLEdBQUc7WUFDSCxFQUFFO1NBQ0gsQ0FBQztRQUVGLE1BQU0sVUFBVSxHQUFHO1lBQ2pCLDBEQUEwRDtZQUMxRCwwQkFBMEI7WUFDMUIsRUFBRTtZQUNGLDBDQUEwQztZQUMxQyxvQkFBb0I7WUFDcEIseURBQXlEO1lBQ3pELDRDQUE0QztZQUM1QyxLQUFLO1lBQ0wsRUFBRTtTQUNILENBQUM7UUFFRixNQUFNLFFBQVEsR0FBRztZQUNmLDRCQUE0QjtZQUM1QixtQ0FBbUM7WUFDbkMsdUJBQXVCO1lBQ3ZCLDBCQUEwQjtZQUMxQixrREFBa0Q7WUFDbEQsRUFBRTtZQUNGLGtCQUFrQjtZQUNsQixzQkFBc0I7WUFDdEIsYUFBYTtZQUNiLHdCQUF3QjtZQUN4QixtQ0FBbUM7WUFDbkMsSUFBSTtZQUNKLEVBQUU7WUFDRiw0RUFBNEU7WUFDNUUsK0RBQStEO1lBQy9ELDRFQUE0RTtZQUM1RSxvQkFBb0I7WUFDcEIsRUFBRTtTQUNILENBQUM7UUFFRixNQUFNLFFBQVEsR0FBRztZQUNmLFFBQVE7WUFDUixjQUFjO1lBQ2QsbUZBQW1GO1lBQ25GLHlFQUF5RTtZQUN6RSxpQkFBaUI7WUFDakIsd0NBQXdDO1lBQ3hDLHVDQUF1QztZQUN2QyxHQUFHO1lBQ0gsRUFBRTtZQUNGLFFBQVE7WUFDUix5RUFBeUU7WUFDekUsZ0JBQWdCO1lBQ2hCLEdBQUc7WUFDSCxFQUFFO1NBQ0gsQ0FBQztRQUVGLE1BQU0saUJBQWlCLEdBQUc7WUFDeEIsNkNBQTZDO1lBQzdDLEVBQUU7WUFDRiw0REFBNEQ7WUFDNUQseURBQXlEO1lBQ3pELGdDQUFnQztZQUNoQywwREFBMEQ7WUFDMUQsOEJBQThCO1lBQzlCLDhCQUE4QjtZQUM5Qiw4QkFBOEI7WUFDOUIsOEJBQThCO1lBQzlCLCtCQUErQjtZQUMvQixVQUFVO1lBQ1YsZ0JBQWdCO1lBQ2hCLFFBQVE7WUFDUixLQUFLO1lBQ0wsSUFBSTtZQUNKLEVBQUU7WUFDRixpQ0FBaUM7U0FDbEMsQ0FBQztRQUVGLE1BQU0sWUFBWSxHQUFHO1lBQ25CLG1FQUFtRTtZQUNuRSxrQ0FBa0M7WUFDbEMsZ0RBQWdEO1lBQ2hELDREQUE0RDtZQUM1RCxxQ0FBcUM7WUFDckMsRUFBRTtTQUNILENBQUM7UUFFRixNQUFNLFlBQVksR0FBRyxDQUFDLHlDQUF5QyxDQUFDLENBQUM7UUFFakUsb0JBQW9CO1FBQ3BCLE1BQU0sZUFBZSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLEdBQUcsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUV0RCxJQUFJLHVCQUFTLENBQUMsT0FBTyxFQUFFLElBQUksQ0FBQyxNQUFNLEVBQUU7WUFDbEMsS0FBSyxFQUFFO2dCQUNMLG9CQUFvQixFQUFFLFlBQVksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO2dCQUM3QyxVQUFVLEVBQUUsT0FBTyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7Z0JBQzlCLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsRUFBRSxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztnQkFDMUMsQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxFQUFFLFVBQVUsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO2dCQUNuRCxTQUFTLEVBQUUsTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7Z0JBQzVCLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsRUFBRSxRQUFRLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztnQkFDOUMsV0FBVyxFQUFFLFFBQVEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO2dCQUNoQyxDQUFDLGtCQUFrQixHQUFHLGVBQWUsQ0FBQyxFQUFFLGlCQUFpQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7Z0JBQ3BFLENBQUMsYUFBYSxHQUFHLGVBQWUsQ0FBQyxFQUFFLFlBQVksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO2FBQzNEO1NBQ0YsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztDQUNGO0FBT0Q7O0dBRUc7QUFDSCxNQUFhLFlBQWEsU0FBUSxlQUFRO0lBQ3hDLFlBQ0UsT0FBK0IsRUFDL0IsUUFBZ0IsRUFDaEIsVUFBK0IsRUFBRTtRQUVqQyxLQUFLLENBQUMsT0FBTyxFQUFFLFFBQVEsRUFBRSxPQUFPLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBRVMsaUJBQWlCLENBQUMsQ0FBWTtRQUN0QyxPQUFPLENBQUMseUNBQXlDLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDaEUsQ0FBQzs7QUFYSCxvQ0FZQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHBhdGggZnJvbSBcInBhdGhcIjtcbmltcG9ydCB7IENvbXBvbmVudCB9IGZyb20gXCIuLi9jb21wb25lbnRcIjtcbmltcG9ydCB7IEZpbGVCYXNlLCBGaWxlQmFzZU9wdGlvbnMsIElSZXNvbHZlciB9IGZyb20gXCIuLi9maWxlXCI7XG5pbXBvcnQge1xuICBOb2RlUHJvamVjdCxcbiAgTm9kZVByb2plY3RPcHRpb25zLFxuICBUeXBlU2NyaXB0SnN4TW9kZSxcbiAgVHlwZVNjcmlwdE1vZHVsZVJlc29sdXRpb24sXG59IGZyb20gXCIuLi9qYXZhc2NyaXB0XCI7XG5pbXBvcnQgeyBTYW1wbGVEaXIgfSBmcm9tIFwiLi4vc2FtcGxlLWZpbGVcIjtcbmltcG9ydCB7IFNvdXJjZUNvZGUgfSBmcm9tIFwiLi4vc291cmNlLWNvZGVcIjtcbmltcG9ydCB7IFR5cGVTY3JpcHRBcHBQcm9qZWN0LCBUeXBlU2NyaXB0UHJvamVjdE9wdGlvbnMgfSBmcm9tIFwiLi4vdHlwZXNjcmlwdFwiO1xuaW1wb3J0IHsgZGVlcE1lcmdlIH0gZnJvbSBcIi4uL3V0aWxcIjtcblxuZXhwb3J0IGludGVyZmFjZSBSZWFjdFJld2lyZU9wdGlvbnMge1xuICAvKipcbiAgICogUmV3aXJlIHdlYnBhY2sgY29uZmlndXJhdGlvbi5cbiAgICpcbiAgICogVXNlIHRoaXMgcHJvcGVydHkgdG8gb3ZlcnJpZGUgd2VicGFjayBjb25maWd1cmF0aW9uIHByb3BlcnRpZXMgcHJvdmlkZWRcbiAgICogYnkgY3JlYXRlLXJlYWN0LWFwcCwgd2l0aG91dCBuZWVkaW5nIHRvIGVqZWN0LlxuICAgKlxuICAgKiBUaGlzIHByb3BlcnR5IHdpbGwgY3JlYXRlIGEgYGNvbmZpZy1vdmVycmlkZXMuanNgIGZpbGUgaW4geW91ciByb290IGRpcmVjdG9yeSxcbiAgICogd2hpY2ggd2lsbCBjb250YWluIHRoZSBkZXNpcmVkIHJld2lyaW5nIGNvZGUuXG4gICAqXG4gICAqIFRvICoqb3ZlcnJpZGUqKiB0aGUgY29uZmlndXJhdGlvbiwgeW91IGNhbiBwcm92aWRlIHNpbXBsZSBrZXkgdmFsdWUgcGFpcnMuXG4gICAqIEtleXMgdGFrZSB0aGUgZm9ybSBvZiBqcyBjb2RlIGRpcmVjdGl2ZXMgdGhhdCB0cmF2ZXJzZSB0byB0aGUgZGVzaXJlZCBwcm9wZXJ0eS5cbiAgICogVmFsdWVzIHNob3VsZCBiZSBKU09OIHNlcmlhbGl6YWJsZSBvYmplY3RzLlxuICAgKlxuICAgKiBGb3IgZXhhbXBsZSwgdGhlIGZvbGxvd2luZyBjb25maWc6XG4gICAqXG4gICAqIGBgYGpzb25cbiAgICogcmV3aXJlOiB7IFwibW9kdWxlLnVua25vd25Db250ZXh0Q3JpdGljYWxcIjogZmFsc2UgfVxuICAgKiBgYGBcbiAgICpcbiAgICogV2lsbCB0cmFuc2xhdGUgdG8gdGhlIGZvbGxvd2luZyBgY29uZmlnLW92ZXJyaWRlcy5qc2AgZmlsZTpcbiAgICpcbiAgICogYGBganNcbiAgICogbW9kdWxlLmV4cG9ydHMgPSBmdW5jdGlvbiBvdmVycmlkZShjb25maWcsIGVudikge1xuICAgKiAgIGNvbmZpZy5tb2R1bGUudW5rbm93bkNvbnRleHRDcml0aWNhbCA9IGZhbHNlO1xuICAgKiB9XG4gICAqIGBgYFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIHJld2lyZWQgY29uZmlnLlxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vd2VicGFjay5qcy5vcmcvY29uZmlndXJhdGlvbi9cbiAgICogQHNlZSBodHRwczovL2dpdGh1Yi5jb20vdGltYXJuZXkvcmVhY3QtYXBwLXJld2lyZWRcbiAgICovXG4gIHJlYWRvbmx5IHJld2lyZT86IHsgW2tleTogc3RyaW5nXTogYW55IH07XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUmVhY3RUeXBlU2NyaXB0UHJvamVjdE9wdGlvbnNcbiAgZXh0ZW5kcyBUeXBlU2NyaXB0UHJvamVjdE9wdGlvbnMsXG4gICAgUmVhY3RSZXdpcmVPcHRpb25zIHt9XG5cbmV4cG9ydCBpbnRlcmZhY2UgUmVhY3RQcm9qZWN0T3B0aW9uc1xuICBleHRlbmRzIE5vZGVQcm9qZWN0T3B0aW9ucyxcbiAgICBSZWFjdFJld2lyZU9wdGlvbnMge1xuICAvKipcbiAgICogU291cmNlIGRpcmVjdG9yeS5cbiAgICpcbiAgICogQGRlZmF1bHQgXCJzcmNcIlxuICAgKi9cbiAgcmVhZG9ubHkgc3JjZGlyPzogc3RyaW5nO1xuICAvKipcbiAgICogR2VuZXJhdGUgb25lLXRpbWUgc2FtcGxlIGluIGBzcmMvYCBhbmQgYHB1YmxpYy9gIGlmIHRoZXJlIGFyZSBubyBmaWxlcyB0aGVyZS5cbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgc2FtcGxlQ29kZT86IGJvb2xlYW47XG59XG5cbi8qKlxuICogUmVhY3QgcHJvamVjdCB1c2luZyBKYXZhU2NyaXB0LlxuICpcbiAqIEBwamlkIHJlYWN0XG4gKi9cbmV4cG9ydCBjbGFzcyBSZWFjdFByb2plY3QgZXh0ZW5kcyBOb2RlUHJvamVjdCB7XG4gIC8qKlxuICAgKiBUaGUgZGlyZWN0b3J5IGluIHdoaWNoIHNvdXJjZSBmaWxlcyByZXNpZGUuXG4gICAqIEBkZWZhdWx0IFwic3JjXCJcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBzcmNkaXI6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihvcHRpb25zOiBSZWFjdFByb2plY3RPcHRpb25zKSB7XG4gICAgc3VwZXIoe1xuICAgICAgamVzdDogZmFsc2UsXG4gICAgICAuLi5vcHRpb25zLFxuICAgIH0pO1xuXG4gICAgdGhpcy5zcmNkaXIgPSBvcHRpb25zLnNyY2RpciA/PyBcInNyY1wiO1xuXG4gICAgbmV3IFJlYWN0Q29tcG9uZW50KHRoaXMsIHsgdHlwZXNjcmlwdDogZmFsc2UsIHJld2lyZTogb3B0aW9ucy5yZXdpcmUgfSk7XG5cbiAgICAvLyBnZW5lcmF0ZSBzYW1wbGUgY29kZSBpbiBgc3JjYCBhbmQgYHB1YmxpY2AgaWYgdGhlc2UgZGlyZWN0b3JpZXMgYXJlIGVtcHR5IG9yIG5vbi1leGlzdGVudC5cbiAgICBpZiAob3B0aW9ucy5zYW1wbGVDb2RlID8/IHRydWUpIHtcbiAgICAgIG5ldyBSZWFjdFNhbXBsZUNvZGUodGhpcywge1xuICAgICAgICBmaWxlRXh0OiBcImpzeFwiLFxuICAgICAgICBzcmNkaXI6IHRoaXMuc3JjZGlyLFxuICAgICAgfSk7XG4gICAgICBuZXcgU2FtcGxlRGlyKHRoaXMsIFwicHVibGljXCIsIHtcbiAgICAgICAgc291cmNlRGlyOiBwYXRoLmpvaW4oX19kaXJuYW1lLCBcIi4uXCIsIFwiLi5cIiwgXCJhc3NldHNcIiwgXCJ3ZWJcIiwgXCJyZWFjdFwiKSxcbiAgICAgIH0pO1xuICAgIH1cbiAgfVxufVxuXG4vKipcbiAqIFJlYWN0IHByb2plY3QgdXNpbmcgVHlwZVNjcmlwdC5cbiAqXG4gKiBAcGppZCByZWFjdC10c1xuICovXG5leHBvcnQgY2xhc3MgUmVhY3RUeXBlU2NyaXB0UHJvamVjdCBleHRlbmRzIFR5cGVTY3JpcHRBcHBQcm9qZWN0IHtcbiAgLyoqXG4gICAqIFRoZSBkaXJlY3RvcnkgaW4gd2hpY2ggc291cmNlIGZpbGVzIHJlc2lkZS5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBzcmNkaXI6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihvcHRpb25zOiBSZWFjdFR5cGVTY3JpcHRQcm9qZWN0T3B0aW9ucykge1xuICAgIGNvbnN0IGRlZmF1bHRPcHRpb25zID0ge1xuICAgICAgc3JjZGlyOiBcInNyY1wiLFxuICAgICAgZXNsaW50OiB0cnVlLFxuICAgICAgamVzdDogZmFsc2UsXG4gICAgICB0c2NvbmZpZzoge1xuICAgICAgICBpbmNsdWRlOiBbXCJzcmNcIl0sXG4gICAgICAgIGNvbXBpbGVyT3B0aW9uczoge1xuICAgICAgICAgIHRhcmdldDogXCJlczVcIixcbiAgICAgICAgICBsaWI6IFtcImRvbVwiLCBcImRvbS5pdGVyYWJsZVwiLCBcImVzbmV4dFwiXSxcbiAgICAgICAgICBhbGxvd0pzOiB0cnVlLFxuICAgICAgICAgIHNraXBMaWJDaGVjazogdHJ1ZSxcbiAgICAgICAgICBlc01vZHVsZUludGVyb3A6IHRydWUsXG4gICAgICAgICAgYWxsb3dTeW50aGV0aWNEZWZhdWx0SW1wb3J0czogdHJ1ZSxcbiAgICAgICAgICBzdHJpY3Q6IHRydWUsXG4gICAgICAgICAgZm9yY2VDb25zaXN0ZW50Q2FzaW5nSW5GaWxlTmFtZXM6IHRydWUsXG4gICAgICAgICAgbm9GYWxsdGhyb3VnaENhc2VzSW5Td2l0Y2g6IHRydWUsXG4gICAgICAgICAgbW9kdWxlOiBcImNvbW1vbmpzXCIsXG4gICAgICAgICAgbW9kdWxlUmVzb2x1dGlvbjogVHlwZVNjcmlwdE1vZHVsZVJlc29sdXRpb24uTk9ERSxcbiAgICAgICAgICByZXNvbHZlSnNvbk1vZHVsZTogdHJ1ZSxcbiAgICAgICAgICBpc29sYXRlZE1vZHVsZXM6IHRydWUsXG4gICAgICAgICAgbm9FbWl0OiB0cnVlLFxuICAgICAgICAgIGpzeDogVHlwZVNjcmlwdEpzeE1vZGUuUkVBQ1RfSlNYLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICAgIHR5cGVzY3JpcHRWZXJzaW9uOiBvcHRpb25zLnR5cGVzY3JpcHRWZXJzaW9uID8/IFwiXjQuMC4zXCIsXG4gICAgfTtcblxuICAgIC8vIG5ldmVyIGdlbmVyYXRlIGRlZmF1bHQgVHlwZVNjcmlwdCBzYW1wbGUgY29kZSwgc2luY2UgdGhpcyBjbGFzcyBwcm92aWRlcyBpdHMgb3duXG4gICAgc3VwZXIoXG4gICAgICBkZWVwTWVyZ2UoW1xuICAgICAgICBkZWZhdWx0T3B0aW9ucyxcbiAgICAgICAgb3B0aW9ucyxcbiAgICAgICAgeyBzYW1wbGVDb2RlOiBmYWxzZSB9LFxuICAgICAgXSkgYXMgVHlwZVNjcmlwdFByb2plY3RPcHRpb25zXG4gICAgKTtcblxuICAgIHRoaXMuc3JjZGlyID0gb3B0aW9ucy5zcmNkaXIgPz8gXCJzcmNcIjtcblxuICAgIHRoaXMuZXNsaW50Py5hZGRSdWxlcyh7XG4gICAgICBcImltcG9ydC9uby1leHRyYW5lb3VzLWRlcGVuZGVuY2llc1wiOiBbXG4gICAgICAgIFwiZXJyb3JcIixcbiAgICAgICAge1xuICAgICAgICAgIGRldkRlcGVuZGVuY2llczogW1wiKiovc3JjLyoqLyoudGVzdC50c3hcIiwgXCIqKi9zcmMvc2V0dXBUZXN0cy50c1wiXSxcbiAgICAgICAgICBvcHRpb25hbERlcGVuZGVuY2llczogZmFsc2UsXG4gICAgICAgICAgcGVlckRlcGVuZGVuY2llczogdHJ1ZSxcbiAgICAgICAgfSxcbiAgICAgIF0sXG4gICAgfSk7XG5cbiAgICBuZXcgUmVhY3RDb21wb25lbnQodGhpcywgeyB0eXBlc2NyaXB0OiB0cnVlLCByZXdpcmU6IG9wdGlvbnMucmV3aXJlIH0pO1xuXG4gICAgLy8gZ2VuZXJhdGUgc2FtcGxlIGNvZGUgaW4gYHNyY2AgYW5kIGBwdWJsaWNgIGlmIHRoZXNlIGRpcmVjdG9yaWVzIGFyZSBlbXB0eSBvciBub24tZXhpc3RlbnQuXG4gICAgaWYgKG9wdGlvbnMuc2FtcGxlQ29kZSA/PyB0cnVlKSB7XG4gICAgICBuZXcgUmVhY3RTYW1wbGVDb2RlKHRoaXMsIHtcbiAgICAgICAgZmlsZUV4dDogXCJ0c3hcIixcbiAgICAgICAgc3JjZGlyOiB0aGlzLnNyY2RpcixcbiAgICAgIH0pO1xuICAgICAgbmV3IFNhbXBsZURpcih0aGlzLCBcInB1YmxpY1wiLCB7XG4gICAgICAgIHNvdXJjZURpcjogcGF0aC5qb2luKF9fZGlybmFtZSwgXCIuLlwiLCBcIi4uXCIsIFwiYXNzZXRzXCIsIFwid2ViXCIsIFwicmVhY3RcIiksXG4gICAgICB9KTtcbiAgICB9XG5cbiAgICB0aGlzLnBhY2thZ2UuYWRkUGFja2FnZVJlc29sdXRpb25zKFxuICAgICAgLy8gaHR0cHM6Ly9naXRodWIuY29tL0RlZmluaXRlbHlUeXBlZC9EZWZpbml0ZWx5VHlwZWQvaXNzdWVzLzYyMzAwXG4gICAgICBcIkB0eXBlcy9leHByZXNzQDQuMTcuMTNcIixcbiAgICAgIFwiQHR5cGVzL2V4cHJlc3Mtc2VydmUtc3RhdGljLWNvcmVANC4xNy4zMFwiXG4gICAgKTtcbiAgfVxufVxuXG5leHBvcnQgaW50ZXJmYWNlIFJlYWN0Q29tcG9uZW50T3B0aW9ucyBleHRlbmRzIFJlYWN0UmV3aXJlT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBXaGV0aGVyIHRvIGFwcGx5IG9wdGlvbnMgc3BlY2lmaWMgZm9yIFR5cGVTY3JpcHQgUmVhY3QgcHJvamVjdHMuXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSB0eXBlc2NyaXB0PzogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGNsYXNzIFJlYWN0Q29tcG9uZW50IGV4dGVuZHMgQ29tcG9uZW50IHtcbiAgcHJpdmF0ZSByZWFkb25seSB0eXBlc2NyaXB0OiBib29sZWFuO1xuXG4gIGNvbnN0cnVjdG9yKHByb2plY3Q6IE5vZGVQcm9qZWN0LCBvcHRpb25zOiBSZWFjdENvbXBvbmVudE9wdGlvbnMpIHtcbiAgICBzdXBlcihwcm9qZWN0KTtcblxuICAgIHRoaXMudHlwZXNjcmlwdCA9IG9wdGlvbnMudHlwZXNjcmlwdCA/PyBmYWxzZTtcblxuICAgIC8vIE5vIGNvbXBpbGUgZm9yIHJlYWN0IGFwcFxuICAgIHByb2plY3QuY29tcGlsZVRhc2sucmVzZXQoKTtcblxuICAgIHByb2plY3QuYWRkRGVwcyhcInJlYWN0XCIsIFwicmVhY3QtZG9tXCIsIFwicmVhY3Qtc2NyaXB0c0BeNVwiLCBcIndlYi12aXRhbHNcIik7XG4gICAgcHJvamVjdC5hZGREZXZEZXBzKFxuICAgICAgXCJAdGVzdGluZy1saWJyYXJ5L2plc3QtZG9tXCIsXG4gICAgICBcIkB0ZXN0aW5nLWxpYnJhcnkvcmVhY3RcIixcbiAgICAgIFwiQHRlc3RpbmctbGlicmFyeS91c2VyLWV2ZW50XCJcbiAgICApO1xuICAgIGlmICh0aGlzLnR5cGVzY3JpcHQpIHtcbiAgICAgIHByb2plY3QuYWRkRGV2RGVwcyhcIkB0eXBlcy9qZXN0XCIsIFwiQHR5cGVzL3JlYWN0XCIsIFwiQHR5cGVzL3JlYWN0LWRvbVwiKTtcbiAgICB9XG5cbiAgICBjb25zdCByZXdpcmUgPSBvcHRpb25zLnJld2lyZSA/PyBmYWxzZTtcblxuICAgIGlmIChyZXdpcmUpIHtcbiAgICAgIGNvbnN0IG92ZXJyaWRlc1BhdGggPSBcIi5wcm9qZW4vcmVhY3QtY29uZmlnLW92ZXJyaWRlcy5qc1wiO1xuICAgICAgcHJvamVjdC5hZGREZXZEZXBzKFwicmVhY3QtYXBwLXJld2lyZWRcIik7XG4gICAgICBwcm9qZWN0LmFkZEZpZWxkcyh7IFwiY29uZmlnLW92ZXJyaWRlcy1wYXRoXCI6IG92ZXJyaWRlc1BhdGggfSk7XG5cbiAgICAgIGNvbnN0IGNvbmZpZ092ZXJyaWRlcyA9IG5ldyBTb3VyY2VDb2RlKHRoaXMucHJvamVjdCwgb3ZlcnJpZGVzUGF0aCk7XG4gICAgICBpZiAoIWNvbmZpZ092ZXJyaWRlcy5tYXJrZXIpIHtcbiAgICAgICAgY29uZmlnT3ZlcnJpZGVzLmxpbmUoYC8vICR7Y29uZmlnT3ZlcnJpZGVzLm1hcmtlcn1gKTtcbiAgICAgIH1cbiAgICAgIGNvbmZpZ092ZXJyaWRlcy5saW5lKFwiLyoqXCIpO1xuICAgICAgY29uZmlnT3ZlcnJpZGVzLmxpbmUoXG4gICAgICAgIFwiICogT3ZlcnJpZGUgQ1JBIGNvbmZpZ3VyYXRpb24gd2l0aG91dCBuZWVkaW5nIHRvIGVqZWN0LlwiXG4gICAgICApO1xuICAgICAgY29uZmlnT3ZlcnJpZGVzLmxpbmUoXCIgKlwiKTtcbiAgICAgIGNvbmZpZ092ZXJyaWRlcy5saW5lKFxuICAgICAgICBcIiAqIEBzZWUgaHR0cHM6Ly93d3cubnBtanMuY29tL3BhY2thZ2UvcmVhY3QtYXBwLXJld2lyZWRcIlxuICAgICAgKTtcbiAgICAgIGNvbmZpZ092ZXJyaWRlcy5saW5lKFwiICovXCIpO1xuICAgICAgY29uZmlnT3ZlcnJpZGVzLm9wZW4oXCJtb2R1bGUuZXhwb3J0cyA9IGZ1bmN0aW9uIG92ZXJyaWRlKGNvbmZpZywgZW52KSB7XCIpO1xuICAgICAgZm9yIChjb25zdCBba2V5LCB2YWx1ZV0gb2YgT2JqZWN0LmVudHJpZXMocmV3aXJlKSkge1xuICAgICAgICBjb25maWdPdmVycmlkZXMubGluZShgY29uZmlnLiR7a2V5fSA9ICR7SlNPTi5zdHJpbmdpZnkodmFsdWUpfTtgKTtcbiAgICAgIH1cbiAgICAgIGNvbmZpZ092ZXJyaWRlcy5saW5lKFwicmV0dXJuIGNvbmZpZztcIik7XG4gICAgICBjb25maWdPdmVycmlkZXMuY2xvc2UoXCJ9O1wiKTtcbiAgICB9XG5cbiAgICBjb25zdCByZWFjdFNjcmlwdHMgPSByZXdpcmUgPyBcInJlYWN0LWFwcC1yZXdpcmVkXCIgOiBcInJlYWN0LXNjcmlwdHNcIjtcblxuICAgIC8vIENyZWF0ZSBSZWFjdCBBcHAgQ0xJIGNvbW1hbmRzLCBzZWU6IGh0dHBzOi8vY3JlYXRlLXJlYWN0LWFwcC5kZXYvZG9jcy9hdmFpbGFibGUtc2NyaXB0cy9cbiAgICBwcm9qZWN0LmFkZFRhc2soXCJkZXZcIiwge1xuICAgICAgZGVzY3JpcHRpb246IFwiU3RhcnRzIHRoZSByZWFjdCBhcHBsaWNhdGlvblwiLFxuICAgICAgZXhlYzogYCR7cmVhY3RTY3JpcHRzfSBzdGFydGAsXG4gICAgfSk7XG5cbiAgICBwcm9qZWN0LmNvbXBpbGVUYXNrLmV4ZWMoYCR7cmVhY3RTY3JpcHRzfSBidWlsZGApO1xuXG4gICAgcHJvamVjdC50ZXN0VGFzay5leGVjKGAke3JlYWN0U2NyaXB0c30gdGVzdCAtLXdhdGNoQWxsPWZhbHNlYCk7XG5cbiAgICBjb25zdCB0ZXN0V2F0Y2ggPSBwcm9qZWN0LnRhc2tzLnRyeUZpbmQoXCJ0ZXN0OndhdGNoXCIpO1xuICAgIHRlc3RXYXRjaD8ucmVzZXQoYCR7cmVhY3RTY3JpcHRzfSB0ZXN0YCk7XG5cbiAgICBwcm9qZWN0Lm5wbWlnbm9yZT8uZXhjbHVkZShcIiMgQnVpbGRcIiwgXCIvYnVpbGQvXCIpO1xuICAgIHByb2plY3QuZ2l0aWdub3JlLmV4Y2x1ZGUoXCIjIEJ1aWxkXCIsIFwiL2J1aWxkL1wiKTtcblxuICAgIHByb2plY3QucGFja2FnZS5hZGRGaWVsZChcImVzbGludENvbmZpZ1wiLCB7XG4gICAgICBleHRlbmRzOiBbXCJyZWFjdC1hcHBcIiwgXCJyZWFjdC1hcHAvamVzdFwiXSxcbiAgICB9KTtcblxuICAgIHByb2plY3QucGFja2FnZS5hZGRGaWVsZChcImJyb3dzZXJzbGlzdFwiLCB7XG4gICAgICBwcm9kdWN0aW9uOiBbXCI+MC4yJVwiLCBcIm5vdCBkZWFkXCIsIFwibm90IG9wX21pbmkgYWxsXCJdLFxuICAgICAgZGV2ZWxvcG1lbnQ6IFtcbiAgICAgICAgXCJsYXN0IDEgY2hyb21lIHZlcnNpb25cIixcbiAgICAgICAgXCJsYXN0IDEgZmlyZWZveCB2ZXJzaW9uXCIsXG4gICAgICAgIFwibGFzdCAxIHNhZmFyaSB2ZXJzaW9uXCIsXG4gICAgICBdLFxuICAgIH0pO1xuICB9XG59XG5cbmludGVyZmFjZSBSZWFjdFNhbXBsZUNvZGVPcHRpb25zIHtcbiAgLyoqXG4gICAqIEZpbGUgZXh0ZW5zaW9uIGZvciBzYW1wbGUgamF2YXNjcmlwdCBjb2RlIHRvIGJlIHNhdmVkIGFzLlxuICAgKlxuICAgKiBAZGVmYXVsdCBcImpzeFwiXG4gICAqL1xuICByZWFkb25seSBmaWxlRXh0Pzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgZGlyZWN0b3J5IGluIHdoaWNoIFJlYWN0IGpzeCBmaWxlcyBhcmUgZGVjbGFyZWQuXG4gICAqL1xuICByZWFkb25seSBzcmNkaXI6IHN0cmluZztcbn1cblxuY2xhc3MgUmVhY3RTYW1wbGVDb2RlIGV4dGVuZHMgQ29tcG9uZW50IHtcbiAgcHJpdmF0ZSByZWFkb25seSBmaWxlRXh0OiBzdHJpbmc7XG4gIHByaXZhdGUgcmVhZG9ubHkgc3JjZGlyOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3IocHJvamVjdDogTm9kZVByb2plY3QsIG9wdGlvbnM6IFJlYWN0U2FtcGxlQ29kZU9wdGlvbnMpIHtcbiAgICBzdXBlcihwcm9qZWN0KTtcblxuICAgIHRoaXMuZmlsZUV4dCA9IG9wdGlvbnMuZmlsZUV4dCA/PyBcImpzeFwiO1xuICAgIHRoaXMuc3JjZGlyID0gb3B0aW9ucy5zcmNkaXI7XG5cbiAgICBjb25zdCBsb2dvU3ZnID0gW1xuICAgICAgJzxzdmcgeG1sbnM9XCJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2Z1wiIHZpZXdCb3g9XCIwIDAgODQxLjkgNTk1LjNcIj4nLFxuICAgICAgJyAgICA8ZyBmaWxsPVwiIzYxREFGQlwiPicsXG4gICAgICAnICAgICAgICA8cGF0aCBkPVwiTTY2Ni4zIDI5Ni41YzAtMzIuNS00MC43LTYzLjMtMTAzLjEtODIuNCAxNC40LTYzLjYgOC0xMTQuMi0yMC4yLTEzMC40LTYuNS0zLjgtMTQuMS01LjYtMjIuNC01LjZ2MjIuM2M0LjYgMCA4LjMuOSAxMS40IDIuNiAxMy42IDcuOCAxOS41IDM3LjUgMTQuOSA3NS43LTEuMSA5LjQtMi45IDE5LjMtNS4xIDI5LjQtMTkuNi00LjgtNDEtOC41LTYzLjUtMTAuOS0xMy41LTE4LjUtMjcuNS0zNS4zLTQxLjYtNTAgMzIuNi0zMC4zIDYzLjItNDYuOSA4NC00Ni45Vjc4Yy0yNy41IDAtNjMuNSAxOS42LTk5LjkgNTMuNi0zNi40LTMzLjgtNzIuNC01My4yLTk5LjktNTMuMnYyMi4zYzIwLjcgMCA1MS40IDE2LjUgODQgNDYuNi0xNCAxNC43LTI4IDMxLjQtNDEuMyA0OS45LTIyLjYgMi40LTQ0IDYuMS02My42IDExLTIuMy0xMC00LTE5LjctNS4yLTI5LTQuNy0zOC4yIDEuMS02Ny45IDE0LjYtNzUuOCAzLTEuOCA2LjktMi42IDExLjUtMi42Vjc4LjVjLTguNCAwLTE2IDEuOC0yMi42IDUuNi0yOC4xIDE2LjItMzQuNCA2Ni43LTE5LjkgMTMwLjEtNjIuMiAxOS4yLTEwMi43IDQ5LjktMTAyLjcgODIuMyAwIDMyLjUgNDAuNyA2My4zIDEwMy4xIDgyLjQtMTQuNCA2My42LTggMTE0LjIgMjAuMiAxMzAuNCA2LjUgMy44IDE0LjEgNS42IDIyLjUgNS42IDI3LjUgMCA2My41LTE5LjYgOTkuOS01My42IDM2LjQgMzMuOCA3Mi40IDUzLjIgOTkuOSA1My4yIDguNCAwIDE2LTEuOCAyMi42LTUuNiAyOC4xLTE2LjIgMzQuNC02Ni43IDE5LjktMTMwLjEgNjItMTkuMSAxMDIuNS00OS45IDEwMi41LTgyLjN6bS0xMzAuMi02Ni43Yy0zLjcgMTIuOS04LjMgMjYuMi0xMy41IDM5LjUtNC4xLTgtOC40LTE2LTEzLjEtMjQtNC42LTgtOS41LTE1LjgtMTQuNC0yMy40IDE0LjIgMi4xIDI3LjkgNC43IDQxIDcuOXptLTQ1LjggMTA2LjVjLTcuOCAxMy41LTE1LjggMjYuMy0yNC4xIDM4LjItMTQuOSAxLjMtMzAgMi00NS4yIDItMTUuMSAwLTMwLjItLjctNDUtMS45LTguMy0xMS45LTE2LjQtMjQuNi0yNC4yLTM4LTcuNi0xMy4xLTE0LjUtMjYuNC0yMC44LTM5LjggNi4yLTEzLjQgMTMuMi0yNi44IDIwLjctMzkuOSA3LjgtMTMuNSAxNS44LTI2LjMgMjQuMS0zOC4yIDE0LjktMS4zIDMwLTIgNDUuMi0yIDE1LjEgMCAzMC4yLjcgNDUgMS45IDguMyAxMS45IDE2LjQgMjQuNiAyNC4yIDM4IDcuNiAxMy4xIDE0LjUgMjYuNCAyMC44IDM5LjgtNi4zIDEzLjQtMTMuMiAyNi44LTIwLjcgMzkuOXptMzIuMy0xM2M1LjQgMTMuNCAxMCAyNi44IDEzLjggMzkuOC0xMy4xIDMuMi0yNi45IDUuOS00MS4yIDggNC45LTcuNyA5LjgtMTUuNiAxNC40LTIzLjcgNC42LTggOC45LTE2LjEgMTMtMjQuMXpNNDIxLjIgNDMwYy05LjMtOS42LTE4LjYtMjAuMy0yNy44LTMyIDkgLjQgMTguMi43IDI3LjUuNyA5LjQgMCAxOC43LS4yIDI3LjgtLjctOSAxMS43LTE4LjMgMjIuNC0yNy41IDMyem0tNzQuNC01OC45Yy0xNC4yLTIuMS0yNy45LTQuNy00MS03LjkgMy43LTEyLjkgOC4zLTI2LjIgMTMuNS0zOS41IDQuMSA4IDguNCAxNiAxMy4xIDI0IDQuNyA4IDkuNSAxNS44IDE0LjQgMjMuNHpNNDIwLjcgMTYzYzkuMyA5LjYgMTguNiAyMC4zIDI3LjggMzItOS0uNC0xOC4yLS43LTI3LjUtLjctOS40IDAtMTguNy4yLTI3LjguNyA5LTExLjcgMTguMy0yMi40IDI3LjUtMzJ6bS03NCA1OC45Yy00LjkgNy43LTkuOCAxNS42LTE0LjQgMjMuNy00LjYgOC04LjkgMTYtMTMgMjQtNS40LTEzLjQtMTAtMjYuOC0xMy44LTM5LjggMTMuMS0zLjEgMjYuOS01LjggNDEuMi03Ljl6bS05MC41IDEyNS4yYy0zNS40LTE1LjEtNTguMy0zNC45LTU4LjMtNTAuNiAwLTE1LjcgMjIuOS0zNS42IDU4LjMtNTAuNiA4LjYtMy43IDE4LTcgMjcuNy0xMC4xIDUuNyAxOS42IDEzLjIgNDAgMjIuNSA2MC45LTkuMiAyMC44LTE2LjYgNDEuMS0yMi4yIDYwLjYtOS45LTMuMS0xOS4zLTYuNS0yOC0xMC4yek0zMTAgNDkwYy0xMy42LTcuOC0xOS41LTM3LjUtMTQuOS03NS43IDEuMS05LjQgMi45LTE5LjMgNS4xLTI5LjQgMTkuNiA0LjggNDEgOC41IDYzLjUgMTAuOSAxMy41IDE4LjUgMjcuNSAzNS4zIDQxLjYgNTAtMzIuNiAzMC4zLTYzLjIgNDYuOS04NCA0Ni45LTQuNS0uMS04LjMtMS0xMS4zLTIuN3ptMjM3LjItNzYuMmM0LjcgMzguMi0xLjEgNjcuOS0xNC42IDc1LjgtMyAxLjgtNi45IDIuNi0xMS41IDIuNi0yMC43IDAtNTEuNC0xNi41LTg0LTQ2LjYgMTQtMTQuNyAyOC0zMS40IDQxLjMtNDkuOSAyMi42LTIuNCA0NC02LjEgNjMuNi0xMSAyLjMgMTAuMSA0LjEgMTkuOCA1LjIgMjkuMXptMzguNS02Ni43Yy04LjYgMy43LTE4IDctMjcuNyAxMC4xLTUuNy0xOS42LTEzLjItNDAtMjIuNS02MC45IDkuMi0yMC44IDE2LjYtNDEuMSAyMi4yLTYwLjYgOS45IDMuMSAxOS4zIDYuNSAyOC4xIDEwLjIgMzUuNCAxNS4xIDU4LjMgMzQuOSA1OC4zIDUwLjYtLjEgMTUuNy0yMyAzNS42LTU4LjQgNTAuNnpNMzIwLjggNzguNHpcIi8+JyxcbiAgICAgICcgICAgICAgIDxjaXJjbGUgY3g9XCI0MjAuOVwiIGN5PVwiMjk2LjVcIiByPVwiNDUuN1wiLz4nLFxuICAgICAgJyAgICAgICAgPHBhdGggZD1cIk01MjAuNSA3OC4xelwiLz4nLFxuICAgICAgXCIgICAgPC9nPlwiLFxuICAgICAgXCI8L3N2Zz5cIixcbiAgICAgIFwiXCIsXG4gICAgXTtcblxuICAgIGNvbnN0IGFwcEpzeCA9IFtcbiAgICAgIFwiaW1wb3J0IGxvZ28gZnJvbSAnLi9sb2dvLnN2Zyc7XCIsXG4gICAgICBcImltcG9ydCAnLi9BcHAuY3NzJ1wiLFxuICAgICAgXCJcIixcbiAgICAgIFwiZnVuY3Rpb24gQXBwKCkge1wiLFxuICAgICAgXCIgIHJldHVybiAoXCIsXG4gICAgICAnICAgPGRpdiBjbGFzc05hbWU9XCJBcHBcIj4nLFxuICAgICAgJyAgICAgIDxoZWFkZXIgY2xhc3NOYW1lPVwiQXBwLWhlYWRlclwiPicsXG4gICAgICAnICAgICAgICA8aW1nIHNyYz17bG9nb30gY2xhc3NOYW1lPVwiQXBwLWxvZ29cIiBhbHQ9XCJsb2dvXCIgLz4nLFxuICAgICAgXCIgICAgICAgIDxwPlwiLFxuICAgICAgYCAgICAgICAgICBFZGl0IDxjb2RlPnNyYy9BcHAuJHt0aGlzLmZpbGVFeHR9PC9jb2RlPiBhbmQgc2F2ZSB0byByZWxvYWQuYCxcbiAgICAgIFwiICAgICAgICA8L3A+XCIsXG4gICAgICAnICAgICAgICA8YSBjbGFzc05hbWU9XCJBcHAtbGlua1wiJyxcbiAgICAgICcgICAgICAgICAgaHJlZj1cImh0dHBzOi8vcmVhY3Rqcy5vcmdcIicsXG4gICAgICAnICAgICAgICAgIHRhcmdldD1cIl9ibGFua1wiJyxcbiAgICAgICcgICAgICAgICAgcmVsPVwibm9vcGVuZXIgbm9yZWZlcnJlclwiJyxcbiAgICAgIFwiICAgICAgICA+XCIsXG4gICAgICBcIiAgICAgICAgICBMZWFybiBSZWFjdFwiLFxuICAgICAgXCIgICAgICAgIDwvYT5cIixcbiAgICAgIFwiICAgICAgPC9oZWFkZXI+XCIsXG4gICAgICBcIiAgICA8L2Rpdj5cIixcbiAgICAgIFwiICApO1wiLFxuICAgICAgXCJ9XCIsXG4gICAgICBcIlwiLFxuICAgICAgXCJleHBvcnQgZGVmYXVsdCBBcHA7XCIsXG4gICAgICBcIlwiLFxuICAgIF07XG5cbiAgICBjb25zdCBhcHBDc3MgPSBbXG4gICAgICBcIi5BcHAge1wiLFxuICAgICAgXCIgIHRleHQtYWxpZ246IGNlbnRlcjtcIixcbiAgICAgIFwifVwiLFxuICAgICAgXCJcIixcbiAgICAgIFwiLkFwcC1sb2dvIHtcIixcbiAgICAgIFwiICBoZWlnaHQ6IDQwdm1pbjtcIixcbiAgICAgIFwiICBwb2ludGVyLWV2ZW50czogbm9uZTtcIixcbiAgICAgIFwifVwiLFxuICAgICAgXCJcIixcbiAgICAgIFwiQG1lZGlhIChwcmVmZXJzLXJlZHVjZWQtbW90aW9uOiBuby1wcmVmZXJlbmNlKSB7XCIsXG4gICAgICBcIiAgLkFwcC1sb2dvIHtcIixcbiAgICAgIFwiICAgIGFuaW1hdGlvbjogQXBwLWxvZ28tc3BpbiBpbmZpbml0ZSAyMHMgbGluZWFyO1wiLFxuICAgICAgXCIgIH1cIixcbiAgICAgIFwifVwiLFxuICAgICAgXCJcIixcbiAgICAgIFwiLkFwcC1oZWFkZXIge1wiLFxuICAgICAgXCIgIGJhY2tncm91bmQtY29sb3I6ICMyODJjMzQ7XCIsXG4gICAgICBcIiAgbWluLWhlaWdodDogMTAwdmg7XCIsXG4gICAgICBcIiAgZGlzcGxheTogZmxleDtcIixcbiAgICAgIFwiICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1wiLFxuICAgICAgXCIgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XCIsXG4gICAgICBcIiAganVzdGlmeS1jb250ZW50OiBjZW50ZXI7XCIsXG4gICAgICBcIiAgZm9udC1zaXplOiBjYWxjKDEwcHggKyAydm1pbik7XCIsXG4gICAgICBcIiAgY29sb3I6IHdoaXRlO1wiLFxuICAgICAgXCJ9XCIsXG4gICAgICBcIlwiLFxuICAgICAgXCIuQXBwLWxpbmsge1wiLFxuICAgICAgXCIgIGNvbG9yOiAjNjFkYWZiO1wiLFxuICAgICAgXCJ9XCIsXG4gICAgICBcIlwiLFxuICAgICAgXCJAa2V5ZnJhbWVzIEFwcC1sb2dvLXNwaW4ge1wiLFxuICAgICAgXCIgIGZyb20ge1wiLFxuICAgICAgXCIgICAgdHJhbnNmb3JtOiByb3RhdGUoMGRlZyk7XCIsXG4gICAgICBcIiAgfVwiLFxuICAgICAgXCIgIHRvIHtcIixcbiAgICAgIFwiICAgIHRyYW5zZm9ybTogcm90YXRlKDM2MGRlZyk7XCIsXG4gICAgICBcIiAgfVwiLFxuICAgICAgXCJ9XCIsXG4gICAgICBcIlwiLFxuICAgIF07XG5cbiAgICBjb25zdCBhcHBUZXN0SnN4ID0gW1xuICAgICAgXCJpbXBvcnQgeyByZW5kZXIsIHNjcmVlbiB9IGZyb20gJ0B0ZXN0aW5nLWxpYnJhcnkvcmVhY3QnO1wiLFxuICAgICAgXCJpbXBvcnQgQXBwIGZyb20gJy4vQXBwJztcIixcbiAgICAgIFwiXCIsXG4gICAgICBcInRlc3QoJ3JlbmRlcnMgbGVhcm4gcmVhY3QgbGluaycsICgpID0+IHtcIixcbiAgICAgIFwiICByZW5kZXIoPEFwcCAvPik7XCIsXG4gICAgICBcIiAgY29uc3QgbGlua0VsZW1lbnQgPSBzY3JlZW4uZ2V0QnlUZXh0KC9sZWFybiByZWFjdC9pKTtcIixcbiAgICAgIFwiICBleHBlY3QobGlua0VsZW1lbnQpLnRvQmVJblRoZURvY3VtZW50KCk7XCIsXG4gICAgICBcIn0pO1wiLFxuICAgICAgXCJcIixcbiAgICBdO1xuXG4gICAgY29uc3QgaW5kZXhKc3ggPSBbXG4gICAgICBcImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XCIsXG4gICAgICBcImltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nO1wiLFxuICAgICAgXCJpbXBvcnQgJy4vaW5kZXguY3NzJztcIixcbiAgICAgIFwiaW1wb3J0IEFwcCBmcm9tICcuL0FwcCc7XCIsXG4gICAgICBcImltcG9ydCByZXBvcnRXZWJWaXRhbHMgZnJvbSAnLi9yZXBvcnRXZWJWaXRhbHMnO1wiLFxuICAgICAgXCJcIixcbiAgICAgIFwiUmVhY3RET00ucmVuZGVyKFwiLFxuICAgICAgXCIgIDxSZWFjdC5TdHJpY3RNb2RlPlwiLFxuICAgICAgXCIgICAgPEFwcCAvPlwiLFxuICAgICAgXCIgIDwvUmVhY3QuU3RyaWN0TW9kZT4sXCIsXG4gICAgICBcIiAgZG9jdW1lbnQuZ2V0RWxlbWVudEJ5SWQoJ3Jvb3QnKVwiLFxuICAgICAgXCIpO1wiLFxuICAgICAgXCJcIixcbiAgICAgIFwiLy8gSWYgeW91IHdhbnQgdG8gc3RhcnQgbWVhc3VyaW5nIHBlcmZvcm1hbmNlIGluIHlvdXIgYXBwLCBwYXNzIGEgZnVuY3Rpb25cIixcbiAgICAgIFwiLy8gdG8gbG9nIHJlc3VsdHMgKGZvciBleGFtcGxlOiByZXBvcnRXZWJWaXRhbHMoY29uc29sZS5sb2cpKVwiLFxuICAgICAgXCIvLyBvciBzZW5kIHRvIGFuIGFuYWx5dGljcyBlbmRwb2ludC4gTGVhcm4gbW9yZTogaHR0cHM6Ly9iaXQubHkvQ1JBLXZpdGFsc1wiLFxuICAgICAgXCJyZXBvcnRXZWJWaXRhbHMoKTtcIixcbiAgICAgIFwiXCIsXG4gICAgXTtcblxuICAgIGNvbnN0IGluZGV4Q3NzID0gW1xuICAgICAgXCJib2R5IHtcIixcbiAgICAgIFwiICBtYXJnaW46IDA7XCIsXG4gICAgICBcIiAgZm9udC1mYW1pbHk6IC1hcHBsZS1zeXN0ZW0sIEJsaW5rTWFjU3lzdGVtRm9udCwgJ1NlZ29lIFVJJywgJ1JvYm90bycsICdPeHlnZW4nLFwiLFxuICAgICAgXCIgICAgJ1VidW50dScsICdDYW50YXJlbGwnLCAnRmlyYSBTYW5zJywgJ0Ryb2lkIFNhbnMnLCAnSGVsdmV0aWNhIE5ldWUnLFwiLFxuICAgICAgXCIgICAgc2Fucy1zZXJpZjtcIixcbiAgICAgIFwiICAtd2Via2l0LWZvbnQtc21vb3RoaW5nOiBhbnRpYWxpYXNlZDtcIixcbiAgICAgIFwiICAtbW96LW9zeC1mb250LXNtb290aGluZzogZ3JheXNjYWxlO1wiLFxuICAgICAgXCJ9XCIsXG4gICAgICBcIlwiLFxuICAgICAgXCJjb2RlIHtcIixcbiAgICAgIFwiICBmb250LWZhbWlseTogc291cmNlLWNvZGUtcHJvLCBNZW5sbywgTW9uYWNvLCBDb25zb2xhcywgJ0NvdXJpZXIgTmV3JyxcIixcbiAgICAgIFwiICAgIG1vbm9zcGFjZTtcIixcbiAgICAgIFwifVwiLFxuICAgICAgXCJcIixcbiAgICBdO1xuXG4gICAgY29uc3QgcmVwb3J0V2ViVml0YWxzSnMgPSBbXG4gICAgICBcImltcG9ydCB7IFJlcG9ydEhhbmRsZXIgfSBmcm9tICd3ZWItdml0YWxzJztcIixcbiAgICAgIFwiXCIsXG4gICAgICBcImNvbnN0IHJlcG9ydFdlYlZpdGFscyA9IChvblBlcmZFbnRyeT86IFJlcG9ydEhhbmRsZXIpID0+IHtcIixcbiAgICAgIFwiICBpZiAob25QZXJmRW50cnkgJiYgb25QZXJmRW50cnkgaW5zdGFuY2VvZiBGdW5jdGlvbikge1wiLFxuICAgICAgXCIgICAgaW1wb3J0KCd3ZWItdml0YWxzJykudGhlbihcIixcbiAgICAgIFwiICAgICAgKHsgZ2V0Q0xTLCBnZXRGSUQsIGdldEZDUCwgZ2V0TENQLCBnZXRUVEZCIH0pID0+IHtcIixcbiAgICAgIFwiICAgICAgICBnZXRDTFMob25QZXJmRW50cnkpO1wiLFxuICAgICAgXCIgICAgICAgIGdldEZJRChvblBlcmZFbnRyeSk7XCIsXG4gICAgICBcIiAgICAgICAgZ2V0RkNQKG9uUGVyZkVudHJ5KTtcIixcbiAgICAgIFwiICAgICAgICBnZXRMQ1Aob25QZXJmRW50cnkpO1wiLFxuICAgICAgXCIgICAgICAgIGdldFRURkIob25QZXJmRW50cnkpO1wiLFxuICAgICAgXCIgICAgICB9LFwiLFxuICAgICAgXCIgICAgICAoKSA9PiB7fVwiLFxuICAgICAgXCIgICAgKTtcIixcbiAgICAgIFwiICB9XCIsXG4gICAgICBcIn07XCIsXG4gICAgICBcIlwiLFxuICAgICAgXCJleHBvcnQgZGVmYXVsdCByZXBvcnRXZWJWaXRhbHM7XCIsXG4gICAgXTtcblxuICAgIGNvbnN0IHNldHVwVGVzdHNKcyA9IFtcbiAgICAgIFwiLy8gamVzdC1kb20gYWRkcyBjdXN0b20gamVzdCBtYXRjaGVycyBmb3IgYXNzZXJ0aW5nIG9uIERPTSBub2Rlcy5cIixcbiAgICAgIFwiLy8gYWxsb3dzIHlvdSB0byBkbyB0aGluZ3MgbGlrZTpcIixcbiAgICAgIFwiLy8gZXhwZWN0KGVsZW1lbnQpLnRvSGF2ZVRleHRDb250ZW50KC9yZWFjdC9pKVwiLFxuICAgICAgXCIvLyBsZWFybiBtb3JlOiBodHRwczovL2dpdGh1Yi5jb20vdGVzdGluZy1saWJyYXJ5L2plc3QtZG9tXCIsXG4gICAgICBcImltcG9ydCAnQHRlc3RpbmctbGlicmFyeS9qZXN0LWRvbSc7XCIsXG4gICAgICBcIlwiLFxuICAgIF07XG5cbiAgICBjb25zdCByZWFjdFR5cGVEZWYgPSBbJy8vLyA8cmVmZXJlbmNlIHR5cGVzPVwicmVhY3Qtc2NyaXB0c1wiIC8+J107XG5cbiAgICAvLyBqcy90cyBub3QganN4L3RzeFxuICAgIGNvbnN0IGZpbGVFeHRXaXRob3V0WCA9IHRoaXMuZmlsZUV4dC5yZXBsYWNlKFwieFwiLCBcIlwiKTtcblxuICAgIG5ldyBTYW1wbGVEaXIocHJvamVjdCwgdGhpcy5zcmNkaXIsIHtcbiAgICAgIGZpbGVzOiB7XG4gICAgICAgIFwicmVhY3QtYXBwLWVudi5kLnRzXCI6IHJlYWN0VHlwZURlZi5qb2luKFwiXFxuXCIpLFxuICAgICAgICBcImxvZ28uc3ZnXCI6IGxvZ29Tdmcuam9pbihcIlxcblwiKSxcbiAgICAgICAgW1wiQXBwLlwiICsgdGhpcy5maWxlRXh0XTogYXBwSnN4LmpvaW4oXCJcXG5cIiksXG4gICAgICAgIFtcIkFwcC50ZXN0LlwiICsgdGhpcy5maWxlRXh0XTogYXBwVGVzdEpzeC5qb2luKFwiXFxuXCIpLFxuICAgICAgICBcIkFwcC5jc3NcIjogYXBwQ3NzLmpvaW4oXCJcXG5cIiksXG4gICAgICAgIFtcImluZGV4LlwiICsgdGhpcy5maWxlRXh0XTogaW5kZXhKc3guam9pbihcIlxcblwiKSxcbiAgICAgICAgXCJpbmRleC5jc3NcIjogaW5kZXhDc3Muam9pbihcIlxcblwiKSxcbiAgICAgICAgW1wicmVwb3J0V2ViVml0YWxzLlwiICsgZmlsZUV4dFdpdGhvdXRYXTogcmVwb3J0V2ViVml0YWxzSnMuam9pbihcIlxcblwiKSxcbiAgICAgICAgW1wic2V0dXBUZXN0cy5cIiArIGZpbGVFeHRXaXRob3V0WF06IHNldHVwVGVzdHNKcy5qb2luKFwiXFxuXCIpLFxuICAgICAgfSxcbiAgICB9KTtcbiAgfVxufVxuXG4vKipcbiAqIEBkZXByZWNhdGVkIE5vIGxvbmdlciB1c2VkLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFJlYWN0VHlwZURlZk9wdGlvbnMgZXh0ZW5kcyBGaWxlQmFzZU9wdGlvbnMge31cblxuLyoqXG4gKiBAZGVwcmVjYXRlZCBObyBsb25nZXIgdXNlZC5cbiAqL1xuZXhwb3J0IGNsYXNzIFJlYWN0VHlwZURlZiBleHRlbmRzIEZpbGVCYXNlIHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJvamVjdDogUmVhY3RUeXBlU2NyaXB0UHJvamVjdCxcbiAgICBmaWxlUGF0aDogc3RyaW5nLFxuICAgIG9wdGlvbnM6IFJlYWN0VHlwZURlZk9wdGlvbnMgPSB7fVxuICApIHtcbiAgICBzdXBlcihwcm9qZWN0LCBmaWxlUGF0aCwgb3B0aW9ucyk7XG4gIH1cblxuICBwcm90ZWN0ZWQgc3ludGhlc2l6ZUNvbnRlbnQoXzogSVJlc29sdmVyKTogc3RyaW5nIHwgdW5kZWZpbmVkIHtcbiAgICByZXR1cm4gWycvLy8gPHJlZmVyZW5jZSB0eXBlcz1cInJlYWN0LXNjcmlwdHNcIiAvPiddLmpvaW4oXCJcXG5cIik7XG4gIH1cbn1cbiJdfQ==